/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.javaseis.array.beta.FftNdLocal;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.array.beta.test.JPerfTestShapes;
import org.javaseis.fft.IFFT;
import org.javaseis.iterators.beta.IPositionIterator;
import org.javaseis.util.MemoryReporter;
import org.junit.Assert;

public class JPerfTestFftNdLocal {
    private int _logLevel;
    private boolean _doChecks;
    private MemoryReporter _memrp = null;

    public JPerfTestFftNdLocal() {
        this(Level.INFO, false);
    }

    public JPerfTestFftNdLocal(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    public JPerfTestFftNdLocal(Level level, boolean doChecks, MemoryReporter memrp) {
        this.setLevel(level);
        this._doChecks = doChecks;
        this._memrp = memrp;
    }

    private void fftHarness(int fftDimensions, int[] shape, float[] pad) {
        FftNdLocal fnd = new FftNdLocal(fftDimensions, shape, pad, IFFT.Type.REAL);
        IFlexArray<float[]> gma = FlexArray.createFloatArray(shape);
        int[] pos = new int[shape.length];
        PositionIterator pti = new PositionIterator(shape, pos, IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
        Random r = new Random(12345L);
        while (pti.hasNext()) {
            pti.next();
            float[] trc = gma.getTrace(pos);
            for (int i = 0; i < shape[0]; ++i) {
                trc[i] = r.nextFloat();
            }
        }
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < shape.length; ++i) {
            arraySize *= (double)shape[i];
        }
        double startTime = JPerfTestFftNdLocal.getTime();
        if (this._memrp != null) {
            fnd.setmemlog(this._memrp);
        }
        fnd.forward(gma);
        fnd.inverse(gma);
        double elapsedTime = JPerfTestFftNdLocal.getTime() - startTime;
        this.logInfo(fftDimensions + "D FFT Forward/Inverse : size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(shape));
        this.logFine("\nAfter FFT round trip");
        if (this._doChecks) {
            pti.reset();
            r.setSeed(12345L);
            while (pti.hasNext()) {
                pti.next();
                float[] trc = gma.getTrace(pos);
                for (int i = 0; i < shape[0]; ++i) {
                    float f1 = trc[i];
                    float f2 = r.nextFloat();
                    Assert.assertEquals((String)("frequency slice " + i + Arrays.toString(pos)), (double)f1, (double)f2, (double)1.0E-6f);
                }
            }
        }
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    public static void main(String[] args) {
        int i;
        Boolean memoryPrint = true;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        List<int[]> shapes = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        MemoryReporter memrp = null;
        if (memoryPrint.booleanValue()) {
            memrp = new MemoryReporter();
        }
        JPerfTestFftNdLocal tester = new JPerfTestFftNdLocal(Level.INFO, false);
        System.setProperty("JavaSeisInterfaces", "IFFT");
        System.setProperty("IFFT", "org.javaseis.fft.SeisFftJtk,org.javaseis.fft.SeisFftJTransform");
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        double startTime = JPerfTestFftNdLocal.getTime();
        for (i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for 1D: " + memrp.getMemoryUsage());
            }
            tester.fftHarness(1, shapes.get(i), pad);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for 1D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
        tester.logInfo("Total time for 1D : " + (JPerfTestFftNdLocal.getTime() - startTime) + " sec");
        startTime = JPerfTestFftNdLocal.getTime();
        for (i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for 2D: " + memrp.getMemoryUsage());
            }
            tester.fftHarness(2, shapes.get(i), pad);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for 2D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
        tester.logInfo("Total time for 2D : " + (JPerfTestFftNdLocal.getTime() - startTime) + " sec");
        startTime = JPerfTestFftNdLocal.getTime();
        for (i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for 3D: " + memrp.getMemoryUsage());
            }
            tester.fftHarness(3, shapes.get(i), pad);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for 3D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
        tester.logInfo("Total time for 3D : " + (JPerfTestFftNdLocal.getTime() - startTime) + " sec");
    }
}

