/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.curves.CurveProps;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.FpParams;
import com.certicom.ecc.spec.F2mParameterSpec;
import com.certicom.ecc.spec.FFParameterSpec;
import com.certicom.ecc.spec.FpParameterSpec;
import com.certicom.ecc.system.SystemConfig;
import java.math.BigInteger;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class CurveList {
    public static final int FPCURVE = 0;
    public static final int F2MCURVE = 1;
    private static Vector a;
    private static Properties b;

    private CurveList() {
        b.put("secp160r1.resolveName", "secp160r1");
        b.put("1.3.132.0.8.resolveName", "secp160r1");
        b.put("secp192r1.resolveName", "secp192r1");
        b.put("P-192.resolveName", "secp192r1");
        b.put("1.2.840.10045.3.1.1.resolveName", "secp192r1");
        b.put("secp224r1.resolveName", "secp224r1");
        b.put("P-224.resolveName", "secp224r1");
        b.put("1.3.132.0.33.resolveName", "secp224r1");
        b.put("secp256r1.resolveName", "secp256r1");
        b.put("P-256.resolveName", "secp256r1");
        b.put("1.2.840.10045.3.1.7.resolveName", "secp256r1");
        b.put("P-384.resolveName", "P-384");
        b.put("secp384r1.resolveName", "P-384");
        b.put("1.3.132.0.34.resolveName", "P-384");
        b.put("P-521.resolveName", "P-521");
        b.put("secp521r1.resolveName", "P-521");
        b.put("1.3.132.0.35.resolveName", "P-521");
        b.put("sect163k1.resolveName", "sect163k1");
        b.put("K-163.resolveName", "sect163k1");
        b.put("1.3.132.0.1.resolveName", "sect163k1");
        b.put("sect163r2.resolveName", "sect163r2");
        b.put("B-163.resolveName", "sect163r2");
        b.put("1.3.132.0.15.resolveName", "sect163r2");
        b.put("sect233k1.resolveName", "sect233k1");
        b.put("K-233.resolveName", "sect233k1");
        b.put("1.3.132.0.26.resolveName", "sect233k1");
        b.put("sect233r1.resolveName", "sect233r1");
        b.put("B-233.resolveName", "sect233r1");
        b.put("1.3.132.0.27.resolveName", "sect233r1");
        b.put("sect239k1.resolveName", "sect239k1");
        b.put("1.3.132.0.3.resolveName", "sect239k1");
        b.put("sect283k1.resolveName", "sect283k1");
        b.put("K-283.resolveName", "sect283k1");
        b.put("1.3.132.0.16.resolveName", "sect283k1");
        b.put("sect283r1.resolveName", "sect283r1");
        b.put("B-283.resolveName", "sect283r1");
        b.put("1.3.132.0.17.resolveName", "sect283r1");
        b.put("K-409.resolveName", "K-409");
        b.put("sect409k1.resolveName", "K-409");
        b.put("1.3.132.0.36.resolveName", "K-409");
        b.put("B-409.resolveName", "B-409");
        b.put("sect409r1.resolveName", "B-409");
        b.put("1.3.132.0.37.resolveName", "B-409");
        b.put("K-571.resolveName", "K-571");
        b.put("sect571k1.resolveName", "K-571");
        b.put("1.3.132.0.38.resolveName", "K-571");
        b.put("B-571.resolveName", "B-571");
        b.put("sect571r1.resolveName", "B-571");
        b.put("1.3.132.0.39.resolveName", "B-571");
        b.put("wTLS5.resolveName", "wTLS5");
        b.put("1.2.840.10045.3.0.1.resolveName", "wTLS5");
        b.put("fp", "secp160r1 secp192r1 secp224r1 secp256r1 P-384 P-521");
        b.put("f2m", "sect163k1 sect163r2 sect233k1 sect233r1 sect239k1 sect283k1 sect283r1 B-409 B-571 K-409 K-571 wTLS5");
        b.put("size.160", "secp160r1");
        b.put("size.163", "sect163k1 sect163r2 wTLS5");
        b.put("size.192", "secp192r1");
        b.put("size.224", "secp224r1");
        b.put("size.233", "sect233k1 sect233r1");
        b.put("size.239", "sect239k1");
        b.put("size.256", "secp256r1");
        b.put("size.283", "sect283k1 sect283r1");
        b.put("size.384", "P-384");
        b.put("size.409", "B-409 K-409");
        b.put("size.521", "P-521");
        b.put("size.571", "B-571 K-571");
        if (b.isEmpty()) {
            throw new IllegalStateException("cannot open curves list.");
        }
        a = new Vector();
    }

    private static Object a(String string) {
        Properties properties;
        Object object;
        Object object2;
        String string2 = string.replace('-', '_');
        try {
            object2 = Class.forName("com.certicom.ecc.curves." + string2);
            object = (CurveProps)((Class)object2).newInstance();
            properties = object.a();
        }
        catch (Exception exception) {
            return null;
        }
        if (properties.isEmpty()) {
            return null;
        }
        object2 = properties.getProperty("type");
        if (object2 == null || !((String)object2).equals("fp") && !((String)object2).equals("f2m")) {
            return null;
        }
        object = properties.getProperty("a");
        String string3 = properties.getProperty("b");
        String string4 = properties.getProperty("baseAtX");
        String string5 = properties.getProperty("baseAtY");
        String string6 = properties.getProperty("n");
        if (object == null || string3 == null || string4 == null || string5 == null || string6 == null) {
            return null;
        }
        String string7 = properties.getProperty("seed");
        String string8 = properties.getProperty("h");
        String string9 = properties.getProperty("oid");
        String string10 = null;
        FFParameterSpec fFParameterSpec = null;
        try {
            if (((String)object2).equals("fp")) {
                string10 = properties.getProperty("p");
                if (string10 == null) {
                    return null;
                }
                fFParameterSpec = new FpParameterSpec(((String)object).indexOf("-") != -1 ? new BigInteger(string10, 16).add(new BigInteger((String)object, 16)).toByteArray() : new BigInteger((String)object, 16).toByteArray(), string3.indexOf("-") != -1 ? new BigInteger(string10, 16).add(new BigInteger(string3, 16)).toByteArray() : new BigInteger(string3, 16).toByteArray(), string7 == null ? null : new BigInteger(string7, 16).toByteArray(), new BigInteger(string4, 16).toByteArray(), new BigInteger(string5, 16).toByteArray(), new BigInteger(string6, 16).toByteArray(), Integer.parseInt(string8, 16), new BigInteger(string10, 16).toByteArray(), new String(string2), string9);
            } else {
                string10 = properties.getProperty("m");
                if (string10 == null) {
                    return null;
                }
                String string11 = properties.getProperty("k1");
                String string12 = properties.getProperty("k2");
                String string13 = properties.getProperty("k3");
                fFParameterSpec = new F2mParameterSpec(((String)object).indexOf("-") != -1 ? new BigInteger(string10, 16).add(new BigInteger((String)object, 16)).toByteArray() : new BigInteger((String)object, 16).toByteArray(), string3.indexOf("-") != -1 ? new BigInteger(string10, 16).add(new BigInteger(string3, 16)).toByteArray() : new BigInteger(string3, 16).toByteArray(), string7 == null ? null : new BigInteger(string7, 16).toByteArray(), new BigInteger(string4, 16).toByteArray(), new BigInteger(string5, 16).toByteArray(), new BigInteger(string6, 16).toByteArray(), Integer.parseInt(string8, 16), Integer.parseInt(string10, 16), string11 == null ? -1 : Integer.parseInt(string11, 16), string12 == null ? -1 : Integer.parseInt(string12, 16), string13 == null ? -1 : Integer.parseInt(string13, 16), new String(string2), string9);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return fFParameterSpec;
    }

    private static ECParams b(String string) {
        Object object = CurveList.a(string);
        if (object instanceof ECParams) {
            ECParams eCParams = (ECParams)object;
            a.addElement(new Curve(string, eCParams.getSize(), eCParams instanceof FpParams ? 0 : 1, eCParams));
            return eCParams;
        }
        return null;
    }

    public static ECParams byName(String string) {
        String string2 = string.equals("ImplicitlyCA") ? b.getProperty(SystemConfig.getConfig().getCurve() + ".resolveName") : b.getProperty(string + ".resolveName");
        if (string2 == null) {
            return null;
        }
        Object object = a.elements();
        while (object.hasMoreElements()) {
            Curve curve = (Curve)object.nextElement();
            if (!Curve.a(curve).equals(string2)) continue;
            return Curve.b(curve);
        }
        object = CurveList.b(string2);
        if (object == null) {
            throw new IllegalArgumentException(string + " not found.");
        }
        return object;
    }

    public static ECParams byOID(String string) {
        return CurveList.byName(string);
    }

    public static ECParams bySize(int n2, int n3) {
        Object object;
        Object object2 = a.elements();
        while (object2.hasMoreElements()) {
            object = (Curve)object2.nextElement();
            if (Curve.c((Curve)object) != n2 || Curve.d((Curve)object) != n3) continue;
            return Curve.b((Curve)object);
        }
        object2 = b.getProperty("size." + n2);
        if (object2 == null) {
            return null;
        }
        object = b.getProperty(n3 == 0 ? "fp" : "f2m");
        if (object == null) {
            return null;
        }
        boolean bl = false;
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (((String)object).indexOf(string) == -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            return CurveList.b(string);
        }
        throw new IllegalArgumentException("curve not found.");
    }

    static {
        b = new Properties();
        new CurveList();
    }

    static class Curve {
        private String a;
        private int b;
        private int c;
        private ECParams d = null;

        Curve(String string, int n2, int n3, ECParams eCParams) {
            this.a = string;
            this.b = n2;
            this.c = n3;
            this.d = eCParams;
        }

        static String a(Curve curve) {
            return curve.a;
        }

        static ECParams b(Curve curve) {
            return curve.d;
        }

        static int c(Curve curve) {
            return curve.b;
        }

        static int d(Curve curve) {
            return curve.c;
        }
    }
}

