#include "javavm.h"
#include "jsfiles.h"

#include <stdlib.h>
#include <string.h>
#include <assert.h>

int main (int argc, char **argv)
{
  int scnt = 8;
  int tcnt = 4;
  int fcnt = 3;
  int hcnt = 6;
  float srate = 0.004f;
  float xlin_dist = 12.5f;
  float ilin_dist = 25.0f;
  
  int k2, k3, ok, elem;
  long k4, nt, zero, one;
  
  int isa, lun, cnt;
  char path[200];
  const char *def_dir = "/tmp/";
  const char *user = getenv ("USER");
  const char *def_path = "/jsdata/junk.js";
  int sample_count;
  long trace_count;
  float *trace;
  double *header;
  char mess[100], domain[32], units[32], type[24], format[24];
  int ml, tl, fl;
  float **traces;
  double **props;
  int length;
  long lorg, ldel;
  double porg, pdel;

  double world[6], rworld[6];
  double grid[4], rgrid[4];
  long logical[8], rlogical[8];

  world[0] = 0;
  world[1] = 0;
  world[2] = (tcnt - 1) * xlin_dist;
  world[3] = 0;
  world[4] = (tcnt - 1) * xlin_dist;
  world[5] = (fcnt - 1) * ilin_dist;
  grid[0] = 0;
  grid[1] = 0;
  grid[2] = xlin_dist;
  grid[3] = ilin_dist;
  logical[0] = 0;
  logical[1] = 0;
  logical[2] = tcnt;
  logical[3] = 0;
  logical[4] = tcnt;
  logical[5] = fcnt;
  logical[6] = 1;
  logical[7] = 1;

  if (argc > 1) {
   strcpy (path, argv[1]);
  }
  else {
    strcpy (path, def_dir);
    strcat (path, user);
    strcat (path, def_path);
  }

  lun = jsfiles_getlun ((const char *)path, "r");
  if (lun > 0) {
    ok = jsfiles_open (lun);
     if (ok != 1) {
      printf ("   open to check for preexistance = %d\n", ok);
      exit (1);
    }
     ok = jsfiles_close (lun);
     if (ok != 1) {
       printf ("   preexistance close status = %d\n", ok);
       exit (1);
     }

    lun = jsfiles_getlun ((const char *)path, "rw");
    ok = jsfiles_open (lun);
    if (ok != 1) {
      printf ("   preexistance open to remove status = %d\n", ok);
      exit (1);
    }

    ok = jsfiles_remove (lun);
    if (ok != 1) {
      printf ("   preexistance removal status = %d\n", ok);
      exit (1);
    }
  }

  lun = jsfiles_getlun ((const char *)path, "rw");
  if (lun < 1) {
    printf ("Failed to get lun %s\n", path);
    exit (1);
  }

  zero = 0;
  one = 1;
  ok = jsfiles_setaxis (lun, 1, scnt, "time", "milliseconds", zero, one, 0.0,
    srate*1000);
  if (ok != 1) {
    printf ("   setaxis 1 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_setaxis (lun, 2, tcnt, "space", "feet", zero, one, 0.0,
    xlin_dist);
  if (ok != 1) {
    printf ("   setaxis 2 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_setaxis (lun, 3, fcnt, "space", "feet", zero, one, 0.0,
    ilin_dist); 
  if (ok != 1) {
    printf ("   setaxis 3 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_addlongproperty (lun, "SEQ_DISK", "trace sequence number");
  if (ok != 1) {
    printf ("   add property 1 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_addintproperty (lun, "TLIVE_S", "head mute index");
  if (ok != 1) {
    printf ("   add property 2 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_addlongproperty (lun, "XLINE_NO", "CMP X grid coordinate");
  if (ok != 1) {
    printf ("   add property 3 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_addlongproperty (lun, "ILINE_NO", "CMP Y grid coordinate");
  if (ok != 1) {
    printf ("   add property 4 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_addfloatproperty (lun, "MAX_AMPL", "largest absolute value on trace");
  if (ok != 1) {
    printf ("   add property 5 status = %d\n", ok);
    exit (1);
  }
  ok = jsfiles_addintproperty (lun, "TLIVE_E", "tail mute index");
  if (ok != 1) {
    printf ("   add property 6 status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_setdatatype (lun, "STACK");
  if (ok != 1) {
    printf ("   set data type status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_settraceformat (lun, "FLOAT");
  if (ok != 1) {
    printf ("   set trace format status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_setbin (lun, world, grid, logical);
  if (ok != 1) {
    printf ("   set bin status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   write open status = %d\n", ok);
    exit (1);
  }
  nt = jsfiles_gettracecount (lun);
  if (nt != tcnt*fcnt) {
    printf ("   %ld traces in file\n", nt);
    exit (1);
  }

  traces = (float **)malloc (sizeof(float*)*nt);
  props = (double **)malloc (sizeof(double*)*nt);
  for (k2 = 0; k2 < nt; k2++) {
    traces[k2] = (float *)malloc (sizeof(float)*scnt);
    for (k3 = 0; k3 < scnt; k3++) {
      traces[k2][k3] = 0;
    }
    props[k2] = (double *)malloc (sizeof(double)*hcnt);
    for (k3 = 0; k3 < hcnt; k3++) {
      props[k2][k3] = 0;
    }
  }

  k4 = 1;
  for (k2 = 0; k2 < nt; k2++) {
    elem = k2 % scnt;
    traces[k2][elem] = 1;
    ok = jsfiles_settracenumber (lun, k4);
    if (ok != 1) {
      printf ("   set trace status = %d writing trace %ld\n", ok, k4);
      exit (1);
    }
    cnt = jsfiles_puttrace (lun, traces[k2], scnt);
    if (cnt != scnt) {
      printf ("   %d samples written out to trace %ld\n", cnt, k4);
      exit (1);
    }
    props[k2][0] = k4;
    props[k2][1] = 1;
    props[k2][2] = k2 % tcnt + 1;
    props[k2][3] = ((k2 / tcnt) % fcnt + 1) * 10;
    props[k2][4] = 1;
    props[k2][5] = scnt;
    ok = jsfiles_putlongproperty (lun, "SEQ_DISK", (long)props[k2][0]);
    if (ok != 1) {
      printf ("   put property 1 status = %d on trace %ld\n", ok, k4);
      exit (1);
    }
    ok = jsfiles_putintproperty (lun, "TLIVE_S", (int)props[k2][1]);
    if (ok != 1) {
      printf ("   put property 2 status = %d on trace %ld\n", ok, k4);
      exit (1);
    }
    ok = jsfiles_putlongproperty (lun, "XLINE_NO", (long)props[k2][2]);
    if (ok != 1) {
      printf ("   put property 3 status = %d on trace %ld\n", ok, k4);
      exit (1);
    }
    ok = jsfiles_putlongproperty (lun, "ILINE_NO", (long)props[k2][3]);
    if (ok != 1) {
      printf ("   put property 4 status = %d on trace %ld\n", ok, k4);
      exit (1);
    }
    ok = jsfiles_putfloatproperty (lun, "MAX_AMPL", (float)props[k2][4]);
    if (ok != 1) {
      printf ("   put property 5 status = %d on trace %ld\n", ok, k4);
      exit (1);
    }
    ok = jsfiles_putintproperty (lun, "TLIVE_E", (int)props[k2][5]);
    if (ok != 1) {
      printf ("   put property 6 status = %d on trace %ld\n", ok, k4);
      exit (1);
    }
    k4++;
  }
  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   write close status = %d\n", ok);
    exit (1);
  }

  lun = jsfiles_getlun ((const char *)path, "r");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   read open status = %d for lun = %d\n", ok, lun);
    exit (1);
  }

  ok = jsfiles_getaxis (lun, 1, &length, domain, units, &lorg, &ldel,
    &porg, &pdel);
  if (ok != 1) {
    printf ("   getaxis 1 status = %d\n", ok);
    exit (1);
  }
  ok = length == scnt &&
    strcmp (domain, "time") == 0 &&
    strcmp (units, "milliseconds") == 0 && 
    lorg == zero &&
    ldel == one &&
    porg == 0.0 &&
    pdel == srate * 1000 ? 1 : 0;
  if (ok != 1) {
    printf ("   getaxis 1 mismatch occurred\n");
    exit (1);
  }

  ok = jsfiles_getaxis (lun, 2, &length, domain, units, &lorg, &ldel,
    &porg, &pdel);
  if (ok != 1) {
    printf ("   getaxis 2 status = %d\n", ok);
    exit (1);
  }
  ok = length == tcnt &&
    strcmp (domain, "space") == 0 &&
    strcmp (units, "feet") == 0 && 
    lorg == zero &&
    ldel == one &&
    porg == 0.0 &&
    pdel == xlin_dist ? 1 : 0;
  if (ok != 1) {
    printf ("   getaxis 2 mismatch occurred\n");
    exit (1);
  }

  ok = jsfiles_getaxis (lun, 3, &length, domain, units, &lorg, &ldel,
    &porg, &pdel);
  if (ok != 1) {
    printf ("   getaxis 3 status = %d\n", ok);
    exit (1);
  }
  ok = length == fcnt &&
    strcmp (domain, "space") == 0 &&
    strcmp (units, "feet") == 0 && 
    lorg == zero &&
    ldel == one &&
    porg == 0.0 &&
    pdel == ilin_dist ? 1 : 0;
  if (ok != 1) {
    printf ("   getaxis 3 mismatch occurred\n");
    exit (1);
  }

  tl = 24;
  tl = jsfiles_getdatatype (lun, type, tl);
  if (tl != 5) {
    printf ("   get data type len = %d\n", tl);
    printf ("   get data type returned %s\n", type);
    exit (1);
  }

  fl = 24;
  fl = jsfiles_gettraceformat (lun, format, fl);
  if (fl != 5) {
    printf ("   get trace format len = %d\n", fl);
    printf ("   get trace format returned %s\n", format);
    exit (1);
  }

  isa = jsfiles_isa (lun);
  if (isa != 1) {
    printf ("   isa flag is %d\n", isa);
    exit (1);
  }

  ok = jsfiles_status (lun);
  if (ok != 1) {
    printf ("   status flag is %d\n", ok);
    exit (1);
  }

  ml = 100;
  ml = jsfiles_message (lun, mess, ml);
  if (ml != 0) {
    printf ("   error message len = %d\n", ml);
    printf ("   error message = %s\n", mess);
    exit (1);
  }

  trace_count = jsfiles_gettracecount (lun);
  if (trace_count != tcnt*fcnt) {
    printf ("   trace count is %ld\n", trace_count);
    exit (1);
  }
  sample_count = jsfiles_getsamplecount (lun);
  if (sample_count != scnt) {
    printf ("   sample count is %d\n", sample_count);
    exit (1);
  }
  if (sample_count < 1) sample_count = 1;
  trace = (float *)malloc (sample_count*sizeof(float));
  header = (double *)malloc (6*sizeof(double));
  k4 = 1;
  for (k2 = 0; k2 < trace_count; k2++) {
    ok = jsfiles_settracenumber (lun, k4);
    if (ok != 1) {
      printf ("   set trace status = %d reading trace %ld\n", ok, k4);
      exit (1);
    }
    header[0] = (double)jsfiles_getlongproperty (lun, "SEQ_DISK");
    header[1] = (double)jsfiles_getintproperty (lun, "TLIVE_S");
    header[2] = (double)jsfiles_getlongproperty (lun, "XLINE_NO");
    header[3] = (double)jsfiles_getlongproperty (lun, "ILINE_NO");
    header[4] = (double)jsfiles_getfloatproperty (lun, "MAX_AMPL");
    header[5] = (double)jsfiles_getintproperty (lun, "TLIVE_E");
    for (k3 = 0; ok == 1 && k3 < hcnt; k3++) {
      ok = header[k3] == props[k2][k3] ? 1 : 0;
    }
    if (ok != 1) {
      printf ("   property %d mismatch on trace %ld\n", k3-1, k4);
      exit (1);
    }
    cnt = jsfiles_gettrace (lun, trace, scnt);
    if (cnt != scnt) {
      printf ("   no of trace samples = %d on trace %ld\n", cnt, k4);
      exit (1);
    }
    for (k3 = 0; ok == 1 && k3 < scnt; k3++) {
      ok = trace[k3] == traces[k2][k3] ? 1 : 0;
    }
    if (ok != 1) {
      printf ("   trace value %d mismatch on trace %ld\n", k3-1, k4);
      exit (1);
    }
    k4++;
  }

  ok = jsfiles_getbin (lun, rworld, rgrid, rlogical);
  if (ok != 1) {
    printf ("   getbin status = %d\n", ok);
    exit (1);
  }

  for (k2 = 0, ok = 1; ok != 1 && k2 < 6; k2++) {
    ok = rworld[k2] == world[k2] ? 1 : 0;
    if (ok != 1) {
      printf ("   bin world coord %d mismatch\n", k2);
    }
  }

  for (k2 = 0, ok = 1; ok != 1 && k2 < 4; k2++) {
    ok = rgrid[k2] == grid[k2] ? 1 : 0;
    if (ok != 1) {
      printf ("   bin grid coord %d mismatch\n", k2);
    }
  }

  for (k2 = 0, ok = 1; ok != 1 && k2 < 6; k2++) {
    ok = rlogical[k2] == logical[k2] ? 1 : 0;
    if (ok != 1) {
      printf ("   bin logical coord %d mismatch\n", k2);
    }
  }

  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   close status = %d\n", ok);
    exit (1);
  }



  lun = jsfiles_getlun ((const char *)path, "rw");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   open to remove status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   close status = %d\n", ok);
    exit (1);
  }

  lun = jsfiles_getlun ((const char *)path, "rw");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   open to remove status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   close status = %d\n", ok);
    exit (1);
  }

  lun = jsfiles_getlun ((const char *)path, "rw");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   open to remove status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   close status = %d\n", ok);
    exit (1);
  }

  lun = jsfiles_getlun ((const char *)path, "rw");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   open to remove status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   close status = %d\n", ok);
    exit (1);
  }

  lun = jsfiles_getlun ((const char *)path, "rw");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   open to remove status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_close (lun);
  if (ok != 1) {
    printf ("   close status = %d\n", ok);
    exit (1);
  }





  lun = jsfiles_getlun ((const char *)path, "rw");
  ok = jsfiles_open (lun);
  if (ok != 1) {
    printf ("   open to remove status = %d\n", ok);
    exit (1);
  }

  ok = jsfiles_remove (lun);
  if (ok != 1) {
    printf ("   removal status = %d\n", ok);
    exit (1);
  }

  jsfiles_delete ();
  javavm_delete ();

  printf ("Success!\n");
  exit (0);
}

