#include "javavm.h"

#include <stdlib.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif


static char classpath[2048];

static JaViMa *JVM = NULL;

void javavm_create ()
{
  char *path;
  JavaVMInitArgs vm_args;
  JavaVMOption options[2];
  jint result;

  if (JVM == NULL) {
    JVM = (JaViMa *)malloc (sizeof(JaViMa));
    strcpy (classpath, "-Djava.class.path=");
    path = getenv ("CLASSPATH");
    strcat (classpath, path);
    /*printf ("class path is %s\n", classpath);*/

    options[0].optionString = classpath;

    memset (&vm_args, 0, sizeof(vm_args));
    vm_args.version = JNI_VERSION_1_6;
    /*vm_args.version = JNI_VERSION_1_4;*/
    /*vm_args.version = JNI_VERSION_1_2;*/
    vm_args.options = options;
    vm_args.nOptions = 1;
    vm_args.ignoreUnrecognized = 1;

    result = JNI_CreateJavaVM (&(JVM->_jvm), (void **)&(JVM->_env), &vm_args);
    if (result < 0) {
      fprintf (stderr, "Failed to create the Java VM\n");
      return;
    }
  }
}

JaViMa *javavm_fetch ()
{
  javavm_create ();
  return JVM;
}

void javavm_delete ()
{
  if (JVM != NULL) {
    (*(JVM->_jvm))->DestroyJavaVM (JVM->_jvm); /* has been buggy! */
    free (JVM);
    JVM = NULL;
  }
}

#ifdef __cplusplus
}
#endif
