/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parset;

import edu.mines.jtk.util.ParameterConvertException;
import edu.mines.jtk.util.ParameterSet;
import edu.mines.jtk.util.ParameterSetFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.util.SeisException;

public class ParameterSetIO {
    private static final int BROADCAST_TAG = 835872;
    private static int _defaultBufferSize = 10000;

    public static ParameterSet argsToParameters(String[] args) {
        ParameterSet parset = new ParameterSet();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') continue;
            String key = args[i].substring(1, args[i].length());
            if (++i == args.length) {
                return parset;
            }
            parset.setString(key, args[i]);
        }
        return parset;
    }

    public static ParameterSet broadcast(ParameterSet ps, IParallelContext pc) {
        if (pc == null) {
            throw new IllegalArgumentException("IParallelContext is null");
        }
        if (pc.isMaster()) {
            if (ps == null) {
                throw new IllegalArgumentException("Input ParameterSet is null");
            }
        } else if (ps == null) {
            ps = new ParameterSet();
        }
        Object[] objArray = new Object[]{ps};
        pc.bcast(835872, objArray, 0, 1, 0);
        pc.barrier();
        return (ParameterSet)objArray[0];
    }

    private static void checkFileName(String fileName, String mode) {
        if (!fileName.endsWith(".xml")) {
            new IOException("Attempt to " + mode + " XML data for non-XML file name '" + fileName + "'").printStackTrace();
        }
    }

    public static ParameterSet readFile(String fileName) throws IOException, ParameterSetFormatException {
        ParameterSetIO.checkFileName(fileName, "read");
        long fileSize = new File(fileName).length();
        StringBuffer buffer = new StringBuffer((int)fileSize);
        FileReader file = new FileReader(fileName);
        return ParameterSetIO.doReader(file, buffer);
    }

    public static ParameterSet readReader(Reader reader) throws IOException, ParameterSetFormatException {
        return ParameterSetIO.doReader(reader, new StringBuffer(_defaultBufferSize));
    }

    public static ParameterSet readInputStream(InputStream stream) throws IOException, ParameterSetFormatException {
        return ParameterSetIO.readReader(new InputStreamReader(stream));
    }

    private static ParameterSet doReader(Reader reader, StringBuffer buffer) throws IOException, ParameterSetFormatException {
        String s;
        BufferedReader input;
        BufferedReader bufferedReader = input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        while ((s = input.readLine()) != null) {
            buffer.append(s);
        }
        input.close();
        ParameterSet parset = new ParameterSet("");
        parset.fromString(buffer.toString());
        return parset;
    }

    public static void writeFile(ParameterSet ps, String fileName) throws IOException {
        ParameterSetIO.checkFileName(fileName, "write");
        FileWriter writer = new FileWriter(fileName);
        ParameterSetIO.writeWriter(ps, writer);
        ((Writer)writer).close();
    }

    public static void writeWriter(ParameterSet ps, Writer writer) throws IOException {
        writer.write(ps.toString());
    }

    public static void writeOutputStream(ParameterSet ps, OutputStream output) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(output);
        ParameterSetIO.writeWriter(ps, osw);
        osw.close();
    }

    public static void checkRequiredParameter(ParameterSet parset, String name) throws SeisException {
        if (parset.getParameter(name) == null) {
            throw new SeisException("Parameter '" + name + "' is missing from the XML properties:\n" + parset.toString());
        }
    }

    public static boolean getRequiredBoolean(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getBoolean(name, false);
    }

    public static int getRequiredInt(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getInt(name, 0);
    }

    public static long getRequiredLong(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getLong(name, 0L);
    }

    public static float getRequiredFloat(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getFloat(name, 0.0f);
    }

    public static double getRequiredDouble(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getDouble(name, 0.0);
    }

    public static String getRequiredString(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getString(name, null);
    }

    public static boolean[] getRequiredBooleans(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getBooleans(name, null);
    }

    public static int[] getRequiredInts(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getInts(name, null);
    }

    public static long[] getRequiredLongs(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getLongs(name, null);
    }

    public static float[] getRequiredFloats(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getFloats(name, null);
    }

    public static double[] getRequiredDoubles(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getDoubles(name, null);
    }

    public static String[] getRequiredStrings(ParameterSet parset, String name) throws ParameterConvertException, SeisException {
        ParameterSetIO.checkRequiredParameter(parset, name);
        return parset.getStrings(name, null);
    }
}

