/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javaseis.array.IMultiArray;
import org.javaseis.compress.TraceCompressor;
import org.javaseis.grid.BinGrid;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.BufferedVirtualIO;
import org.javaseis.io.ExtentListEntry;
import org.javaseis.io.ExtentManager;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.JSUtilFile;
import org.javaseis.io.TraceMap;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualFoldersSS;
import org.javaseis.io.VirtualIO;
import org.javaseis.opf.OpfCollection;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;
import org.javaseis.properties.PropertiesConverter;
import org.javaseis.properties.PropertiesTree;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;
import org.javaseis.properties.Units;
import org.javaseis.seiszip.SeisPEG;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.ArrayUtil;
import org.javaseis.util.SeisException;

public class Seisio
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Seisio.class.getName());
    protected static boolean _testMode = false;
    public static final int VERSION_J_REFERENCE1 = 1;
    public static final int VERSION_J_REFERENCE2 = 2;
    private static final String COMMENTS = "Comments";
    public static final String DATA_DIMENSIONS = "DataDimensions";
    protected static final String DATA_TYPE = "DataType";
    protected static final String BYTE_ORDER = "ByteOrder";
    protected static final String TRACE_FORMAT = "TraceFormat";
    public static final String MAPPED = "Mapped";
    public static final String PHYSICAL_ORIGINS = "PhysicalOrigins";
    public static final String PHYSICAL_DELTAS = "PhysicalDeltas";
    public static final String AXIS_UNITS = "AxisUnits";
    public static final String AXIS_LABELS = "AxisLabels";
    public static final String AXIS_DOMAINS = "AxisDomains";
    public static final String AXIS_LENGTHS = "AxisLengths";
    public static final String HEADER_LENGTH_BYTES = "HeaderLengthBytes";
    public static final String HEADER_LENGTH = "HeaderLength";
    public static final String LOGICAL_ORIGINS = "LogicalOrigins";
    public static final String LOGICAL_DELTAS = "LogicalDeltas";
    private static final String JAVASEIS_VERSION = "JavaSeisVersion";
    public static final String DESCRIPTIVE_NAME = "DescriptiveName";
    private static final String HAS_TRACES = "HasTraces";
    private static final String FILE_PROPERTIES_OBS = "FileProperties";
    public static final String FILE_PROPERTIES_XML = "FileProperties.xml";
    private static final String HISTORY_XML = "History.xml";
    public static final String FILE_STUB = "Name.properties";
    public static final String TRACE_DATA = "TraceFile";
    public static final String TRACE_HEADERS = "TraceHeaders";
    public static final String TRACE_MAP = "TraceMap";
    public static final String HAS_TRACES_FILE = "Status.properties";
    private static final String TRACE_DATA_XML = "TraceFile.xml";
    private static final String TRACE_HEADERS_XML = "TraceHeaders.xml";
    private static final String SORT_FILES = "^Sort.*$";
    public static final String MODE_READ_ONLY = "r";
    public static final String MODE_READ_WRITE = "rw";
    protected static final String _earlyVersion1 = "2006.01";
    protected static final String _preXmlVersion = "2006.2";
    protected static final String _version = "2006.3";
    private static final long FLUSH_INTERVAL = Integer.parseInt(System.getProperty("org.javaseis.io.flushInterval", "1000"));
    protected String _path;
    protected int _versionInput = 2;
    protected int _versionOutput = 2;
    protected GridDefinition _gridDefinition;
    protected DataDefinition _dataDefinition;
    private TraceProperties _traceProperties = null;
    private ParameterSet _tracePropertiesParset = null;
    private PropertiesTree _propertiesTree = null;
    protected ParameterSet _filePropertiesParset = null;
    protected boolean _isReadOnly;
    protected boolean _isChanged;
    protected boolean _isMapped;
    protected boolean _isVirtual;
    protected boolean _usesHeaderProperties;
    protected boolean _ignoreHeadersAndFoldMap;
    protected ByteOrder _byteOrder;
    protected TraceCompressor _traceCompressor;
    protected SeisPEG _seisPEG;
    protected OpfCollection _opfCollection;
    protected VirtualIO _traceIO;
    protected VirtualIO _headerIO;
    private long _currentFrameCnt;
    protected ByteBuffer _traceBuffer;
    protected FloatBuffer _traceBufferView;
    protected byte[] _byteTraceBuffer;
    protected ByteBuffer _headerBuffer;
    protected IntBuffer _headerBufferView;
    protected float[][] _traceData;
    protected int _headerLengthBytes;
    protected int _headerLengthWords;
    protected int _traceLength;
    protected int _traceLengthWords;
    protected long _frameLength;
    protected long _frameHeaderLength;
    protected long _volumeLength;
    protected DataFormat _traceFormat;
    protected long _traceIndex;
    protected int _frameIndex;
    protected int _volumeIndex;
    protected long _traceFilePosition;
    protected long _headerFilePosition;
    protected int[] _position;
    protected TraceMap _traceMap = null;
    protected int _tracesInFrame = 0;
    protected VirtualFolders _vFolders = null;
    private static List<String> s_savePrimaryFilesList;

    public static void setLogLevel(Level logLevel) {
    }

    public static ParameterSet readHistory(String datasetPath) throws IOException {
        String historyFileName = datasetPath + File.separator + HISTORY_XML;
        return ParameterSetIO.readFile(historyFileName);
    }

    public static void createStub(String datasetPath, String descriptiveName) throws IOException {
        Seisio.writeSingleProperty(datasetPath, FILE_STUB, DESCRIPTIVE_NAME, descriptiveName);
    }

    private static void writeSingleProperty(String datasetPath, String fileName, String propertyName, String propertyValue) throws IOException {
        boolean success;
        Properties properties = new Properties();
        properties.setProperty(propertyName, propertyValue);
        String comments = "www.javaseis.org - JavaSeis File Properties 2006.3";
        File dir = new File(datasetPath);
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new IOException("Unable to create JavaSeis directory '" + datasetPath + "'");
        }
        File file = new File(datasetPath + File.separator + fileName);
        file.delete();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, comments);
        fileOutputStream.close();
    }

    public static String getDescription(String datasetPath) throws IOException {
        Seisio.convertIfNecessary(datasetPath);
        File file = new File(datasetPath + File.separator + FILE_STUB);
        FileInputStream inStream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(inStream);
        ((InputStream)inStream).close();
        String descriptiveName = properties.getProperty(DESCRIPTIVE_NAME);
        if (descriptiveName == null) {
            throw new IOException("The descriptive name property 'DescriptiveName' was not found in JavaSeis stub file '" + file.getAbsolutePath() + "'");
        }
        return descriptiveName;
    }

    public static boolean hasStub(String datasetPath) {
        Seisio.convertIfNecessary(datasetPath);
        return new File(datasetPath + File.separator + FILE_STUB).exists();
    }

    public static boolean hasFramework(String datasetPath) {
        return new File(datasetPath + File.separator + FILE_PROPERTIES_XML).exists();
    }

    public static boolean setHasTraces(String datasetPath, boolean hasTraces) {
        if (Seisio.hasTraces(datasetPath) == hasTraces) {
            return true;
        }
        try {
            Seisio.writeSingleProperty(datasetPath, HAS_TRACES_FILE, HAS_TRACES, Boolean.toString(hasTraces));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasBeenEmptied(String datasetPath) {
        if (datasetPath == null) {
            throw new IllegalArgumentException("Path to dataset cannot be null");
        }
        String hasTracesFile = datasetPath + File.separator + HAS_TRACES_FILE;
        boolean exists = new File(hasTracesFile).exists();
        boolean hasTraces = Seisio.hasTraces(datasetPath);
        return Seisio.hasFramework(datasetPath) && !hasTraces && (exists || !VirtualFolders.isVirtual(datasetPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTraces(String datasetPath) {
        if (datasetPath == null) {
            throw new IllegalArgumentException("Path to dataset cannot be null");
        }
        String hasTracesFile = datasetPath + File.separator + HAS_TRACES_FILE;
        if (new File(hasTracesFile).exists()) {
            Properties properties = new Properties();
            FileInputStream fs = null;
            int ntries = 10;
            for (int itry = 0; itry < ntries; ++itry) {
                try {
                    fs = new FileInputStream(hasTracesFile);
                    properties.load(fs);
                    String hasTracesProp = properties.getProperty(HAS_TRACES, Boolean.toString(false));
                    boolean bl = Boolean.valueOf(hasTracesProp);
                    return bl;
                }
                catch (FileNotFoundException e) {
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    if (itry == ntries - 1) {
                        e.printStackTrace();
                        continue;
                    }
                    try {
                        Thread.sleep(250L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        boolean bl = false;
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (IOException ex2) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                }
                finally {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return false;
    }

    private static void convertIfNecessary(String datasetPath) {
        try {
            if (PropertiesConverter.needsConversion(datasetPath)) {
                PropertiesConverter.convert(datasetPath);
                if (PropertiesConverter.needsConversion(datasetPath)) {
                    new SeisException("Properties conversion failed for dataset '" + datasetPath + "'").printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delete(String path) {
        JSUtilFile ufile = new JSUtilFile(path);
        if (!ufile.isDirectory()) {
            return false;
        }
        try {
            VirtualFolders vFolders = VirtualFolders.factory(path);
            return ExtentManager.delete(path, vFolders, true);
        }
        catch (SeisException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean purge(String path) {
        boolean ok = true;
        JSUtilFile ufile = new JSUtilFile(path);
        if (!ufile.isDirectory()) {
            return false;
        }
        try {
            VirtualFolders vFolders = VirtualFolders.factory(path);
            if (ExtentManager.delete(path, vFolders, false) && ufile.exists()) {
                File[] files = ufile.listFiles();
                if (files != null) {
                    for (File f : files) {
                        boolean deleteit = true;
                        for (String saveExpr : s_savePrimaryFilesList) {
                            if (!f.getName().equals(saveExpr) && !f.getName().matches(saveExpr)) continue;
                            deleteit = false;
                            break;
                        }
                        if (!deleteit) continue;
                        ok &= new JSUtilFile(f).recursiveDelete();
                    }
                }
                vFolders = new VirtualFoldersSS(path, new String[]{path}, new ExtentPolicyRandom());
                vFolders.store();
                File traceDataXML = new File(path, TRACE_DATA_XML);
                File traceHeadersXML = new File(path, TRACE_HEADERS_XML);
                if (!traceDataXML.exists()) {
                    VirtualIO traceIO = new VirtualIO(path + File.separator + TRACE_DATA_XML, TRACE_DATA, vFolders, 1L, 1, 1L);
                    traceIO.close();
                }
                if (!traceHeadersXML.exists()) {
                    VirtualIO headerIO = new VirtualIO(path + File.separator + TRACE_HEADERS_XML, TRACE_HEADERS, vFolders, 1L, 1, 1L);
                    headerIO.close();
                }
            }
            Seisio.setHasTraces(path, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return ok;
    }

    public static boolean isJavaSeis(String path) {
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.isDirectory()) {
            return false;
        }
        f = new File(path + File.separator + FILE_PROPERTIES_XML);
        if (!(f.exists() && f.isFile() || (f = new File(path + File.separator + FILE_PROPERTIES_OBS)).exists() && f.isFile())) {
            return false;
        }
        f = new File(path + File.separator + TRACE_DATA);
        return f.exists() && f.isFile() || (f = new File(path + File.separator + TRACE_DATA_XML)).exists() && f.isFile();
    }

    public Seisio(String path) throws SeisException {
        this._path = new String(path);
        this._gridDefinition = null;
        this._dataDefinition = null;
        boolean mustExist = false;
        this._propertiesTree = new PropertiesTree(path, mustExist);
        this._filePropertiesParset = this._propertiesTree.getFileProperties();
        this._tracePropertiesParset = this._propertiesTree.getTraceProperties();
        this._isMapped = false;
        this._isVirtual = false;
        this._filePropertiesParset.setString(COMMENTS, "www.javaseis.org - JavaSeis File Properties 2006.3");
        this._filePropertiesParset.setString(JAVASEIS_VERSION, _version);
        this._filePropertiesParset.setString(DATA_TYPE, "UNKNOWN");
        this._filePropertiesParset.setString(TRACE_FORMAT, "FLOAT");
        this._filePropertiesParset.setString(BYTE_ORDER, ByteOrder.nativeOrder().toString());
        this._filePropertiesParset.setBoolean(MAPPED, false);
        this._usesHeaderProperties = false;
    }

    public Seisio(String path, GridDefinition gridDefinition) throws SeisException {
        this(path, gridDefinition, DataDefinition.getDefault(), null);
    }

    public Seisio(String path, GridDefinition gridDefinition, DataDefinition dataDefinition, TraceProperties headerDefinition) throws SeisException {
        this(path);
        this._gridDefinition = gridDefinition;
        this._dataDefinition = dataDefinition;
        this._traceProperties = headerDefinition;
        if (headerDefinition != null) {
            this._usesHeaderProperties = true;
            this._headerLengthBytes = headerDefinition.getRecordLength();
            this._headerLengthWords = this._headerLengthBytes / 4;
            if (this._headerLengthWords * 4 < this._headerLengthBytes) {
                ++this._headerLengthWords;
            }
            headerDefinition.toParameterSet(this._tracePropertiesParset);
        } else {
            this._usesHeaderProperties = false;
        }
        this._filePropertiesParset.setString(DATA_TYPE, dataDefinition.getDataTypeString());
        this._filePropertiesParset.setString(TRACE_FORMAT, dataDefinition.getTraceFormatString());
        this._filePropertiesParset.setString(BYTE_ORDER, dataDefinition.getByteOrderString());
        this._filePropertiesParset.setInt(DATA_DIMENSIONS, gridDefinition.getNumDimensions());
        this._filePropertiesParset.setStrings(AXIS_LABELS, gridDefinition.getAxisLabelsStrings());
        this._filePropertiesParset.setStrings(AXIS_UNITS, gridDefinition.getAxisUnitsStrings());
        this._filePropertiesParset.setStrings(AXIS_DOMAINS, gridDefinition.getAxisDomainsStrings());
        this._filePropertiesParset.setLongs(AXIS_LENGTHS, gridDefinition.getAxisLengths());
        this._filePropertiesParset.setLongs(LOGICAL_ORIGINS, gridDefinition.getAxisLogicalOrigins());
        this._filePropertiesParset.setLongs(LOGICAL_DELTAS, gridDefinition.getAxisLogicalDeltas());
        this._filePropertiesParset.setDoubles(PHYSICAL_ORIGINS, gridDefinition.getAxisPhysicalOrigins());
        this._filePropertiesParset.setDoubles(PHYSICAL_DELTAS, gridDefinition.getAxisPhysicalDeltas());
        this._filePropertiesParset.setInt(HEADER_LENGTH_BYTES, this._headerLengthBytes);
    }

    public Seisio(String path, int ndim, int[] idim, ByteOrder byteOrder) throws SeisException {
        this(path);
        this._gridDefinition = GridDefinition.getDefault(ndim, idim);
        this._dataDefinition = new DataDefinition(DataType.CUSTOM, DataFormat.FLOAT, byteOrder);
        this._byteOrder = byteOrder;
        this._usesHeaderProperties = false;
        this._headerLengthBytes = 0;
        this._headerLengthWords = 0;
        this._filePropertiesParset.setString(DATA_TYPE, this._dataDefinition.getDataTypeString());
        this._filePropertiesParset.setString(TRACE_FORMAT, this._dataDefinition.getTraceFormatString());
        this._filePropertiesParset.setString(BYTE_ORDER, this._dataDefinition.getByteOrderString());
        this._filePropertiesParset.setInt(DATA_DIMENSIONS, this._gridDefinition.getNumDimensions());
        this._filePropertiesParset.setStrings(AXIS_LABELS, this._gridDefinition.getAxisLabelsStrings());
        this._filePropertiesParset.setStrings(AXIS_UNITS, this._gridDefinition.getAxisUnitsStrings());
        this._filePropertiesParset.setStrings(AXIS_DOMAINS, this._gridDefinition.getAxisDomainsStrings());
        this._filePropertiesParset.setLongs(AXIS_LENGTHS, this._gridDefinition.getAxisLengths());
        this._filePropertiesParset.setLongs(LOGICAL_ORIGINS, this._gridDefinition.getAxisLogicalOrigins());
        this._filePropertiesParset.setLongs(LOGICAL_DELTAS, this._gridDefinition.getAxisLogicalDeltas());
        this._filePropertiesParset.setDoubles(PHYSICAL_ORIGINS, this._gridDefinition.getAxisPhysicalOrigins());
        this._filePropertiesParset.setDoubles(PHYSICAL_DELTAS, this._gridDefinition.getAxisPhysicalDeltas());
        this._filePropertiesParset.setInt(HEADER_LENGTH_BYTES, this._headerLengthBytes);
    }

    public void create() throws SeisException {
        this.do_create(false, null, 0);
    }

    public void create(VirtualFolders vFolders, int vfioNumExtents) throws SeisException {
        if (vfioNumExtents < 1) {
            throw new SeisException("VFIO Extent count is too small");
        }
        this.do_create(true, vFolders, vfioNumExtents);
    }

    private void do_create(boolean isVirtual, VirtualFolders vFolders, int numExtents) throws SeisException {
        String extentName;
        File file;
        this._isVirtual = isVirtual;
        if (this._isVirtual) {
            this._vFolders = vFolders;
        }
        if ((file = new File(this._path)).exists()) {
            if (!file.isDirectory()) {
                throw new SeisException("Existing path is not directory: " + this._path);
            }
        } else if (!file.mkdirs()) {
            throw new SeisException("Could not create directory: " + this._path);
        }
        int numSamples = (int)this._gridDefinition.getAxisLength(0);
        int traceLengthInBytes = TraceCompressor.getRecordLength(this._dataDefinition.getTraceFormat(), numSamples);
        long traceCount = 1L;
        for (int i = 1; i < this._gridDefinition.getNumDimensions(); ++i) {
            traceCount *= this._gridDefinition.getAxisLength(i);
        }
        long traceFileFrameSize = (long)traceLengthInBytes * this._gridDefinition.getAxisLength(1);
        long headerFileFrameSize = (long)this._headerLengthBytes * this._gridDefinition.getAxisLength(1);
        long traceFileLength = traceCount * (long)traceLengthInBytes;
        long headerFileLength = traceCount * (long)this._headerLengthBytes;
        if (this._isVirtual) {
            extentName = TRACE_DATA;
            this._traceIO = new VirtualIO(this._path + File.separator + TRACE_DATA_XML, extentName, this._vFolders, traceFileLength, numExtents, traceFileFrameSize);
        } else {
            this._traceIO = new VirtualIO(this._path + File.separator + TRACE_DATA);
        }
        if (this._usesHeaderProperties) {
            if (this._isVirtual) {
                extentName = TRACE_HEADERS;
                this._headerIO = new VirtualIO(this._path + File.separator + TRACE_HEADERS_XML, extentName, this._vFolders, headerFileLength, numExtents, headerFileFrameSize);
            } else {
                this._headerIO = new VirtualIO(this._path + File.separator + TRACE_HEADERS);
            }
        }
        int numTraces = (int)this._gridDefinition.getAxisLength(1);
        int numFrames = (int)this._gridDefinition.getAxisLength(2);
        int numHeaderWords = this._headerLengthBytes / 4;
        DataFormat traceFormat = this._dataDefinition.getTraceFormat();
        this._traceLength = TraceCompressor.getRecordLength(traceFormat, numSamples);
        this._traceLengthWords = (int)this._gridDefinition.getAxisLength(0);
        this._traceFormat = this._dataDefinition.getTraceFormat();
        this._traceLength = TraceCompressor.getRecordLength(this._traceFormat, numSamples);
        this._traceFormat = this._dataDefinition.getTraceFormat();
        this._traceLength = TraceCompressor.getRecordLength(this._traceFormat, numSamples);
        this._traceLengthWords = (int)this._gridDefinition.getAxisLength(0);
        this._frameLength = (long)this._traceLength * (long)numTraces;
        this._volumeLength = this._frameLength * (long)numFrames;
        this._frameHeaderLength = (long)this._headerLengthBytes * (long)numTraces;
        try {
            this._byteOrder = this._dataDefinition.getByteOrder();
            if (this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
                this._byteTraceBuffer = new byte[(int)this._frameLength + SeisPEG.getOutputHdrBufferSize(this._headerLengthWords, numTraces)];
                this._traceBuffer = ByteBuffer.wrap(this._byteTraceBuffer);
            } else {
                this._traceBuffer = ByteBuffer.allocateDirect((int)this._frameLength);
            }
            this._traceBuffer.order(this._byteOrder);
            this._traceBufferView = this._traceBuffer.asFloatBuffer();
            this._traceData = new float[numTraces][numSamples];
            if (this._usesHeaderProperties) {
                this._headerBuffer = ByteBuffer.allocateDirect((int)this._frameHeaderLength);
                this._headerBuffer.order(this._byteOrder);
                this._headerBufferView = this._headerBuffer.asIntBuffer();
                this._traceProperties.setBuffer(this._headerBuffer);
            }
            this._traceMap = this.loadTraceMap(this._isMapped, "wb");
        }
        catch (IllegalArgumentException ex) {
            throw new SeisException("Error allocating buffers\n" + ex.getMessage());
        }
        if (!this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
            this._traceCompressor = new TraceCompressor(this._traceFormat, numSamples, this._traceBuffer);
        }
        if (!Seisio.hasStub(this._path)) {
            String descriptiveName = this._path;
            try {
                Seisio.createStub(this._path, descriptiveName);
            }
            catch (IOException e) {
                throw new SeisException(e.toString());
            }
        }
        this._propertiesTree.write();
        this._traceIndex = 0L;
        this._frameIndex = -1;
        this._volumeIndex = -1;
        this._traceFilePosition = 0L;
        this._headerFilePosition = 0L;
        int numDimensions = this._gridDefinition.getNumDimensions();
        this._position = new int[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            this._position[i] = -1;
        }
        if (this._isVirtual) {
            this._vFolders.store();
            String value = System.getenv("PRECREATE_EXTENTS");
            if (value != null) {
                value = value.toLowerCase();
            }
            if (value != null && (value.startsWith("t") || value.startsWith("y"))) {
                LOG.info("Precreating extents");
                String[] folders = this._vFolders.getSecondary();
                for (int i = 0; i < numExtents; ++i) {
                    int index = this._vFolders._policy.getNextExtentFolder(i, numExtents, this._vFolders);
                    String traceFile = folders[index] + File.separatorChar + TRACE_DATA + i;
                    File tf = new File(traceFile);
                    String headerFile = folders[index] + File.separatorChar + TRACE_HEADERS + i;
                    File hf = new File(headerFile);
                    try {
                        tf.createNewFile();
                        LOG.fine(tf.getAbsolutePath());
                        hf.createNewFile();
                        LOG.fine(hf.getAbsolutePath());
                        continue;
                    }
                    catch (IOException e) {
                        throw new SeisException(e.toString());
                    }
                }
            }
        }
        if (this._isMapped) {
            this._traceMap.intializeTraceMapOnDisk();
        }
        this._isReadOnly = false;
        this._isChanged = false;
    }

    public boolean delete() {
        try {
            this.close();
        }
        catch (SeisException seisException) {
            // empty catch block
        }
        return Seisio.delete(this._path);
    }

    public void open(String openMode, IParallelContext pc) throws SeisException {
        if (pc == null) {
            throw new IllegalArgumentException("ParallelContext is not valid");
        }
        if (!VirtualFolders.isVirtual(this._path)) {
            this.open(openMode);
            return;
        }
        this._vFolders = VirtualFolders.factory(this._path);
        if (pc.rank() == 0) {
            this._vFolders.findExtents();
        }
        String[] traces = this._vFolders.getExtentPathNames(TRACE_DATA);
        String[] headers = this._vFolders.getExtentPathNames(TRACE_HEADERS);
        int[] lengths = new int[]{traces.length, headers.length};
        pc.bcastInt(0, lengths, 0, 2, 0);
        if (pc.rank() != 0) {
            traces = new String[lengths[0]];
            headers = new String[lengths[1]];
        }
        pc.bcast(0, traces, 0, traces.length, 0);
        pc.bcast(0, headers, 0, headers.length, 0);
        this._vFolders.preComputedExtents(traces, headers);
        this.open(openMode);
    }

    public void loadDatasetDefinition() throws SeisException {
        DataType dataType = DataType.UNKNOWN;
        this._traceFormat = DataFormat.FLOAT;
        File dir = new File(this._path);
        if (!dir.isDirectory()) {
            throw new SeisException("Directory does not exist: " + this._path);
        }
        Seisio.convertIfNecessary(this._path);
        boolean mustExist = true;
        this._propertiesTree = new PropertiesTree(this._path, mustExist);
        this._propertiesTree.read();
        this._filePropertiesParset = this._propertiesTree.getFileProperties();
        this._tracePropertiesParset = this._propertiesTree.getTraceProperties();
        try {
            String value = this._filePropertiesParset.getString(JAVASEIS_VERSION, null);
            if (value != null) {
                if (value.equals(_earlyVersion1)) {
                    this._versionInput = 1;
                } else if (value.equals(_preXmlVersion)) {
                    this._versionInput = 1;
                }
            }
            this._byteOrder = ByteOrder.LITTLE_ENDIAN;
            if (this._filePropertiesParset.getString(BYTE_ORDER, "LITTLE_ENDIAN").equals("BIG_ENDIAN")) {
                this._byteOrder = ByteOrder.BIG_ENDIAN;
            }
            int numDimensions = ParameterSetIO.getRequiredInt(this._filePropertiesParset, DATA_DIMENSIONS);
            AxisLabel[] axisLabels = new AxisLabel[numDimensions];
            Units[] axisUnits = new Units[numDimensions];
            DataDomain[] axisDomains = new DataDomain[numDimensions];
            String[] axisLabelsStr = new String[numDimensions];
            String[] axisUnitsStr = new String[numDimensions];
            String[] axisDomainsStr = new String[numDimensions];
            long[] axisLengths = new long[numDimensions];
            long[] logicalOrigins = new long[numDimensions];
            long[] logicalDeltas = new long[numDimensions];
            double[] physicalOrigins = new double[numDimensions];
            double[] physicalDeltas = new double[numDimensions];
            axisLabelsStr = ParameterSetIO.getRequiredStrings(this._filePropertiesParset, AXIS_LABELS);
            axisUnitsStr = ParameterSetIO.getRequiredStrings(this._filePropertiesParset, AXIS_UNITS);
            axisDomainsStr = ParameterSetIO.getRequiredStrings(this._filePropertiesParset, AXIS_DOMAINS);
            axisLengths = ParameterSetIO.getRequiredLongs(this._filePropertiesParset, AXIS_LENGTHS);
            logicalOrigins = ParameterSetIO.getRequiredLongs(this._filePropertiesParset, LOGICAL_ORIGINS);
            logicalDeltas = ParameterSetIO.getRequiredLongs(this._filePropertiesParset, LOGICAL_DELTAS);
            physicalOrigins = ParameterSetIO.getRequiredDoubles(this._filePropertiesParset, PHYSICAL_ORIGINS);
            physicalDeltas = ParameterSetIO.getRequiredDoubles(this._filePropertiesParset, PHYSICAL_DELTAS);
            AxisDefinition[] axis = new AxisDefinition[numDimensions];
            for (int i = 0; i < numDimensions; ++i) {
                axisLabels[i] = AxisLabel.get(axisLabelsStr[i]);
                if (axisLabels[i] == null) {
                    axisLabels[i] = new AxisLabel(axisLabelsStr[i], axisLabelsStr[i]);
                }
                axisUnits[i] = Units.get(axisUnitsStr[i]);
                if (axisUnits[i] == null) {
                    axisUnits[i] = new Units(axisUnitsStr[i], "");
                }
                axisDomains[i] = DataDomain.get(axisDomainsStr[i]);
                if (axisDomains[i] == null) {
                    axisDomains[i] = new DataDomain(axisDomainsStr[i], "");
                }
                axis[i] = new AxisDefinition(axisLabels[i], axisUnits[i], axisDomains[i], axisLengths[i], logicalOrigins[i], logicalDeltas[i], physicalOrigins[i], physicalDeltas[i]);
            }
            this._gridDefinition = new GridDefinition(numDimensions, axis);
            String dataTypeStr = ParameterSetIO.getRequiredString(this._filePropertiesParset, DATA_TYPE);
            dataType = DataType.get(dataTypeStr);
            String traceFormatStr = ParameterSetIO.getRequiredString(this._filePropertiesParset, TRACE_FORMAT);
            this._traceFormat = DataFormat.get(traceFormatStr);
            this._dataDefinition = new DataDefinition(dataType, this._traceFormat, this._byteOrder);
            this._isMapped = this._filePropertiesParset.getBoolean(MAPPED, false);
            switch (this._versionInput) {
                case 1: 
                case 2: {
                    this._headerLengthBytes = ParameterSetIO.getRequiredInt(this._filePropertiesParset, HEADER_LENGTH_BYTES);
                    if (this._headerLengthBytes <= 0) break;
                    this._usesHeaderProperties = true;
                    this._headerLengthWords = this._headerLengthBytes / 4;
                    break;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SeisException("Error processing properties file:\n" + ex.getMessage());
        }
        this._isChanged = false;
        int numHeaderProps = 0;
        PropertyDescription[] headerProps = null;
        if (this._usesHeaderProperties) {
            try {
                if (this._tracePropertiesParset == null) {
                    throw new SeisException("Trace Properties XML parameter set is missing");
                }
                if (this._tracePropertiesParset.countParameterSets() < 1) {
                    throw new SeisException("Trace Properties XML parameter set is zero-length");
                }
                this._traceProperties = new TraceProperties(this._tracePropertiesParset);
                headerProps = this._traceProperties.getTraceProperties();
                if (headerProps != null) {
                    numHeaderProps = headerProps.length;
                }
            }
            catch (IOException ex) {
                if (ex instanceof SeisException) {
                    throw (SeisException)ex;
                }
                throw new SeisException("Error loading header properties\n" + ex.getMessage());
            }
            if (this._traceProperties.getRecordLength() != this._headerLengthBytes) {
                throw new SeisException("Header length mismatch\nFileProperties=" + this._headerLengthBytes + "\n" + "TraceHeaders=" + this._traceProperties.getRecordLength());
            }
        }
    }

    public void setIgnoreHeadersAndFoldMap(boolean ignore) {
        this._ignoreHeadersAndFoldMap = ignore;
    }

    public void open(String openMode) throws SeisException {
        this.loadDatasetDefinition();
        String mode = MODE_READ_ONLY;
        this._isReadOnly = true;
        if (openMode.equals(MODE_READ_WRITE)) {
            this._isReadOnly = false;
            mode = MODE_READ_WRITE;
        }
        this._isVirtual = VirtualFolders.isVirtual(this._path);
        if (this._isVirtual) {
            if (this._vFolders == null) {
                this._vFolders = VirtualFolders.factory(this._path);
            }
            VirtualFolder[] v = this._vFolders.getFolders();
            LOG.fine("VirtualFolders:");
            for (VirtualFolder f : v) {
                LOG.fine(" " + f.getPath());
            }
        }
        String modeFixed = this.refineMode(mode, "org.javaseis.io.trace.bufferedwrites");
        this._traceIO = this.loadTraceVIO(modeFixed);
        this._headerIO = this.loadHeaderVIO(modeFixed);
        int numSamples = (int)this._gridDefinition.getNumSamplesPerTrace();
        int numTraces = (int)this._gridDefinition.getNumTracesPerFrame();
        int numFrames = (int)this._gridDefinition.getNumFramesPerVolume();
        int numHeaderWords = this._headerLengthBytes / 4;
        this._traceLengthWords = numSamples;
        this._traceLength = TraceCompressor.getRecordLength(this._traceFormat, numSamples);
        this._frameLength = (long)this._traceLength * (long)numTraces;
        this._volumeLength = this._frameLength * (long)numFrames;
        this._frameHeaderLength = (long)this._headerLengthBytes * (long)numTraces;
        try {
            if (this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
                this._byteTraceBuffer = new byte[(int)this._frameLength + SeisPEG.getOutputHdrBufferSize(this._headerLengthWords, numTraces)];
                this._traceBuffer = ByteBuffer.wrap(this._byteTraceBuffer);
            } else {
                this._traceBuffer = ByteBuffer.allocateDirect((int)this._frameLength);
            }
            this._traceBuffer.order(this._byteOrder);
            this._traceBufferView = this._traceBuffer.asFloatBuffer();
            this._traceData = new float[numTraces][numSamples];
            if (this._usesHeaderProperties) {
                this._headerBuffer = ByteBuffer.allocateDirect((int)this._frameHeaderLength);
                this._headerBuffer.order(this._byteOrder);
                this._headerBufferView = this._headerBuffer.asIntBuffer();
                this._traceProperties.setBuffer(this._headerBuffer);
            }
            this._traceMap = this.loadTraceMap(this._isMapped, mode);
        }
        catch (IllegalArgumentException ex) {
            throw new SeisException("Could not allocate buffers\n" + ex.getMessage());
        }
        if (!this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
            this._traceCompressor = new TraceCompressor(this._traceFormat, numSamples, this._traceBuffer);
        }
        this._traceIndex = -1L;
        this._frameIndex = -1;
        this._volumeIndex = -1;
        this._traceFilePosition = -1L;
        this._headerFilePosition = -1L;
        int numDimensions = this._gridDefinition.getNumDimensions();
        this._position = new int[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            this._position[i] = -1;
        }
    }

    public void close() throws SeisException {
        long[] stats;
        if (this._opfCollection != null) {
            this._opfCollection.close();
        }
        if (this._traceIO != null) {
            if (this._traceIO instanceof BufferedVirtualIO) {
                stats = ((BufferedVirtualIO)this._traceIO).getWriteStats();
                System.out.println("TraceIO writes = " + stats[0] + " actual disk writes = " + stats[1] + " gaps filled = " + stats[2] + " gaps larger than a single block = " + stats[3]);
            }
            this._traceIO.close();
        }
        if (this._headerIO != null) {
            if (this._headerIO instanceof BufferedVirtualIO) {
                stats = ((BufferedVirtualIO)this._headerIO).getWriteStats();
                System.out.println("HeaderIO writes = " + stats[0] + " actual disk writes = " + stats[1] + " gaps filled = " + stats[2] + " gaps larger than a single block = " + stats[3]);
            }
            this._headerIO.close();
        }
        if (this._isMapped && this._traceMap != null) {
            this._traceMap.close();
        }
        if (!this._isChanged) {
            return;
        }
        this._propertiesTree.write();
    }

    public void writeHistory(ParameterSet historyParameters) throws IOException {
        String historyFileName = this._path + File.separator + HISTORY_XML;
        ParameterSetIO.writeFile(historyParameters, historyFileName);
    }

    public ParameterSet readHistory() throws IOException {
        return Seisio.readHistory(this._path);
    }

    public String getBasePath() {
        return this._path;
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    public boolean isMapped() {
        return this._isMapped;
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    public String getVersionString() {
        return _version;
    }

    public GridDefinition getGridDefinition() {
        return this._gridDefinition;
    }

    public DataDefinition getDataDefinition() {
        return this._dataDefinition;
    }

    public TraceProperties getTraceProperties() {
        return this._traceProperties;
    }

    public void writeBinGridToFileProperties(ParameterSet ps) {
        this._isChanged = true;
        this._filePropertiesParset.addParameterSet("BinGrid");
        ps.copyTo(this._filePropertiesParset);
    }

    public BinGrid getBinGrid() throws SeisException {
        return new BinGrid(this._filePropertiesParset.getParameterSet("BinGrid"));
    }

    public ParameterSet getCustomProperties() {
        if (this._propertiesTree == null) {
            throw new RuntimeException("Root parameter set is null (dataset not initialized?)");
        }
        return this._propertiesTree.getCustomProperties();
    }

    public void storeProperties() throws SeisException {
        if (this._propertiesTree == null) {
            throw new RuntimeException("Root parameter set is null (dataset not initialized?)");
        }
        this._propertiesTree.write();
    }

    public long getTraceIndex() {
        return this._traceIndex;
    }

    public int getTracesInFrame() {
        return this._tracesInFrame;
    }

    public int readFrame(int[] position) throws SeisException {
        this.setPosition(position);
        int numTraces = this.readFrame();
        return numTraces;
    }

    public int readFullFrame() throws SeisException {
        this._tracesInFrame = (int)this._gridDefinition.getNumTracesPerFrame();
        int numTraces = this.readFrame();
        return numTraces;
    }

    public int writeFrame(int[] position, int tracesToWrite) throws SeisException {
        this.setPosition(position);
        int numTraces = this.writeFrame(tracesToWrite);
        return numTraces;
    }

    public void readMultiArray(IMultiArray a, int[] position) throws SeisException {
        int[] alen = a.getShape();
        int asize = alen.length;
        long[] dlen = this._gridDefinition.getAxisLengths();
        if (asize > this._gridDefinition.getNumDimensions()) {
            throw new SeisException("MultiArray dimensions exceeds dataset dimensions");
        }
        if (asize < 2 || asize > 5) {
            throw new SeisException("MultiArray must have between 2 and 5 dimensions");
        }
        for (int i = 0; i < asize; ++i) {
            if ((long)alen[i] < dlen[i]) {
                throw new SeisException("MultiArray size is too short for dataset");
            }
            position[i] = 0;
        }
        int nframe = 1;
        for (int i = 2; i < asize; ++i) {
            nframe *= alen[i];
        }
        int[] apos = new int[asize];
        position[1] = 0;
        position[0] = 0;
        for (int i = 0; i < nframe; ++i) {
            this.readFrame(position);
            a.putFrame(this._traceData, apos);
            if (asize > 2) {
                apos[2] = apos[2] + 1;
                if (apos[2] >= alen[2]) {
                    apos[2] = 0;
                    if (asize > 3) {
                        apos[3] = apos[3] + 1;
                        if (apos[3] >= alen[3]) {
                            apos[3] = 0;
                            if (asize > 4) {
                                apos[4] = apos[4] + 1;
                            }
                        }
                    }
                }
            }
            ArrayUtil.arraycopy(apos, 0, position, 0, asize);
        }
    }

    public void writeMultiArray(IMultiArray a, int[] position) throws SeisException {
        int[] alen = a.getShape();
        int asize = alen.length;
        long[] dlen = this._gridDefinition.getAxisLengths();
        if (asize > this._gridDefinition.getNumDimensions()) {
            throw new SeisException("MultiArray dimensions exceeds dataset dimensions");
        }
        if (asize < 2 || asize > 5) {
            throw new SeisException("MultiArray must have between 2 and 5 dimensions");
        }
        for (int i = 0; i < asize; ++i) {
            if ((long)alen[i] != dlen[i]) {
                throw new SeisException("MultiArray size does not match dataset");
            }
            position[i] = 0;
        }
        int nframe = 1;
        for (int i = 2; i < asize; ++i) {
            nframe *= alen[i];
        }
        int[] apos = new int[asize];
        position[1] = 0;
        position[0] = 0;
        for (int i = 0; i < nframe; ++i) {
            a.getFrame(this._traceData, apos);
            this.writeFrame(position, this._traceData.length);
            if (asize > 2) {
                apos[2] = apos[2] + 1;
                if (apos[2] >= alen[2]) {
                    apos[2] = 0;
                    if (asize > 3) {
                        apos[3] = apos[3] + 1;
                        if (apos[3] >= alen[3]) {
                            apos[3] = 0;
                            if (asize > 4) {
                                apos[4] = apos[4] + 1;
                            }
                        }
                    }
                }
            }
            ArrayUtil.arraycopy(apos, 0, position, 0, asize);
        }
    }

    public int readFrame() throws SeisException {
        int numTraces;
        int numBytes1;
        int length1;
        this._traceBuffer.clear();
        this._traceBuffer.position(0);
        long newTraceFilePosition = this._traceIO.setPosition(this._traceFilePosition);
        if (newTraceFilePosition != this._traceFilePosition) {
            throw new SeisException("Unable to seek to trace data file offset " + this._traceFilePosition);
        }
        int maxTracesPerFrame = (int)this._gridDefinition.getNumTracesPerFrame();
        if (this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
            length1 = maxTracesPerFrame * this._traceLength;
            this._traceBuffer.limit(length1);
            numBytes1 = this._traceIO.read(this._traceBuffer);
            if (this._seisPEG == null) {
                this._seisPEG = new SeisPEG(this._byteTraceBuffer);
            }
        } else {
            length1 = this._tracesInFrame * this._traceLength;
            this._traceBuffer.limit(length1);
            numBytes1 = this._traceIO.read(this._traceBuffer);
            if (numBytes1 != length1) {
                throw new SeisException("Error reading from trace data file '" + this._traceIO.getPath() + "' (" + numBytes1 + " != " + length1 + ")");
            }
        }
        if (!this._ignoreHeadersAndFoldMap && this._usesHeaderProperties && this._seisPEG == null) {
            this._headerBuffer.clear();
            this._headerBuffer.position(0);
            long newHeaderFilePosition = this._headerIO.setPosition(this._headerFilePosition);
            if (newHeaderFilePosition != this._headerFilePosition) {
                throw new SeisException("Unable to seek to trace header file offset " + this._traceFilePosition);
            }
            int length2 = this._tracesInFrame * this._headerLengthBytes;
            this._headerBuffer.limit(length2);
            int numBytes2 = this._headerIO.read(this._headerBuffer);
            if (numBytes2 != length2) {
                throw new SeisException("Error reading from trace header file '" + this._headerIO.getPath() + "':  received " + numBytes2 + " bytes but expecting " + length2);
            }
        }
        if (this._seisPEG != null) {
            try {
                if (this._usesHeaderProperties) {
                    this._seisPEG.uncompress(this._byteTraceBuffer, numBytes1, this._traceData, this._headerBufferView);
                } else {
                    this._seisPEG.uncompress(this._byteTraceBuffer, numBytes1, this._traceData);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SeisException(ex.toString());
            }
            numTraces = this._tracesInFrame;
        } else {
            this._traceCompressor.unpackFrame(this._tracesInFrame, this._traceData);
            numTraces = this.convertBytesToTraces(numBytes1);
        }
        return numTraces;
    }

    public int readFrameHeaders() throws SeisException {
        if (!this._usesHeaderProperties) {
            return 0;
        }
        this._headerBuffer.clear();
        this._headerBuffer.position(0);
        long newHeaderFilePosition = this._headerIO.setPosition(this._headerFilePosition);
        if (newHeaderFilePosition != this._headerFilePosition) {
            throw new SeisException("Unable to seek to trace header file offset " + this._traceFilePosition);
        }
        int length2 = this._tracesInFrame * this._headerLengthBytes;
        this._headerBuffer.limit(length2);
        int numBytes2 = this._headerIO.read(this._headerBuffer);
        if (numBytes2 != length2) {
            throw new SeisException("Error reading from trace header file: " + this._headerIO.getPath());
        }
        return this._tracesInFrame;
    }

    public int writeFrame(int tracesToWrite) throws SeisException {
        if (this._versionInput != this._versionOutput) {
            throw new SeisException("Cannot write to old JavaSeis version.");
        }
        if (this._currentFrameCnt >= FLUSH_INTERVAL) {
            LOG.fine("JavaSeis data being flushed to physical media");
            this._traceIO.flush();
            if (this._usesHeaderProperties) {
                this._headerIO.flush();
            }
            this._currentFrameCnt = 0L;
        } else {
            ++this._currentFrameCnt;
        }
        int length1 = -1;
        this._traceBuffer.position(0);
        if (this._seisPEG != null) {
            if (tracesToWrite < 1) {
                throw new SeisException("tracesToWrite < 1");
            }
            if (this._usesHeaderProperties) {
                length1 = this._seisPEG.compress(this._traceData, tracesToWrite, this._headerBufferView, this._headerLengthWords, this._byteTraceBuffer);
                this._seisPEG.updateStatistics(tracesToWrite, this._traceLengthWords, this._headerLengthWords, length1);
            } else {
                length1 = this._seisPEG.compress(this._traceData, tracesToWrite, this._byteTraceBuffer);
                this._seisPEG.updateStatistics(tracesToWrite, this._traceLengthWords, 0, length1);
            }
            this._traceBuffer.limit(length1);
        } else {
            length1 = tracesToWrite * this._traceLength;
            this._traceBuffer.limit(length1);
            this._traceCompressor.packFrame(tracesToWrite, this._traceData);
        }
        long newTraceFilePosition = this._traceIO.setPosition(this._traceFilePosition);
        if (newTraceFilePosition != this._traceFilePosition) {
            throw new SeisException("Unable to seek to trace data file offset " + this._traceFilePosition);
        }
        if (newTraceFilePosition != this._traceFilePosition) {
            throw new SeisException("Unable to seek to trace data file offset " + this._traceFilePosition);
        }
        this._traceBuffer.position(0);
        int numBytes1 = this._traceIO.write(this._traceBuffer);
        if (numBytes1 != length1) {
            throw new SeisException("Error writing to trace data file: " + this._traceIO.getPath());
        }
        if (this._usesHeaderProperties && this._opfCollection != null) {
            this._opfCollection.write(this._traceIndex, tracesToWrite);
        }
        if (this._usesHeaderProperties && this._seisPEG == null) {
            int length2 = tracesToWrite * this._headerLengthBytes;
            this._headerBuffer.position(0);
            this._headerBuffer.limit(length2);
            long newHeaderFilePosition = this._headerIO.setPosition(this._headerFilePosition);
            if (newHeaderFilePosition != this._headerFilePosition) {
                throw new SeisException("Unable to seek to trace header file offset " + this._traceFilePosition);
            }
            int numBytes2 = this._headerIO.write(this._headerBuffer);
            if (numBytes2 != length2) {
                throw new SeisException("Error writing to trace header file: " + this._headerIO.getPath());
            }
        }
        int numTraces = -1;
        numTraces = this._seisPEG != null ? tracesToWrite : this.convertBytesToTraces(numBytes1);
        if (this._isMapped) {
            this._traceMap.putFold(this._position, numTraces);
        }
        this._tracesInFrame = numTraces;
        return numTraces;
    }

    public void readFrameScattered(int tracesInFrame, long[] traceIndex, ByteBuffer sortReadTraceBuffer, ByteBuffer sortReadHeaderBuffer, TraceCompressor sortReadTraceCompressor, float[][] traceData) throws SeisException {
        if (tracesInFrame > traceData.length) {
            throw new SeisException("Requested number of traces exceed trace array size");
        }
        if (tracesInFrame * this._traceLength > sortReadTraceBuffer.capacity()) {
            throw new SeisException("Requested number of traces exceed trace buffer capacity");
        }
        if (tracesInFrame * this._headerLengthBytes > sortReadHeaderBuffer.capacity()) {
            throw new SeisException("Requested number of headers exceed header buffer capacity");
        }
        int offset = 0;
        int hoffset = 0;
        int bufferCapacity = sortReadTraceBuffer.capacity();
        for (int i = 0; i < tracesInFrame; ++i) {
            sortReadTraceBuffer.position(offset);
            if ((offset += this._traceLength) > bufferCapacity) break;
            sortReadTraceBuffer.limit(offset);
            this._traceFilePosition = traceIndex[i] * (long)this._traceLength;
            this._traceIO.setPosition(this._traceFilePosition);
            int nbytes = this._traceIO.read(sortReadTraceBuffer);
            if (nbytes != this._traceLength) {
                throw new SeisException("Error reading from trace data file: " + this._traceIO.getPath());
            }
            if (!this._usesHeaderProperties || sortReadHeaderBuffer == null) continue;
            sortReadHeaderBuffer.position(hoffset);
            sortReadHeaderBuffer.limit(hoffset += this._headerLengthBytes);
            this._headerFilePosition = traceIndex[i] * (long)this._headerLengthBytes;
            this._headerIO.setPosition(this._headerFilePosition);
            nbytes = this._headerIO.read(sortReadHeaderBuffer);
            if (nbytes == this._headerLengthBytes) continue;
            throw new SeisException("Error reading TraceHeaders: " + this._headerIO.getPath());
        }
        sortReadTraceCompressor.unpackFrame(tracesInFrame, traceData);
    }

    public void readFrameHdrsScattered(int tracesInFrame, long[] traceIndex, ByteBuffer sortReadHeaderBuffer) throws SeisException {
        if (tracesInFrame > this._traceData.length) {
            throw new SeisException("Requested number of traces exceed trace array size");
        }
        if (tracesInFrame * this._headerLengthBytes > sortReadHeaderBuffer.capacity()) {
            throw new SeisException("Requested number of headers exceed header buffer capacity");
        }
        int hoffset = 0;
        for (int i = 0; i < tracesInFrame; ++i) {
            if (!this._usesHeaderProperties || sortReadHeaderBuffer == null) continue;
            sortReadHeaderBuffer.position(hoffset);
            sortReadHeaderBuffer.limit(hoffset += this._headerLengthBytes);
            this._headerFilePosition = traceIndex[i] * (long)this._headerLengthBytes;
            this._headerIO.setPosition(this._headerFilePosition);
            int nbytes = this._headerIO.read(sortReadHeaderBuffer);
            if (nbytes == this._headerLengthBytes) continue;
            throw new SeisException("Error reading TraceHeaders: " + this._headerIO.getPath());
        }
    }

    public void readTrace(long traceIndex) throws SeisException {
        this._traceBuffer.position(0);
        this._traceBuffer.limit(this._traceLength);
        this._traceFilePosition = traceIndex * (long)this._traceLength;
        this._traceIO.setPosition(this._traceFilePosition);
        int nbytes = this._traceIO.read(this._traceBuffer);
        if (nbytes != this._traceLength) {
            throw new SeisException("Error reading from trace data file: " + this._traceIO.getPath());
        }
        if (this._usesHeaderProperties) {
            this._headerBuffer.position(0);
            this._headerBuffer.limit(this._headerLengthBytes);
            this._headerFilePosition = traceIndex * (long)this._headerLengthBytes;
            this._headerIO.setPosition(this._headerFilePosition);
            nbytes = this._headerIO.read(this._headerBuffer);
            if (nbytes != this._headerLengthBytes) {
                throw new SeisException("Error reading TraceHeaders: " + this._headerIO.getPath());
            }
        }
        this._tracesInFrame = 1;
        if (this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
            throw new IllegalStateException("readTrace() is not supported for SeisPEG format");
        }
        this._traceCompressor.unpackFrame(this._tracesInFrame, this._traceData);
    }

    public void writeTrace(long traceIndex) throws SeisException {
        if (this._versionInput != this._versionOutput) {
            throw new SeisException("Cannot write to old JavaSeis version.");
        }
        this._traceBuffer.position(0);
        this._traceBuffer.limit(this._traceLength);
        this._tracesInFrame = 1;
        if (this._traceFormat.equals((Object)DataFormat.SEISPEG)) {
            throw new IllegalStateException("writeTrace() is not supported for SeisPEG format");
        }
        this._traceCompressor.packFrame(this._tracesInFrame, this._traceData);
        this._traceBuffer.position(0);
        this._traceBuffer.limit(this._traceLength);
        this._traceFilePosition = (long)this._traceLength * traceIndex;
        long newTraceFilePosition = this._traceIO.setPosition(this._traceFilePosition);
        if (newTraceFilePosition != this._traceFilePosition) {
            throw new SeisException("Unable to seek to trace data file offset " + this._traceFilePosition);
        }
        int numBytes1 = this._traceIO.write(this._traceBuffer);
        if (numBytes1 != this._traceLength) {
            throw new SeisException("Error writing to trace data file: " + this._traceIO.getPath());
        }
        if (this._usesHeaderProperties) {
            if (this._opfCollection != null) {
                this._opfCollection.write(traceIndex, 1);
            }
            this._headerBuffer.position(0);
            this._headerBuffer.limit(this._headerLengthBytes);
            this._headerFilePosition = traceIndex * (long)this._headerLengthBytes;
            long newHeaderFilePosition = this._headerIO.setPosition(this._headerFilePosition);
            if (newHeaderFilePosition != this._headerFilePosition) {
                throw new SeisException("Unable to seek to trace header file offset " + this._traceFilePosition);
            }
            int numBytes2 = this._headerIO.write(this._headerBuffer);
            if (numBytes2 != this._headerLengthBytes) {
                throw new SeisException("Error writing to trace header file: " + this._headerIO.getPath());
            }
        }
    }

    public void setVersionToInput(int versionInput) {
        this._versionInput = versionInput;
    }

    public void setCompressor2D(SeisPEG seisPEG) {
        SeisPEG obj = seisPEG;
        if (obj instanceof OpfCollection) {
            this._opfCollection = (OpfCollection)((Object)obj);
            try {
                this._opfCollection.openForWrite(this._gridDefinition, this._traceProperties, this._path);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else if (obj instanceof SeisPEG) {
            if (!DataFormat.SEISPEG.equals((Object)this._dataDefinition.getTraceFormat())) {
                throw new RuntimeException("Trace format must be '" + (Object)((Object)DataFormat.SEISPEG) + " to use SeisPEG compression");
            }
            this._seisPEG = obj;
        } else if (obj == null) {
            throw new IllegalArgumentException("Argument to setCompressor2D is null");
        }
    }

    public void setMapped() throws SeisException {
        this._isMapped = true;
        this._filePropertiesParset.setBoolean(MAPPED, true);
    }

    public long findLogicalIndex(int axisIndex, long logicalPosition) throws SeisException {
        long delta;
        int numDimensions = this._gridDefinition.getNumDimensions();
        if (axisIndex < 0 || axisIndex >= numDimensions) {
            throw new SeisException("Invalid dimension index: " + axisIndex);
        }
        String label = this._gridDefinition.getAxisLabelString(axisIndex);
        long length = this._gridDefinition.getAxisLength(axisIndex);
        long origin = this._gridDefinition.getAxisLogicalOrigin(axisIndex);
        int error = (int)((logicalPosition - origin) % (delta = this._gridDefinition.getAxisLogicalDelta(axisIndex)));
        if (error != 0) {
            throw new SeisException(label + " " + logicalPosition + " does not exist.");
        }
        long index = (logicalPosition - origin) / delta;
        if (index < 0L || index >= length) {
            throw new SeisException(label + " " + logicalPosition + " outside bounds.");
        }
        return index;
    }

    public VirtualIO getTraceIO() {
        return this._traceIO;
    }

    public VirtualIO getHeaderIO() {
        return this._headerIO;
    }

    public VirtualIO getMapIO() {
        return (VirtualIO)this._traceMap.getMapIO();
    }

    public float[][] getTraceDataArray() {
        return this._traceData;
    }

    public void setTraceDataArray(float[][] trc) throws SeisException {
        int tracesPerFrame = (int)this._gridDefinition.getAxisLength(1);
        if (trc.length < tracesPerFrame) {
            throw new SeisException("Number of traces in trace array is too small: " + trc.length + " vs. expected " + tracesPerFrame);
        }
        int samplesPerTrace = (int)this._gridDefinition.getAxisLength(0);
        for (int i = 0; i < trc.length; ++i) {
            if (trc[i].length >= samplesPerTrace) continue;
            throw new SeisException("Number of samples in trace array is too small: " + trc[i].length + " vs. expected " + samplesPerTrace);
        }
        this._traceData = trc;
    }

    void setSortReadDataArray(float[][] trc) throws SeisException {
        this._traceData = trc;
    }

    public boolean frameExists(int[] position) throws SeisException {
        if (this._isMapped) {
            return this.setPosition(position) > 0;
        }
        return true;
    }

    public int[] getPosition() {
        return (int[])this._position.clone();
    }

    public int setPosition(int[] position) throws SeisException {
        if (Arrays.equals(position, this._position)) {
            return this._tracesInFrame;
        }
        int numDimensions = this._gridDefinition.getNumDimensions();
        int numSamplesPerTrace = (int)this._gridDefinition.getNumSamplesPerTrace();
        int numTracesPerFrame = (int)this._gridDefinition.getNumTracesPerFrame();
        int numFramesPerVolume = (int)this._gridDefinition.getNumFramesPerVolume();
        if (position.length < numDimensions) {
            throw new SeisException("Mismatch in size of position array: " + position.length + " < " + numDimensions);
        }
        for (int i = 2; i < numDimensions; ++i) {
            long axisLength = this._gridDefinition.getAxisLength(i);
            if ((long)position[i] >= axisLength) {
                throw new SeisException("Axis " + i + " position must be < " + axisLength);
            }
            this._position[i] = position[i];
        }
        int volumeIndex = 0;
        if (numDimensions > 3) {
            int volumeSum = 1;
            for (int i = 3; i < numDimensions; ++i) {
                volumeIndex += volumeSum * this._position[i];
                volumeSum *= (int)this._gridDefinition.getAxisLength(i);
            }
        }
        this._frameIndex = position[2];
        this._traceIndex = (long)numTracesPerFrame * (long)numFramesPerVolume * (long)volumeIndex + (long)numTracesPerFrame * (long)this._frameIndex;
        this._traceFilePosition = this._traceIndex * (long)this._traceLength;
        this._headerFilePosition = this._traceIndex * (long)this._headerLengthBytes;
        this._tracesInFrame = this._isMapped && !this._ignoreHeadersAndFoldMap ? this._traceMap.getFold(position) : numTracesPerFrame;
        this._volumeIndex = volumeIndex;
        return this._tracesInFrame;
    }

    public void trackIoRate(boolean flag) {
        this._traceIO.trackTime(flag);
        if (this._usesHeaderProperties) {
            this._headerIO.trackTime(flag);
        }
        if (this._isMapped) {
            this._traceMap.trackTime(flag);
        }
    }

    public float getTotalIoRate() {
        long totBytes = this._traceIO.getIoBytes();
        float totTime = this._traceIO.getIoTime();
        if (this._usesHeaderProperties) {
            totBytes += this._headerIO.getIoBytes();
            totTime += this._headerIO.getIoTime();
        }
        if (this._isMapped) {
            totBytes += this._traceMap.getIoBytes();
            totTime += this._traceMap.getIoTime();
        }
        if (totTime == 0.0f) {
            return 0.0f;
        }
        return (float)totBytes / (totTime * 1024.0f * 1024.0f);
    }

    public float getTotalIoTime() {
        float totTime = this._traceIO.getIoTime();
        if (this._usesHeaderProperties) {
            totTime += this._headerIO.getIoTime();
        }
        if (this._isMapped) {
            totTime += this._traceMap.getIoTime();
        }
        return totTime;
    }

    public long getTotalIoBytes() {
        long totBytes = this._traceIO.getIoBytes();
        if (this._usesHeaderProperties) {
            totBytes += this._headerIO.getIoBytes();
        }
        if (this._isMapped) {
            totBytes += this._traceMap.getIoBytes();
        }
        return totBytes;
    }

    public float getTraceIoRate() {
        long totBytes = this._traceIO.getIoBytes();
        float totTime = this._traceIO.getIoTime();
        if (totTime == 0.0f) {
            return 0.0f;
        }
        return (float)totBytes / (totTime * 1024.0f * 1024.0f);
    }

    public float getHeaderIoRate() {
        if (!this._usesHeaderProperties) {
            return 0.0f;
        }
        long totBytes = this._headerIO.getIoBytes();
        float totTime = this._headerIO.getIoTime();
        if (totTime == 0.0f) {
            return 0.0f;
        }
        return (float)totBytes / (totTime * 1024.0f * 1024.0f);
    }

    protected int convertTracesToBytes(int numTraces) {
        int numBytes = numTraces * this._traceLength;
        return numBytes;
    }

    protected int convertBytesToTraces(int numBytes) {
        int numTraces = numBytes / this._traceLength;
        if (this._traceLength * numTraces != numBytes) {
            return -1;
        }
        return numTraces;
    }

    public void readTraceMap(int[][] foldMap4d, int hypercubeIx) throws SeisException {
        int ndim = this._gridDefinition.getNumDimensions();
        long[] axisLengths = this._gridDefinition.getAxisLengths();
        int nHypercubes = ndim > 4 ? (int)axisLengths[4] : 1;
        int nVolumes = ndim > 3 ? (int)axisLengths[3] : 1;
        int nFrames = (int)axisLengths[2];
        int[] position = new int[ndim];
        Arrays.fill(position, 0);
        if (position.length > 4 && hypercubeIx < nHypercubes && hypercubeIx >= 0) {
            position[4] = hypercubeIx;
        }
        if (ndim == 3) {
            this._traceMap.emptyCache();
        }
        for (int ivol = 0; ivol < nVolumes; ++ivol) {
            if (position.length > 3) {
                position[3] = ivol;
            }
            this._traceMap.loadVolume(position);
            int[] traceMapArray = this._traceMap.getTraceMapArray();
            ArrayUtil.arraycopy(traceMapArray, 0, foldMap4d[ivol], 0, nFrames);
        }
    }

    public Iterator<int[]> frameIterator() {
        return new FrameIterator();
    }

    public int debugGetExtentCount(String type) {
        ExtentListEntry[] extents = this.getExtents(type);
        return extents.length;
    }

    public int debugGetExtentCountPopulated(String type) {
        ExtentListEntry[] extents = this.getExtents(type);
        int populated = 0;
        for (int i = 0; i < extents.length; ++i) {
            if (extents[i] == null || extents[i].getExtentSize() <= 0L) continue;
            ++populated;
        }
        return populated;
    }

    public ExtentListEntry[] getExtents(String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("Type is not valid");
        }
        if (!this._isVirtual) {
            return null;
        }
        if (type.compareToIgnoreCase(TRACE_DATA) == 0) {
            return this._traceIO.getExtents();
        }
        if (type.compareToIgnoreCase(TRACE_HEADERS) == 0) {
            return this._headerIO.getExtents();
        }
        return null;
    }

    public ExtentPolicy getExtentPolicy(String type) {
        if (!this._isVirtual) {
            return null;
        }
        if (type.compareToIgnoreCase(TRACE_DATA) == 0) {
            return this._traceIO.getExtentPolicy();
        }
        if (type.compareToIgnoreCase(TRACE_HEADERS) == 0) {
            return this._headerIO.getExtentPolicy();
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static void main(String[] args) throws Exception {
        Seisio fileStruct = null;
        String path = TestUtil.getDatasetPath("jsTestDataset");
        boolean isJavaSeis = Seisio.isJavaSeis(path);
        LOG.fine("isJavaSeis: " + isJavaSeis);
        if (isJavaSeis) {
            Seisio.delete(path);
            System.gc();
        }
        LOG.fine("Seisio: Test of \"Non-virtual\" dataset...");
        fileStruct = Seisio.testFileStruct("Non-virtual", path, null, 0);
        boolean deleteNonVirtual = true;
        if (deleteNonVirtual) {
            fileStruct.close();
            boolean isNonVirtualDeleted = Seisio.delete(path);
            if (!isNonVirtualDeleted) {
                throw new SeisException("Error deleting dataset");
            }
            LOG.fine("Seisio: Non-virtual dataset deleted.");
        }
        fileStruct = null;
        System.gc();
        int vfioExtentCount = 10;
        VirtualFolders vFolders = TestUtil.getVirtualFolders(path);
        LOG.fine("Seisio: Test  \"Virtual\" dataset...");
        fileStruct = Seisio.testFileStruct("Virtual", path, vFolders, vfioExtentCount);
        boolean deleteVirtual = false;
        if (deleteVirtual) {
            boolean isVirtualDeleted = fileStruct.delete();
            if (!isVirtualDeleted) {
                throw new SeisException("Error deleting dataset");
            }
            LOG.fine("Seisio: Non-virtual dataset deleted.");
        }
        fileStruct = null;
        System.gc();
        fileStruct = new Seisio(path);
        fileStruct.open(MODE_READ_ONLY);
        GridDefinition testGridDef = fileStruct.getGridDefinition();
        LOG.fine("Seisio: Checking grid definition...");
        int testNumDimensions = testGridDef.getNumDimensions();
        LOG.fine("Seisio:   Property # of axes: " + testNumDimensions);
        for (int i = 0; i < testNumDimensions; ++i) {
            AxisDefinition axis = testGridDef.getAxis(i);
            LOG.fine("Seisio:   Axis : " + axis.getLabel() + " --> " + "units=" + axis.getUnits() + ", domain=" + axis.getDomain());
        }
        long testNumSamples = testGridDef.getNumSamplesPerTrace();
        LOG.fine("Seisio:   Property # of samples: " + testNumSamples);
        long testNumTraces = testGridDef.getNumTracesPerFrame();
        LOG.fine("Seisio:   Property # of traces: " + testNumTraces);
        long testNumFrames = testGridDef.getNumFramesPerVolume();
        LOG.fine("Seisio:   Property # of frames: " + testNumFrames);
        long testNumVolumes = testGridDef.getNumVolumesPerHypercube();
        LOG.fine("Seisio:   Property # of volumes: " + testNumVolumes);
        DataDefinition testDataDef = fileStruct.getDataDefinition();
        LOG.fine("Seisio: Checking data definition...");
        DataType testDataType = testDataDef.getDataType();
        LOG.fine("Seisio:   Property data type: " + testDataDef.getDataTypeString());
        DataFormat testTraceFormat = testDataDef.getTraceFormat();
        LOG.fine("Seisio:   Property trace format: " + testDataDef.getTraceFormatString());
        TraceProperties testHeaderDef = fileStruct.getTraceProperties();
        LOG.fine("Seisio: Checking header definition...");
        int testNumHeaderProps = testHeaderDef.getNumProperties();
        LOG.fine("Seisio:   Property # of header properties: " + testNumHeaderProps);
        PropertyDescription[] testHeaderProps = testHeaderDef.getTraceProperties();
        for (int i = 0; i < testNumHeaderProps; ++i) {
            LOG.fine("Seisio:   Header : " + testHeaderProps[i].getLabel() + " --> " + testHeaderProps[i].getDescription() + ", reclen=" + testHeaderProps[i].getRecordLength() + ", offset=" + testHeaderProps[i].getOffset());
        }
        float[][] testTraceData = fileStruct.getTraceDataArray();
        int[] testPosition = new int[testNumDimensions];
        testPosition[0] = 0;
        testPosition[1] = 0;
        int volumeIndex = 0;
        while ((long)volumeIndex < testNumVolumes) {
            testPosition[3] = volumeIndex;
            int frameIndex = 0;
            while ((long)frameIndex < testNumFrames) {
                testPosition[2] = frameIndex;
                int count = fileStruct.readFrame(testPosition);
                if ((long)count != testNumTraces) {
                    throw new SeisException("Error reading from dataset (" + count + " != " + testNumTraces);
                }
                if ((long)volumeIndex == testNumVolumes / 2L && (long)frameIndex == testNumFrames / 2L) {
                    int traceIndex = 0;
                    while ((long)traceIndex < testNumTraces) {
                        if ((long)traceIndex == testNumTraces / 2L) {
                            LOG.fine("Seisio: Checking header...");
                            testHeaderDef.setTraceIndex(traceIndex);
                            for (int headerIndex = 0; headerIndex < testNumHeaderProps; ++headerIndex) {
                                String key = testHeaderProps[headerIndex].getLabel();
                                LOG.fine("Seisio:   Header : " + key + " --> " + testHeaderDef.getValue(key));
                            }
                        }
                        ++traceIndex;
                    }
                }
                ++frameIndex;
            }
            volumeIndex += 100;
        }
        LOG.fine("Seisio: ProMAX dataset read.");
        fileStruct.close();
        Seisio.delete(path);
        LOG.fine("*** " + fileStruct.getClass().toString() + " Success ***");
    }

    public static Seisio testFileStruct(String testDesc, String path, VirtualFolders vFolders, int vfioExtentCount) throws Exception {
        int origNumDimensions = 4;
        int origNumSamples = 251;
        int origNumTraces = 50;
        int origNumFrames = 21;
        int origNumVolumes = 11;
        AxisDefinition[] axes = new AxisDefinition[origNumDimensions];
        axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MSEC, DataDomain.TIME, origNumSamples, 0L, 4L, 0.0, 4.0);
        axes[1] = new AxisDefinition(AxisLabel.OFFSET, Units.FEET, DataDomain.SPACE, origNumTraces, 50L, 50L, 50.0, 50.0);
        axes[2] = new AxisDefinition(AxisLabel.CROSSLINE, Units.FEET, DataDomain.SPACE, origNumFrames, 100L, 1L, 1250.0, 12.5);
        axes[3] = new AxisDefinition(AxisLabel.INLINE, Units.FEET, DataDomain.SPACE, origNumVolumes, 200L, 2L, 5000.0, 25.0);
        GridDefinition origGridDef = new GridDefinition(origNumDimensions, axes);
        LOG.fine("Seisio: " + testDesc + " dataset grid definition created.");
        DataType origDataType = DataType.CMP;
        DataFormat origTraceFormat = DataFormat.FLOAT;
        DataDefinition origDataDef = new DataDefinition(origDataType, origTraceFormat);
        LOG.fine("Seisio: " + testDesc + " dataset data definition created.");
        String[] Presidents = new String[]{"George Washington", "Thomas Jefferson", "Abe Lincoln", "Teddy Roosevelt"};
        int origNumHeaderProps = 5;
        PropertyDescription[] origHeaderProps = new PropertyDescription[origNumHeaderProps];
        origHeaderProps[0] = new PropertyDescription("THE_PREZ", "Name of President", 9, 27);
        origHeaderProps[1] = new PropertyDescription("ILINE_NO", "Inline #", 3, 1);
        origHeaderProps[2] = new PropertyDescription("XLINE_NO", "Crossline #", 3, 1);
        origHeaderProps[3] = new PropertyDescription("SRC_XYZ", "Source xyz-coordinates", 6, 3);
        origHeaderProps[4] = new PropertyDescription("RECV_XYZ", "Receiver xyz-coordinates", 6, 3);
        TraceProperties origHeaderDef = new TraceProperties(origNumHeaderProps, origHeaderProps);
        LOG.fine("Seisio: " + testDesc + " dataset header definition created.");
        Seisio fileStruct = new Seisio(path, origGridDef, origDataDef, origHeaderDef);
        fileStruct.setMapped();
        if (vFolders == null) {
            fileStruct.create();
        } else {
            fileStruct.create(vFolders, vfioExtentCount);
        }
        LOG.fine("Seisio: " + testDesc + " dataset created.");
        float[][] origTraceData = fileStruct.getTraceDataArray();
        double pi = Math.PI;
        double omega1 = pi / (double)(origNumSamples - 1);
        for (int i = 0; i < origNumTraces; ++i) {
            double omega2 = (double)(i + 10) * omega1;
            for (int j = 0; j < origNumSamples; ++j) {
                double t = j;
                origTraceData[i][j] = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
            }
        }
        LOG.fine("Seisio: " + testDesc + " dataset synthetic traces generated.");
        double[] xyz = new double[3];
        double dxy = 0.0;
        int[] origPosition = new int[origNumDimensions];
        origPosition[0] = 0;
        origPosition[1] = 0;
        for (int volumeIndex = 0; volumeIndex < origNumVolumes; ++volumeIndex) {
            origPosition[3] = volumeIndex;
            AxisDefinition volumeAxis = origGridDef.getAxis(3);
            int iline = (int)(volumeAxis.getLogicalOrigin() + volumeAxis.getLogicalDelta() * (long)volumeIndex);
            double xm = volumeAxis.getPhysicalOrigin() + volumeAxis.getPhysicalDelta() * (double)volumeIndex;
            int frameIndex = 0;
            while (frameIndex < origNumFrames) {
                AxisDefinition frameAxis = origGridDef.getAxis(2);
                int xline = (int)(frameAxis.getLogicalOrigin() + frameAxis.getLogicalDelta() * (long)frameIndex);
                double ym = frameAxis.getPhysicalOrigin() + frameAxis.getPhysicalDelta() * (double)frameIndex;
                for (int traceIndex = 0; traceIndex < origNumTraces; ++traceIndex) {
                    AxisDefinition traceAxis = origGridDef.getAxis(1);
                    dxy = traceAxis.getPhysicalOrigin() + traceAxis.getPhysicalDelta() * (double)traceIndex;
                    origHeaderDef.setTraceIndex(traceIndex);
                    origHeaderDef.putInt("ILINE_NO", iline);
                    origHeaderDef.putInt("XLINE_NO", xline);
                    xyz[0] = xm;
                    xyz[1] = ym;
                    xyz[2] = 0.0;
                    origHeaderDef.putDoubleArray("SRC_XYZ", xyz);
                    xyz[0] = xm + dxy;
                    xyz[1] = ym - dxy;
                    xyz[2] = 1.0;
                    origHeaderDef.putDoubleArray("RECV_XYZ", xyz);
                    int presIndex = traceIndex % Presidents.length;
                    origHeaderDef.putValue("THE_PREZ", Presidents[presIndex]);
                }
                origPosition[2] = frameIndex++;
                int count = fileStruct.writeFrame(origPosition, origNumTraces);
                if (count == origNumTraces) continue;
                throw new SeisException("Seisio: Error writing to dataset (" + count + " != " + origNumTraces);
            }
        }
        LOG.fine("Seisio: " + testDesc + " dataset written.");
        fileStruct.close();
        LOG.fine("Seisio: " + testDesc + " dataset closed.");
        fileStruct.open(MODE_READ_WRITE);
        LOG.fine("Seisio: " + testDesc + " dataset opened.");
        GridDefinition testGridDef = fileStruct.getGridDefinition();
        LOG.fine("Seisio: Checking grid definition...");
        int testNumDimensions = testGridDef.getNumDimensions();
        if (testNumDimensions != origNumDimensions) {
            throw new SeisException("Mismatch in data type: " + testNumDimensions + " vs " + origNumDimensions);
        }
        for (int i = 0; i < testNumDimensions; ++i) {
            AxisDefinition axis = testGridDef.getAxis(i);
            LOG.fine("Seisio:   Axis : " + axis.getLabel() + " --> " + "units=" + axis.getUnits() + ", domain=" + axis.getDomain());
        }
        long testNumSamples = testGridDef.getNumSamplesPerTrace();
        if (testNumSamples != (long)origNumSamples) {
            throw new SeisException("Mismatch in # of samples: " + testNumSamples + " vs " + origNumSamples);
        }
        long testNumTraces = testGridDef.getNumTracesPerFrame();
        if (testNumTraces != (long)origNumTraces) {
            throw new SeisException("Mismatch in # of traces: " + testNumTraces + " vs " + origNumTraces);
        }
        long testNumFrames = testGridDef.getNumFramesPerVolume();
        if (testNumFrames != (long)origNumFrames) {
            throw new SeisException("Mismatch in # of frames: " + testNumFrames + " vs " + origNumFrames);
        }
        long testNumVolumes = testGridDef.getNumVolumesPerHypercube();
        if (testNumVolumes != (long)origNumVolumes) {
            throw new SeisException("Mismatch in # of volumes: " + testNumVolumes + " vs " + origNumVolumes);
        }
        DataDefinition testDataDef = fileStruct.getDataDefinition();
        LOG.fine("Seisio: Checking data definition...");
        DataType testDataType = testDataDef.getDataType();
        if (testDataType != origDataType) {
            throw new SeisException("Mismatch in data type: " + testDataDef.getDataTypeString() + " vs " + origDataDef.getDataTypeString());
        }
        DataFormat testTraceFormat = testDataDef.getTraceFormat();
        if (testTraceFormat != origTraceFormat) {
            throw new SeisException("Mismatch in trace format: " + testDataDef.getTraceFormatString() + " vs " + origDataDef.getTraceFormatString());
        }
        TraceProperties testHeaderDef = fileStruct.getTraceProperties();
        LOG.fine("Seisio: Checking header definition...");
        int testNumHeaderProps = testHeaderDef.getNumProperties();
        if (testNumHeaderProps != origNumHeaderProps) {
            throw new SeisException("Mismatch in # of header properties: " + testNumHeaderProps + " vs " + origNumHeaderProps);
        }
        PropertyDescription[] testHeaderProps = testHeaderDef.getTraceProperties();
        for (int i = 0; i < testNumHeaderProps; ++i) {
            LOG.fine("Seisio:   Header : " + testHeaderProps[i].getLabel() + " --> " + testHeaderProps[i].getDescription() + ", reclen=" + testHeaderProps[i].getRecordLength() + ", offset=" + testHeaderProps[i].getOffset());
        }
        float[][] testTraceData = fileStruct.getTraceDataArray();
        int[] testPosition = new int[testNumDimensions];
        testPosition[0] = 0;
        testPosition[1] = 0;
        int volumeIndex = 0;
        while ((long)volumeIndex < testNumVolumes) {
            testPosition[3] = volumeIndex;
            int frameIndex = 0;
            while ((long)frameIndex < testNumFrames) {
                testPosition[2] = frameIndex;
                int count = fileStruct.readFrame(testPosition);
                if ((long)count != testNumTraces) {
                    throw new SeisException("Error reading from dataset (" + count + " != " + testNumTraces);
                }
                if ((long)volumeIndex == testNumVolumes / 2L && (long)frameIndex == testNumFrames / 2L) {
                    int traceIndex = 0;
                    while ((long)traceIndex < testNumTraces) {
                        if ((long)traceIndex == testNumTraces / 2L) {
                            LOG.fine("Seisio: Checking header...");
                            testHeaderDef.setTraceIndex(traceIndex);
                            for (int headerIndex = 0; headerIndex < testNumHeaderProps; ++headerIndex) {
                                String key = testHeaderProps[headerIndex].getLabel();
                                LOG.fine("Seisio:   Header : " + key + " --> " + testHeaderDef.getValue(key));
                            }
                        }
                        ++traceIndex;
                    }
                }
                ++frameIndex;
            }
            ++volumeIndex;
        }
        LOG.fine("Seisio: " + testDesc + " dataset read.");
        fileStruct.close();
        LOG.fine("Seisio: " + testDesc + " dataset closed.");
        return fileStruct;
    }

    public static AxisLabel[] getPreferredAxisLabels(DataType dataType) throws SeisException {
        String dataTypeStr = dataType.getName();
        return Seisio.getPreferredAxisLabels(dataTypeStr);
    }

    public static AxisLabel[] getPreferredAxisLabels(String dataTypeStr) throws SeisException {
        int prefNumDimensions = 0;
        AxisLabel[] prefAxisLabels = null;
        if (dataTypeStr.equalsIgnoreCase(DataType.CMP.getName())) {
            prefNumDimensions = 4;
            prefAxisLabels = new AxisLabel[prefNumDimensions];
            prefAxisLabels[0] = AxisLabel.TIME;
            prefAxisLabels[1] = AxisLabel.OFFSET;
            prefAxisLabels[2] = AxisLabel.CROSSLINE;
            prefAxisLabels[3] = AxisLabel.INLINE;
        } else if (dataTypeStr.equalsIgnoreCase(DataType.SOURCE.getName())) {
            prefNumDimensions = 4;
            prefAxisLabels = new AxisLabel[prefNumDimensions];
            prefAxisLabels[0] = AxisLabel.TIME;
            prefAxisLabels[1] = AxisLabel.CHANNEL;
            prefAxisLabels[2] = AxisLabel.SOURCE;
            prefAxisLabels[3] = AxisLabel.SAIL_LINE;
        } else if (dataTypeStr.equalsIgnoreCase(DataType.RECEIVER.getName())) {
            prefNumDimensions = 4;
            prefAxisLabels = new AxisLabel[prefNumDimensions];
            prefAxisLabels[0] = AxisLabel.TIME;
            prefAxisLabels[1] = AxisLabel.SOURCE;
            prefAxisLabels[2] = AxisLabel.RECEIVER_LINE;
            prefAxisLabels[3] = AxisLabel.SAIL_LINE;
        } else if (dataTypeStr.equalsIgnoreCase(DataType.OFFSET_BIN.getName())) {
            prefNumDimensions = 4;
            prefAxisLabels = new AxisLabel[prefNumDimensions];
            prefAxisLabels[0] = AxisLabel.TIME;
            prefAxisLabels[1] = AxisLabel.CROSSLINE;
            prefAxisLabels[2] = AxisLabel.INLINE;
            prefAxisLabels[3] = AxisLabel.OFFSET_BIN;
        } else if (dataTypeStr.equalsIgnoreCase(DataType.STACK.getName())) {
            prefNumDimensions = 4;
            prefAxisLabels = new AxisLabel[prefNumDimensions];
            prefAxisLabels[0] = AxisLabel.TIME;
            prefAxisLabels[1] = AxisLabel.OFFSET;
            prefAxisLabels[2] = AxisLabel.CROSSLINE;
            prefAxisLabels[3] = AxisLabel.INLINE;
        } else if (!dataTypeStr.equalsIgnoreCase(DataType.CUSTOM.getName()) && !dataTypeStr.equalsIgnoreCase(DataType.UNKNOWN.getName())) {
            throw new SeisException("Invalid JavaSeis data type: " + dataTypeStr);
        }
        return prefAxisLabels;
    }

    public VirtualFolders getVirtualFolders() {
        return this._vFolders;
    }

    public TraceMap getTraceMap() {
        return this._traceMap;
    }

    private TraceMap loadTraceMap(boolean isMapped, String mode) throws SeisException {
        if (!this._isMapped) {
            return null;
        }
        mode = this.refineMode(mode, "org.javaseis.io.tracemap.bufferedwrites");
        TraceMap tmio = null;
        tmio = new TraceMap(this._gridDefinition.getAxisLengths(), this._byteOrder, this._path, mode);
        return tmio;
    }

    private VirtualIO loadTraceVIO(String modeFixed) throws SeisException {
        VirtualIO traceIO;
        if (modeFixed.contains("wb")) {
            int cache = 0x2000000;
            int blockSize = 0;
            traceIO = this._isVirtual ? new BufferedVirtualIO(this._path + File.separator + TRACE_DATA_XML, modeFixed, this._vFolders, cache, blockSize) : new BufferedVirtualIO(this._path + File.separator + TRACE_DATA, modeFixed, cache, blockSize);
        } else {
            traceIO = this._isVirtual ? new VirtualIO(this._path + File.separator + TRACE_DATA_XML, modeFixed, this._vFolders) : new VirtualIO(this._path + File.separator + TRACE_DATA, modeFixed);
        }
        return traceIO;
    }

    private VirtualIO loadHeaderVIO(String modeFixed) throws SeisException {
        VirtualIO headerIO;
        if (!this._usesHeaderProperties) {
            return null;
        }
        if (modeFixed.contains("wb")) {
            int cache = 0x2000000;
            int blockSize = 0;
            headerIO = this._isVirtual ? new BufferedVirtualIO(this._path + File.separator + TRACE_HEADERS_XML, modeFixed, this._vFolders, cache, blockSize) : new BufferedVirtualIO(this._path + File.separator + TRACE_HEADERS, modeFixed, cache, blockSize);
        } else {
            headerIO = this._isVirtual ? new VirtualIO(this._path + File.separator + TRACE_HEADERS_XML, modeFixed, this._vFolders) : new VirtualIO(this._path + File.separator + TRACE_HEADERS, modeFixed);
        }
        return headerIO;
    }

    private String refineMode(String mode, String propName) {
        String m;
        String modeOut = m = mode.toLowerCase();
        if (m.contains("w")) {
            String p = System.getProperty(propName);
            if (p != null) {
                modeOut = p.startsWith("t") || p.startsWith("y") || p.startsWith("T") || p.startsWith("Y") ? "wb" : "w";
            }
            mode = "w";
        }
        return modeOut;
    }

    static {
        LOG.config("Data will be flushed after every " + FLUSH_INTERVAL + " framees");
        s_savePrimaryFilesList = Arrays.asList(FILE_PROPERTIES_OBS, FILE_PROPERTIES_XML, FILE_STUB, HISTORY_XML, TRACE_MAP, TRACE_DATA_XML, TRACE_HEADERS_XML, HAS_TRACES_FILE, SORT_FILES);
    }

    private class FrameIterator
    implements Iterator {
        private int[] position;
        private int[] size;
        private int ndim;
        private long nframe;
        private long iframe;
        private long[] frameMultiplier;
        private boolean foundNext;

        public FrameIterator() {
            int i;
            this.ndim = Seisio.this._gridDefinition.getNumDimensions();
            this.size = new int[this.ndim];
            for (i = 0; i < this.ndim; ++i) {
                this.size[i] = (int)Seisio.this._gridDefinition.getAxisLength(i);
            }
            this.frameMultiplier = new long[this.ndim];
            this.frameMultiplier[1] = 1L;
            this.nframe = 1L;
            for (i = 2; i < this.ndim; ++i) {
                this.frameMultiplier[i] = this.frameMultiplier[i - 1] * (long)this.size[i - 1];
                this.nframe *= (long)this.size[i];
            }
            this.position = new int[this.ndim];
            this.iframe = 0L;
        }

        public int[] next() {
            this.nextFrame();
            try {
                Seisio.this.setPosition(this.position);
                Seisio.this.readFrame();
            }
            catch (SeisException e) {
                throw new NoSuchElementException(e.getMessage());
            }
            return this.position;
        }

        public void nextFrame() {
            if (Seisio.this._isMapped) {
                if (this.foundNext) {
                    return;
                }
                if (this.hasNext()) {
                    return;
                }
                this.iframe = this.nframe - 1L;
            }
            if (this.iframe == this.nframe - 1L) {
                throw new NoSuchElementException("End of data in JavaSeis dataset");
            }
            ++this.iframe;
            this.frameToPosition();
        }

        private void frameToPosition() {
            this.position[1] = 0;
            this.position[0] = 0;
            long ifrm = this.iframe;
            for (int i = this.ndim - 1; i > 1; --i) {
                long ival = ifrm / this.frameMultiplier[i];
                this.position[i] = (int)ival;
                ifrm -= ival * this.frameMultiplier[i];
            }
        }

        private void positionToFrame() {
            this.iframe = 0L;
            for (int i = 2; i < this.ndim; ++i) {
                this.iframe += (long)this.position[i] * this.frameMultiplier[i];
            }
        }

        @Override
        public boolean hasNext() {
            if (!Seisio.this._isMapped) {
                return this.iframe < this.nframe - 1L;
            }
            this.foundNext = false;
            long ifrm = this.iframe;
            this.iframe = ifrm + 1L;
            while (this.iframe < this.nframe) {
                this.frameToPosition();
                try {
                    this.foundNext = Seisio.this.frameExists(this.position);
                }
                catch (SeisException e) {
                    return false;
                }
                if (this.foundNext) {
                    return true;
                }
                ++this.iframe;
            }
            return false;
        }

        @Override
        public void remove() {
        }
    }
}

