/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.JPerfTestShapes;
import org.javaseis.array.MultiArray;
import org.javaseis.array.MultiArrayPositionIterator;

public class JPerfTestMultiArrayReshape {
    private int _logLevel;
    private boolean _doChecks;

    public JPerfTestMultiArrayReshape() {
        this(Level.INFO, false);
    }

    public JPerfTestMultiArrayReshape(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    private void testContraction(int[] inshape) {
        int ndim = inshape.length;
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        MultiArray m = MultiArray.factory(ndim, Integer.TYPE, 1, inshape);
        this.fillArray(m);
        this.logFine("After fill");
        this.printArray(m);
        Random r = new Random(1234567L);
        int[] newshape = (int[])inshape.clone();
        for (int i = 0; i < ndim; ++i) {
            newshape[i] = Math.max((int)(r.nextFloat() * (float)inshape[i]), 2);
        }
        double startTime = JPerfTestMultiArrayReshape.getTime();
        m.reshape(newshape);
        double elapsedTime = JPerfTestMultiArrayReshape.getTime() - startTime;
        this.logInfo("Reshape contraction: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(inshape) + " output shape" + Arrays.toString(m.getShape()));
        this.logFine("\nAfter contract");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
    }

    private void testExpansion(int[] inshape) {
        int ndim = inshape.length;
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        Random r = new Random(1234567L);
        int[] newshape = (int[])inshape.clone();
        for (int i = 0; i < ndim; ++i) {
            newshape[i] = Math.max((int)(r.nextFloat() * (float)inshape[i]), 2);
        }
        MultiArray m = MultiArray.factory(ndim, Integer.TYPE, 1, inshape);
        m.setShape(newshape);
        this.fillArray(m);
        this.logFine("After fill");
        this.printArray(m);
        double startTime = JPerfTestMultiArrayReshape.getTime();
        m.reshape(inshape);
        double elapsedTime = JPerfTestMultiArrayReshape.getTime() - startTime;
        this.logInfo("Reshape expansion: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(newshape) + " output shape" + Arrays.toString(m.getShape()));
        this.logFine("\nAfter expansion");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, newshape);
        }
    }

    private void testMixed(int[] inshape) {
        MultiArray m;
        int ndim = inshape.length;
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        Random r = new Random(1234567L);
        int[] newshape = (int[])inshape.clone();
        for (int i = 0; i < ndim; ++i) {
            newshape[i] = Math.max((int)(r.nextFloat() * (float)inshape[i]), 2);
            int n = i;
            newshape[n] = newshape[n] + Math.max((int)(r.nextFloat() * (float)inshape[i]), 2);
        }
        double arraySize2 = 3.814697265625E-6;
        for (int i = 0; i < newshape.length; ++i) {
            arraySize2 *= (double)newshape[i];
        }
        if (arraySize2 > arraySize) {
            arraySize = arraySize2;
            m = MultiArray.factory(ndim, Integer.TYPE, 1, newshape);
        } else {
            m = MultiArray.factory(ndim, Integer.TYPE, 1, inshape);
        }
        m.setShape(inshape);
        this.fillArray(m);
        this.logFine("After fill");
        this.printArray(m);
        double startTime = JPerfTestMultiArrayReshape.getTime();
        m.reshape(newshape);
        double elapsedTime = JPerfTestMultiArrayReshape.getTime() - startTime;
        this.logInfo("Reshape mixed: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(inshape) + " output shape" + Arrays.toString(m.getShape()));
        this.logFine("\nAfter reshape");
        this.printArray(m);
        if (this._doChecks) {
            int[] checkshape = (int[])inshape.clone();
            for (int i = 0; i < ndim; ++i) {
                if (newshape[i] >= checkshape[i]) continue;
                checkshape[i] = newshape[i];
            }
            this.checkArray(m, checkshape);
        }
    }

    private int pvalue(int[] position, int is) {
        int value = is;
        int mult = 1;
        for (int i = 0; i < position.length; ++i) {
            value += mult * position[i];
            mult *= 10;
        }
        return value;
    }

    private void fillArray(IMultiArray m) {
        int[] buf = new int[m.getShape()[0]];
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        while (it.hasNext()) {
            int[] pos = it.next();
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = this.pvalue(pos, i);
            }
            m.putTrace(buf, pos);
        }
    }

    private void checkArray(IMultiArray m, int[] checkShape) {
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] bufTrue = new int[m.getShape()[0]];
        int[] buf = new int[m.getShape()[0]];
        while (it.hasNext()) {
            int i;
            int[] pos = it.next();
            m.getTrace(buf, pos);
            boolean ret = false;
            for (i = 1; i < pos.length; ++i) {
                if (pos[i] < checkShape[i]) continue;
                ret = true;
            }
            if (ret) continue;
            for (i = 0; i < buf.length && i < checkShape[0]; ++i) {
                bufTrue[i] = this.pvalue(pos, i);
                if (buf[i] == bufTrue[i]) continue;
                System.err.println("Check failed at position " + Arrays.toString(pos) + " expected " + bufTrue[i] + " actual " + buf[i]);
            }
        }
    }

    private void printArray(IMultiArray m) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] shape = m.getShape();
        int[] buf = new int[m.getShape()[0]];
        while (it.hasNext()) {
            int[] pos = it.next();
            System.out.println("Values at position " + Arrays.toString(pos));
            m.getTrace(buf, pos);
            for (int i0 = 0; i0 < shape[0]; ++i0) {
                System.out.println("val[" + i0 + "] = " + buf[i0]);
            }
        }
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    public static void main(String[] args) {
        Boolean memoryPrint = false;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        List<int[]> shapes3 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        JPerfTestMultiArrayReshape tester = new JPerfTestMultiArrayReshape(Level.INFO, true);
        double startTime = JPerfTestMultiArrayReshape.getTime();
        for (int[] shape : shapes3) {
            tester.testContraction(shape);
            System.gc();
        }
        tester.logInfo("Total time for contraction: " + (JPerfTestMultiArrayReshape.getTime() - startTime) + " sec");
        startTime = JPerfTestMultiArrayReshape.getTime();
        for (int[] shape : shapes3) {
            tester.testExpansion(shape);
            System.gc();
        }
        tester.logInfo("Total time for expansion: " + (JPerfTestMultiArrayReshape.getTime() - startTime) + " sec");
        startTime = JPerfTestMultiArrayReshape.getTime();
        for (int[] shape : shapes3) {
            tester.testMixed(shape);
            System.gc();
        }
        tester.logInfo("Total time for mixed: " + (JPerfTestMultiArrayReshape.getTime() - startTime) + " sec");
    }
}

