/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmLicenseElementException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class FlexlmDate
implements FlexlmConstants {
    private static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final String[] monthsInDigits = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final int[] daysPerMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private GregorianCalendar gc;
    boolean isPermanent;
    boolean isMonthInDigits = false;

    public FlexlmDate(int n) {
        int n2 = n >> 9 & 0x7F;
        int n3 = n >> 5 & 0xF;
        int n4 = n & 0x1F;
        this.gc = new GregorianCalendar(n2 += 1900, n3, n4);
    }

    public FlexlmDate(String string, Boolean ... booleanArray) throws FlexlmLicenseElementException {
        if (string.equalsIgnoreCase("permanent")) {
            this.isPermanent = true;
        } else {
            int n;
            this.isPermanent = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            if (stringTokenizer.countTokens() != 3) {
                throw new FlexlmLicenseElementException(-507, 4011, null, 0, null, null);
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-507, 4012, null, 0, null, null);
            }
            if (n2 < 1) {
                throw new FlexlmLicenseElementException(-507, 4013, null, 0, null, null);
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.length() > 3) {
                string2 = string2.substring(0, 3);
            }
            int n3 = -1;
            for (n = 0; n < months.length; ++n) {
                if (!string2.equalsIgnoreCase(months[n])) continue;
                n3 = n;
                break;
            }
            if (n3 == -1 && booleanArray.length == 1 && booleanArray[0].booleanValue()) {
                for (n = 0; n < monthsInDigits.length; ++n) {
                    if (!string2.equalsIgnoreCase(monthsInDigits[n])) continue;
                    n3 = n;
                    this.isMonthInDigits = true;
                    break;
                }
            }
            if (n3 == -1) {
                throw new FlexlmLicenseElementException(-507, 4014, null, 0, null, null);
            }
            if (n2 > daysPerMonth[n3]) {
                throw new FlexlmLicenseElementException(-507, 4015, null, 0, null, null);
            }
            int n4 = 0;
            try {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-507, 4016, null, 0, null, null);
            }
            if (n4 < 0) {
                throw new FlexlmLicenseElementException(-507, 4017, null, 0, null, null);
            }
            if (n4 == 0) {
                this.isPermanent = true;
            } else if (n4 < 100) {
                n4 += 1900;
            }
            if (!this.isPermanent) {
                this.gc = new GregorianCalendar(n4, n3, n2);
            }
        }
    }

    public boolean isPast() {
        if (this.isPermanent) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.after(this.gc);
    }

    public boolean isFuture() {
        if (this.isPermanent) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.before(this.gc);
    }

    public boolean after(FlexlmDate flexlmDate) {
        return this.gc.after(flexlmDate.getCalendar());
    }

    public int getDay() {
        if (this.isPermanent) {
            return 1;
        }
        return this.gc.get(5);
    }

    public String getMonth() {
        if (this.isPermanent) {
            return "jan";
        }
        return months[this.gc.get(2)];
    }

    public int getYear() {
        if (this.isPermanent) {
            return 0;
        }
        return this.gc.get(1);
    }

    public int daysUntilExpiration() {
        if (this.isPermanent) {
            return -3650000;
        }
        if (this.isPast()) {
            return -10;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l = gregorianCalendar.getTime().getTime();
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)this.gc.clone();
        gregorianCalendar2.set(11, 23);
        gregorianCalendar2.set(12, 59);
        gregorianCalendar2.set(13, 59);
        gregorianCalendar.set(14, 0);
        long l2 = gregorianCalendar2.getTime().getTime();
        int n = (int)((l2 - l) / 86400000L);
        return n;
    }

    public Calendar getCalendar() {
        return this.gc;
    }

    public boolean equals(Object object) {
        FlexlmDate flexlmDate = (FlexlmDate)object;
        if (flexlmDate == null) {
            return false;
        }
        if (this.isPermanent && flexlmDate.isPermanent) {
            return true;
        }
        return this.gc.equals(flexlmDate.getCalendar());
    }

    public String toString() {
        if (this.isPermanent) {
            return "permanent";
        }
        if (this.isMonthInDigits) {
            return this.gc.get(5) + "-" + monthsInDigits[this.gc.get(2)] + "-" + this.gc.get(1);
        }
        return this.gc.get(5) + "-" + months[this.gc.get(2)] + "-" + this.gc.get(1);
    }

    public String toZeroYearString() {
        String string = this.toString();
        if (string.equals("permanent")) {
            return "1-jan-0";
        }
        return string;
    }

    String getMonthInDigitsToString() {
        String string = monthsInDigits[this.gc.get(2)];
        return string + "\u0000";
    }
}

