/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

public enum DataFormat {
    FLOAT("FLOAT", "32-bit Float", 4),
    INT16("INT16", "16-bit Integer", 2),
    INT08("INT08", "08-bit Integer", 1),
    COMPRESSED_INT16("COMPRESSED_INT16", "Compressed 16-bit Integer", 2),
    COMPRESSED_INT08("COMPRESSED_INT08", "Compressed 08-bit Integer", 1),
    SEISPEG("SeisPEG Compressed", "SeisPEG 2D Compression", 4);

    protected String _name;
    protected String _description;
    protected int _bytesPerSample;

    private DataFormat(String name, String description, int bytesPerSample) {
        this._name = new String(name);
        this._description = new String(description);
        this._bytesPerSample = bytesPerSample;
    }

    public static DataFormat get(String name) {
        if (name == null) {
            return null;
        }
        for (DataFormat dataFormat : DataFormat.values()) {
            if (!dataFormat.toString().equals(name)) continue;
            return dataFormat;
        }
        return null;
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public int getBytesPerSample() {
        return this._bytesPerSample;
    }
}

