/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import java.util.Arrays;
import org.javaseis.array.TransposeType;
import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayPositionIterator;

public class FftNd {
    SeisFft[] _ffts;
    int _ndim;
    int[] _inShape;
    int[] _forwardShape;
    boolean _complex;
    private DistributedArray _da;

    public FftNd(int[] shapeIn) {
        int ndim = shapeIn.length;
        this.init(ndim, shapeIn, new float[ndim], IFFT.Type.REAL);
    }

    public FftNd(int[] shapeIn, float[] pad, IFFT.Type type) {
        this.init(shapeIn.length, shapeIn, pad, type);
    }

    public FftNd(int ndim, int[] shape, float[] pad, IFFT.Type type) {
        this.init(ndim, shape, pad, type);
    }

    public FftNd(int ndim, int[] shape, float[] pad, IFFT.Type type, IFFT.Scale scale) {
        this.init(ndim, shape, pad, type, scale);
    }

    public void init(int ndim, int[] shape, float[] pad, IFFT.Type type) {
        this.init(ndim, shape, pad, type, IFFT.Scale.INVERSE);
    }

    public void init(int ndim, int[] shape, float[] pad, IFFT.Type type, IFFT.Scale scale) {
        if (ndim < 1 || ndim > 5 || ndim > shape.length) {
            throw new RuntimeException("Only support 1D -- 5D FFT now! " + ndim);
        }
        this._ndim = ndim;
        this._ffts = new SeisFft[ndim];
        this._inShape = (int[])shape.clone();
        this._forwardShape = (int[])shape.clone();
        this._ffts[0] = type == IFFT.Type.REAL ? new SeisFft(shape[0], pad[0], type, -1, scale) : new SeisFft(shape[0], pad[0], type, 1, scale);
        this._forwardShape[0] = this._ffts[0].getLength();
        for (int i = 1; i < ndim; ++i) {
            this._ffts[i] = new SeisFft(shape[i], pad[i], IFFT.Type.COMPLEX, 1, scale);
            this._forwardShape[i] = this._ffts[i].getLength();
        }
        if (type == IFFT.Type.REAL) {
            this._complex = false;
            this._forwardShape[0] = this._forwardShape[0] / 2 + 1;
        } else {
            this._complex = true;
        }
    }

    public int[] getForwardShape() {
        return (int[])this._forwardShape.clone();
    }

    public int[] getInverseShape() {
        return (int[])this._inShape.clone();
    }

    public void setDistributedArray(DistributedArray da) {
        if (da.getDimensions() < this._ndim) {
            throw new RuntimeException("\nInput arrays have wrong dimensions: " + da.getDimensions() + " fft dimension: " + this._ndim);
        }
        this._da = da;
    }

    public void forward(DistributedArray da) {
        if (this._complex && da.getElementCount() != 2) {
            throw new RuntimeException("\nInput arrays have wrong element counts:" + da.getElementCount() + "transform type:" + (this._complex ? "Complex" : "Real"));
        }
        this.setDistributedArray(da);
        this.forward();
    }

    public void forward() {
        int daDim = this._da.getDimensions();
        int lDim = Math.min(this._ndim, daDim - 1);
        for (int idim = 0; idim < lDim; ++idim) {
            this.forwardFft1D(idim);
            this._da.makeLegalForTranspose();
            if (lDim >= 2) {
                this._da.getMultiArray().transpose(TransposeType.T21);
            }
            if (lDim >= 3) {
                this._da.getMultiArray().transpose(TransposeType.T132);
            }
            if (lDim >= 4) {
                this._da.getMultiArray().transpose(TransposeType.T1243);
            }
            if (lDim < 2) continue;
            this._da.matchLocalShape();
        }
        if (lDim < this._ndim) {
            this._da.transposeOuter();
            if (lDim >= 4) {
                this._da.getMultiArray().transpose(TransposeType.T1243);
            }
            if (lDim >= 3) {
                this._da.getMultiArray().transpose(TransposeType.T132);
            }
            if (lDim >= 2) {
                this._da.getMultiArray().transpose(TransposeType.T21);
                this._da.matchLocalShape();
            }
            this.forwardFft1D(lDim);
            this._da.makeLegalForTranspose();
            if (lDim >= 2) {
                this._da.getMultiArray().transpose(TransposeType.T21);
            }
            if (lDim >= 3) {
                this._da.getMultiArray().transpose(TransposeType.T132);
            }
            if (lDim >= 4) {
                this._da.getMultiArray().transpose(TransposeType.T1243);
            }
            if (lDim >= 2) {
                this._da.matchLocalShape();
            }
            this._da.transposeOuter();
        }
    }

    private void forwardFft1D(int idim) {
        int elem = this._da.getElementCount();
        int[] shape = this._da.getShape();
        DistributedArray r = this._da.distributedView();
        if (idim == 0 && !this._complex) {
            this._da.setElementCount(2);
        }
        shape[0] = this._forwardShape[idim];
        this._da.setShape(shape);
        float[] trc = new float[this._forwardShape[idim] * 2];
        int idir = -1;
        if (r.getShape()[0] * r.getElementCount() > this._da.getShape()[0] * this._da.getElementCount()) {
            idir = 1;
        }
        int[] position = new int[shape.length];
        DistributedArrayPositionIterator dapi = new DistributedArrayPositionIterator(this._da, position, idir);
        while (dapi.hasNext()) {
            dapi.next();
            Arrays.fill(trc, 0.0f);
            r.getTrace(trc, position);
            if (elem == 1) {
                this._ffts[idim].realToComplex(trc);
            } else {
                this._ffts[idim].complexForward(trc);
            }
            this._da.putTrace(trc, position);
        }
    }

    public void inverse(DistributedArray da) {
        if (da.getElementCount() != 2) {
            throw new RuntimeException("\nInput arrays have wrong element counts:" + da.getElementCount() + " must be Complex");
        }
        this.setDistributedArray(da);
        this.inverse();
    }

    public void inverse() {
        int daDim = this._da.getDimensions();
        int lDim = Math.min(this._ndim, daDim - 1);
        this._da.makeLegalForTranspose();
        if (lDim < this._ndim) {
            this._da.transposeOuter();
            if (lDim >= 4) {
                this._da.getMultiArray().transpose(TransposeType.T1243);
            }
            if (lDim >= 3) {
                this._da.getMultiArray().transpose(TransposeType.T132);
            }
            if (lDim >= 2) {
                this._da.getMultiArray().transpose(TransposeType.T21);
                this._da.matchLocalShape();
            }
            this.inverseFft1D(lDim);
            this._da.makeLegalForTranspose();
            if (lDim >= 2) {
                this._da.getMultiArray().transpose(TransposeType.T21);
            }
            if (lDim >= 3) {
                this._da.getMultiArray().transpose(TransposeType.T132);
            }
            if (lDim >= 4) {
                this._da.getMultiArray().transpose(TransposeType.T1243);
            }
            if (lDim >= 2) {
                this._da.matchLocalShape();
            }
            this._da.transposeOuter();
        }
        for (int idim = lDim - 1; idim >= 0; --idim) {
            if (lDim >= 4) {
                this._da.getMultiArray().transpose(TransposeType.T1243);
            }
            if (lDim >= 3) {
                this._da.getMultiArray().transpose(TransposeType.T132);
            }
            if (lDim >= 2) {
                this._da.getMultiArray().transpose(TransposeType.T21);
                this._da.matchLocalShape();
            }
            this.inverseFft1D(idim);
            this._da.makeLegalForTranspose();
        }
    }

    private void inverseFft1D(int idim) {
        int elem = this._da.getElementCount();
        float[] trc = new float[this._forwardShape[idim] * elem];
        int[] shape = this._da.getShape();
        DistributedArray r = this._da.distributedView();
        if (idim == 0 && !this._complex) {
            this._da.setElementCount(1);
            elem = 1;
        }
        shape[0] = this._inShape[idim];
        this._da.setShape(shape);
        int idir = -1;
        if (r.getShape()[0] * r.getElementCount() > this._da.getShape()[0] * this._da.getElementCount()) {
            idir = 1;
        }
        int[] position = new int[shape.length];
        DistributedArrayPositionIterator dapi = new DistributedArrayPositionIterator(this._da, position, idir);
        while (dapi.hasNext()) {
            dapi.next();
            Arrays.fill(trc, 0.0f);
            r.getTrace(trc, position);
            if (elem == 1) {
                this._ffts[idim].complexToReal(trc);
            } else {
                this._ffts[idim].complexInverse(trc);
            }
            this._da.putTrace(trc, position);
        }
    }
}

