/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.CleanHandler;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.ArraysUtil;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.FrameIterator;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.TraceIterator;
import org.javaseis.array.beta.VolumeIterator;
import org.javaseis.array.beta.test.JTestFlexArray2D;
import org.junit.Assert;
import org.junit.Test;

public class JTestFlexArray3D {
    private static final Logger LOG = Logger.getLogger(JTestFlexArray3D.class.getName());

    @Test
    public void testGetFrameIO() {
        int[] shape = new int[]{11, 13, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            T[] frame;
            int j;
            IFlexArray aa = list.get(i);
            for (j = 0; j < shape[2]; ++j) {
                frame = aa.getFrame(new int[]{0, 0, j});
                ArraysUtil.fill(frame, j);
            }
            for (j = 0; j < shape[2]; ++j) {
                frame = aa.getFrame(new int[]{0, 0, j});
                Object t = frame[0];
                Number obj = (Number)Array.get(t, 0);
                Assert.assertEquals((long)j, (long)obj.intValue());
            }
        }
    }

    @Test
    public void testReshape2() {
        int[] shape = new int[]{11, 5, 9};
        int[] shape2 = new int[]{11, 5, 7};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void testReshape2Expand() {
        int[] shape = new int[]{11, 5, 1};
        int[] shape2 = new int[]{11, 5, 2};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.reshape(shape2);
            Assert.assertArrayEquals((int[])shape2, (int[])aa.getShape());
        }
    }

    @Test
    public void testT213() {
        int[] shape = new int[]{11, 5, 1};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.transpose(TransposeType.T213);
            Assert.assertArrayEquals((int[])new int[]{5, 11, 1}, (int[])aa.getShape());
            if (aa.getElementCount() == 1) {
                JTestFlexArray2D.validateData(aa);
                continue;
            }
            LOG.warning("T213 is not validating results for complex data");
        }
    }

    @Test
    public void testT132() {
        int[] shape = new int[]{11, 5, 9};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.transpose(TransposeType.T132);
            Assert.assertArrayEquals((int[])new int[]{11, 9, 5}, (int[])aa.getShape());
            JTestFlexArray2D.validateData(aa);
        }
    }

    @Test
    public void testT231() {
        int[] shape = new int[]{11, 5, 9};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            aa.transpose(TransposeType.T231);
            Assert.assertArrayEquals((int[])new int[]{5, 9, 11}, (int[])aa.getShape());
            if (aa.getElementCount() == 1) {
                JTestFlexArray2D.validateData(aa);
                continue;
            }
            LOG.warning("T231 is not validating results for complex data");
        }
    }

    @Test
    public void testCopyConstructor() {
        int[] shape = new int[]{11, 5, 7};
        int[] shape2 = new int[]{1, 5, 7};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            JTestFlexArray2D.modifyTraceValue(aa);
            JTestFlexArray2D.validateData(aa);
            FlexArray bb = new FlexArray((FlexArray)aa);
            JTestFlexArray2D.validateData(bb);
            bb.reshape(shape2);
            JTestFlexArray2D.validateData(bb);
            Assert.assertArrayEquals((int[])shape, (int[])aa.getShape());
            Assert.assertArrayEquals((int[])shape2, (int[])bb.getShape());
        }
    }

    @Test
    public void testRemoveDimension() {
        int[] shape = new int[]{11, 5, 7};
        int[] shape2 = new int[]{11, 5};
        List<IFlexArray> list = this.getTestArrays(shape);
        for (int i = 0; i < list.size(); ++i) {
            IFlexArray aa = list.get(i);
            aa.reshape(shape2);
            Assert.assertEquals((long)2L, (long)aa.getDimensions());
            Assert.assertEquals((long)11L, (long)aa.getShape()[0]);
            Assert.assertEquals((long)5L, (long)aa.getShape()[1]);
        }
    }

    @Test
    public void testVolumeIO() {
        int j;
        int[] shape = new int[]{3, 2, 2, 1};
        IFlexArray<float[]> aa = FlexArray.createFloatArray(shape);
        int cnt = 0;
        TraceIterator<float[]> ti = new TraceIterator<float[]>(aa);
        while (ti.hasNext()) {
            float[] t = ti.next();
            ArraysUtil.fill(t, ++cnt);
        }
        FrameIterator fi = new FrameIterator(aa);
        while (fi.hasNext()) {
            float[][] frame = (float[][])fi.next();
            for (int i = 0; i < frame.length; ++i) {
            }
        }
        VolumeIterator vi = new VolumeIterator(aa);
        while (vi.hasNext()) {
            float[][][] volume = (float[][][])vi.next();
            for (int i = 0; i < volume.length; ++i) {
                for (j = 0; j < volume[i].length; ++j) {
                }
            }
        }
        vi.reset();
        while (vi.hasNext()) {
            float[][][] volume = (float[][][])vi.next();
            float[][][] vOut = new float[volume.length][volume[0].length][];
            for (int i = 0; i < volume.length; ++i) {
                for (int j2 = 0; j2 < volume[i].length; ++j2) {
                    vOut[i][j2] = volume[j2][i];
                }
            }
            aa.putVolume((T[][])vOut, vi.getPosition());
        }
        vi.reset();
        while (vi.hasNext()) {
            float[][][] volume = (float[][][])vi.next();
            for (int i = 0; i < volume.length; ++i) {
                for (j = 0; j < volume[i].length; ++j) {
                }
            }
        }
    }

    private List<IFlexArray> getTestArrays(int[] shape) {
        ArrayList<IFlexArray> list = new ArrayList<IFlexArray>();
        list.add(FlexArray.createIntArray(shape));
        list.add(FlexArray.createFloatArray(shape));
        list.add(FlexArray.createIntArray(1, shape));
        list.add(FlexArray.createFloatArray(1, shape));
        list.add(new FlexArray(long[].class, 1, shape));
        list.add(new FlexArray(short[].class, 1, shape));
        list.add(new FlexArray(double[].class, 1, shape));
        list.add(new FlexArray(byte[].class, 1, shape));
        list.add(FlexArray.createIntArray(2, shape));
        list.add(FlexArray.createFloatArray(2, shape));
        return list;
    }

    static {
        CleanHandler.setDefaultHandler();
    }
}

