/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.a.c.a;
import com.certicom.ecc.a.c.b;
import com.certicom.ecc.a.c.d;
import com.certicom.ecc.a.d.c;
import com.certicom.ecc.a.d.e;
import com.certicom.ecc.a.d.g;
import com.certicom.ecc.a.d.h;
import com.certicom.ecc.a.d.i;
import com.certicom.ecc.a.d.q;
import com.certicom.ecc.a.d.r;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.jcae.DHKeyParams;
import com.certicom.ecc.jcae.X942KeyParams;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.spec.X942ParameterSpec;
import com.certicom.ecc.spec.X942PublicKeySpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHPublicKeyImpl
implements Zeroizeable,
DHPublicKey {
    private static final long serialVersionUID = 3573164197839170895L;
    private BigInteger b;
    protected DHKeyParams a;
    private boolean c = false;

    public DHPublicKeyImpl() {
    }

    public DHPublicKeyImpl(DSAPublicKey dSAPublicKey) {
        this.b = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        this.a = new DHKeyParams(dSAParams.getP(), dSAParams.getG(), dSAParams.getQ().bitLength());
    }

    public DHPublicKeyImpl(DSAPublicKeySpec dSAPublicKeySpec) {
        this.b = dSAPublicKeySpec.getY();
        this.a = new DHKeyParams(dSAPublicKeySpec.getP(), dSAPublicKeySpec.getG(), dSAPublicKeySpec.getQ().bitLength());
    }

    public DHPublicKeyImpl(DHPublicKey dHPublicKey) {
        this.b = dHPublicKey.getY();
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        this.a = new DHKeyParams(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL());
    }

    public DHPublicKeyImpl(DHPublicKeySpec dHPublicKeySpec) {
        this.b = dHPublicKeySpec.getY();
        this.a = new DHKeyParams(dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
    }

    public DHPublicKeyImpl(X942PublicKeySpec x942PublicKeySpec) {
        this.b = x942PublicKeySpec.getY();
        this.a = new X942KeyParams(x942PublicKeySpec.getP(), x942PublicKeySpec.getG(), x942PublicKeySpec.getQ(), x942PublicKeySpec.getJ(), x942PublicKeySpec.getSeed(), x942PublicKeySpec.getCounter());
    }

    public DHPublicKeyImpl(byte[] byArray) throws IOException, q {
        com.certicom.ecc.a.c.c c2 = new com.certicom.ecc.a.c.c();
        c2.decode(byArray);
        d d2 = c2.b();
        i i2 = d2.a();
        if (i2.toString().equals("1.2.840.113549.1.3.1")) {
            h h2 = d2.b();
            this.a = new DHKeyParams(((com.certicom.ecc.a.b.c.c)h2).a(), ((com.certicom.ecc.a.b.c.c)h2).b(), ((com.certicom.ecc.a.b.c.c)h2).c());
        } else if (i2.toString().equals("1.2.840.10046.2.1")) {
            h h3 = d2.b();
            this.a = new X942KeyParams(((a)h3).a(), ((a)h3).b(), ((a)h3).c(), ((a)h3).d(), ((a)h3).e().a(), ((a)h3).e().b());
        } else {
            throw new IOException("Security_InvalidAlgorithmIdentifier");
        }
        g g2 = new g();
        g2.decode(c2.a());
        this.b = new BigInteger(1, g2.a());
    }

    public BigInteger getY() {
        return this.b;
    }

    public DHParameterSpec getParams() {
        if (this.a instanceof X942KeyParams) {
            X942KeyParams x942KeyParams = (X942KeyParams)this.a;
            return new X942ParameterSpec(x942KeyParams.getP(), x942KeyParams.getG(), x942KeyParams.getQ(), x942KeyParams.getJ(), x942KeyParams.getSeed(), x942KeyParams.getCounter(), x942KeyParams.getL());
        }
        return new DHParameterSpec(this.a.getP(), this.a.getG(), this.a.getL());
    }

    public String getFormat() {
        if (SystemConfig.getConfig().getFormat() == 10) {
            return "RAW";
        }
        return "X.509";
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String toString() {
        return "[ Public key: " + this.b.toString(16) + " Parameters: " + this.a.toString() + " ]";
    }

    public byte[] getEncoded() {
        if (SystemConfig.getConfig().getFormat() == 10) {
            throw new IllegalStateException("Cannot encode in RAW mode.");
        }
        try {
            com.certicom.ecc.a.c.c c2;
            Object object;
            c c3 = new c();
            new g(this.b).encode(c3);
            byte[] byArray = c3.a();
            if (this.a instanceof X942KeyParams) {
                object = new b(((X942KeyParams)this.a).getSeed(), ((X942KeyParams)this.a).getCounter());
                c2 = new com.certicom.ecc.a.c.c(new d("1.2.840.10046.2.1", new a(((X942KeyParams)this.a).getP(), ((X942KeyParams)this.a).getG(), ((X942KeyParams)this.a).getQ(), ((X942KeyParams)this.a).getJ(), (b)object)), byArray);
            } else {
                c2 = new com.certicom.ecc.a.c.c(new d("1.2.840.113549.1.3.1", new com.certicom.ecc.a.b.c.c(this.a.getP(), this.a.getG(), this.a.getL())), byArray);
            }
            object = new c();
            c2.encode((e)object);
            return ((c)object).a();
        }
        catch (r r2) {
            throw new IllegalStateException("Could not encode public key");
        }
        catch (q q2) {
            throw new IllegalStateException("Could not encode public key");
        }
    }

    public boolean isZeroized() {
        return this.c;
    }

    public boolean testZeroizationState() {
        return this.c;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.b = BigInteger.ZERO;
        if (this.a != null) {
            this.a.zeroize();
        }
        this.c = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public boolean validate(byte[] byArray) {
        return this.validate(new BigInteger(1, byArray));
    }

    public boolean validate(BigInteger bigInteger) {
        CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "DHPublicKeyValid");
        cryptoTransform.init(5, new Object[]{this.a.getP(), bigInteger}, null);
        byte[] byArray = this.b.toByteArray();
        Boolean bl = (Boolean)cryptoTransform.transformToObject(byArray, 0, byArray.length, true);
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(new Boolean(this.c));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.b = (BigInteger)objectInputStream.readObject();
        this.a = (DHKeyParams)objectInputStream.readObject();
        this.c = (Boolean)objectInputStream.readObject();
    }
}

