/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.interfaces.F2mParams;
import com.certicom.ecc.spec.FFParameterSpec;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class F2mParameterSpec
extends FFParameterSpec
implements F2mParams,
Serializable {
    private static final long serialVersionUID = -4737925806342630638L;
    private int l = -1;
    private int m = -1;
    private int n = -1;

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int n4, int n5, int n6, String string, String string2) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string, string2);
        this.l = n4;
        this.m = n5;
        this.n = n6;
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int n4, String string, String string2) {
        this(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, n4, -1, -1, string, string2);
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, String string, String string2) {
        this(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, -1, -1, -1, string, string2);
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int[] nArray, String string, String string2) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string, string2);
        if (nArray != null) {
            if (nArray.length == 1) {
                this.l = nArray[0];
            } else if (nArray.length == 3) {
                this.l = nArray[0];
                this.m = nArray[1];
                this.n = nArray[2];
            } else {
                throw new IllegalArgumentException("basis not recognized");
            }
        }
    }

    public int basisType() {
        return this.l == -1 ? 0 : (this.m == -1 ? 1 : 2);
    }

    public int[] getBasis() {
        switch (this.basisType()) {
            case 0: {
                return null;
            }
            case 1: {
                return new int[]{this.l};
            }
        }
        return new int[]{this.l, this.m, this.n};
    }

    public boolean equals(Object object) {
        if (object instanceof F2mParameterSpec) {
            F2mParameterSpec f2mParameterSpec = (F2mParameterSpec)object;
            return super.equals(object) && this.getSize() == f2mParameterSpec.getSize() && this.l == f2mParameterSpec.l && this.m == f2mParameterSpec.m && this.n == f2mParameterSpec.n;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.getSize() << 9 ^ this.l << 6 ^ this.m << 3 ^ this.n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ FieldType: F2m");
        return stringBuffer.append(" curveAtA: ").append(Conversion.OS2Hex(this.b, 8)).append(" curveAtB: ").append(Conversion.OS2Hex(this.c, 8)).append(" seed: ").append(this.d == null ? "NULL" : Conversion.OS2Hex(this.d, 8)).append(" baseAtX: ").append(Conversion.OS2Hex(this.e, 8)).append(" baseAtY: ").append(Conversion.OS2Hex(this.f, 8)).append(" order: ").append(Conversion.OS2Hex(this.g, 8)).append(" cf: ").append(Integer.toString(this.h)).append(" size: ").append(Integer.toString(this.getSize())).append(" basis: ").append(" k: ").append(this.l == -1 ? "NULL " : Integer.toString(this.l)).append(" k2: ").append(this.m == -1 ? "NULL " : Integer.toString(this.m)).append(" k3: ").append(this.n == -1 ? "NULL " : Integer.toString(this.n)).append(" ]").toString();
    }

    public void zeroize() throws FIPSException {
        this.l = -1;
        this.m = -1;
        this.n = -1;
        super.zeroize();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Integer(this.l));
        objectOutputStream.writeObject(new Integer(this.m));
        objectOutputStream.writeObject(new Integer(this.n));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.l = (Integer)objectInputStream.readObject();
        this.m = (Integer)objectInputStream.readObject();
        this.n = (Integer)objectInputStream.readObject();
    }
}

