/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.RNGSpi;
import com.certicom.ecc.jcae.SHA1Spi;
import com.certicom.ecc.spec.X942GenParameterSpec;
import com.certicom.ecc.spec.X942ParameterSpec;
import com.certicom.ecc.spec.X942ValidationParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;

public class DHAlgGenSpi
extends AlgorithmParameterGeneratorSpi {
    private static final BigInteger b = BigInteger.valueOf(0L);
    private static final BigInteger c = BigInteger.valueOf(1L);
    DHGenParameterSpec a;
    private SecureRandom d;
    private int e = 0;
    private int f = 160;
    private int g = 1024;

    private BigInteger[] a(BigInteger bigInteger, int n2) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        int n3;
        BigInteger bigInteger6 = null;
        BigInteger bigInteger7 = null;
        BigInteger bigInteger8 = null;
        int n4 = (this.f + 159) / 160;
        int n5 = (this.g + 159) / 160;
        int n6 = (this.g + 1023) / 1024;
        bigInteger7 = BigInteger.valueOf(0L);
        BigInteger bigInteger9 = BigInteger.valueOf(n4);
        BigInteger bigInteger10 = BigInteger.valueOf(n5);
        BigInteger bigInteger11 = c.shiftLeft(160).subtract(c);
        BigInteger bigInteger12 = c.shiftLeft(this.g).subtract(c);
        BigInteger bigInteger13 = c.shiftLeft(this.g - 1);
        for (n3 = 0; n3 < n4; ++n3) {
            bigInteger5 = bigInteger.add(BigInteger.valueOf(n3));
            bigInteger4 = this.a(bigInteger5);
            bigInteger3 = this.a(bigInteger5.add(bigInteger9).and(bigInteger11));
            bigInteger7 = bigInteger7.add(bigInteger4.xor(bigInteger3).shiftLeft(160 * n3));
        }
        if (!(bigInteger7 = bigInteger7.and(c.shiftLeft(this.f).subtract(c)).setBit(0).setBit(this.f - 1)).isProbablePrime(80)) {
            return null;
        }
        bigInteger5 = bigInteger7.shiftLeft(1);
        bigInteger4 = bigInteger.add(bigInteger9).add(bigInteger9);
        n2 = n2 < 0 ? 4096 * n6 : ++n2;
        for (n3 = 0; n3 < n2; ++n3) {
            bigInteger3 = b;
            for (int i2 = 0; i2 < n5; ++i2) {
                bigInteger3 = bigInteger3.add(this.a(bigInteger4.add(BigInteger.valueOf(i2))).shiftLeft(160 * i2));
            }
            bigInteger2 = bigInteger3.and(bigInteger12).setBit(this.g - 1);
            bigInteger6 = bigInteger2.subtract(bigInteger2.mod(bigInteger5)).add(c);
            if (bigInteger6.compareTo(bigInteger13) > 0 && bigInteger6.isProbablePrime(80)) break;
            bigInteger4 = bigInteger4.add(bigInteger10);
        }
        if (n3 >= n2) {
            return null;
        }
        bigInteger3 = bigInteger6.subtract(c).divide(bigInteger7);
        bigInteger2 = bigInteger6.subtract(c);
        BigInteger[] bigIntegerArray = BigInteger.valueOf(2L);
        while (bigIntegerArray.compareTo(bigInteger2) < 0 && (bigInteger8 = bigIntegerArray.modPow(bigInteger3, bigInteger6)).compareTo(c) == 0) {
            bigIntegerArray = bigIntegerArray.add(c);
        }
        bigIntegerArray = new BigInteger[]{bigInteger6, bigInteger7, bigInteger8, bigInteger3, bigInteger, BigInteger.valueOf(n3)};
        return bigIntegerArray;
    }

    private BigInteger a(BigInteger bigInteger) {
        SHA1Spi sHA1Spi = new SHA1Spi();
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        sHA1Spi.engineUpdate(byArray, 0, n2);
        byArray2 = sHA1Spi.engineDigest();
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return bigInteger2;
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.g = n2;
        this.f = 160;
        this.e = 0;
        this.d = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Security_InvalidAlgorithmParameter");
        }
        this.a = (DHGenParameterSpec)algorithmParameterSpec;
        this.g = this.a.getPrimeSize();
        if (this.g < 160) {
            throw new InvalidAlgorithmParameterException("Security_Invalid_DH_L");
        }
        if (algorithmParameterSpec instanceof X942GenParameterSpec) {
            this.f = ((X942GenParameterSpec)algorithmParameterSpec).getM();
            if (this.f < 160) {
                throw new InvalidAlgorithmParameterException("Security_Invalid_DH_MTooSmall");
            }
        } else {
            this.f = 160;
        }
        this.e = this.a.getExponentSize();
        if (this.e < 0) {
            throw new InvalidAlgorithmParameterException("Security_Invalid_DH_Exponent");
        }
        if (this.e > this.g) {
            throw new InvalidAlgorithmParameterException("Security_Invalid_DH_ExponentL");
        }
        this.d = secureRandom;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        BigInteger[] bigIntegerArray;
        Object object;
        if (this.d == null) {
            this.d = RNGSpi.a();
        }
        if (this.a instanceof X942ValidationParameterSpec) {
            object = (X942ValidationParameterSpec)this.a;
            bigIntegerArray = this.a(((X942ValidationParameterSpec)object).getSeed(), ((X942ValidationParameterSpec)object).getCounter());
            if (bigIntegerArray == null) {
                return null;
            }
        } else {
            object = new byte[this.f + 7 >> 3];
            this.d.nextBytes((byte[])object);
            boolean bl = false;
            while ((bigIntegerArray = this.a(new BigInteger(1, (byte[])object), -1)) == null) {
                this.d.nextBytes((byte[])object);
            }
        }
        try {
            object = AlgorithmParameters.getInstance("DiffieHellman", "Certicom");
            ((AlgorithmParameters)object).init(new X942ParameterSpec(bigIntegerArray[0], bigIntegerArray[2], bigIntegerArray[1], bigIntegerArray[3], bigIntegerArray[4], bigIntegerArray[5].intValue(), this.e));
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

