/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import org.javaseis.io.ExtentPolicyEnum;
import org.javaseis.io.VirtualFolders;
import org.javaseis.util.SeisException;
import org.javaseis.util.access.JavaSeisDescriptor;
import org.javaseis.util.datavolume.DiskSet;
import org.javaseis.util.datavolume.VDU;
import org.javaseis.util.datavolume.VolumeParameters;

public class DiskVolume {
    protected JavaSeisDescriptor _jd = null;
    protected long _ext_size = 0L;
    protected int _num_extents = 0;
    protected DiskSet _disk_set = null;
    protected String _name = null;
    protected VirtualFolders _folders = null;

    public DiskVolume(JavaSeisDescriptor jd, VolumeParameters vp) {
        this._jd = jd;
        long size = this._jd.getSampleCount() * (long)this._jd.getDataDefinition().getTraceFormat().getBytesPerSample();
        long ext_size = vp.getExtSize();
        if (ext_size < 1L) {
            ext_size = VDU.defaultExtent(vp.getHosts().length, size);
        }
        this.setExtentSize(ext_size);
        try {
            this.createLocation(vp);
            this.createDescription(size);
        }
        catch (SeisException e) {
            System.out.println(e.getMessage());
        }
    }

    public JavaSeisDescriptor descriptor() {
        return this._jd;
    }

    protected void createLocation(VolumeParameters vp) throws SeisException {
        this._disk_set = new DiskSet(vp.getPath(), vp.getRoot(), vp.getHosts(), vp.getLocation());
        this._name = vp.getName();
        if (vp.getInitializeFlag()) {
            this._disk_set.recursiveDelete(this._name);
        }
        this._folders = this._disk_set.getVirtualFolders(this._name, ExtentPolicyEnum.get(vp.getExtentPolicyID()));
    }

    public String getPath() throws SeisException {
        return this._disk_set.getPath(this._name);
    }

    public VirtualFolders getFolders() {
        return this._folders;
    }

    public void createDescription(long size) throws SeisException {
        if (size < 1L) {
            throw new SeisException("DiskVolume failed: the size is undefined\n");
        }
        if (this._ext_size < 1L) {
            throw new SeisException("DiskVolume failed: the extent size is undefined\n");
        }
        this.findNumExtents(size);
    }

    public void setExtentSize(long ext_size) {
        this._ext_size = ext_size;
    }

    protected void findNumExtents(long size) {
        this._num_extents = (int)Math.ceil((double)size / (double)this._ext_size);
    }

    public int getNumExtents() {
        if (this._folders == null) {
            return 0;
        }
        return this._num_extents;
    }

    public DiskSet getDiskSet() {
        return this._disk_set;
    }
}

