/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import edu.mines.jtk.util.ParameterSet;
import org.javaseis.grid.BinGrid;
import org.javaseis.io.Seisio;
import org.javaseis.util.SeisException;
import org.javaseis.util.access.JavaSeisDescriptor;
import org.javaseis.util.access.TraceAccessor;
import org.javaseis.util.datavolume.DiskVolume;
import org.javaseis.util.datavolume.VolumeEvaluator;
import org.javaseis.util.datavolume.VolumeParameters;

public class SeisioCreator {
    private Seisio _seisio = null;
    private DiskVolume _dv = null;

    public SeisioCreator(JavaSeisDescriptor jd, VolumeParameters vp) {
        this(jd, vp, null);
    }

    public SeisioCreator(JavaSeisDescriptor jd, VolumeParameters vp, ParameterSet bingrid) {
        this._dv = new DiskVolume(jd, vp);
        try {
            this._seisio = new Seisio(this._dv.getPath(), jd.getGridDefinition(), jd.getDataDefinition(), jd.getHeaderDefinition());
            this._seisio.setMapped();
        }
        catch (SeisException e) {
            System.out.println(e.getMessage());
            this._seisio = null;
            return;
        }
        if (vp.getInitializeFlag()) {
            try {
                this.createName(vp.getName());
                this.createBinGrid(bingrid);
                if (this._dv.getFolders() == null || this._dv.getNumExtents() < 1) {
                    this._seisio.create();
                } else {
                    this._seisio.create(this._dv.getFolders(), this._dv.getNumExtents());
                    VolumeEvaluator vol_eval = new VolumeEvaluator(this._seisio);
                    for (int k2 = 0; k2 < this._dv.getNumExtents(); ++k2) {
                        this._seisio.getTraceIO().setPosition(TraceAccessor.getFirstTraceByteInFrame(k2, this._dv.getNumExtents(), vol_eval, this._dv.descriptor().getDataDefinition().getTraceFormat()));
                        if (this._seisio.getHeaderIO() == null) continue;
                        this._seisio.getHeaderIO().setPosition(TraceAccessor.getFirstHeaderByteInFrame(k2, this._dv.getNumExtents(), vol_eval, this._seisio.getTraceProperties()));
                    }
                }
                this._seisio.close();
            }
            catch (Exception e) {
                System.out.println("SeisCreator: " + e.getMessage());
                this._seisio = null;
                return;
            }
        }
    }

    public Seisio getSeisio() {
        return this._seisio;
    }

    public DiskVolume getDiskVolume() {
        return this._dv;
    }

    private void createName(String name) throws Exception {
        int index = name.indexOf(".");
        index = index > 0 ? index : name.length() - 1;
        Seisio.createStub(this._dv.getPath(), name.substring(0, index));
    }

    private boolean createBinGrid(ParameterSet parset) throws SeisException {
        boolean retval = false;
        if (parset != null) {
            BinGrid bingrid = new BinGrid(parset);
            this._seisio.writeBinGridToFileProperties(bingrid.toParameterSet());
            retval = true;
        }
        return retval;
    }
}

