/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.util.Random;
import junit.framework.TestCase;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.MultiArray;
import org.javaseis.array.TransposeType;

public class JTestMultiArray
extends TestCase {
    BackingArray.Type _type = BackingArray.Type.JAVA_ARRAY;

    public static void main(String[] args) {
        JTestMultiArray test = new JTestMultiArray();
        test.testLoop3d();
        test.testLoop4d();
        test.testTranspose21();
        test.testTranspose132();
        test.testTranspose321();
        test.testTranspose1243();
        test._type = BackingArray.Type.JAVA_LONG_ARRAY;
        test.testLoop3d();
        test.testLoop4d();
        test.testTranspose21();
        test.testTranspose132();
        test.testTranspose321();
        test.testTranspose1243();
    }

    public void testLoop3d() {
        int i;
        int k;
        int[] lengths = new int[]{4, 3, 2};
        MultiArray sa = JTestMultiArray.initArray(this._type, lengths);
        int[] position = new int[]{0, 0, 0};
        int[] buf = new int[lengths[0]];
        for (k = 0; k < lengths[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < lengths[1]; ++j) {
                int i2;
                position[1] = j;
                for (i2 = 0; i2 < lengths[0]; ++i2) {
                    position[0] = i2;
                    JTestMultiArray.assertEquals((String)"Loop test 1 failed", (int)JTestMultiArray.testFn(i2, j, k), (int)sa.getInt(position));
                }
                position[0] = 0;
                sa.getTrace(buf, position);
                for (i2 = 0; i2 < lengths[0]; ++i2) {
                    JTestMultiArray.assertEquals((String)"Loop test 1 failed", (int)JTestMultiArray.testFn(i2, j, k), (int)buf[i2]);
                }
            }
        }
        for (k = 0; k < lengths[2]; ++k) {
            position[2] = k;
            for (i = 0; i < lengths[0]; ++i) {
                position[0] = i;
                for (int j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    JTestMultiArray.assertEquals((String)"Loop test 2 failed", (int)JTestMultiArray.testFn(i, j, k), (int)sa.getInt(position));
                }
            }
        }
        for (int j = 0; j < lengths[1]; ++j) {
            position[1] = j;
            for (i = 0; i < lengths[0]; ++i) {
                position[0] = i;
                for (int k2 = 0; k2 < lengths[2]; ++k2) {
                    position[2] = k2;
                    JTestMultiArray.assertEquals((String)"Loop test 3 failed", (int)JTestMultiArray.testFn(i, j, k2), (int)sa.getInt(position));
                }
            }
        }
        for (int k3 = 0; k3 < lengths[2]; ++k3) {
            position[2] = k3;
            position[1] = 0;
            position[0] = 0;
            IMultiArray sb = sa.view(2, position);
            for (int j = 0; j < lengths[1]; ++j) {
                position[1] = j;
                for (int i3 = 0; i3 < lengths[0]; ++i3) {
                    position[0] = i3;
                    int val = sb.getInt(position);
                    JTestMultiArray.assertEquals((String)("Loop test 4 failed (view) at " + i3 + " " + j + " " + k3), (int)JTestMultiArray.testFn(i3, j, k3), (int)val);
                }
            }
        }
    }

    public void testLoop4d() {
        int i;
        int j;
        int[] lengths = new int[]{5, 4, 3, 2};
        MultiArray sa = JTestMultiArray.initArray4(lengths);
        int[] position = new int[]{0, 0, 0, 0};
        int[] buf = new int[lengths[0]];
        for (int m = 0; m < lengths[3]; ++m) {
            position[3] = m;
            for (int k = 0; k < lengths[2]; ++k) {
                position[2] = k;
                for (j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    for (i = 0; i < lengths[0]; ++i) {
                        position[0] = i;
                        JTestMultiArray.assertEquals((String)"4d Loop test 1 failed", (int)JTestMultiArray.testFn(i, j, k, m), (int)sa.getInt(position));
                    }
                    position[0] = 0;
                    sa.getTrace(buf, position);
                    for (i = 0; i < lengths[0]; ++i) {
                        JTestMultiArray.assertEquals((String)"4D Loop test 1 failed", (int)JTestMultiArray.testFn(i, j, k, m), (int)buf[i]);
                    }
                }
            }
        }
        for (int k = 0; k < lengths[2]; ++k) {
            position[2] = k;
            for (int m = 0; m < lengths[3]; ++m) {
                position[3] = m;
                for (j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    for (i = 0; i < lengths[0]; ++i) {
                        position[0] = i;
                        JTestMultiArray.assertEquals((String)" 4d Loop test 2 failed", (int)JTestMultiArray.testFn(i, j, k, m), (int)sa.getInt(position));
                    }
                }
            }
        }
    }

    public void testTranspose21() {
        int[] lengths = new int[]{4, 3, 2};
        MultiArray sa = JTestMultiArray.initArray(this._type, lengths);
        sa.transpose(TransposeType.T21);
        int[] transLengths = new int[]{3, 4, 2};
        int[] position = new int[]{0, 0, 0};
        for (int k = 0; k < transLengths[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < transLengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < transLengths[0]; ++i) {
                    position[0] = i;
                    JTestMultiArray.assertEquals((String)"Transpose 213 Failed", (int)JTestMultiArray.testFn(j, i, k), (int)sa.getInt(position));
                }
            }
        }
    }

    public void testTranspose132() {
        int[] lengths = new int[]{4, 3, 2};
        MultiArray sa = JTestMultiArray.initArray(this._type, lengths);
        sa.transpose(TransposeType.T132);
        int[] transLengths = new int[]{4, 2, 3};
        int[] position = new int[]{0, 0, 0};
        for (int k = 0; k < transLengths[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < transLengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < transLengths[0]; ++i) {
                    position[0] = i;
                    JTestMultiArray.assertEquals((String)"Transpose 132 Failed", (int)JTestMultiArray.testFn(i, k, j), (int)sa.getInt(position));
                }
            }
        }
    }

    public void testTranspose321() {
        int[] lengths = new int[]{4, 3, 2};
        MultiArray sa = JTestMultiArray.initArray(this._type, lengths);
        sa.transpose(TransposeType.T321);
        int[] transLengths = new int[]{2, 3, 4};
        int[] position = new int[]{0, 0, 0};
        for (int k = 0; k < transLengths[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < transLengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < transLengths[0]; ++i) {
                    position[0] = i;
                    JTestMultiArray.assertEquals((String)"Transpose 321 Failed", (int)JTestMultiArray.testFn(k, j, i), (int)sa.getInt(position));
                }
            }
        }
    }

    public void testTranspose1243() {
        int[] lengths = new int[]{4, 3, 2, 4};
        MultiArray sa = JTestMultiArray.initArray4(lengths);
        sa.transpose(TransposeType.T1243);
        int[] transLengths = new int[]{4, 2, 4, 2};
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = 0; m < transLengths[3]; ++m) {
            position[3] = m;
            for (int k = 0; k < transLengths[2]; ++k) {
                position[2] = k;
                for (int j = 0; j < transLengths[1]; ++j) {
                    position[1] = j;
                    for (int i = 0; i < transLengths[0]; ++i) {
                        position[0] = i;
                        JTestMultiArray.assertEquals((String)"Transpose 1243 Failed", (int)JTestMultiArray.testFn(i, j, m, k), (int)sa.getInt(position));
                    }
                }
            }
        }
    }

    public void testReshape() {
        int ib;
        int ia;
        MultiArray sb;
        MultiArray sa;
        int itest;
        int ntest = 10;
        int ndim = 4;
        int[] maxLengths = new int[]{57, 19, 43, 101};
        int[] lengths = new int[ndim];
        int[] newLengths = new int[ndim];
        Random r = new Random(12345L);
        for (itest = 0; itest < ntest; ++itest) {
            for (int i = 0; i < ndim; ++i) {
                lengths[i] = Math.max((int)(Math.random() * (double)maxLengths[i]), 2);
            }
            sa = JTestMultiArray.initArrayFloat(maxLengths, maxLengths);
            sb = new MultiArray(sa);
            this.checkContents("testReshape contract iteration " + itest, sb, lengths);
            sa = null;
            sb = null;
            System.gc();
        }
        for (itest = 0; itest < ntest; ++itest) {
            for (int i = 0; i < ndim; ++i) {
                ia = Math.max((int)(Math.random() * (double)maxLengths[i]), 2);
                if (ia > (ib = Math.max((int)(Math.random() * (double)maxLengths[i]), 2))) {
                    lengths[i] = ib;
                    newLengths[i] = ia;
                    continue;
                }
                lengths[i] = ia;
                newLengths[i] = ib;
            }
            sa = JTestMultiArray.initArrayFloat(lengths, maxLengths);
            sb = new MultiArray(sa);
            this.checkContents("testReshape expand iteration " + itest, sb, lengths);
            sa = null;
            sb = null;
            System.gc();
        }
        int[] checklen = new int[ndim];
        for (int itest2 = 0; itest2 < ntest; ++itest2) {
            for (int i = 0; i < ndim; ++i) {
                ia = (int)(r.nextDouble() * (double)maxLengths[i]);
                ib = (int)(r.nextDouble() * (double)maxLengths[i]);
                lengths[i] = Math.max(ia, 1);
                newLengths[i] = Math.max(ib, 1);
                checklen[i] = Math.min(ia, ib);
            }
            MultiArray sa2 = JTestMultiArray.initArrayFloat(lengths, maxLengths);
            MultiArray sb2 = new MultiArray(sa2);
            this.checkContents("Arbitrary Shape iteration " + itest2, sb2, checklen);
            sa2 = null;
            sb2 = null;
            System.gc();
        }
    }

    public void testCreateBigArray() {
        int ndim = 3;
        int[] lengths = new int[]{1, 1, 1};
        long maxArrayLength = 2147483747L;
        MultiArray sa = new MultiArray(ndim, Integer.TYPE, 1, lengths);
        try {
            sa.allocate(maxArrayLength);
            try {
                sa.setShape(new int[]{2, 2, 2});
            }
            catch (AssertionError e) {
                JTestMultiArray.fail((String)("Failed to set shape: " + ((Throwable)((Object)e)).getMessage()));
            }
            long backingArrayLength = sa.getBackingArray().getBackingArrayLength();
            JTestMultiArray.assertEquals((long)maxArrayLength, (long)backingArrayLength);
            JTestMultiArray.fail((String)"This test should have received an IllegalArgumentException!");
        }
        catch (IllegalArgumentException e) {
            JTestMultiArray.assertTrue((String)"Caught IllegalArgumentException", (boolean)true);
        }
        sa = new MultiArray(ndim, Integer.TYPE, 1, lengths);
        try {
            sa.setBackingArrayType(BackingArray.Type.JAVA_LONG_ARRAY);
            long heapMaxSize = Runtime.getRuntime().maxMemory();
            if (heapMaxSize < 11534336000L) {
                System.out.println("testCreateBigArray needs -Xmx12500m or bigger!  Current setting is " + heapMaxSize + " bytes.  Skipping test . . .");
                return;
            }
            sa.allocate(maxArrayLength);
            try {
                sa.setShape(new int[]{2, 2, 2});
            }
            catch (AssertionError e) {
                JTestMultiArray.fail((String)("Failed to set shape: " + ((Throwable)((Object)e)).getMessage()));
            }
            long backingArrayLength = sa.getBackingArray().getBackingArrayLength();
            JTestMultiArray.assertEquals((long)maxArrayLength, (long)backingArrayLength);
        }
        catch (IllegalArgumentException e) {
            JTestMultiArray.fail((String)"Caught IllegalArgumentException");
        }
    }

    public static MultiArray initArray(BackingArray.Type type, int[] lengths) {
        int ndim = 3;
        MultiArray sa = MultiArray.factory(ndim, Integer.TYPE, 1, lengths, type);
        int[] position = new int[]{0, 0, 0};
        for (int k = 0; k < lengths[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < lengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < lengths[0]; ++i) {
                    position[0] = i;
                    sa.putSample(JTestMultiArray.testFn(i, j, k), position);
                }
            }
        }
        return sa;
    }

    public static MultiArray initArray4(int[] lengths) {
        int ndim = 4;
        MultiArray sa = MultiArray.factory(ndim, Integer.TYPE, 1, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = 0; m < lengths[3]; ++m) {
            position[3] = m;
            for (int k = 0; k < lengths[2]; ++k) {
                position[2] = k;
                for (int j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    for (int i = 0; i < lengths[0]; ++i) {
                        position[0] = i;
                        sa.putSample(JTestMultiArray.testFn(i, j, k, m), position);
                    }
                }
            }
        }
        return sa;
    }

    public static MultiArray initArrayFloat(int[] lengths, int[] lengthsMax) {
        int ndim = 4;
        MultiArray sa = MultiArray.factory(ndim, Float.TYPE, 1, lengthsMax, BackingArray.Type.BYTE_BUFFER);
        sa.setShape(lengths);
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = 0; m < lengths[3]; ++m) {
            position[3] = m;
            for (int k = 0; k < lengths[2]; ++k) {
                position[2] = k;
                for (int j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    for (int i = 0; i < lengths[0]; ++i) {
                        position[0] = i;
                        sa.putSample(JTestMultiArray.testFloat(i, j, k, m), position);
                    }
                }
            }
        }
        return sa;
    }

    public static int testFn(int i, int j) {
        return i + 100 * j;
    }

    public static int testFn(int i, int j, int k) {
        return i + 100 * j + 10000 * k;
    }

    public static int testFn(int i, int j, int k, int m) {
        return i + 100 * j + 10000 * k + 1000000 * m;
    }

    public static float testFloat(int i, int j, int k, int m) {
        return 1.0f * (float)i + 100.0f * (float)j + 1000.0f * (float)k + 100000.0f * (float)m;
    }

    public void checkContents(String title, MultiArray sa, int[] lengths) {
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = lengths[3] - 1; m >= 0; --m) {
            position[3] = m;
            for (int k = lengths[2] - 1; k >= 0; --k) {
                position[2] = k;
                for (int j = lengths[1] - 1; j >= 0; --j) {
                    position[1] = j;
                    for (int i = lengths[0] - 1; i >= 0; --i) {
                        position[0] = i;
                        float f2 = sa.getFloat(position);
                        float f1 = JTestMultiArray.testFloat(i, j, k, m);
                        JTestMultiArray.assertEquals((String)title, (float)f1, (float)f2, (float)1.0E-6f);
                    }
                }
            }
        }
    }
}

