/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import edu.mines.jtk.util.ParameterSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.util.SeisException;

public class TraceProperties
implements Serializable {
    private static final long serialVersionUID = 7234531710826856260L;
    private static final Logger log = Logger.getLogger("org.javaseis.properties");
    static final String ENTRY = "entry_";
    static final String LABEL = "label";
    static final String DESCRIPTION = "description";
    static final String FORMAT = "format";
    static final String COUNT = "elementCount";
    static final String OFFSET = "byteOffset";
    protected Map<String, PropertyDescription> _map = new LinkedHashMap<String, PropertyDescription>();
    protected ByteBuffer _buffer;
    protected int _traceIndex = 0;
    protected int _recordLength = 0;
    protected String _version = "2006.01";

    public TraceProperties() {
    }

    public TraceProperties(ByteBuffer buffer) {
        this();
        this.setBuffer(buffer);
    }

    public TraceProperties(int numProps, PropertyDescription[] traceProps) {
        this();
        if (numProps < 0) {
            numProps = 0;
            System.out.println("Number of trace properties < zero...setting to zero.");
        }
        if (numProps > 0 && traceProps == null) {
            throw new IllegalArgumentException("No property definitions specified.");
        }
        if (numProps > 0 && numProps != traceProps.length) {
            throw new IllegalArgumentException("Number of trace properties does not match array length.");
        }
        for (int i = 0; i < numProps; ++i) {
            this.addTraceProperty(traceProps[i]);
        }
    }

    public TraceProperties(ParameterSet tracePropertiesParset) throws SeisException {
        this();
        this.load(tracePropertiesParset);
    }

    public void toParameterSet(ParameterSet tracePropertiesParset) {
        PropertyDescription[] propertyDescriptions = this.getTraceProperties();
        PropertyDescription.sort(propertyDescriptions);
        for (int i = 0; i < propertyDescriptions.length; ++i) {
            ParameterSet parameterSet = tracePropertiesParset.addParameterSet(ENTRY + i);
            parameterSet.setString(LABEL, propertyDescriptions[i].getLabel());
            parameterSet.setString(DESCRIPTION, propertyDescriptions[i].getDescription());
            parameterSet.setString(FORMAT, propertyDescriptions[i].getFormatString());
            parameterSet.setInt(COUNT, propertyDescriptions[i].getCount());
            parameterSet.setInt(OFFSET, propertyDescriptions[i].getOffset());
        }
    }

    private void load(ParameterSet tracePropertiesParset) throws SeisException {
        if (tracePropertiesParset == null) {
            throw new IllegalArgumentException("tracePropertiesParset is null");
        }
        this._map.clear();
        this._recordLength = 0;
        int nEntries = tracePropertiesParset.countParameterSets();
        for (int i = 0; i < nEntries; ++i) {
            ParameterSet p = tracePropertiesParset.getParameterSet(ENTRY + i);
            if (p == null) {
                throw new SeisException("TraceProperties entry " + i + " is missing in parameter set:\n" + tracePropertiesParset.toString());
            }
            String label = p.getString(LABEL, null);
            String description = p.getString(DESCRIPTION, null);
            String formatString = p.getString(FORMAT, null);
            int count = p.getInt(COUNT, -1);
            int offset = p.getInt(OFFSET, -1);
            if (label == null || description == null || formatString == null || count == -1 || offset == -1) {
                throw new SeisException("TraceProperties entry " + i + " is malformed in parameter set:\n" + tracePropertiesParset.toString() + "\n(" + label + " " + description + " " + formatString + " " + count + " " + offset + ")");
            }
            if (this._recordLength != offset) {
                throw new SeisException("Current trace properties record length of " + this._recordLength + " does not match offset " + offset + " of header '" + label + "' (header order scrambled?)");
            }
            PropertyDescription property = new PropertyDescription(label, description, PropertyDescription.getFormat(formatString), count);
            this.addTraceProperty(property);
        }
    }

    public void loadProMAX_C(InputStream istream, int propertyCount) throws IOException {
        InputStreamReader istreamReader = new InputStreamReader(istream);
        BufferedReader bufferReader = new BufferedReader(istreamReader);
        String line = " ";
        String[] formatString = new String[]{"UNKNOWN", "INTEGER", "FLOAT", "DOUBLE", "CHAR"};
        boolean[] propertyFound = new boolean[propertyCount];
        for (int i = 0; i < propertyCount; ++i) {
            propertyFound[i] = false;
        }
        PropertyDescription property = new PropertyDescription();
        this._map.clear();
        this._recordLength = 0;
        while (line != null && line.length() > 0) {
            try {
                String line2;
                String[] substrings;
                int numSubstrings;
                line = bufferReader.readLine();
                if (line == null || line.length() <= 0 || (numSubstrings = (substrings = (line2 = line.replace(",", "_")).split("\t")).length) == 1 || numSubstrings != 6) continue;
                int count = 0;
                int format = 0;
                int byte_loc = 0;
                int index = 0;
                try {
                    count = Integer.parseInt(substrings[2]);
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Error parsing header count trace property");
                }
                try {
                    format = Integer.parseInt(substrings[3]);
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Error parsing header format trace property");
                }
                try {
                    byte_loc = Integer.parseInt(substrings[4]);
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Error parsing header byte location trace property");
                }
                try {
                    index = Integer.parseInt(substrings[5]);
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Error parsing header index trace property");
                }
                propertyFound[index] = true;
                String key = new String(substrings[0]);
                StringBuffer value = new StringBuffer("\"");
                int slen = substrings[1].length();
                value.append(substrings[1].substring(1, slen - 1));
                value.append(";" + formatString[format]);
                value.append(";" + count);
                value.append(";" + byte_loc);
                value.append("\"");
                property.set(key, value.toString());
                this.addTraceProperty(property);
            }
            catch (IOException ex) {
                throw new IOException("Error reading trace property entry " + ex.getMessage());
            }
        }
        for (int i = 0; i < propertyCount; ++i) {
            if (propertyFound[i]) continue;
            throw new IOException("Header property " + (i + i) + " of " + propertyCount + " not found!");
        }
    }

    public void setBuffer(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this._buffer;
    }

    public int getRecordLength() {
        return this._recordLength;
    }

    public int getNumProperties() {
        return this._map.size();
    }

    public void setTraceIndex(int traceIndex) {
        this._traceIndex = traceIndex;
    }

    public void addTraceProperty(PropertyDescription property) {
        PropertyDescription newProperty = property.clone();
        int offset = newProperty.getOffset();
        int length = newProperty.getRecordLength();
        if (offset == -1) {
            newProperty.setOffset(this._recordLength);
            this._recordLength += length;
        } else if (offset + length > this._recordLength) {
            this._recordLength = offset + length;
        }
        this._map.put(newProperty.getLabel(), newProperty);
    }

    public boolean exists(String key) {
        return this._map.containsKey(key);
    }

    public PropertyDescription getTraceProperty(String key) {
        return this._map.get(key);
    }

    public PropertyDescription[] getTraceProperties() {
        PropertyDescription[] headerProps = null;
        int count = this.getNumProperties();
        int counter = 0;
        if (count > 0) {
            headerProps = new PropertyDescription[count];
            for (String key : this._map.keySet()) {
                log.fine("3) TraceProperties key= " + key);
                headerProps[counter] = this._map.get(key);
                ++counter;
            }
        }
        return headerProps;
    }

    public short putShort(String key, short value) {
        this.setBufferPosition(key);
        this._buffer.putShort(value);
        return value;
    }

    public int putInt(String key, int value) {
        this.setBufferPosition(key);
        this._buffer.putInt(value);
        return value;
    }

    public long putLong(String key, long value) {
        this.setBufferPosition(key);
        this._buffer.putLong(value);
        return value;
    }

    public float putFloat(String key, float value) {
        this.setBufferPosition(key);
        this._buffer.putFloat(value);
        return value;
    }

    public double putDouble(String key, double value) {
        this.setBufferPosition(key);
        this._buffer.putDouble(value);
        return value;
    }

    public short[] putShortArray(String key, short[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            this._buffer.putShort(values[i]);
        }
        return values;
    }

    public int[] putIntArray(String key, int[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            this._buffer.putInt(values[i]);
        }
        return values;
    }

    public long[] putLongArray(String key, long[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            this._buffer.putLong(values[i]);
        }
        return values;
    }

    public float[] putFloatArray(String key, float[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            this._buffer.putFloat(values[i]);
        }
        return values;
    }

    public double[] putDoubleArray(String key, double[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            this._buffer.putDouble(values[i]);
        }
        return values;
    }

    public short getShort(String key) {
        this.setBufferPosition(key);
        short value = this._buffer.getShort();
        return value;
    }

    public int getInt(String key) {
        this.setBufferPosition(key);
        int value = this._buffer.getInt();
        return value;
    }

    public long getLong(String key) {
        this.setBufferPosition(key);
        long value = this._buffer.getLong();
        return value;
    }

    public float getFloat(String key) {
        this.setBufferPosition(key);
        float value = this._buffer.getFloat();
        return value;
    }

    public double getDouble(String key) {
        this.setBufferPosition(key);
        double value = this._buffer.getDouble();
        return value;
    }

    public void getShortArray(String key, short[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            values[i] = this._buffer.getShort();
        }
    }

    public void getIntArray(String key, int[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            values[i] = this._buffer.getInt();
        }
    }

    public void getLongArray(String key, long[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            values[i] = this._buffer.getLong();
        }
    }

    public void getFloatArray(String key, float[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            values[i] = this._buffer.getFloat();
        }
    }

    public void getDoubleArray(String key, double[] values) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int count = property.getCount();
        for (int i = 0; i < count; ++i) {
            values[i] = this._buffer.getDouble();
        }
    }

    public <T> T getValue(String key) {
        T value = null;
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        int format = property.getFormat();
        switch (format) {
            case 1: {
                Byte B = new Byte(this._buffer.get());
                return (T)B;
            }
            case 2: {
                Short S = new Short(this._buffer.getShort());
                return (T)S;
            }
            case 3: {
                Integer I = new Integer(this._buffer.getInt());
                return (T)I;
            }
            case 4: {
                Long L = new Long(this._buffer.getLong());
                return (T)L;
            }
            case 5: {
                Float F = new Float(this._buffer.getFloat());
                return (T)F;
            }
            case 6: {
                Double D = new Double(this._buffer.getDouble());
                return (T)D;
            }
            case 9: {
                int recordNumChars = property.getCount();
                char[] cstr = new char[recordNumChars];
                for (int i = 0; i < recordNumChars; ++i) {
                    cstr[i] = this._buffer.getChar();
                }
                String Str = new String(cstr);
                return (T)Str;
            }
            case 10: {
                int recordNumChars = property.getCount();
                char[] cstr = new char[recordNumChars];
                for (int i = 0; i < recordNumChars; ++i) {
                    cstr[i] = (char)this._buffer.get();
                }
                String Str = new String(cstr);
                return (T)Str;
            }
        }
        return value;
    }

    public <T> T putValue(String key, T value) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
        if (Byte.class.isInstance(value)) {
            byte b = (Byte)value;
            this._buffer.put(b);
        } else if (Short.class.isInstance(value)) {
            short s = (Short)value;
            this._buffer.putShort(s);
        } else if (Integer.class.isInstance(value)) {
            int i = (Integer)value;
            this._buffer.putInt(i);
        } else if (Long.class.isInstance(value)) {
            long l = (Long)value;
            this._buffer.putLong(l);
        } else if (Float.class.isInstance(value)) {
            float f = ((Float)value).floatValue();
            this._buffer.putFloat(f);
        } else if (Double.class.isInstance(value)) {
            double d = (Double)value;
            this._buffer.putDouble(d);
        } else if (String.class.isInstance(value)) {
            char[] cstr = ((String)value).toCharArray();
            if (cstr != null) {
                int i;
                int recordNumChars = property.getCount();
                int stringNumChars = Math.min(cstr.length, recordNumChars);
                for (i = 0; i < stringNumChars; ++i) {
                    if (property.getFormat() == 9) {
                        this._buffer.putChar(cstr[i]);
                        continue;
                    }
                    this._buffer.put((byte)cstr[i]);
                }
                for (i = stringNumChars; i < recordNumChars; ++i) {
                    if (property.getFormat() == 9) {
                        this._buffer.putChar('\u0000');
                        continue;
                    }
                    this._buffer.put((byte)0);
                }
                cstr = null;
            }
        } else {
            return null;
        }
        return value;
    }

    protected void setBufferPosition(String key) {
        PropertyDescription property = this.getTraceProperty(key);
        this.setBufferPosition(property);
    }

    protected void setBufferPosition(PropertyDescription property) {
        int position = this._recordLength * this._traceIndex + property.getOffset();
        this._buffer.limit(this._buffer.capacity());
        this._buffer.position(position);
    }

    public static void main(String[] args) throws SeisException, IOException {
        String[] traceHeaderName = new String[]{"Inline", "X-line", "SourceX", "SourceY", "SourceZ", "ReceiverX", "ReceiverY", "ReceiverZ"};
        String[] traceHeaderDesc = new String[]{"Inline number;INTEGER;1;0", "Crossline number;INTEGER;1;4", "Source X coordinate;DOUBLE;1;8", "Source Y coordinate;DOUBLE;1;16", "Source Z coordinate;DOUBLE;1;24", "Receiver X coordinate;DOUBLE;1;32", "Receiver Y coordinate;DOUBLE;1;40", "Receiver Z coordinate;DOUBLE;1;48"};
        int traceHeaderCount = traceHeaderName.length;
        int numTraces = 10;
        int headerLength = 56;
        ByteBuffer buffer = ByteBuffer.allocateDirect(numTraces * headerLength);
        TraceProperties traceProperites = new TraceProperties();
        PropertyDescription property = new PropertyDescription();
        for (int i = 0; i < traceHeaderCount; ++i) {
            property.set(traceHeaderName[i], traceHeaderDesc[i]);
            traceProperites.addTraceProperty(property);
        }
        traceProperites.setBuffer(buffer);
        int iline = 100;
        int xline = 200;
        double x = 0.0;
        double y = 0.0;
        double h = 0.0;
        for (int i = 0; i < numTraces; ++i) {
            h = 50.0 * (double)i;
            traceProperites.setTraceIndex(i);
            traceProperites.putInt("Inline", iline);
            traceProperites.putInt("X-line", xline);
            traceProperites.putDouble("SourceX", x + h);
            traceProperites.putDouble("SourceY", 0.0);
            traceProperites.putDouble("SourceZ", 0.0);
            traceProperites.putDouble("ReceiverX", x - h);
            traceProperites.putDouble("ReceiverY", 0.0);
            traceProperites.putDouble("ReceiverZ", 0.0);
        }
        System.out.println("TraceProperites: Trace headers generated.");
        ParameterSet tracePropertiesParset = new ParameterSet();
        traceProperites.toParameterSet(tracePropertiesParset);
        System.out.println("TraceProperites: Trace headers stored.");
        traceProperites = null;
        System.gc();
        traceProperites = new TraceProperties(buffer);
        traceProperites.load(tracePropertiesParset);
        System.out.println("TraceProperites: Trace properties loaded.");
        traceProperites.setTraceIndex(0);
        for (int i = 0; i < numTraces; ++i) {
            traceProperites.setTraceIndex(i);
            System.out.println("   TraceIndex=" + i + " Inline=" + traceProperites.getInt("Inline") + " X-line=" + traceProperites.getInt("X-line") + " SourceX=" + traceProperites.getDouble("SourceX") + " ReceiverX=" + traceProperites.getDouble("ReceiverX"));
        }
        System.out.println("TraceProperites: Trace headers printed.");
        File file = new File("temp");
        file.delete();
        System.out.println("TraceProperites: Temporary file deleted.");
    }
}

