/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import org.javaseis.array.IMultiArray;
import org.javaseis.array.MultiArray;
import org.javaseis.array.TransposeType;
import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;

public class SeisFft2d {
    private IFFT _f0;
    private IFFT _f1;
    private IMultiArray _a;
    private int[] _inputShape;
    private int[] _fftShape;
    private int[] _fftLengths;
    private int[] _fftSigns;
    private boolean _isTransformed = false;

    public SeisFft2d(int[] len, float[] pad, int[] isign) {
        assert (len.length > 1);
        assert (pad.length > 1);
        assert (isign.length > 1);
        this._fftSigns = new int[]{isign[0], isign[1]};
        this._f0 = isign[0] != 0 ? new SeisFft(len[0], pad[0], IFFT.Type.REAL, isign[0]) : new SeisFft(len[0], pad[0], IFFT.Type.REAL, -1);
        this._f1 = isign[1] != 0 ? new SeisFft(len[1], pad[1], IFFT.Type.COMPLEX, isign[1]) : new SeisFft(len[1], pad[1], IFFT.Type.COMPLEX, 1);
        this._inputShape = (int[])len.clone();
        this._fftLengths = new int[]{this._f0.getLength(), this._f1.getLength()};
        this._fftShape = isign[0] == 0 ? new int[]{1 + this._fftLengths[0] / 2, this._fftLengths[1]} : (int[])this._fftLengths.clone();
    }

    public SeisFft2d(int[] len, float[] pad) {
        this(len, pad, new int[]{-1, 1});
    }

    public SeisFft2d(int len0, int len1, float pad0, float pad1, int sign0, int sign1) {
        this(new int[]{len0, len1}, new float[]{pad0, pad1}, new int[]{sign0, sign1});
    }

    public SeisFft2d(int len0, int len1, float pad0, float pad1) {
        this(new int[]{len0, len1}, new float[]{pad0, pad1}, new int[]{-1, 1});
    }

    public int[] getFftLengths() {
        return (int[])this._fftLengths.clone();
    }

    public int[] getFftSigns() {
        return (int[])this._fftSigns.clone();
    }

    public IMultiArray allocateArray() {
        return MultiArray.factory(2, Float.TYPE, 2, this._fftShape);
    }

    public void realToComplex(IMultiArray f) {
        int[] position = new int[]{0, 0};
        int nt = this._inputShape[0];
        int nx = this._inputShape[1];
        if (f.getLength(0) != nt || f.getLength(1) != nx) {
            throw new RuntimeException("MultiArray Shape does not match input data size");
        }
        int nft = 1 + this._fftLengths[0] / 2;
        int nkx = this._fftLengths[1];
        if (f.getBufferLength() < (long)(2 * nft * nkx)) {
            throw new RuntimeException("MultiArray is too short for the output transform");
        }
        float[] c = new float[Math.max(2 * nft, 2 * nkx)];
        f.reshape(new int[]{2 * nft, nx});
        IMultiArray r = f.view();
        f.setElementCount(2);
        f.setShape(new int[]{nft, nx});
        int j = 0;
        while (j < nx) {
            position[1] = j++;
            r.getTrace(c, position);
            this._f0.realToComplex(c);
            f.putTrace(c, position);
        }
        f.transpose(TransposeType.T21);
        f.reshape(new int[]{nkx, nft});
        j = 0;
        while (j < nft) {
            position[1] = j++;
            f.getTrace(c, position);
            this._f1.complexForward(c);
            f.putTrace(c, position);
        }
        this._isTransformed = true;
    }

    public void complexToReal(IMultiArray f) {
        int[] position = new int[]{0, 0};
        int nt = this._inputShape[0];
        int nx = this._inputShape[1];
        int nft = 1 + this._fftLengths[0] / 2;
        int nkx = this._fftLengths[1];
        float[] c = new float[Math.max(2 * nft, 2 * nkx)];
        int j = 0;
        while (j < nft) {
            position[1] = j++;
            f.getTrace(c, position);
            this._f1.complexInverse(c);
            f.putTrace(c, position);
        }
        f.reshape(new int[]{nx, nft});
        f.transpose(TransposeType.T21);
        j = 0;
        while (j < nx) {
            position[1] = j++;
            f.getTrace(c, position);
            this._f0.complexToReal(c);
            f.putTrace(c, position);
        }
        f.reshape(1, new int[]{nt, nx});
        this._isTransformed = false;
    }

    public void complexTransform(IMultiArray f) {
    }

    public static void main(String[] args) {
        System.out.println("Please see SeisFft2dTest.java for test code.");
    }
}

