/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import junit.framework.TestCase;
import org.javaseis.array.IMultiArray;
import org.javaseis.fft.SeisFft2d;

public class JTestSeisFft2d
extends TestCase {
    public static final int TEST_DC = 101;
    public static final int TEST_RAMP = 102;
    public static final int TEST_LEFT_AND_RIGHT_DIP = 103;
    public static final int NFMAX = 500;
    public static final int NXMAX = 150;
    public static final int NTESTS = 100;
    public static final double TOLERANCE = 3.0E-4;
    public static boolean CHATTY = true;
    public static boolean VERBOSE = false;

    public void testAll() {
        this.compareInputToRoundTripOutput(101, 4, 4);
        for (int i = 0; i < 100; ++i) {
            int nf = (int)(498.0 * Math.random() + 2.0);
            int nx = (int)(148.0 * Math.random() + 2.0);
            if (CHATTY) {
                System.out.printf("JTestSeisFft2d:  nf=%4d,  nx=%4d\n", nf, nx);
            }
            this.compareInputToRoundTripOutput(101, nf, nx);
            this.compareInputToRoundTripOutput(102, nf, nx);
            this.compareInputToRoundTripOutput(103, nf, nx);
        }
        System.out.println("*** org.javaseis.tests.JTestSeisFft2d SUCCESS ***");
    }

    public void compareInputToRoundTripOutput(int testType, int nf, int nx) {
        int i;
        int[] len = new int[]{nf, nx};
        float[] pad = new float[]{0.0f, 0.0f};
        SeisFft2d f2d = new SeisFft2d(len, pad);
        IMultiArray sa = f2d.allocateArray();
        int[] arrayLengths = sa.getShape();
        int[] fftLengths = f2d.getFftLengths();
        if (CHATTY) {
            System.out.println();
            System.out.printf("inputLengths = %3d %3d\n", len[0], len[1]);
            System.out.printf("arrayLengths = %3d %3d\n", arrayLengths[0], arrayLengths[1]);
            System.out.printf("  fftLengths = %3d %3d\n", fftLengths[0], fftLengths[1]);
        }
        sa.setElementCount(1);
        sa.setShape(len);
        int[] position = new int[]{0, 0};
        float[] a = new float[nf];
        for (int j = 0; j < nx; ++j) {
            int k = 0;
            position[1] = j;
            for (int ia = 0; ia < nf; ++ia) {
                switch (testType) {
                    case 101: {
                        a[ia] = 1.0f;
                        break;
                    }
                    case 102: {
                        a[ia] = k;
                        break;
                    }
                    case 103: {
                        a[ia] = (float)Math.cos(Math.PI * 2 * (double)(ia + j) / 100.0);
                        int n = ia;
                        a[n] = a[n] + (float)Math.cos(Math.PI * 2 * (double)(ia - j) / 100.0);
                    }
                }
                if (VERBOSE) {
                    if (k < 10) {
                        System.out.printf("%5d %10.5f\n", k, Float.valueOf(a[ia]));
                    } else if (k == 10) {
                        System.out.println();
                    }
                }
                ++k;
            }
            sa.putTrace(a, position);
        }
        float[] copyOfInput = new float[a.length];
        for (int i2 = 0; i2 < a.length; ++i2) {
            copyOfInput[i2] = a[i2];
        }
        f2d.realToComplex(sa);
        int nLive = nf * nx;
        position[1] = 0;
        position[0] = 0;
        if (testType == 101) {
            JTestSeisFft2d.assertEquals((String)"SeisFft2d.forward failure", (double)nLive, (double)sa.getFloat(position), (double)1.0E-5);
        }
        f2d.complexToReal(sa);
        if (VERBOSE) {
            for (i = 0; i < a.length; ++i) {
                System.out.printf("%5d %10.5f %10.5f\n", i, Float.valueOf(a[i]), Float.valueOf(copyOfInput[i]));
            }
        }
        for (i = 0; i < a.length; ++i) {
            JTestSeisFft2d.assertEquals((String)("SeisFft2d.inverse failure @ i = " + i), (double)copyOfInput[i], (double)a[i], (double)3.0E-4);
        }
    }
}

