/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Iterator;
import org.javaseis.array.IMultiArray;

public class MultiArrayVolumeIterator
implements Iterable,
Iterator {
    private IMultiArray _a;
    private int _ndim;
    private int _nvolumes;
    private int _ivolume;
    private int _incr;
    private int[] _position;
    private int[] _shape;
    private int[] _volumeMultiplier;
    private boolean _forward = true;

    public MultiArrayVolumeIterator(IMultiArray a) {
        this.constructIterator(a, true);
    }

    public MultiArrayVolumeIterator(IMultiArray a, boolean forward) {
        this.constructIterator(a, forward);
    }

    private void constructIterator(IMultiArray a, boolean forward) {
        this._ndim = a.getDimensions();
        if (this._ndim < 3) {
            throw new IllegalArgumentException("MultiArrayVolumeIterator: Number of dimensions must be 3 or larger");
        }
        this._a = a;
        this._shape = this._a.getShape();
        this._position = new int[this._ndim];
        this._volumeMultiplier = new int[this._ndim];
        this._nvolumes = 1;
        for (int i = 2; i < this._ndim; ++i) {
            this._nvolumes *= this._shape[i];
            this._volumeMultiplier[i] = this._nvolumes;
        }
        this._forward = forward;
        if (this._forward) {
            this._ivolume = 0;
            this._incr = 1;
        } else {
            this._ivolume = this._nvolumes - 1;
            this._incr = -1;
        }
    }

    public Iterator iterator() {
        return new MultiArrayVolumeIterator(this._a);
    }

    @Override
    public boolean hasNext() {
        if (this._forward) {
            return this._ivolume < this._nvolumes;
        }
        return this._ivolume >= 0;
    }

    public IMultiArray next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Call to MultiArrayVolumeIterator.next() when hasNext() is false");
        }
        this.volumeToPosition();
        this._ivolume += this._incr;
        return this._a.view(3, this._position);
    }

    private void volumeToPosition() {
        this._position[2] = 0;
        this._position[1] = 0;
        this._position[0] = 0;
        int ivolume = this._ivolume;
        for (int i = this._ndim - 1; i >= 3; --i) {
            this._position[i] = ivolume % this._volumeMultiplier[i];
            ivolume -= this._volumeMultiplier[i] * this._position[i];
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("MultiArrayFrameIterator.remove() is not supported");
    }
}

