/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.WriteOperation;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

public class CommandWriteOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final String databaseName;
    private final BsonDocument command;
    private final Decoder<T> decoder;

    public CommandWriteOperation(String databaseName, BsonDocument command, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.command = Assertions.notNull("command", command);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(WriteBinding binding) {
        return CommandOperationHelper.executeWrappedCommandProtocol(this.databaseName, this.command, this.decoder, binding);
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(this.databaseName, this.command, this.decoder, binding, callback);
    }
}

