/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public final class SystemConfig
extends Hashtable {
    private static final long serialVersionUID = 382458920184588269L;
    public static final int RAW = 10;
    public static final int ASN1 = 11;
    public static final int UNCOMPRESSED = 4;
    public static final int COMPRESSED = 2;
    public static final int HYBRID = 6;
    public static final int SB = 16;
    public static final int ANSI = 32;
    public static final int EXPAND = 1;
    public static final int HASH = 17;
    public static final int NOHASH = 18;
    public static final String ECDSA = "ECDSA";
    public static final String ECDH = "ECDH";
    public static final String ECMQV = "ECMQV";
    private static SystemConfig a = new SystemConfig();
    private static ThreadLocal b = new ThreadLocal();

    private SystemConfig() {
        this.put("format.global", new Integer(11));
        this.put("conformance.global", new Integer(16));
        this.put("compression.global", this.a());
        this.put("hash.global", new Integer(17));
        this.put("curve.global", "sect163k1");
        this.put("securityStrength.global", new Integer(80));
        this.put("predictionResistance.global", new Boolean(false));
    }

    private Integer a() {
        String string = System.getProperty("certicom.compression");
        int n2 = 2;
        if (string != null) {
            if ("uncompressed".equals(string = string.toLowerCase())) {
                n2 = 4;
            } else if ("hybrid".equals(string)) {
                n2 = 6;
            }
        }
        return new Integer(n2);
    }

    public static SystemConfig getConfig() {
        SystemConfig systemConfig = (SystemConfig)b.get();
        if (systemConfig == null) {
            systemConfig = a;
        }
        return systemConfig;
    }

    public static SystemConfig getConfig(InputStream inputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        if (!(object instanceof SystemConfig)) {
            throw new IOException("not a system config file.");
        }
        a = (SystemConfig)object;
        return a;
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
    }

    public int getFormat() {
        Object v = this.get("format.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global format.");
    }

    public int getPtCompression() {
        Object v = this.get("compression.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global compression.");
    }

    public int getConformance() {
        Object v = this.get("conformance.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global conformance.");
    }

    public int getHashType() {
        Object v = this.get("hash.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global hash-type.");
    }

    public String getCurve() {
        Object v = this.get("curve.global");
        if (v != null) {
            return new String((String)v);
        }
        throw new IllegalStateException("no global curve.");
    }

    public int getFormat(String string) {
        Object v = this.get("format" + string);
        if (v != null) {
            return (Integer)v;
        }
        return this.getFormat();
    }

    public int getPtCompression(String string) {
        Object v = this.get("compression" + string);
        if (v != null) {
            return (Integer)v;
        }
        return this.getPtCompression();
    }

    public int getConformance(String string) {
        Object v = this.get("conformance" + string);
        if (v != null) {
            return (Integer)v;
        }
        return this.getConformance();
    }

    public String getCurve(String string) {
        Object v = this.get("curve" + string);
        if (v != null) {
            return new String((String)v);
        }
        return this.getCurve();
    }

    public int getSecurityStrength() {
        Object v = this.get("securityStrength.global");
        if ("securityStrength" != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global security strength");
    }

    public boolean getPredictionResistanceFlag() {
        Object v = this.get("predictionResistance.global");
        if (v != null) {
            return (Boolean)v;
        }
        throw new IllegalStateException("no global prediction resistance");
    }

    public void setFormat(int n2) {
        switch (n2) {
            case 10: 
            case 11: {
                this.put("format" + ".global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("format unknown.");
            }
        }
    }

    public void setPtCompression(int n2) {
        switch (n2) {
            case 2: 
            case 4: 
            case 6: {
                this.put("compression.global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("compression unknown.");
            }
        }
    }

    public void setConformance(int n2) {
        switch (n2) {
            case 16: 
            case 32: {
                this.put("conformance.global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("conformance unknown.");
            }
        }
    }

    public void setHashType(int n2) {
        switch (n2) {
            case 17: 
            case 18: {
                this.put("hash.global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("conformance unknown.");
            }
        }
    }

    public void setCurve(String string) {
        if (string == null) {
            throw new IllegalArgumentException("curve is null.");
        }
        this.put("curve.global", new String(string));
    }

    public void setSecurityStrength(int n2) {
        this.put("securityStrength.global", new Integer(n2));
    }

    public void setPredictionResistanceFlag(boolean bl) {
        this.put("predictionResistance.global", new Boolean(bl));
    }

    public static SystemConfig getNewDefaultInstance() {
        return new SystemConfig();
    }

    public static void setCurrentThreadSystemConfig(SystemConfig systemConfig) {
        b.set(systemConfig);
    }

    public static SystemConfig getCurrentThreadSystemConfig() {
        return (SystemConfig)b.get();
    }

    public static void clearCurrentThreadSystemConfig() {
        b.set(null);
    }
}

