/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.DH;
import com.certicom.ecc.scheme.DSA;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import com.certicom.ecc.util.RandomValue;
import com.certicom.ecc.util.a;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Random;

public class IDLCKeyGen
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = 5310141577962920771L;
    protected BigInteger a;
    protected BigInteger b;
    protected BigInteger c;
    private int d = 0;
    private int e = 0;

    public IDLCKeyGen() {
        super("IDLCKeyGen");
    }

    public void reset() {
        super.reset();
        this.a = null;
        this.b = null;
        this.c = null;
        this.d = 0;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n2, objectArray, random);
        if (n2 != 5 || random == null || objectArray == null || objectArray.length != 3) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        byte[] byArray = (byte[])objectArray[0];
        byte[] byArray2 = (byte[])objectArray[1];
        byte[] byArray3 = (byte[])objectArray[2];
        this.a(byArray, byArray2, byArray3);
    }

    public int outputSize(int n2, boolean bl) {
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        if (this.g == null || this.c == null) {
            throw new IllegalStateException("no random object or parameters");
        }
        BigInteger bigInteger = RandomValue.inRange(this.g, this.b == null ? this.a : this.b, true);
        try {
            byArray5 = Conversion.I2OSP(bigInteger, -1);
        }
        catch (ConversionException conversionException) {
            byArray5 = bigInteger.toByteArray();
        }
        if (byArray5.length > this.d) {
            byArray4 = new byte[this.d];
            System.arraycopy(byArray5, byArray5.length - this.d, byArray4, 0, this.d);
        } else {
            byArray4 = byArray5;
        }
        BigInteger bigInteger2 = this.c.modPow(bigInteger, this.a);
        try {
            byArray3 = Conversion.I2OSP(bigInteger2, -1);
        }
        catch (ConversionException conversionException) {
            byArray3 = bigInteger2.toByteArray();
        }
        if (byArray3.length > this.e) {
            byArray2 = new byte[this.e];
            System.arraycopy(byArray3, byArray3.length - this.e, byArray2, 0, this.e);
        } else {
            byArray2 = byArray3;
        }
        return new Object[]{byArray4, byArray2};
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            this.a = new BigInteger(1, byArray);
            if (byArray2 == null) {
                this.b = null;
                this.d = byArray.length;
            } else {
                this.b = new BigInteger(1, byArray2);
                this.d = byArray2.length;
            }
            this.c = new BigInteger(1, byArray3);
            this.e = byArray.length;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("invalid parameters.");
        }
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
        if (this.c == null) {
            return false;
        }
        if (this.a == null) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(1, (byte[])((Object[])object)[1]);
        BigInteger bigInteger2 = new BigInteger(1, (byte[])((Object[])object)[0]);
        BigInteger bigInteger3 = this.c.modPow(bigInteger2, this.a);
        return bigInteger.equals(bigInteger3);
        {
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeInt(this.d);
        objectOutputStream.writeInt(this.e);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (BigInteger)objectInputStream.readObject();
        this.b = (BigInteger)objectInputStream.readObject();
        this.c = (BigInteger)objectInputStream.readObject();
        this.d = objectInputStream.readInt();
        this.e = objectInputStream.readInt();
    }

    public static class DHKeyGen
    extends IDLCKeyGen {
        private static Hashtable d = new Hashtable();

        private Object[] a() {
            Object[] objectArray = (Object[])d.get(this.a);
            if (objectArray == null) {
                objectArray = (Object[])this.transformToObject(null, 0, 0, true);
                d.put(this.a, objectArray);
            }
            return objectArray;
        }

        protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
            if (super.a(byArray, n2, n3, bl, object)) {
                byte[] byArray2 = (byte[])((Object[])object)[0];
                byte[] byArray3 = (byte[])((Object[])object)[1];
                Object[] objectArray = this.a();
                byte[][] byArrayArray = new byte[2][];
                DH dH = new DH();
                for (int i2 = 0; i2 < 2; ++i2) {
                    dH.init(6, new Object[]{this.a.toByteArray(), i2 == 0 ? byArray3 : (byte[])objectArray[1], i2 == 0 ? (Object)objectArray[0] : byArray2}, null);
                    byArrayArray[i2] = dH.transform(null, 0, 0, true);
                    if (byArrayArray[i2] != null && byArrayArray[i2].length != 0) continue;
                    return false;
                }
                return Arrays.equals(byArrayArray[0], byArrayArray[1]);
            }
            return false;
        }
    }

    public static class DSAKeyGen
    extends IDLCKeyGen {
        protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
            if (super.a(byArray, n2, n3, bl, object)) {
                if (this.a == null || this.b == null || this.c == null) {
                    return false;
                }
                byte[] byArray2 = (byte[])((Object[])object)[0];
                byte[] byArray3 = (byte[])((Object[])object)[1];
                byte[] byArray4 = "Romanes eunt domus".getBytes();
                DSA dSA = new DSA();
                try {
                    dSA.init(1, new Object[]{this.a.toByteArray(), this.b.toByteArray(), this.c.toByteArray(), byArray2}, this.g);
                    byte[] byArray5 = dSA.transform(byArray4, 0, byArray4.length, true);
                    if (this.g()) {
                        com.certicom.ecc.util.a.a("IDLC Keygen: modifying signature 5th byte", byArray5);
                        byArray5[4] = (byte)(byArray5[4] & 0xFF ^ 1);
                        com.certicom.ecc.util.a.a(byArray5);
                    }
                    dSA.init(2, new Object[]{this.a.toByteArray(), this.b.toByteArray(), this.c.toByteArray(), byArray3}, null);
                    dSA.transform(byArray4, 0, byArray4.length, true);
                    return dSA.verify(byArray5, 0, byArray5.length);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            return false;
        }
    }
}

