/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import org.javaseis.fft.IFFT;
import org.javaseis.util.ArrayUtil;

public class SeisFft
implements IFFT {
    protected IFFT.Type _type;
    protected IFFT.Scale _scale;
    protected int _lendata;
    protected int _lenfft;
    protected int _lentran;
    protected int _signForward;
    protected int _signInverse;
    protected float _scaleForward;
    protected float _scaleInverse;
    protected float[] _cy;
    protected float[] _wk;
    protected FftReal _fftReal;
    protected FftComplex _fftCplx;

    public SeisFft() {
    }

    public SeisFft(int length) {
        this.setFftParms(length, IFFT.Type.REAL, IFFT.Scale.INVERSE, 0.0f, -1);
    }

    public SeisFft(int length, float padPercent) {
        this.setFftParms(length, IFFT.Type.REAL, IFFT.Scale.INVERSE, padPercent, -1);
    }

    public SeisFft(int length, float padPercent, IFFT.Type type) {
        int isign = 1;
        if (type == IFFT.Type.REAL) {
            isign = -1;
        }
        this.setFftParms(length, type, IFFT.Scale.INVERSE, padPercent, isign);
    }

    public SeisFft(int length, float padPercent, IFFT.Type type, int isign) {
        this.setFftParms(length, type, IFFT.Scale.INVERSE, padPercent, isign);
    }

    public SeisFft(int length, float padPercent, IFFT.Type type, int isign, IFFT.Scale scale) {
        this.setFftParms(length, type, scale, padPercent, isign);
    }

    @Override
    public void setFftParms(int length, IFFT.Type type, IFFT.Scale scale, float padPercent, int forwardSign) {
        if (forwardSign < 0) {
            this._signForward = -1;
            this._signInverse = 1;
        } else if (forwardSign > 0) {
            this._signForward = 1;
            this._signInverse = -1;
        } else {
            this._signForward = 0;
            this._signInverse = 0;
        }
        this._type = type;
        this._lendata = length;
        this.setLength(this._lendata, padPercent);
        this._scale = scale;
        if (forwardSign == 0) {
            this._scale = IFFT.Scale.NONE;
        }
        if (scale == IFFT.Scale.SYMMETRIC) {
            this._scaleInverse = this._scaleForward = (float)(1.0 / Math.sqrt(this._lenfft));
        } else if (scale == IFFT.Scale.INVERSE) {
            this._scaleForward = 1.0f;
            this._scaleInverse = 1.0f / (float)this._lenfft;
        } else {
            this._scaleForward = 1.0f;
            this._scaleInverse = 1.0f;
        }
        if (this._type == IFFT.Type.REAL) {
            this._fftReal = new FftReal(this._lenfft);
            this._lentran = this._lenfft + 2;
        } else {
            this._fftCplx = new FftComplex(this._lenfft);
            this._lentran = 2 * this._lenfft;
            this._lendata = 2 * this._lendata;
        }
        this._wk = new float[this._lentran];
        this._cy = new float[this._lentran];
        assert (this._cy != null) : "Memory allocation failed";
    }

    private int setLength(int length, float padPercent) {
        int len = (int)(0.5 + (1.0 + 0.01 * (double)padPercent) * (double)length);
        this._lenfft = this._type == IFFT.Type.REAL ? FftReal.nfftSmall((int)len) : FftComplex.nfftSmall((int)len);
        return this._lenfft;
    }

    public static int length(int len, float pad, IFFT.Type type) {
        int flen = (int)(0.5 + (1.0 + 0.01 * (double)pad) * (double)len);
        int lenfft = 0;
        lenfft = type == IFFT.Type.REAL ? FftReal.nfftSmall((int)flen) : FftComplex.nfftSmall((int)flen);
        return lenfft;
    }

    @Override
    public int getLength() {
        return this._lenfft;
    }

    @Override
    public int getArrayLength() {
        return this._lentran;
    }

    private void scaleCopyForward(float[] a, int ia, float[] b, int ib, int n) {
        for (int i = 0; i < n; ++i) {
            b[ib + i] = this._scaleForward * a[ia + i];
        }
    }

    private void scaleCopyInverse(float[] a, int ia, float[] b, int ib, int n) {
        for (int i = 0; i < n; ++i) {
            b[ib + i] = this._scaleInverse * a[ia + i];
        }
    }

    @Override
    public void realToComplex(float[] rx) {
        if (this._signForward != 0) {
            ArrayUtil.arraycopy(rx, 0, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftReal.realToComplex(this._signForward, this._wk, this._wk);
            this.scaleCopyForward(this._wk, 0, rx, 0, this._lentran);
        }
    }

    @Override
    public void complexToReal(float[] cy) {
        if (this._signInverse != 0) {
            ArrayUtil.arraycopy(cy, 0, this._wk, 0, this._lentran);
            this._fftReal.complexToReal(this._signInverse, this._wk, this._cy);
            this.scaleCopyInverse(this._cy, 0, cy, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                cy[i] = 0.0f;
            }
        }
    }

    @Override
    public void complexForward(float[] cx) {
        if (this._signForward != 0) {
            ArrayUtil.arraycopy(cx, 0, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftCplx.complexToComplex(this._signForward, this._wk, this._cy);
            this.scaleCopyForward(this._cy, 0, cx, 0, this._lentran);
        }
    }

    @Override
    public void complexInverse(float[] cy) {
        if (this._signInverse != 0) {
            ArrayUtil.arraycopy(cy, 0, this._wk, 0, this._lentran);
            this._fftCplx.complexToComplex(this._signInverse, this._wk, this._cy);
            this.scaleCopyInverse(this._cy, 0, cy, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                cy[i] = 0.0f;
            }
        }
    }

    @Override
    public void realToComplex(float[] rx, int offset) {
        if (this._signForward != 0) {
            ArrayUtil.arraycopy(rx, offset, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftReal.realToComplex(this._signForward, this._wk, this._cy);
            this.scaleCopyForward(this._cy, 0, rx, offset, this._lentran);
        }
    }

    @Override
    public void complexToReal(float[] cy, int offset) {
        if (this._signInverse != 0) {
            ArrayUtil.arraycopy(cy, offset, this._wk, 0, this._lentran);
            this._fftReal.complexToReal(this._signInverse, this._wk, this._cy);
            this.scaleCopyInverse(this._cy, 0, cy, offset, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                cy[i + offset] = 0.0f;
            }
        }
    }

    @Override
    public void complexForward(float[] cx, int offset) {
        if (this._signForward != 0) {
            ArrayUtil.arraycopy(cx, offset, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftCplx.complexToComplex(this._signForward, this._wk, this._cy);
            this.scaleCopyForward(this._cy, 0, cx, offset, this._lentran);
        }
    }

    @Override
    public void complexInverse(float[] cy, int offset) {
        if (this._signInverse != 0) {
            ArrayUtil.arraycopy(cy, offset, this._wk, 0, this._lentran);
            this._fftCplx.complexToComplex(this._signInverse, this._wk, this._cy);
            this.scaleCopyInverse(this._cy, 0, cy, offset, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                cy[i + offset] = 0.0f;
            }
        }
    }

    @Override
    public void realToComplex(float[] rx, float[] cy) {
        if (this._signForward != 0) {
            this.scaleCopyForward(rx, 0, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftReal.realToComplex(this._signForward, this._wk, cy);
        } else {
            ArrayUtil.arraycopy(rx, 0, cy, 0, this._lendata);
        }
    }

    @Override
    public void complexToReal(float[] cy, float[] rx) {
        if (this._signInverse != 0) {
            this._fftReal.complexToReal(this._signInverse, cy, this._wk);
            this.scaleCopyInverse(this._wk, 0, rx, 0, this._lendata);
        } else {
            ArrayUtil.arraycopy(cy, 0, rx, 0, this._lendata);
        }
    }

    @Override
    public void complexForward(float[] cx, float[] cy) {
        if (this._signForward != 0) {
            this.scaleCopyForward(cx, 0, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftCplx.complexToComplex(this._signForward, this._wk, cy);
        } else {
            ArrayUtil.arraycopy(cx, 0, cy, 0, this._lendata);
        }
    }

    @Override
    public void complexInverse(float[] cy, float[] cx) {
        if (this._signInverse != 0) {
            this._fftCplx.complexToComplex(this._signInverse, cy, this._wk);
            this.scaleCopyInverse(this._wk, 0, cx, 0, this._lendata);
        } else {
            ArrayUtil.arraycopy(cy, 0, cx, 0, this._lendata);
        }
    }

    @Override
    public void realToComplex(float[] rx, int xoff, float[] cy, int yoff) {
        if (this._signForward != 0) {
            ArrayUtil.arraycopy(rx, xoff, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftReal.realToComplex(this._signForward, this._wk, this._cy);
            this.scaleCopyForward(this._cy, 0, cy, yoff, this._lentran);
        } else {
            ArrayUtil.arraycopy(rx, xoff, cy, yoff, this._lendata);
        }
    }

    @Override
    public void complexToReal(float[] cy, int yoff, float[] rx, int xoff) {
        if (this._signInverse != 0) {
            ArrayUtil.arraycopy(cy, yoff, this._cy, 0, this._lentran);
            this._fftReal.complexToReal(this._signInverse, this._cy, this._wk);
            this.scaleCopyInverse(this._wk, 0, rx, xoff, this._lendata);
        } else {
            ArrayUtil.arraycopy(cy, yoff, rx, xoff, this._lentran);
        }
    }

    @Override
    public void complexForward(float[] cx, int xoff, float[] cy, int yoff) {
        if (this._signForward != 0) {
            ArrayUtil.arraycopy(cx, xoff, this._wk, 0, this._lendata);
            for (int i = this._lendata; i < this._lentran; ++i) {
                this._wk[i] = 0.0f;
            }
            this._fftCplx.complexToComplex(this._signForward, this._wk, this._cy);
            this.scaleCopyForward(this._cy, 0, cy, yoff, this._lentran);
        } else {
            ArrayUtil.arraycopy(cx, xoff, cy, yoff, this._lendata);
        }
    }

    @Override
    public void complexInverse(float[] cy, int yoff, float[] cx, int xoff) {
        if (this._signInverse != 0) {
            ArrayUtil.arraycopy(cy, yoff, this._cy, 0, this._lentran);
            this._fftCplx.complexToComplex(this._signInverse, this._cy, this._wk);
            this.scaleCopyInverse(this._wk, 0, cx, xoff, this._lendata);
        } else {
            ArrayUtil.arraycopy(cy, yoff, cx, xoff, this._lentran);
        }
    }

    public static enum Scale {
        NONE,
        SYMMETRIC,
        INVERSE;

    }

    public static enum Type {
        REAL,
        COMPLEX;

    }
}

