/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Stack;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Volume.VolumeStackController;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleCdpOverlay;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Volume.Stack.VolumeStack_InterpolatedWellTopWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VolumeStack_SimpleViewerWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Java2D_VertStackedEnsembleDisplayWidget.Listener {
    protected int m_numPlotsVisible = 2;
    protected VolumeStackController m_stackController;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected VolumeStack_InterpolatedWellTopWidget m_overlayWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_SimpleComposite m_mapWidget = new Java2D_SimpleComposite(false);
    protected JLabel m_coordLabel = new JLabel(" ");
    protected Java2D_UserEventConsumer_ButtonPressed m_clickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_MouseMove m_moveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected Java2D_AxisLocker m_axisLockerTime;
    protected ArrayList<EnsembleViewerWidget> m_widgetList = new ArrayList();
    protected ArrayList<SelectorControlWidget> m_selectorList = new ArrayList();

    public VolumeStack_SimpleViewerWidget(VolumeStackController controller) {
        super(1);
        try {
            this.m_stackController = controller;
            this.m_numPlotsVisible = this.m_stackController.is3D() ? 2 : 1;
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.reloadMapPlot();
            this.m_moveUEC.addListener(this);
            this.m_clickUEC.addListener(this);
            this.loadUEC();
            if (!this.m_stackController.is3D()) {
                Ensemble ensemble = this.m_widgetList.get((int)0).InputEnsemble;
                this.m_stackController.ensemble_Complete2D(ensemble, true);
                this.processEnsemble(0, true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createDisplayWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            main.addComponent(this.m_wiggleOptionsWidget, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeftTop() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            for (int n = 0; n < this.m_numPlotsVisible; ++n) {
                String lbl = String.format("Plot number %d", n + 1);
                SelectorControlWidget w = new SelectorControlWidget(lbl);
                w.listener().addListener(this);
                this.m_selectorList.add(w);
                main.addComponent(w, 0);
            }
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(250.0, 600.0);
            main.addComponent(this.m_axisLockerTime, 0);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addComponent(this.m_coordLabel, 0);
            this.m_coordLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_coordLabel.setForeground(Color.blue);
            main.addComponent(this.m_mapWidget, 10);
            this.m_mapWidget.setColorScaleVisible(false);
            main.setPreferredSize(new Dimension(300, 1200));
            main.setMaximumSize(new Dimension(300, 1200));
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("VolumeProfile", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_overlayWidget = new VolumeStack_InterpolatedWellTopWidget();
            this.m_overlayWidget.listener().addListener(this);
            if (this.m_stackController.is3D()) {
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createLeftTop(), "Basemap");
            }
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, this.createDisplayWidget(), "Display options");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Diagram, this.m_overlayWidget, "Interpolated overlay");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(5, null);
            for (int n = 0; n < this.m_numPlotsVisible; ++n) {
                EnsembleViewerWidget widget = new EnsembleViewerWidget();
                widget.addListener(this);
                main.addComponent(widget, 10);
                this.m_widgetList.add(widget);
            }
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            this.reloadMapPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadUEC() {
        try {
            if (!this.m_stackController.is3D()) {
                return;
            }
            Java2D_Widget w = this.m_mapWidget.mainWidget();
            w.clearEventConsumerList();
            w.addEventConsumer(this.m_moveUEC);
            w.addEventConsumer(this.m_clickUEC);
            w.addZoomer();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadMapPlot() {
        try {
            if (!this.m_stackController.is3D()) {
                return;
            }
            Java2D_Widget w = this.m_mapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            w.addPaintable(this.m_stackController.grid(), -9999);
            for (EnsembleViewerWidget ev : this.m_widgetList) {
                ev.EnsembleOverlay.m_ensemble = ev.ProcessedEnsemble;
                w.addPaintable(ev.EnsembleOverlay, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.repaint();
            this.loadUEC();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadEnsemble(int index) {
        try {
            if (!this.m_stackController.is3D()) {
                return;
            }
            this.m_widgetList.get((int)index).Plane = this.m_selectorList.get(index).getPlane();
            this.m_widgetList.get((int)index).Coord = this.m_selectorList.get(index).getCoord();
            Ensemble ensemble = this.m_widgetList.get((int)index).InputEnsemble;
            if (this.m_widgetList.get((int)index).Plane.equals("Inline")) {
                this.m_stackController.ensemble_Inline(ensemble, this.m_widgetList.get((int)index).Coord, true);
            } else {
                this.m_stackController.ensemble_Crossline(ensemble, this.m_widgetList.get((int)index).Coord, true);
            }
            this.processEnsemble(index, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void applyOverlay() {
        try {
            for (EnsembleViewerWidget w : this.m_widgetList) {
                this.m_overlayWidget.addPick(w.ProcessedEnsemble, "Pick");
                w.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void processEnsemble(int index, boolean unzoom) {
        try {
            EnsembleViewerWidget w = this.m_widgetList.get(index);
            w.InputEnsemble.copyToOtherEnsemble(w.InputEnsemble_Copy);
            w.ProcessedEnsemble = this.m_stackController.is3D() ? (this.m_selectorList.get(index).getProcess() ? this.m_sequence.work(w.InputEnsemble_Copy) : w.InputEnsemble_Copy) : this.m_sequence.work(w.InputEnsemble_Copy);
            this.m_overlayWidget.addPick(w.ProcessedEnsemble, "Pick");
            w.setEnsemble(0, w.ProcessedEnsemble);
            if (unzoom) {
                w.clearAndLoadWigglePaintables();
                w.unzoom();
            } else {
                w.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            int inline;
            int n;
            for (n = 0; n < this.m_selectorList.size(); ++n) {
                if (this.m_selectorList.get(n) != sender) continue;
                String string = (String)data;
                if (string.equalsIgnoreCase("Reload")) {
                    this.loadEnsemble(n);
                    return;
                }
                if (!string.equalsIgnoreCase("ToggleProcess")) continue;
                this.processEnsemble(n, false);
                return;
            }
            if (sender == this.m_overlayWidget) {
                this.applyOverlay();
                return;
            }
            if (sender == this.m_clickUEC) {
                inline = this.m_stackController.grid().getInline(this.m_clickUEC.WorldX, this.m_clickUEC.WorldY);
                int n2 = this.m_stackController.grid().getCrossline(this.m_clickUEC.WorldX, this.m_clickUEC.WorldY);
                for (SelectorControlWidget w : this.m_selectorList) {
                    w.tryToSelect(inline, n2);
                }
                for (int n22 = 0; n22 < this.m_selectorList.size(); ++n22) {
                    this.loadEnsemble(n22);
                }
            }
            if (sender == this.m_moveUEC) {
                inline = this.m_stackController.grid().getInline(this.m_moveUEC.WorldX, this.m_moveUEC.WorldY);
                int n3 = this.m_stackController.grid().getCrossline(this.m_moveUEC.WorldX, this.m_moveUEC.WorldY);
                String s = String.format("Inline: %d  Crossline: %d", inline, n3);
                this.m_coordLabel.setText(s);
            }
            if (sender == this.m_axisLockerTime) {
                for (Java2D_VertStackedEnsembleDisplayWidget java2D_VertStackedEnsembleDisplayWidget : this.m_widgetList) {
                    java2D_VertStackedEnsembleDisplayWidget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                }
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    for (n = 0; n < this.m_widgetList.size(); ++n) {
                        this.processEnsemble(n, false);
                    }
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected class EnsembleViewerWidget
    extends Java2D_VertStackedEnsembleDisplayWidget {
        public Ensemble InputEnsemble;
        public Ensemble InputEnsemble_Copy;
        public Ensemble ProcessedEnsemble;
        public Java2D_Paintable_EnsembleCdpOverlay EnsembleOverlay;
        public String Plane;
        public int Coord;

        public EnsembleViewerWidget() {
            super(1);
            this.InputEnsemble = new Ensemble();
            this.InputEnsemble_Copy = new Ensemble();
            this.ProcessedEnsemble = new Ensemble();
            this.EnsembleOverlay = new Java2D_Paintable_EnsembleCdpOverlay();
            this.Plane = "Inline";
            this.Coord = 1;
            try {
                boolean refractionOkay = RefractionStaticsProject.singleton().valid();
                if (refractionOkay) {
                    this.HeaderTextRowCount = 0;
                    this.setHeaderPlotVisibleCount(0, 1);
                    this.setHeaderPlotHeader(0, 0, "Trace", "Inline");
                } else {
                    this.HeaderTextRowCount = 1;
                    this.setHeaderPlotVisibleCount(0, 0);
                    this.setHeaderPlotHeader(0, 0, "Trace", "Inline");
                }
                this.DrawColor = true;
                this.DrawWiggles = false;
                this.setEnsembleDisplayOptionsWidget(VolumeStack_SimpleViewerWidget.this.m_wiggleOptionsWidget);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    protected class SelectorControlWidget
    extends LinearLayoutWidget
    implements ItemListener,
    ChangeListener,
    ActionListener {
        public static final String MessageReload = "Reload";
        public static final String MessageToggleProcess = "ToggleProcess";
        protected GenericObjectListener m_listener;
        protected JComboBox<String> m_planeCombo;
        protected JSpinner m_spinner;
        protected JCheckBox m_processCheck;
        protected boolean m_ignoreSpinner;
        protected int m_priorInline;
        protected int m_priorCrossline;
        protected SpinnerNumberModel m_model;

        public GenericObjectListener listener() {
            return this.m_listener;
        }

        public SelectorControlWidget(String lbl) {
            super(LinearLayoutWidget.Direction.Vertical, 0, lbl);
            this.m_listener = new GenericObjectListener();
            this.m_planeCombo = new JComboBox();
            this.m_spinner = new JSpinner();
            this.m_ignoreSpinner = true;
            this.m_priorInline = -99999;
            this.m_priorCrossline = -99999;
            this.m_model = null;
            try {
                LinearLayoutWidget sub = this.createHorizontal(0, null, 0);
                this.m_planeCombo.addItem("Inline");
                this.m_planeCombo.addItem("Crossline");
                this.m_planeCombo.setSelectedIndex(0);
                this.m_planeCombo.addItemListener(this);
                this.m_spinner.addChangeListener(this);
                sub.addComponent(this.m_planeCombo, 10);
                sub.addComponent(this.m_spinner, 10);
                this.m_processCheck = new JCheckBox("Apply processing sequence");
                this.m_processCheck.setSelected(true);
                this.m_processCheck.addActionListener(this);
                this.addComponent(this.m_processCheck, 0);
                this.reloadSpinner();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void tryToSelect(int inline, int crossline) {
            try {
                this.m_ignoreSpinner = true;
                if (this.m_planeCombo.getSelectedIndex() == 0) {
                    this.m_model.setValue(new Integer(inline));
                } else {
                    this.m_model.setValue(new Integer(crossline));
                }
                this.m_ignoreSpinner = false;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public boolean getProcess() {
            return this.m_processCheck.isSelected();
        }

        public int getCoord() {
            try {
                if (this.m_model == null) {
                    return -9999;
                }
                return this.m_model.getNumber().intValue();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return -9999;
            }
        }

        public String getPlane() {
            return (String)this.m_planeCombo.getSelectedItem();
        }

        public void reloadSpinner() {
            try {
                this.m_ignoreSpinner = true;
                int min = 0;
                int max = 10;
                int pref = 2;
                if (this.m_planeCombo.getSelectedIndex() == 0) {
                    min = VolumeStack_SimpleViewerWidget.this.m_stackController.grid().inlineMin();
                    max = VolumeStack_SimpleViewerWidget.this.m_stackController.grid().inlineMax();
                    pref = this.m_priorInline;
                } else {
                    min = VolumeStack_SimpleViewerWidget.this.m_stackController.grid().crosslineMin();
                    max = VolumeStack_SimpleViewerWidget.this.m_stackController.grid().crosslineMax();
                    pref = this.m_priorCrossline;
                }
                pref = Math.max(min, pref);
                pref = Math.min(max, pref);
                this.m_model = new SpinnerNumberModel(pref, min, max, 1);
                this.m_spinner.setModel(this.m_model);
                this.m_ignoreSpinner = false;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.m_listener.broadcast(this, MessageToggleProcess);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                if (this.m_ignoreSpinner) {
                    return;
                }
                if (this.m_model == null) {
                    return;
                }
                if (this.m_planeCombo.getSelectedIndex() == 0) {
                    this.m_priorInline = this.m_model.getNumber().intValue();
                } else {
                    this.m_priorCrossline = this.m_model.getNumber().intValue();
                }
                this.m_listener.broadcast(this, MessageReload);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                this.reloadSpinner();
                this.m_listener.broadcast(this, MessageReload);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

