/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Import;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosLibrary.Volume.VolumeProject;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VolumeStackNameSelectionWidget
extends GridLayoutWidget
implements DocumentListener {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected JTextField m_nameTextField = new JTextField("");
    protected JLabel m_errorLabel = new JLabel("", 2);
    protected JLabel m_pathLabel = new JLabel("", 2);

    public VolumeStackNameSelectionWidget(int insets) {
        super(insets, "Stack name");
        try {
            this.m_nameTextField.getDocument().addDocumentListener(this);
            int row = 0;
            this.addComponent(new JLabel("Name:"), row, 0, 0.0, 0.0);
            this.addComponent(this.m_nameTextField, row, 1, 0.0, 10.0);
            this.addComponent(new JLabel("Status:"), ++row, 0);
            this.addComponent(this.m_errorLabel, row, 1, 1.0, 10.0);
            this.addComponent(new JLabel("Stack path: "), ++row, 0, 0.0, 0.0);
            this.addComponent(this.m_pathLabel, row, 1, 1.0, 10.0);
            Tools_FontChanger.changeSizeOfFont(this.m_pathLabel, -2);
            ++row;
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public String name() {
        return this.m_nameTextField.getText();
    }

    public boolean checkName() {
        try {
            String name = this.m_nameTextField.getText();
            this.m_errorLabel.setText("");
            if (name.length() < 3) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Name must have at least 3 characters");
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Spaces and special characters not allowed");
                return false;
            }
            if (Tools_Strings.startsWithNumber(name)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Name cannot start with a number");
                return false;
            }
            String stackContainerPath = VolumeProject.singleton().stackContainerPath();
            String path = stackContainerPath + "/" + name;
            this.m_pathLabel.setText(path);
            if (Tools_FileSystem.exists_path(path)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Stack path already exists");
                return false;
            }
            this.m_errorLabel.setForeground(Color.blue);
            this.m_errorLabel.setText("Name looks okay");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_errorLabel.setText("Exception thrown - check messages");
            return false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

