/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Synthetic;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ExportSyntheticBinaryGLIDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Okay");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnSelect = new JButton("Select");
    protected JLabel m_shotCountLabel = new JLabel("Shot count");
    protected JLabel m_receiverCountLabel = new JLabel("Receiver count");
    protected JLabel m_shotFoldLabel = new JLabel("Shot fold");
    protected JLabel m_shotSpacingLabel = new JLabel("Shot spacing");
    protected JLabel m_shotLineSpacingLabel = new JLabel("Shot line spacing");
    protected JLabel m_receiverSpacingLabel = new JLabel("Receiver spacing");
    protected JLabel m_receiverLineSpacingLabel = new JLabel("Receiver line spacing");
    protected JLabel m_midpointXLabel = new JLabel("Survey midpoint X");
    protected JLabel m_midpointYLabel = new JLabel("Survey midpoint Y");
    protected JLabel m_h0Label = new JLabel("Weathering thickness");
    protected JLabel m_h1Label = new JLabel("Layer 1 thickness");
    protected JLabel m_h2Label = new JLabel("Layer 2 thickness");
    protected JLabel m_v0Label = new JLabel("Weathering velocity");
    protected JLabel m_v1Label = new JLabel("Refractor 1 velocity");
    protected JLabel m_v2Label = new JLabel("Refractor 2 velocity");
    protected JLabel m_v3Label = new JLabel("Refractor 3 velocity");
    protected JLabel m_labelSpace = new JLabel(" ");
    protected JTextField m_shotCountField = new JTextField(1000);
    protected JTextField m_receiverCountField = new JTextField(2000);
    protected JTextField m_shotFoldField = new JTextField(500);
    protected JTextField m_shotSpacingField = new JTextField(Double.toString(100.0));
    protected JTextField m_shotLineSpacingField = new JTextField(Double.toString(800.0));
    protected JTextField m_receiverSpacingField = new JTextField(Double.toString(100.0));
    protected JTextField m_receiverLineSpacingField = new JTextField(Double.toString(800.0));
    protected JTextField m_midpointXField = new JTextField(Double.toString(100000.0));
    protected JTextField m_midpointYField = new JTextField(Double.toString(100000.0));
    protected JTextField m_h0Field = new JTextField(Double.toString(300.0));
    protected JTextField m_h1Field = new JTextField(Double.toString(300.0));
    protected JTextField m_h2Field = new JTextField(Double.toString(300.0));
    protected JTextField m_v0Field = new JTextField(Double.toString(3000.0));
    protected JTextField m_v1Field = new JTextField(Double.toString(5000.0));
    protected JTextField m_v2Field = new JTextField(Double.toString(7000.0));
    protected JTextField m_v3Field = new JTextField(Double.toString(9000.0));
    protected JTextField m_timeField = new JTextField(Double.toString(2000.0));
    protected JLabel m_lblPath = new JLabel("");
    protected String m_outputPath = "";
    protected ParameterTree m_parameterTree = new ParameterTree();
    public boolean OK = false;

    public ExportSyntheticBinaryGLIDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget path = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            path.addComponent(this.m_lblPath, 30);
            this.m_lblPath.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_lblPath.setText(this.m_outputPath);
            this.m_btnSelect = path.createButton("Select", this, 0);
            this.m_parameterTree.int_get(this.m_shotCountField, "ShotCount", 1000);
            this.m_parameterTree.int_get(this.m_receiverCountField, "ReceiverCount", 2000);
            this.m_parameterTree.int_get(this.m_shotFoldField, "ShotFold", 500);
            this.m_parameterTree.double_get(this.m_shotSpacingField, "ShotSpacing", 100.0);
            this.m_parameterTree.double_get(this.m_shotLineSpacingField, "ShotLineSpacing", 800.0);
            this.m_parameterTree.double_get(this.m_receiverSpacingField, "ReceiverSpacing", 100.0);
            this.m_parameterTree.double_get(this.m_receiverLineSpacingField, "ReceiverLineSpacing", 800.0);
            this.m_parameterTree.double_get(this.m_midpointXField, "MidpointX", 100000.0);
            this.m_parameterTree.double_get(this.m_midpointYField, "MidpointY", 100000.0);
            this.m_parameterTree.double_get(this.m_h0Field, "H0", 300.0);
            this.m_parameterTree.double_get(this.m_h1Field, "H1", 300.0);
            this.m_parameterTree.double_get(this.m_h2Field, "H2", 300.0);
            this.m_parameterTree.double_get(this.m_v0Field, "V0", 3000.0);
            this.m_parameterTree.double_get(this.m_v1Field, "V1", 5000.0);
            this.m_parameterTree.double_get(this.m_v2Field, "V2", 7000.0);
            this.m_parameterTree.double_get(this.m_v3Field, "V3", 9000.0);
            GridLayoutWidget geom = new GridLayoutWidget(3, null);
            int row = 0;
            geom.addSimple(row++, this.m_shotCountLabel, this.m_shotCountField);
            geom.addSimple(row++, this.m_receiverCountLabel, this.m_receiverCountField);
            geom.addSimple(row++, this.m_shotFoldLabel, this.m_shotFoldField);
            geom.addSimple(row++, this.m_shotSpacingLabel, this.m_shotSpacingField);
            geom.addSimple(row++, this.m_shotLineSpacingLabel, this.m_shotLineSpacingField);
            geom.addSimple(row++, this.m_receiverSpacingLabel, this.m_receiverSpacingField);
            geom.addSimple(row++, this.m_receiverLineSpacingLabel, this.m_receiverLineSpacingField);
            geom.addSimple(row++, this.m_labelSpace, this.m_labelSpace);
            geom.addSimple(row++, this.m_midpointXLabel, this.m_midpointXField);
            geom.addSimple(row++, this.m_midpointYLabel, this.m_midpointYField);
            geom.addSimple(row++, this.m_labelSpace, this.m_labelSpace);
            geom.addSimple(row++, this.m_h0Label, this.m_h0Field);
            geom.addSimple(row++, this.m_h1Label, this.m_h1Field);
            geom.addSimple(row++, this.m_h2Label, this.m_h2Field);
            geom.addSimple(row++, this.m_labelSpace, this.m_labelSpace);
            geom.addSimple(row++, this.m_v0Label, this.m_v0Field);
            geom.addSimple(row++, this.m_v1Label, this.m_v1Field);
            geom.addSimple(row++, this.m_v2Label, this.m_v2Field);
            geom.addSimple(row++, this.m_v3Label, this.m_v3Field);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)path, "North");
            this.getContentPane().add((Component)geom, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(new Dimension(350, 600));
            this.setTitle("Create binary GLI file using synthetic geometry and picks");
            this.setLocationRelativeTo(null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void getAll() {
        try {
            int shotCount = Tools_Widget.extractInteger(this.m_shotCountField, 1000, 1, 1000000);
            int receiverCount = Tools_Widget.extractInteger(this.m_receiverCountField, 2000, 1, 3000000);
            int shotFold = Tools_Widget.extractInteger(this.m_shotFoldField, 500, 1, 10000000);
            double shotSpacing = Tools_Widget.extractDouble(this.m_shotSpacingField, 100.0, 1.0, 1000.0);
            double shotLineSpacing = Tools_Widget.extractDouble(this.m_shotLineSpacingField, 800.0, 1.0, 10000.0);
            double receiverSpacing = Tools_Widget.extractDouble(this.m_receiverSpacingField, 100.0, 1.0, 1000.0);
            double receiverLineSpacing = Tools_Widget.extractDouble(this.m_receiverLineSpacingField, 800.0, 1.0, 10000.0);
            double midpointX = Tools_Widget.extractDouble(this.m_midpointXField, 100000.0, 0.0, Double.MAX_VALUE);
            double midpointY = Tools_Widget.extractDouble(this.m_midpointYField, 100000.0, 0.0, Double.MAX_VALUE);
            double h0 = Tools_Widget.extractDouble(this.m_h0Field, 300.0, 1.0, 1.0E8);
            double h1 = Tools_Widget.extractDouble(this.m_h1Field, 300.0, 1.0, 1.0E8);
            double h2 = Tools_Widget.extractDouble(this.m_h2Field, 300.0, 1.0, 1.0E8);
            double v0 = Tools_Widget.extractDouble(this.m_v0Field, 3000.0, 50.0, 1000000.0);
            double v1 = Tools_Widget.extractDouble(this.m_v1Field, 5000.0, v0 + 1.0, 1000000.0);
            double v2 = Tools_Widget.extractDouble(this.m_v2Field, 7000.0, v1 + 1.0, 1000000.0);
            double v3 = Tools_Widget.extractDouble(this.m_v3Field, 9000.0, v2 + 1.0, 1000000.0);
            this.m_parameterTree.int_put("ShotCount", shotCount);
            this.m_parameterTree.int_put("ReceiverCount", receiverCount);
            this.m_parameterTree.int_put("ShotFold", shotFold);
            this.m_parameterTree.double_put("ShotSpacing", shotSpacing);
            this.m_parameterTree.double_put("ShotLineSpacing", shotLineSpacing);
            this.m_parameterTree.double_put("ReceiverSpacing", receiverSpacing);
            this.m_parameterTree.double_put("ReceiverLineSpacing", receiverLineSpacing);
            this.m_parameterTree.double_put("MidpointX", midpointX);
            this.m_parameterTree.double_put("MidpointY", midpointY);
            this.m_parameterTree.double_put("H0", h0);
            this.m_parameterTree.double_put("H1", h1);
            this.m_parameterTree.double_put("H2", h2);
            this.m_parameterTree.double_put("V0", v0);
            this.m_parameterTree.double_put("V1", v1);
            this.m_parameterTree.double_put("V2", v2);
            this.m_parameterTree.double_put("V3", v3);
            double maxTime = Tools_Widget.extractDouble(this.m_timeField, 2000.0, 0.0, 20000.0);
            this.m_parameterTree.double_put("Time", maxTime);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.getAll();
                if (this.m_outputPath == null) {
                    this.OK = false;
                    return;
                }
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnSelect) {
                this.m_outputPath = Tools_Chooser.getDirectory("Select XtremeGeo home directory");
                if (Tools_FileSystem.exists_path(this.m_outputPath)) {
                    this.m_lblPath.setText(this.m_outputPath);
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.getAll();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String outputPath() {
        return this.m_outputPath;
    }

    public ParameterTree paramTree() {
        return this.m_parameterTree;
    }
}

