/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AGC;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Stack.Semblance;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import com.PecosLibrary.Windows.Stack.SemblanceWidget;
import com.PecosLibrary.Windows.Stack.VelocityVersionSelectionWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class StackingVelocityPickerWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
VelocityManager.Listener,
ISaveableFrame {
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected JButton m_applySequence;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected JCheckBox m_showGatherCheck;
    protected JCheckBox m_showNmoCheck;
    protected ParameterTree m_parameters = new ParameterTree();
    protected String m_paramFileName;
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected GridLayoutWidget m_sembWidget;
    protected JTextField m_velMinText = new JTextField("7000");
    protected JTextField m_velMaxText = new JTextField("15000");
    protected JTextField m_velCountText = new JTextField("120");
    protected JTextField m_timeMinText = new JTextField("0");
    protected JTextField m_timeMaxText = new JTextField("1100");
    protected JTextField m_timeDigiText = new JTextField("4");
    protected JTextField m_minOffText = new JTextField("1200");
    protected JTextField m_maxOffText = new JTextField("7000");
    protected JTextField m_muteText = new JTextField("25");
    protected JCheckBox m_waveletCheck = new JCheckBox("Additional wavelet shaping");
    protected SemblanceWidget m_semblanceWidget;
    protected Java2D_SimpleComposite m_basemapWidget = new Java2D_SimpleComposite(false);
    protected JButton m_clearButton;
    protected JButton m_reloadMapButton;
    protected JComboBox<String> m_radiusCombo = new JComboBox();
    protected JCheckBox m_chkUseSparse = new JCheckBox("Use Sparse CMP gathers (if available)");
    protected JButton m_btnReadEchos;
    protected VelocityVersionSelectionWidget m_velVersionWidget;
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_inputEnsemble_Copy = new Ensemble();
    protected Ensemble m_processedEnsemble;
    protected String m_velocityName;
    protected VelocityManager m_velManager;
    protected Java2D_UserEventConsumer_ButtonPressed m_mapLeftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected boolean m_bSparseValid = false;

    public EnsembleWorker_Sequence sequence() {
        return this.m_sequence;
    }

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Stack.StackingVelocityPickerWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Stack velocity";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Stack velocity";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public StackingVelocityPickerWidget() {
        super(1);
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_velManager = RefractionStaticsProject.singleton().getVelocityManager();
            this.m_velManager.addListener(this);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.m_paramFileName = p.guiOptionsPath() + "/VelocityPicker.xml";
            this.m_parameters.read(this.m_paramFileName);
            this.m_paramManager.addTextFieldConnector("m_velMinText", this.m_velMinText, "3000");
            this.m_paramManager.addTextFieldConnector("m_velMaxText", this.m_velMaxText, "19000");
            this.m_paramManager.addTextFieldConnector("m_velCountText", this.m_velCountText, "100");
            this.m_paramManager.addTextFieldConnector("m_timeMinText", this.m_timeMinText, "0");
            this.m_paramManager.addTextFieldConnector("m_timeMaxText", this.m_timeMaxText, "2000");
            this.m_paramManager.addTextFieldConnector("m_timeDigiText", this.m_timeDigiText, "6");
            this.m_paramManager.addTextFieldConnector("m_minOffText", this.m_minOffText, "300");
            this.m_paramManager.addTextFieldConnector("m_maxOffText", this.m_maxOffText, "12000");
            this.m_paramManager.addTextFieldConnector("m_muteText", this.m_muteText, "25");
            this.m_paramManager.setTree(this.m_parameters.ParameterTree_get("Semblance"));
            this.m_wiggleOptionsWidget.setParentParameterTree(this.m_parameters);
            Messenger.singleton().addListener(this);
            this.reloadMapPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
            this.m_wiggleOptionsWidget.saveParameters();
            this.m_parameters.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleVelocityManager(String name, VelocityManager.Message message) {
    }

    protected JComponent createRightParent() {
        try {
            this.m_semblanceWidget = new SemblanceWidget(this);
            this.m_semblanceWidget.setVelocityName(this.m_velVersionWidget.getSelectedVersion());
            System.out.println("m_velVersionWidget.getSelectedVersion() = " + this.m_velVersionWidget.getSelectedVersion());
            this.m_semblanceWidget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            return this.m_semblanceWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createSembOptionsWidget() {
        try {
            GridLayoutWidget grid = new GridLayoutWidget(0, "Velocity function options");
            int row = 0;
            grid.addSimple(row++, new JLabel("Minimum velocity"), this.m_velMinText);
            grid.addSimple(row++, new JLabel("Maximum velocity"), this.m_velMaxText);
            grid.addSimple(row++, new JLabel("Velocity count"), this.m_velCountText);
            grid.addSimple(row++, new JLabel("Minimum time"), this.m_timeMinText);
            grid.addSimple(row++, new JLabel("Maximum time"), this.m_timeMaxText);
            grid.addSimple(row++, new JLabel("Sample interval"), this.m_timeDigiText);
            grid.addSimple(row++, new JLabel("Stretch mute percent"), this.m_muteText);
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_minOffText);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_maxOffText);
            this.m_waveletCheck.addActionListener(this);
            this.m_velMinText.addActionListener(this);
            this.m_velMaxText.addActionListener(this);
            this.m_velCountText.addActionListener(this);
            this.m_timeMinText.addActionListener(this);
            this.m_timeMaxText.addActionListener(this);
            this.m_timeDigiText.addActionListener(this);
            this.m_minOffText.addActionListener(this);
            this.m_maxOffText.addActionListener(this);
            this.m_muteText.addActionListener(this);
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createBasemapWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_velVersionWidget = new VelocityVersionSelectionWidget(this);
            main.addComponent(this.m_velVersionWidget, 0);
            this.m_velocityName = this.m_velVersionWidget.getSelectedVersion();
            main.addComponent(this.createSembOptionsWidget(), 0);
            this.m_btnReadEchos = main.createButton("Import Velocity from Echos ASCII file", this, 0);
            main.addComponent(this.m_chkUseSparse, 0);
            this.m_chkUseSparse.addActionListener(this);
            LinearLayoutWidget temp = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Number of bins", 0);
            this.m_radiusCombo.addItem("1 bin");
            if (RefractionStaticsProject.singleton().dim3D()) {
                for (n = 1; n <= 3; ++n) {
                    num = 2 * n + 1;
                    String s = String.format("%d x %d bins", num, num);
                    this.m_radiusCombo.addItem(s);
                }
            } else {
                for (n = 1; n <= 3; ++n) {
                    num = 2 * n + 1;
                    String s = String.format("%d bins", num);
                    this.m_radiusCombo.addItem(s);
                }
            }
            this.m_radiusCombo.setSelectedIndex(0);
            temp.addComponent(this.m_radiusCombo, 10);
            String s = "<HTML>Left-click to add or select a location. Press \"r\" to remove nearest location</HTML>";
            main.addComponent(new JLabel(s), 0);
            this.m_basemapWidget.setAxesVisible(false, false);
            this.m_basemapWidget.setColorScaleVisible(false);
            main.addComponent(this.m_basemapWidget, 10);
            this.m_mapLeftClickUEC.addListener(this);
            this.m_mapKeyUEC.addListener(this);
            LinearLayoutWidget bottom = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearButton = bottom.createButton("Remove all", this, 0);
            this.m_reloadMapButton = bottom.createButton("Reload plot", this, 0);
            bottom.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createDisplayWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_showGatherCheck = new JCheckBox("Show ensemble without NMO applied");
            this.m_showNmoCheck = new JCheckBox("Show ensemble with NMO applied");
            this.m_showGatherCheck.setSelected(true);
            this.m_showNmoCheck.setSelected(false);
            this.m_showGatherCheck.addActionListener(this);
            this.m_showNmoCheck.addActionListener(this);
            main.addComponent(this.m_showGatherCheck, 0);
            main.addComponent(this.m_showNmoCheck, 0);
            main.createGapLabel(20);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            main.addComponent(this.m_wiggleOptionsWidget, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sequenceFileName = p.guiOptionsPath() + "/Stack_Vel.SequenceXML";
            LinearLayoutWidget worker = LinearLayoutWidget.vert(3, null);
            this.m_applySequence = worker.createButton("Apply processing sequence", this, 0);
            this.m_workerWidget = new Sequence_MainWidget("Stack_Vel", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_workerWidget.setFileName(sequenceFileName);
            worker.addComponent(this.m_workerWidget, 10);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            if (this.m_sequence.size() < 1) {
                this.m_sequence.add(new EnsembleWorker_AGC());
                this.m_sequence.add(new EnsembleWorker_RMS());
            }
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createBasemapWidget(), "Basemap");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, worker, "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, this.createDisplayWidget(), "Display options");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            Tools_FontChanger.changeSizeOfFont(this.m_applySequence, 2);
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void prepSemblanceOptions() {
        try {
            Semblance semb = this.m_semblanceWidget.getSemblance();
            semb.ExtraWaveletShaping = this.m_waveletCheck.isSelected();
            double x1 = Tools_Widget.extractDouble(this.m_minOffText, 0.0, 0.0, 25000.0);
            double x2 = Tools_Widget.extractDouble(this.m_maxOffText, 0.0, x1 + 100.0, 30000.0);
            semb.setOffsetRange(x1, x2);
            this.m_semblanceWidget.setOffsetRange(x1, x2);
            double v1 = Tools_Widget.extractDouble(this.m_velMinText, 1000.0, 10.0, 25000.0);
            double v2 = Tools_Widget.extractDouble(this.m_velMaxText, 7000.0, v1 + 100.0, 30000.0);
            int numv = Tools_Widget.extractInteger(this.m_velCountText, 50, 20, 200);
            semb.setVelocityRange(v1, v2);
            semb.setNumVelocities(numv);
            double t1 = Tools_Widget.extractDouble(this.m_timeMinText, 100.0, 0.0, 3000.0);
            double t2 = Tools_Widget.extractDouble(this.m_timeMaxText, 2000.0, t1 + 100.0, 100000.0);
            double digi = Tools_Widget.extractDouble(this.m_timeDigiText, 8.0, 1.0, 32.0);
            semb.setTimeRange(t1, t2);
            semb.setDigi(digi);
            double mute = Tools_Widget.extractDouble(this.m_muteText, 25.0, 5.0, 200.0);
            semb.setStretchMutePercent(mute);
            this.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMapPlot() {
        try {
            SparseCmpGatherManager sparse;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot"), -9999);
            w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), -9999);
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
            this.m_bSparseValid = false;
            if (this.m_chkUseSparse.isSelected() && (sparse = RefractionStaticsProject.singleton().sparseCmpGathers()).size() > 0) {
                Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray(sparse);
                w.addPaintable(pa, -9999);
                this.m_bSparseValid = true;
            }
            w.addPaintable(velField, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_mapLeftClickUEC);
            w.addEventConsumer(this.m_mapKeyUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean bl = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void readEchos() {
        try {
            String name = Tools_Chooser.getFileName();
            if (name.length() < 3) {
                return;
            }
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
            velField.importEchosAscii(name);
            this.m_velManager.saveVersion(this.m_velocityName);
            this.reloadMapPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnReadEchos) {
                this.readEchos();
                return;
            }
            if (e.getSource() == this.m_chkUseSparse) {
                this.reloadMapPlot();
                return;
            }
            if (e.getSource() == this.m_applySequence) {
                this.m_applySequence.setForeground(Color.BLACK);
                this.processEnsemble(false);
            }
            if (e.getSource() == this.m_showGatherCheck) {
                this.m_semblanceWidget.setGatherVisible(this.m_showGatherCheck.isSelected());
                return;
            }
            if (e.getSource() == this.m_showNmoCheck) {
                this.m_semblanceWidget.setNmoVisible(this.m_showNmoCheck.isSelected());
                return;
            }
            if (e.getSource() == this.m_velMinText || e.getSource() == this.m_velMaxText || e.getSource() == this.m_velCountText || e.getSource() == this.m_timeMinText || e.getSource() == this.m_timeMaxText || e.getSource() == this.m_minOffText || e.getSource() == this.m_maxOffText || e.getSource() == this.m_timeDigiText || e.getSource() == this.m_muteText) {
                this.prepSemblanceOptions();
                this.m_semblanceWidget.computeSemblance();
                this.m_semblanceWidget.clearAndLoadPaintables();
                this.m_semblanceWidget.unzoom();
                return;
            }
            if (e.getSource() == this.m_waveletCheck) {
                // empty if block
            }
            if (e.getSource() == this.m_reloadMapButton) {
                this.reloadMapPlot();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleMapClick() {
        try {
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
            if (this.m_bSparseValid) {
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                SparseCmpGatherManager sparse = p.sparseCmpGathers();
                sparse.selectNearestCMP(this.m_mapLeftClickUEC.WorldX, this.m_mapLeftClickUEC.WorldY, this.m_inputEnsemble);
                p.traceTableWrapper().traceTable().fillEnsembleHeaders(this.m_inputEnsemble);
                p.prepGeometryHeaders(this.m_inputEnsemble, true, true);
                p.inputDataProcessor_Run(this.m_inputEnsemble);
                int pixX = this.m_basemapWidget.getPixelX(sparse.SelectedX);
                int pixY = this.m_basemapWidget.getPixelY(sparse.SelectedY);
                velField.selectLocation(pixX, pixY);
                this.processEnsemble(true);
            } else {
                boolean locChanged = velField.selectLocation(this.m_mapLeftClickUEC.PixelX, this.m_mapLeftClickUEC.PixelY);
                if (locChanged) {
                    this.loadSelectedLocation();
                }
            }
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.forceImageRepaint();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void processEnsemble(boolean unzoom) {
        try {
            if (this.m_inputEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_inputEnsemble_Copy);
                this.m_processedEnsemble = this.m_sequence.work(this.m_inputEnsemble_Copy);
            }
            this.prepSemblanceOptions();
            this.m_semblanceWidget.setEnsemble(this.m_processedEnsemble);
            long start = System.currentTimeMillis();
            this.m_semblanceWidget.computeSemblance();
            long total = System.currentTimeMillis() - start;
            System.out.println("semb comp time = " + total + " for num traces " + this.m_processedEnsemble.traceCount());
            this.m_semblanceWidget.clearAndLoadPaintables();
            this.m_semblanceWidget.unzoom();
            this.m_applySequence.setForeground(Color.BLACK);
            this.m_applySequence.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadSelectedLocation() {
        try {
            this.clearSelectedLocation();
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
            if (RefractionStaticsProject.singleton().dim3D()) {
                Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                int radius = this.m_radiusCombo.getSelectedIndex();
                grid3D.setWorldLocation(velField.SelectedLocation.X, velField.SelectedLocation.Y);
                this.m_inputEnsemble.clearTraces(false);
                RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, grid3D.Inline, grid3D.Crossline, radius, true);
            } else {
                IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                int radius = this.m_radiusCombo.getSelectedIndex();
                int bin = grid2D.getBin(velField.SelectedLocation.X, velField.SelectedLocation.Y);
                this.m_inputEnsemble.clearTraces(false);
                RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, bin, radius, true);
            }
            this.processEnsemble(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearSelectedLocation() {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_semblanceWidget) {
                // empty if block
            }
            if (sender == this.m_velVersionWidget) {
                System.out.println("sender = m_velVersionWidget");
                this.m_velocityName = this.m_velVersionWidget.getSelectedVersion();
                this.m_semblanceWidget.setVelocityName(this.m_velocityName);
                this.m_semblanceWidget.setEnsemble(null);
                this.reloadMapPlot();
                return;
            }
            if (sender == this.m_mapKeyUEC) {
                if (this.m_mapKeyUEC.KeyCode == 82) {
                    VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
                    velField.deleteLocation(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    if (velField.SelectedLocation == null) {
                        this.clearSelectedLocation();
                    }
                    this.m_velManager.versionModified(this.m_velocityName);
                    this.m_basemapWidget.mainWidget().repaint();
                }
                return;
            }
            if (sender == this.m_sequence) {
                this.m_applySequence.setForeground(Color.red);
                return;
            }
            if (sender == this.m_mapLeftClickUEC) {
                this.handleMapClick();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

