/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.Semblance;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Stack.VelocityLocation;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_HorizontalColorCompositeWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Color;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_MoveoutOverlay;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;

public class SemblanceWidget
extends JPanel
implements ComponentListener,
Java2D_Widget.Listener,
Java2D_HorizontalColorCompositeWidget.Listener,
GenericObjectListener.Listener,
VelocityManager.Listener {
    protected Java2D_YAxisWidget m_timeAxis;
    protected Java2D_Widget m_semblanceWidget;
    protected Java2D_XAxisWidget m_semblanceAxis;
    protected Java2D_Widget m_gatherWidget;
    protected Java2D_XAxisWidget m_gatherAxis;
    protected boolean m_gatherVisible = true;
    protected Java2D_Widget m_nmoWidget;
    protected Java2D_XAxisWidget m_nmoAxis;
    protected boolean m_nmoVisible = false;
    protected Java2D_HorizontalColorCompositeWidget m_horizontalColorWidget = null;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected Java2D_EnsembleDisplayOptionsWidget m_optionsWidget = null;
    protected Ensemble m_ensemble;
    protected Java2D_Paintable_Ensemble_Wiggles m_wigglePainter = new Java2D_Paintable_Ensemble_Wiggles();
    protected Java2D_Paintable_MoveoutOverlay m_moveoutOverlay = new Java2D_Paintable_MoveoutOverlay();
    protected Ensemble m_ensembleNMO;
    protected Java2D_Paintable_Ensemble_Color m_colorPainter = new Java2D_Paintable_Ensemble_Color();
    protected Java2D_Paintable_AxisLines m_nmoAxisLines = new Java2D_Paintable_AxisLines();
    protected Range_Double m_rangeOffset = new Range_Double();
    protected Range_Double m_rangeTime = new Range_Double();
    protected Range_Double m_rangeVelocity = new Range_Double();
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected String m_velocityName;
    protected VelocityManager m_velManager;
    protected Semblance m_semblance;
    protected StackGizmo m_stackGizmo = new StackGizmo();
    protected double m_minOffset = 0.0;
    protected double m_maxOffset = 10000.0;

    public void setGatherVisible(boolean v) {
        this.m_gatherVisible = v;
        this.placeWidgets();
    }

    public void setNmoVisible(boolean v) {
        this.m_nmoVisible = v;
        this.placeWidgets();
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public Semblance getSemblance() {
        return this.m_semblance;
    }

    public StackGizmo getStackGizmo() {
        return this.m_stackGizmo;
    }

    public void prepareNMO() {
        try {
            if (!this.m_nmoVisible) {
                return;
            }
            this.m_nmoWidget.clearPaintableList();
            if (this.m_ensemble == null) {
                this.m_nmoWidget.forceImageRepaint();
                this.m_nmoWidget.repaint();
                return;
            }
            this.m_ensembleNMO = new Ensemble();
            this.m_ensemble.copyToOtherEnsemble(this.m_ensembleNMO);
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
            if (velField == null) {
                return;
            }
            if (velField.SelectedLocation == null) {
                return;
            }
            float t0 = (float)this.m_semblance.minTime();
            float digi = this.m_semblance.digi();
            int numTimes = this.m_semblance.numTimes();
            velField.SelectedLocation.setRequestedInterp(t0, digi, numTimes);
            float[] velocity = velField.SelectedLocation.getInterpolatedVelocity();
            if (velocity == null) {
                return;
            }
            this.m_stackGizmo.applyMoveout(this.m_ensembleNMO, velocity, t0, digi, 80.0);
            this.m_ensembleNMO.sortDouble(0, "Trace", "Offset");
            this.m_colorPainter.setEnsemble(this.m_ensembleNMO);
            this.m_nmoWidget.addPaintable(this.m_colorPainter, -999);
            this.m_nmoWidget.addPaintable(this.m_nmoAxisLines, -9999);
            this.m_nmoWidget.forceImageRepaint();
            this.m_nmoWidget.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public SemblanceWidget(GenericObjectListener.Listener listener) {
        try {
            this.m_velManager = RefractionStaticsProject.singleton().getVelocityManager();
            this.m_velManager.addListener(this);
            this.m_listener.addListener(listener);
            this.m_semblance = new Semblance(this.m_stackGizmo);
            this.setLayout(null);
            this.m_horizontalColorWidget = new Java2D_HorizontalColorCompositeWidget(this);
            Java2D_ColorArrayWrapper colorWrapper = this.m_horizontalColorWidget.getColorArrayWrapper();
            int numColors = colorWrapper.colorCount();
            int third = numColors / 3;
            colorWrapper.setColor(0, Color.black);
            colorWrapper.setColor(third, Color.blue);
            colorWrapper.setColor(2 * third, Color.red);
            colorWrapper.setColor(numColors - 1, Color.yellow);
            colorWrapper.interpolateColors(0, third);
            colorWrapper.interpolateColors(third, 2 * third);
            colorWrapper.interpolateColors(2 * third, numColors - 1);
            this.add(this.m_horizontalColorWidget);
            this.m_timeAxis = new Java2D_YAxisWidget();
            this.m_semblanceAxis = new Java2D_XAxisWidget();
            this.m_semblanceAxis.setTitle("Velocity");
            this.m_gatherAxis = new Java2D_XAxisWidget();
            this.m_gatherAxis.setTitle("Offset");
            this.m_nmoAxis = new Java2D_XAxisWidget();
            this.m_semblanceWidget = new Java2D_Widget(colorWrapper);
            this.m_gatherWidget = new Java2D_Widget(colorWrapper);
            this.m_nmoWidget = new Java2D_Widget(colorWrapper);
            this.m_semblanceWidget.addListener(this);
            this.m_gatherWidget.addListener(this);
            this.m_nmoWidget.addListener(this);
            this.addComponentListener(this);
            this.add(this.m_horizontalColorWidget);
            this.add(this.m_timeAxis);
            this.add(this.m_semblanceAxis);
            this.add(this.m_gatherAxis);
            this.add(this.m_nmoAxis);
            this.add(this.m_semblanceWidget);
            this.add(this.m_gatherWidget);
            this.add(this.m_nmoWidget);
            this.m_mouseMoveUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.loadSemblanceUEC();
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setVelocityName(String velName) {
        this.m_velocityName = velName;
    }

    @Override
    public void handleVelocityManager(String name, VelocityManager.Message message) {
    }

    protected void loadSemblanceUEC() {
        try {
            this.m_semblanceWidget.clearEventConsumerList();
            this.m_semblanceWidget.addEventConsumer(this.m_mouseMoveUEC);
            this.m_semblanceWidget.addEventConsumer(this.m_leftClickUEC);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearAndLoadPaintables() {
        try {
            this.m_semblanceWidget.clearPaintableList();
            this.m_gatherWidget.clearPaintableList();
            this.m_nmoWidget.clearPaintableList();
            if (this.m_wigglePainter.ensemble() != null) {
                this.m_gatherWidget.addPaintable(this.m_wigglePainter, -9999);
                this.m_gatherWidget.addPaintable(this.m_moveoutOverlay, -9999);
            }
            if (this.m_colorPainter.ensemble() != null) {
                this.m_nmoWidget.addPaintable(this.m_colorPainter, -9999);
                this.m_nmoAxisLines.HorizontalLineSpacing = 25.0;
                this.m_nmoAxisLines.HorizontalLineColor = Color.GRAY;
                this.m_nmoWidget.addPaintable(this.m_nmoAxisLines, -9999);
            }
            this.m_semblanceWidget.addPaintable(this.m_semblance, -9999);
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
            if (velField.SelectedLocation != null) {
                this.m_semblanceWidget.addPaintable(velField.SelectedLocation, VelocityLocation.PlotType.Semblance.ordinal());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setOffsetRange(double min, double max) {
        try {
            this.m_minOffset = Math.max(0.0, min);
            this.m_maxOffset = Math.max(this.m_minOffset + 10.0, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
        try {
            this.m_rangeVelocity.clearRange();
            this.m_rangeTime.clearRange();
            this.m_rangeOffset.clearRange();
            this.m_gatherWidget.recomputeAllRanges();
            this.m_rangeOffset.expandRange(this.m_gatherWidget.rangeX());
            this.m_rangeOffset.expandRange(0.0);
            this.m_rangeTime.expandRange(this.m_semblance.minTime());
            this.m_rangeTime.expandRange(this.m_semblance.maxTime());
            this.m_rangeVelocity.expandRange(this.m_semblance.minVel());
            this.m_rangeVelocity.expandRange(this.m_semblance.maxVel());
            if (this.m_rangeTime.rangeValid()) {
                this.m_rangeTime.addPercentBuffer(1.0);
            }
            if (this.m_rangeVelocity.rangeValid()) {
                this.m_rangeVelocity.addPercentBuffer(1.0);
            }
            if (this.m_rangeOffset.rangeValid()) {
                this.m_rangeOffset.addPercentBuffer(1.0);
            }
            if (this.m_rangeVelocity.rangeValid() && this.m_rangeTime.rangeValid()) {
                this.m_semblanceWidget.transform().setTechnique(Java2D_Transform.Technique.Inverted);
                this.m_semblanceWidget.transform().setDesiredWorldX(this.m_rangeVelocity.rangeMin(), this.m_rangeVelocity.rangeMax());
                this.m_semblanceWidget.transform().setDesiredWorldY(this.m_rangeTime.rangeMin(), this.m_rangeTime.rangeMax());
                this.m_semblanceWidget.transform().computeTransform();
                this.m_semblanceWidget.repaint();
            }
            if (this.m_rangeOffset.rangeValid() && this.m_rangeTime.rangeValid()) {
                this.m_gatherWidget.transform().setTechnique(Java2D_Transform.Technique.Inverted);
                this.m_gatherWidget.transform().setDesiredWorldX(this.m_minOffset, this.m_maxOffset);
                this.m_gatherWidget.transform().setDesiredWorldY(this.m_rangeTime.rangeMin(), this.m_rangeTime.rangeMax());
                this.m_gatherWidget.transform().computeTransform();
                this.m_gatherWidget.repaint();
            }
            if (this.m_rangeTime.rangeValid() && this.m_ensembleNMO != null) {
                this.m_nmoWidget.transform().setTechnique(Java2D_Transform.Technique.Inverted);
                this.m_nmoWidget.transform().setDesiredWorldX(0.0, this.m_ensembleNMO.traceCount() + 1);
                this.m_nmoWidget.transform().setDesiredWorldY(this.m_rangeTime.rangeMin(), this.m_rangeTime.rangeMax());
                this.m_nmoWidget.transform().computeTransform();
                this.m_nmoWidget.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeSemblance() {
        try {
            this.m_semblance.computeSemblance(100, 10);
            this.prepareNMO();
            this.m_moveoutOverlay.StretchMutePercent = this.m_semblance.getStretchMutePercent();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepWiggleOptions() {
        try {
            if (this.m_optionsWidget == null) {
                return;
            }
            this.m_wigglePainter.setEnsemble(this.m_ensemble);
            this.m_wigglePainter.setAxisTableColumn("Trace", "Offset");
            this.m_wigglePainter.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_optionsWidget.prepPainter(this.m_wigglePainter);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsembleDisplayOptionsWidget(Java2D_EnsembleDisplayOptionsWidget w) {
        try {
            this.m_optionsWidget = w;
            this.m_optionsWidget.listener().addListener(this);
            this.prepWiggleOptions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsemble(Ensemble e) {
        try {
            this.m_ensemble = e;
            if (this.m_ensemble == null) {
                this.m_semblanceWidget.clearPaintableList();
                this.m_gatherWidget.clearPaintableList();
                this.m_nmoWidget.clearPaintableList();
                this.m_semblanceWidget.forceImageRepaint();
                this.m_gatherWidget.forceImageRepaint();
                this.m_nmoWidget.forceImageRepaint();
                this.m_semblanceWidget.repaint();
                this.m_gatherWidget.repaint();
                this.m_nmoWidget.repaint();
                return;
            }
            if (this.m_ensemble != null) {
                this.m_stackGizmo.insertEnsemble(this.m_ensemble, false);
            }
            this.prepWiggleOptions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_leftClickUEC) {
                VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection(this.m_velocityName);
                if (velField.SelectedLocation != null) {
                    if (this.m_leftClickUEC.ControlDown) {
                        velField.SelectedLocation.deletePick_SemblancePlot(this.m_leftClickUEC.PixelY);
                    } else {
                        velField.SelectedLocation.addPick_SemblancePlot(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY);
                    }
                    this.m_semblanceWidget.repaint();
                    this.m_velManager.versionModified(this.m_velocityName);
                    this.prepareNMO();
                }
            }
            if (sender == this.m_mouseMoveUEC) {
                this.m_moveoutOverlay.Time0 = this.m_mouseMoveUEC.WorldY;
                this.m_moveoutOverlay.Velocity = this.m_mouseMoveUEC.WorldX;
                this.m_gatherWidget.repaint();
            }
            if (sender == this.m_optionsWidget) {
                this.prepWiggleOptions();
                this.m_gatherWidget.repaint();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void horizontalColorMapCompositeChanged(Object sender) {
        try {
            this.m_semblanceWidget.forceImageRepaint();
            this.m_semblanceWidget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (widget == this.m_semblanceWidget) {
                this.m_semblanceAxis.setRange(this.m_semblanceWidget.transform().actualLeft(), this.m_semblanceWidget.transform().actualRight());
                this.m_timeAxis.setRange(this.m_semblanceWidget.transform().actualTop(), this.m_semblanceWidget.transform().actualBottom());
                return;
            }
            if (widget == this.m_nmoWidget) {
                this.m_nmoAxis.setRange(this.m_nmoWidget.transform().actualLeft(), this.m_nmoWidget.transform().actualRight());
                return;
            }
            if (widget == this.m_gatherWidget) {
                this.m_gatherAxis.setRange(this.m_gatherWidget.transform().actualLeft(), this.m_gatherWidget.transform().actualRight());
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void placeWidgets() {
        try {
            int width = this.getSize().width;
            int height = this.getSize().height;
            int horzAxisHeight = 34;
            int vertAxisWidth = 54;
            int scrollWidth = 18;
            int scrollHeight = 18;
            int horzColorHeight = 80;
            int weightSemb = 2;
            int weightGather = 3;
            int weightNMO = 3;
            if (!this.m_gatherVisible && this.m_nmoVisible) {
                weightSemb = 2;
                weightGather = 0;
                weightNMO = 5;
            }
            if (this.m_gatherVisible && !this.m_nmoVisible) {
                weightSemb = 2;
                weightGather = 4;
                weightNMO = 0;
            }
            int totalWeight = weightGather + weightNMO + weightSemb;
            int buffer = 8;
            int totalPixels = width - vertAxisWidth - 2 * buffer;
            if (totalPixels < 100) {
                return;
            }
            int mainHeight = height - horzAxisHeight - horzColorHeight;
            if (mainHeight < 10) {
                return;
            }
            int left = 0;
            this.m_timeAxis.setBounds(left, horzAxisHeight, vertAxisWidth, mainHeight);
            int pixForSemb = (int)((double)totalPixels * (double)weightSemb / (double)totalWeight);
            this.m_semblanceAxis.setBounds(left += vertAxisWidth, 0, pixForSemb, horzAxisHeight);
            this.m_semblanceWidget.setBounds(left, horzAxisHeight, pixForSemb, mainHeight);
            this.m_horizontalColorWidget.setBounds(left, height - horzColorHeight, pixForSemb, horzColorHeight);
            left = left + pixForSemb + buffer;
            int pixForGather = (int)((double)totalPixels * (double)weightGather / (double)totalWeight);
            this.m_gatherAxis.setVisible(this.m_gatherVisible);
            this.m_gatherWidget.setVisible(this.m_gatherVisible);
            if (this.m_gatherVisible) {
                this.m_gatherAxis.setBounds(left, 0, pixForGather, horzAxisHeight);
                this.m_gatherWidget.setBounds(left, horzAxisHeight, pixForGather, mainHeight);
                left = left + pixForGather + buffer;
            }
            int pixForNMO = (int)((double)totalPixels * (double)weightNMO / (double)totalWeight);
            this.m_nmoAxis.setVisible(this.m_nmoVisible);
            this.m_nmoWidget.setVisible(this.m_nmoVisible);
            if (this.m_nmoVisible) {
                this.m_nmoAxis.setBounds(left, 0, pixForNMO, horzAxisHeight);
                this.m_nmoWidget.setBounds(left, horzAxisHeight, pixForNMO, mainHeight);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

