/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.XtGeo.XtGeo_Exporter;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleSnapshotViewerWidget;
import com.PecosLibrary.Windows.LWRS.LwrsWidget;
import com.PecosLibrary.Windows.Stack.StackProfileCompositeWidget;
import com.PecosLibrary.Windows.Stack.StackingVelocityPickerWidget;
import com.PecosLibrary.Windows.Synthetic.Synthetic2DWidget;
import com.PecosLibrary.Windows.Volume.VolumeWellTopManagerWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Menu_Stack
implements ActionListener {
    protected JMenu m_menu = new JMenu("QC");
    protected JMenuItem m_menuItem_VelPicker;
    protected JMenuItem m_menuItem_Profile;
    protected JMenuItem m_menuItem_StackVolume;
    protected JMenuItem m_menuItem_Syn2D;
    protected JMenuItem m_menuItem_LWRS;
    protected JMenuItem m_menuItem_WellTop;
    protected JMenuItem m_menuItem_Snapshot;
    protected JMenuItem m_menuItem_ExportXtGeo;
    protected JMenuItem m_menuItem_V0KZ;

    public Menu_Stack(JMenuBar menuBar) {
        try {
            menuBar.add(this.m_menu);
            this.m_menuItem_VelPicker = this.addMenuItem(this.m_menu, "Stacking velocity picker");
            this.m_menuItem_Profile = this.addMenuItem(this.m_menu, "View stacks along profile");
            this.m_menu.addSeparator();
            this.m_menuItem_Snapshot = this.addMenuItem(this.m_menu, "Ensemble snapshot viewer");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void testThrowException() throws Exception {
        try {
            throw new Exception("Sample exception");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return;
        }
    }

    protected void exportXtGeo() {
        try {
            String fileName = Tools_Chooser.getFileName();
            Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
            int indexShotID = table.column_indexOfColumn("ShotID");
            int shotID = table.getInt(0, indexShotID);
            Ensemble e = new Ensemble();
            RefractionStaticsProject.singleton().ensemble_Shot(e, shotID, true);
            EnsembleTrace trace = e.trace(0);
            int numSamp = trace.data().length();
            int maxShots = Math.min(100, table.row_count());
            XtGeo_Exporter exporter = new XtGeo_Exporter(fileName, numSamp);
            exporter.setSingleIndexArray("Shot", "ShotID", maxShots);
            for (int n = 0; n < maxShots; ++n) {
                shotID = table.getInt(n, indexShotID);
                RefractionStaticsProject.singleton().ensemble_Shot(e, shotID, true);
                exporter.appendEnsemble(e, shotID, -9999, -9999);
                System.out.println(String.format("%d of %d", n, table.row_count()));
            }
            exporter.finishedAppending();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void v0kz() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (this.m_menuItem_V0KZ == e.getSource()) {
                this.v0kz();
                return;
            }
            if (this.m_menuItem_ExportXtGeo == e.getSource()) {
                this.exportXtGeo();
                return;
            }
            if (e.getSource() == this.m_menuItem_WellTop) {
                cm.showComponent(VolumeWellTopManagerWidget.class.getName(), "Well tops", "Well tops", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_LWRS) {
                cm.showComponent(LwrsWidget.class.getName(), "ULWS", "ULWS", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Snapshot) {
                cm.showComponent(Java2D_EnsembleSnapshotViewerWidget.class.getName(), "Snapshot scanner", "Snapshot scanner", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Profile) {
                cm.showComponent(StackProfileCompositeWidget.class.getName(), "Profile stacks", "Profile stacks", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_VelPicker) {
                cm.showComponent(StackingVelocityPickerWidget.class.getName(), "Stack velocity", "Stack velocity", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Syn2D) {
                cm.showComponent(Synthetic2DWidget.class.getName(), "2D synthetics", "2D synthetics", true);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

