/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.Timer;

public class StatusPane
extends LinearLayoutWidget
implements ActionListener {
    protected Timer m_timer = new Timer(120000, this);
    protected ArrayList<JLabel> m_list = new ArrayList();

    public StatusPane(int numPanels) {
        super(LinearLayoutWidget.Direction.Horizontal, 0, null);
        try {
            for (int n = 0; n < numPanels; ++n) {
                JLabel lbl = new JLabel();
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
                this.addComponent(lbl, 8);
                this.m_list.add(lbl);
            }
            this.m_timer.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                long start = System.currentTimeMillis();
                System.gc();
                long end = System.currentTimeMillis();
                long free = Runtime.getRuntime().freeMemory() / 1000000L;
                String s = String.format("Free memory: %d MB", free);
                this.m_list.get(0).setText(s);
                if (free < 50L) {
                    this.m_list.get(0).setForeground(Color.red);
                } else {
                    this.m_list.get(0).setForeground(Color.blue);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

