/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class PolygonUsageWidget
extends LinearLayoutWidget {
    protected JLabel m_statusLabel = new JLabel("Polygon okay");
    protected JCheckBox m_shotCheck = new JCheckBox("Shot must be inside polygon");
    protected JCheckBox m_recCheck = new JCheckBox("Receiver must be inside polygon");
    protected JCheckBox m_midCheck = new JCheckBox("Trace midpoint must be inside polygon");

    public PolygonUsageWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, "Polygon restrictions");
        try {
            this.addComponent(this.m_shotCheck, 0);
            this.addComponent(this.m_recCheck, 0);
            this.addComponent(this.m_midCheck, 0);
            this.updateChecks();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean midpointInside() {
        return this.m_midCheck.isSelected();
    }

    public boolean receiverInside() {
        return this.m_recCheck.isSelected();
    }

    public boolean shotInside() {
        return this.m_shotCheck.isSelected();
    }

    public void updateChecks() {
        try {
            boolean ok = RefractionStaticsProject.singleton().polygon().valid();
            this.m_shotCheck.setEnabled(ok);
            this.m_recCheck.setEnabled(ok);
            this.m_midCheck.setEnabled(ok);
            if (ok) {
                this.m_statusLabel.setText("Project polygon okay");
            } else {
                this.m_statusLabel.setText("Project polygon not defined");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

