/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileSelector
implements DocumentListener,
ActionListener {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    public JTextField m_txt = new JTextField();
    public JLabel m_lbl = new JLabel();
    public JButton m_btn = new JButton("Select...");
    public boolean RequireValidFileName = true;
    protected Color m_badColor = new Color(255, 200, 200);

    public FileSelector(GridLayoutWidget grid, int row, String label, GenericObjectListener.Listener listener) {
        try {
            this.m_lbl.setText(label);
            grid.addSimple(row, (Component)this.m_lbl, (Component)this.m_txt, (Component)this.m_btn, 0, 10, 0);
            this.m_txt.getDocument().addDocumentListener(this);
            this.m_btn.addActionListener(this);
            this.m_listenerManager.addListener(listener);
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public boolean fileExists() {
        try {
            return Tools_FileSystem.exists_file(this.m_txt.getText());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String s;
            if (e.getSource() == this.m_btn && (s = Tools_Chooser.getFileName()) != null) {
                this.m_txt.setText(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkName() {
        try {
            if (!this.RequireValidFileName) {
                this.m_txt.setBackground(Color.white);
                return;
            }
            if (!this.fileExists()) {
                this.m_txt.setBackground(this.m_badColor);
                return;
            }
            this.m_txt.setBackground(Color.white);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

