/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class DimensionSelectionWidget
extends LinearLayoutWidget
implements ActionListener {
    protected JRadioButton m_radio3D = new JRadioButton("3D");
    protected JRadioButton m_radio2D = new JRadioButton("2D");
    protected ButtonGroup m_radioGroup = new ButtonGroup();
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public DimensionSelectionWidget(int inset, String label) {
        super(LinearLayoutWidget.Direction.Horizontal, 0, label);
        try {
            this.addComponent(this.m_radio3D, 0);
            this.addComponent(this.m_radio2D, 0);
            this.addStretch(10);
            this.m_radioGroup.add(this.m_radio3D);
            this.m_radioGroup.add(this.m_radio2D);
            this.m_radio2D.addActionListener(this);
            this.m_radio3D.addActionListener(this);
            this.m_radio3D.setSelected(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setForce3D(boolean force3D) {
        try {
            if (force3D) {
                this.m_radio3D.setSelected(true);
                this.m_radio2D.setEnabled(false);
            } else {
                this.m_radio2D.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setDimension(String dim) {
        try {
            if (dim.equalsIgnoreCase("2D")) {
                this.m_radio2D.setSelected(true);
            } else {
                this.m_radio3D.setSelected(true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String dimension() {
        try {
            if (this.m_radio2D.isSelected()) {
                return this.m_radio2D.getText();
            }
            return this.m_radio3D.getText();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "3D";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

