/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class Segy_TraceHeaderWidget
extends LinearLayoutWidget
implements GenericObjectListener.Listener,
ActionListener,
ItemListener,
ChangeListener {
    protected Segy m_segy;
    protected boolean m_bIgnoreEvents = true;
    protected ScrollTable m_scrollTable = new ScrollTable();
    protected ScrollTable m_scrollTable_Data = new ScrollTable();
    protected JTextField m_firstTraceText = new JTextField("1");
    protected JSlider m_firstTraceSlider = new JSlider();
    protected JComboBox<String> m_typeCombo = new JComboBox();
    protected HeaderTableModel m_model = new HeaderTableModel();
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected Ensemble m_ensemble = new Ensemble();

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public Segy_TraceHeaderWidget(Segy segy) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_segy = segy;
            this.m_segy.getListenerController().addListener(this);
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            top.addComponent(this.m_typeCombo, 0);
            this.m_typeCombo.addItem("4-byte int");
            this.m_typeCombo.addItem("2-byte int");
            this.m_typeCombo.addItem("4-byte ieee float");
            this.m_typeCombo.addItem("4-byte ibm float");
            this.m_typeCombo.setSelectedIndex(0);
            this.m_typeCombo.addItemListener(this);
            this.m_model.setDataType(DataType.Int);
            this.m_firstTraceText.setMinimumSize(new Dimension(100, 13));
            this.m_firstTraceText.addActionListener(this);
            top.addComponent(this.m_firstTraceText, 2);
            top.addComponent(this.m_firstTraceSlider, 10);
            this.m_firstTraceSlider.addChangeListener(this);
            JTabbedPane tabs = new JTabbedPane();
            String html = this.create_help_html();
            if (html.length() > 10) {
                JEditorPane editorPane = new JEditorPane();
                editorPane.setContentType("text/html");
                editorPane.setEditable(false);
                editorPane.setText(html);
                tabs.addTab("Help", new JScrollPane(editorPane));
            }
            tabs.addTab("Trace header data", this.m_scrollTable);
            tabs.addTab("Trace data values", this.m_scrollTable_Data);
            this.addComponent(tabs, 10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String row(String table, String col, String comments) {
        try {
            String s = "<tr><td>" + table + "</td><td>" + col + "</td><td>" + comments + "</td></tr>";
            return s;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    protected String create_help_html() {
        try {
            Object s = "<html>";
            s = (String)s + "<head><style>";
            s = (String)s + "table { border-collapse: collapse; width: 80%; margin: 20px auto; }";
            s = (String)s + "th, td { border: 1px solid black; padding: 4px; text-align: left; }";
            s = (String)s + "th { background-color: #f2f2f2; }";
            s = (String)s + "body { font-family: Arial; }";
            s = (String)s + "</style></head>";
            s = (String)s + "<h2>Trace headers for prestack data</h2>";
            s = (String)s + "<p>For more information please visit https://library.seg.org/seg-technical-standards</p>";
            s = (String)s + "<p>Flatirons follows the SEG SPS standard for identifying shots and receivers. ";
            s = (String)s + "Each Shot and receiver is uniquely identified by three numbers, ";
            s = (String)s + "(LineNumber, PointNumber, PointIndex). Of the three only PointNumber is required, ";
            s = (String)s + "but LineNumber is highly recommended for 3D.";
            s = (String)s + "</p>";
            s = (String)s + "<body>";
            s = (String)s + "<table>";
            s = (String)s + "<tr><th>Table</th><th>Column</th><th>Comments</th></tr>";
            s = (String)s + this.row("Trace", "TraceCode", "Required. Used to mark live traces");
            s = (String)s + this.row("Receiver", "Easting", "Required");
            s = (String)s + this.row("Receiver", "Northing", "Required");
            s = (String)s + this.row("Receiver", "Elevation", "Required");
            s = (String)s + this.row("Receiver", "PointNumber", "Required");
            s = (String)s + this.row("Receiver", "LineNumber", "Optional. Recommended for 3D");
            s = (String)s + this.row("Receiver", "PointIndex", "Optional. Rarely used. Replant code");
            s = (String)s + this.row("Receiver", "PointDepth", "Optional. Recommended OBC and marine");
            s = (String)s + this.row("Receiver", "WaterDepth", "Optional. Recommended for OBC and marine");
            s = (String)s + this.row("Shot", "Easting", "Required");
            s = (String)s + this.row("Shot", "Northing", "Required");
            s = (String)s + this.row("Shot", "Elevation", "Required");
            s = (String)s + this.row("Shot", "PointNumber", "Required");
            s = (String)s + this.row("Shot", "LineNumber", "Optional. Recommended for 3D");
            s = (String)s + this.row("Shot", "PointIndex", "Optional. Usually just use FFID");
            s = (String)s + this.row("Shot", "PointDepth", "Optional. Recommended for dynamite, OBC and marine");
            s = (String)s + this.row("Shot", "WaterDepth", "Optional. Recommended for OBC and marine");
            s = (String)s + this.row("Shot", "UpholeTime", "Optional. Recommended for dynamite");
            s = (String)s + "</table>";
            s = (String)s + "</body>";
            s = (String)s + "</html>";
            return s;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    public byte[] firstTraceBytes() {
        return this.m_model.firstTraceBytes();
    }

    public int firstTrace() {
        try {
            return Integer.parseInt(this.m_firstTraceText.getText()) - 1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected void reload() {
        try {
            this.m_scrollTable.table().setModel(new DefaultTableModel());
            if (!this.m_segy.isFileOK()) {
                return;
            }
            int firstTrace = Integer.parseInt(this.m_firstTraceText.getText()) - 1;
            int bytesPerTrace = this.m_segy.bytesPerTrace();
            this.m_model.read(this.m_segy.fileName(), firstTrace, this.m_segy.binaryHeader().FileByteOrder, bytesPerTrace);
            this.m_scrollTable.table().setModel(this.m_model);
            try {
                this.m_ensemble.clearTraces(false);
                this.m_segy.populateEnsemble(this.m_ensemble, firstTrace, 10, true, true);
                this.m_scrollTable_Data.table().setModel(new DataTableModel(firstTrace, this.m_ensemble));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (this.m_bIgnoreEvents) {
                return;
            }
            this.m_bIgnoreEvents = true;
            this.m_firstTraceText.setText(Integer.toString(1 + this.m_firstTraceSlider.getValue()));
            this.reload();
            this.m_bIgnoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_bIgnoreEvents) {
                return;
            }
            if (this.m_typeCombo.getSelectedIndex() == 0) {
                this.m_model.setDataType(DataType.Int);
            }
            if (this.m_typeCombo.getSelectedIndex() == 1) {
                this.m_model.setDataType(DataType.Short);
            }
            if (this.m_typeCombo.getSelectedIndex() == 2) {
                this.m_model.setDataType(DataType.Float);
            }
            if (this.m_typeCombo.getSelectedIndex() == 3) {
                this.m_model.setDataType(DataType.FloatIBM);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_bIgnoreEvents) {
                return;
            }
            this.m_bIgnoreEvents = true;
            int firstTrace = Integer.parseInt(this.m_firstTraceText.getText()) - 1;
            firstTrace = Math.max(firstTrace, 0);
            this.m_firstTraceSlider.setValue(firstTrace);
            this.reload();
            this.m_bIgnoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_segy) {
                this.m_bIgnoreEvents = true;
                this.m_typeCombo.setEnabled(this.m_segy.isFileOK());
                this.m_firstTraceSlider.setEnabled(this.m_segy.isFileOK());
                this.m_firstTraceText.setEnabled(this.m_segy.isFileOK());
                if (!this.m_segy.isFileOK()) {
                    return;
                }
                int numTraces = (int)this.m_segy.traceCount();
                if (this.m_firstTraceSlider.getValue() > numTraces - 8) {
                    int v = numTraces - 8;
                    v = Math.max(v, 0);
                    this.m_firstTraceSlider.setValue(v);
                    this.m_firstTraceText.setText(Integer.toString(v));
                }
                this.m_firstTraceSlider.setMaximum(numTraces - 8);
                this.reload();
                this.m_bIgnoreEvents = false;
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public class HeaderTableModel
    extends AbstractTableModel {
        protected ArrayList<String> m_labelList = new ArrayList();
        protected ArrayList<ByteBuffer> m_bufferList = new ArrayList();
        protected DataType m_type = DataType.Int;
        protected int m_numValid = 0;
        protected byte[] m_tempBytes = new byte[240];
        protected byte[] m_firstTraceBytes = new byte[240];
        protected ArrayList<String> m_twoByte = new ArrayList();
        protected ArrayList<String> m_fourByte = new ArrayList();

        public HeaderTableModel() {
            try {
                int n;
                for (n = 0; n < 10; ++n) {
                    this.m_labelList.add("Not set");
                    this.m_bufferList.add(ByteBuffer.allocate(240));
                }
                for (n = 1; n <= 240; ++n) {
                    this.m_twoByte.add(String.format("%d - %d", n, n + 1));
                    this.m_fourByte.add(String.format("%d - %d", n, n + 3));
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void clear() {
            try {
                this.m_numValid = 0;
                this.fireTableStructureChanged();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setDataType(DataType type) {
            try {
                this.m_type = type;
                this.fireTableStructureChanged();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void read(String fileName, int firstTraceIndex, ByteOrder order, int bytesPerTrace) {
            try {
                this.m_numValid = 0;
                RandomAccessFile reader = new RandomAccessFile(fileName, "r");
                if (reader.length() < 3600L) {
                    reader.close();
                    return;
                }
                long fileLength = reader.length();
                for (int n = firstTraceIndex; n < firstTraceIndex + 10; ++n) {
                    long off = 3600L + (long)n * (long)bytesPerTrace;
                    if (off < 3600L || off >= fileLength) continue;
                    reader.seek(off);
                    if (reader.read(this.m_tempBytes, 0, 240) != 240) continue;
                    ByteBuffer buff = this.m_bufferList.get(this.m_numValid);
                    buff.rewind();
                    buff.put(this.m_tempBytes);
                    buff.order(order);
                    this.m_labelList.set(this.m_numValid, Integer.toString(n + 1));
                    if (this.m_numValid == 0) {
                        System.arraycopy(this.m_tempBytes, 0, this.m_firstTraceBytes, 0, 240);
                    }
                    ++this.m_numValid;
                }
                reader.close();
                this.fireTableStructureChanged();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public byte[] firstTraceBytes() {
            return this.m_firstTraceBytes;
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Bytes";
                }
                return this.m_labelList.get(column - 1);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            if (this.m_type == DataType.Short) {
                return 239;
            }
            return 237;
        }

        @Override
        public int getColumnCount() {
            return 1 + this.m_numValid;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (column == 0) {
                    if (this.m_type == DataType.Short) {
                        return this.m_twoByte.get(row);
                    }
                    return this.m_fourByte.get(row);
                }
                int index = column - 1;
                if (index < 0 || index >= this.m_numValid) {
                    return "Index error";
                }
                ByteBuffer buff = this.m_bufferList.get(index);
                if (this.m_type == DataType.Short) {
                    return Integer.toString(buff.getShort(row));
                }
                if (this.m_type == DataType.Int) {
                    return Integer.toString(buff.getInt(row));
                }
                if (this.m_type == DataType.Float) {
                    return Float.toString(buff.getFloat(row));
                }
                if (this.m_type == DataType.Long) {
                    return Long.toString(buff.getLong(row));
                }
                if (this.m_type == DataType.FloatIBM) {
                    float f = Tools_ByteArray.extractFloatUsingIBM(buff.array(), row);
                    return Float.toString(f);
                }
                return "Bad type";
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return "Error";
            }
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        protected Ensemble m_ensemble;
        protected int m_firstTrace;

        public DataTableModel(int firstTrace, Ensemble ensemble) {
            this.m_ensemble = ensemble;
            this.m_firstTrace = firstTrace;
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column >= 1) {
                    return Integer.toString(column + this.m_firstTrace);
                }
                return " ";
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            try {
                if (this.m_ensemble == null) {
                    return 0;
                }
                if (this.m_ensemble.traceCount() < 1) {
                    return 0;
                }
                return this.m_ensemble.trace(0).data().length();
            }
            catch (Exception error) {
                error.printStackTrace();
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            try {
                if (this.m_ensemble == null) {
                    return 0;
                }
                if (this.m_ensemble.traceCount() < 1) {
                    return 0;
                }
                return 1 + this.m_ensemble.traceCount();
            }
            catch (Exception error) {
                error.printStackTrace();
                return 0;
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (this.m_ensemble == null) {
                    return "Error";
                }
                if (this.m_ensemble.traceCount() < 1) {
                    return "Error";
                }
                if (column >= 1) {
                    return this.m_ensemble.trace(column - 1).data().getStringValue(row);
                }
                return Integer.toString(row);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return "Error";
            }
        }
    }
}

