/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Segy.Segy_DictionaryEditorWidget;
import com.PecosLibrary.Windows.Segy.Segy_EbcdicWidget;
import com.PecosLibrary.Windows.Segy.Segy_FileHeaderWidget;
import com.PecosLibrary.Windows.Segy.Segy_TraceHeaderWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class Segy_MainWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener {
    protected Segy m_segy;
    protected Segy_Dictionary m_dict;
    protected JSplitPane m_topSplitter = new JSplitPane(1);
    protected Segy_TraceHeaderWidget m_traceHeaderWidget;
    protected FileWidget m_fileWidget;
    protected Segy_DictionaryEditorWidget m_dictWidget;

    public Segy_MainWidget(Segy segy, Segy_Dictionary dict) {
        super(0);
        try {
            this.m_segy = segy;
            this.m_dict = dict;
            this.m_topSplitter.setLeftComponent(this.createTopLeftWidgets());
            this.m_topSplitter.setRightComponent(this.createTopRightWidgets());
            this.setTopComponent(this.m_topSplitter);
            this.m_dictWidget = new Segy_DictionaryEditorWidget(segy, dict, false);
            this.setBottomComponent(this.m_dictWidget);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createTopRightWidgets() {
        try {
            this.m_traceHeaderWidget = new Segy_TraceHeaderWidget(this.m_segy);
            this.m_traceHeaderWidget.getListenerController().addListener(this);
            return this.m_traceHeaderWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createTopLeftWidgets() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_fileWidget = new FileWidget(false, true, 3, "SEG-Y file name", this);
            w.addComponent(this.m_fileWidget, 0);
            JTabbedPane tabs = new JTabbedPane();
            w.addComponent(tabs, 10);
            tabs.addTab("File header", new Segy_FileHeaderWidget(this.m_segy));
            tabs.addTab("EBCDIC", new Segy_EbcdicWidget(this.m_segy));
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void createChunks(boolean blank) {
        try {
            if (!this.m_segy.isFileOK()) {
                JOptionPane.showMessageDialog(null, "SEG-Y file not valid", "SEG-Y file not valid", 0);
                return;
            }
            String fileName = this.m_segy.fileName() + "_first";
            int numBytes = 3600 + 20000 * this.m_segy.bytesPerTrace();
            RandomAccessFile reader = new RandomAccessFile(this.m_segy.fileName(), "r");
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes + 1000000);
            reader.read(buffer.array(), 0, numBytes);
            reader.close();
            if (blank) {
                for (int n = 0; n < 3200; ++n) {
                    buffer.array()[n] = 0;
                }
            }
            RandomAccessFile writer = new RandomAccessFile(fileName, "rw");
            writer.write(buffer.array(), 0, numBytes);
            writer.close();
            JOptionPane.showMessageDialog(null, fileName, "SEG-Y sample file created", 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_traceHeaderWidget) {
                this.m_dict.setTestData(this.m_traceHeaderWidget.firstTraceBytes(), this.m_traceHeaderWidget.firstTrace(), this.m_segy.binaryHeader().FileByteOrder);
                return;
            }
            if (sender == this.m_fileWidget) {
                if (data != null && data instanceof String) {
                    String s = (String)data;
                    if (s.equalsIgnoreCase(FileWidget.SegyChunksNE)) {
                        this.createChunks(true);
                        return;
                    }
                    if (s.equalsIgnoreCase(FileWidget.SegyChunks)) {
                        this.createChunks(false);
                        return;
                    }
                }
                this.m_segy.setFileName(this.m_fileWidget.getText());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

