/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Data.DataType;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.Segy.AppFrame_Segy;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;

public class Segy_DictionaryEditorWidget
extends LinearLayoutWidget
implements ActionListener {
    protected JTextField m_fileNameTextField = new JTextField();
    protected JButton m_openButton;
    protected JButton m_saveButton;
    protected JButton m_saveAsButton;
    protected JButton m_newButton;
    protected JButton m_dialogButton;
    protected JLabel m_testTraceLabel = new JLabel("", 4);
    protected JTable m_table = new JTable();
    protected JComboBox<String> m_columnEditorComboBox = new JComboBox();
    protected JComboBox<String> m_tableEditorComboBox = new JComboBox();
    protected JComboBox<String> m_headerTypeComboBox = new JComboBox();
    protected JComboBox<String> m_databaseTypeComboBox = new JComboBox();
    protected JComboBox<String> m_modificationComboBox = new JComboBox();
    protected JCheckBox m_validCheckBox = new JCheckBox();
    protected JButton m_sortOffsetButton;
    protected JButton m_sortNameButton;
    protected JButton m_removeAllButton;
    protected JButton m_removeSelectedButton;
    protected JButton m_addEntryButton;
    protected JButton m_postStackButton;
    protected Segy m_segy;
    protected Segy_Dictionary m_dict;

    public Segy_DictionaryEditorWidget(Segy segy, Segy_Dictionary dict, boolean editor) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_segy = segy;
            this.m_dict = dict;
            this.makeTopWidget(editor);
            this.makeBottomWidget();
            this.setFileNameInfo();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makeBottomWidget() {
        try {
            LinearLayoutWidget mainWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 10);
            LinearLayoutWidget leftWidget = mainWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null, 0);
            this.m_sortNameButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Down, "Sort using table/column", (ActionListener)this);
            this.m_sortOffsetButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Down, "Sort using offset", (ActionListener)this);
            leftWidget.createGapLabel(20);
            this.m_addEntryButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Add, "Add entry", (ActionListener)this);
            leftWidget.createGapLabel(20);
            this.m_postStackButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Stack, "Default post-stack map", (ActionListener)this);
            leftWidget.createGapLabel(20);
            this.m_removeAllButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.DeleteAll, "Remove all entries", (ActionListener)this);
            this.m_removeSelectedButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Delete, "Remove selected", (ActionListener)this);
            leftWidget.addStretch(10);
            JScrollPane scroller = new JScrollPane(this.m_table);
            this.m_table.setGridColor(Color.LIGHT_GRAY);
            this.m_table.setShowGrid(true);
            this.m_table.setModel(this.m_dict);
            this.m_table.setAutoResizeMode(0);
            mainWidget.addComponent(scroller, 10);
            int rowHeight = this.m_table.getRowHeight();
            rowHeight = Math.max(rowHeight, 12);
            this.m_table.setRowHeight(rowHeight + 6);
            this.m_columnEditorComboBox.addItem("Easting");
            this.m_columnEditorComboBox.addItem("Northing");
            this.m_columnEditorComboBox.addItem("Elevation");
            this.m_columnEditorComboBox.addItem("WaterDepth");
            this.m_columnEditorComboBox.addItem("PointDepth");
            this.m_columnEditorComboBox.addItem("UpholeTime");
            this.m_columnEditorComboBox.addItem("Sensor");
            this.m_columnEditorComboBox.addItem("LineNumber");
            this.m_columnEditorComboBox.addItem("PointNumber");
            this.m_columnEditorComboBox.addItem("FFID");
            this.m_columnEditorComboBox.addItem("FBP_User");
            this.m_columnEditorComboBox.addItem("SegyScalar_Coord");
            this.m_columnEditorComboBox.addItem("SegyScalar_Elevation");
            this.m_columnEditorComboBox.addItem("SegyScalar_Time");
            this.m_columnEditorComboBox.addItem("Azimuth");
            this.m_columnEditorComboBox.addItem("Offset");
            this.m_columnEditorComboBox.addItem("CdpX");
            this.m_columnEditorComboBox.addItem("CdpY");
            this.m_columnEditorComboBox.addItem("Inline");
            this.m_columnEditorComboBox.addItem("Crossline");
            this.m_columnEditorComboBox.setEditable(true);
            TableColumn col = this.m_table.getColumnModel().getColumn(1);
            col.setCellEditor(new DefaultCellEditor(this.m_columnEditorComboBox));
            this.m_tableEditorComboBox.addItem("Receiver");
            this.m_tableEditorComboBox.addItem("Shot");
            this.m_tableEditorComboBox.addItem("Trace");
            this.m_tableEditorComboBox.addItem("CDP");
            this.m_tableEditorComboBox.addItem("None");
            col = this.m_table.getColumnModel().getColumn(0);
            col.setCellEditor(new DefaultCellEditor(this.m_tableEditorComboBox));
            this.m_modificationComboBox.addItem(Segy_Dictionary.Modification.None.Description);
            this.m_modificationComboBox.addItem(Segy_Dictionary.Modification.FactorDivide.Description);
            this.m_modificationComboBox.addItem(Segy_Dictionary.Modification.FactorRemainder.Description);
            this.m_modificationComboBox.addItem(Segy_Dictionary.Modification.ElevationScalar.Description);
            this.m_modificationComboBox.addItem(Segy_Dictionary.Modification.CoordScalar.Description);
            this.m_modificationComboBox.addItem(Segy_Dictionary.Modification.TimeScalar.Description);
            col = this.m_table.getColumnModel().getColumn(4);
            col.setCellEditor(new DefaultCellEditor(this.m_modificationComboBox));
            this.m_databaseTypeComboBox.addItem(DataType.Double.Description);
            this.m_databaseTypeComboBox.addItem(DataType.Int.Description);
            this.m_databaseTypeComboBox.addItem(DataType.Float.Description);
            col = this.m_table.getColumnModel().getColumn(6);
            col.setCellEditor(new DefaultCellEditor(this.m_databaseTypeComboBox));
            this.m_headerTypeComboBox.addItem(DataType.Short.Description);
            this.m_headerTypeComboBox.addItem(DataType.Int.Description);
            this.m_headerTypeComboBox.addItem(DataType.Float.Description);
            this.m_headerTypeComboBox.addItem(DataType.FloatIBM.Description);
            this.m_headerTypeComboBox.addItem(DataType.Byte.Description);
            col = this.m_table.getColumnModel().getColumn(2);
            col.setCellEditor(new DefaultCellEditor(this.m_headerTypeComboBox));
            this.m_table.getColumnModel().getColumn(0).setMinWidth(80);
            this.m_table.getColumnModel().getColumn(1).setMinWidth(140);
            this.m_table.getColumnModel().getColumn(2).setMinWidth(60);
            this.m_table.getColumnModel().getColumn(6).setMinWidth(90);
            this.m_table.getColumnModel().getColumn(4).setMinWidth(220);
            this.m_table.getColumnModel().getColumn(3).setMinWidth(60);
            this.m_table.getColumnModel().getColumn(5).setMinWidth(60);
            if (this.m_dict.ShowTestColumnsInTable) {
                this.m_table.getColumnModel().getColumn(10).setMinWidth(140);
                this.m_table.getColumnModel().getColumn(9).setMinWidth(140);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makeTopWidget(boolean editor) {
        try {
            LinearLayoutWidget w = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            w.createGapLabel(28, 10);
            w.addComponent(this.m_fileNameTextField, 10);
            Tools_FontChanger.changeSizeOfFont(this.m_fileNameTextField, -2);
            this.m_openButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileOpen, "Open existing dictionary", (ActionListener)this);
            this.m_saveButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSave, "Save dictionary", (ActionListener)this);
            this.m_saveAsButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSaveAs, "Save to new file", (ActionListener)this);
            this.m_newButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileNew, "New dictionary", (ActionListener)this);
            w.addStretch(10);
            if (editor) {
                this.m_dialogButton = w.createButton("Editor...", this, 0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String fileName;
            if (e.getSource() == this.m_dialogButton) {
                String file = this.m_dict.getFileName();
                AppFrame_Segy dlg = new AppFrame_Segy(true);
                this.m_dict.setFileName(file);
            }
            if (e.getSource() == this.m_sortNameButton) {
                this.m_dict.sortByTableColumn();
                return;
            }
            if (e.getSource() == this.m_sortOffsetButton) {
                this.m_dict.sortByOffset();
                return;
            }
            if (e.getSource() == this.m_addEntryButton) {
                this.m_dict.addEntry("None", "NotSet", DataType.Short, DataType.Double, 0, Segy_Dictionary.Modification.None, 0);
                return;
            }
            if (e.getSource() == this.m_removeAllButton) {
                int res = JOptionPane.showConfirmDialog(this, "Okay to remove all entries?", "Confirm delete", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.m_dict.removeAll();
                return;
            }
            if (e.getSource() == this.m_postStackButton) {
                this.m_dict.removeAll();
                this.m_dict.addPostStackSegyRev1();
                return;
            }
            if (e.getSource() == this.m_removeSelectedButton) {
                int row = this.m_table.getSelectedRow();
                if (row >= 0 && row < this.m_dict.getRowCount()) {
                    this.m_dict.removeEntry(row);
                }
                return;
            }
            if (e.getSource() == this.m_saveButton) {
                if (!this.m_dict.isFileNameValid()) {
                    this.m_fileNameTextField.setText("Open or create a new dictionary");
                    return;
                }
                this.m_dict.save();
                return;
            }
            if (e.getSource() == this.m_saveAsButton) {
                fileName = Tools_Chooser.getSaveFileName(Segy_Dictionary.FileSuffix);
                if (fileName == null) {
                    return;
                }
                this.m_dict.setFileName(fileName);
                this.setFileNameInfo();
                return;
            }
            if (e.getSource() == this.m_newButton) {
                fileName = Tools_Chooser.getSaveFileName(Segy_Dictionary.FileSuffix);
                if (fileName == null) {
                    return;
                }
                this.m_dict.removeAll();
                this.m_dict.addDefaultEntries();
                this.m_dict.setFileName(fileName);
                this.setFileNameInfo();
                return;
            }
            if (e.getSource() == this.m_openButton) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter(" Segy dictionary", Segy_Dictionary.FileSuffix);
                String fileName2 = Tools_Chooser.getFileName("Select Segy dictionary file", filter);
                if (fileName2 == null) {
                    return;
                }
                this.m_dict.setOpenFileName(fileName2);
                this.setFileNameInfo();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setFileNameInfo() {
        try {
            this.m_fileNameTextField.setEditable(false);
            boolean enable = true;
            if (!this.m_dict.isFileNameValid()) {
                this.m_fileNameTextField.setText("Open or create a new dictionary");
                enable = false;
            } else {
                this.m_fileNameTextField.setText(this.m_dict.getFileName());
            }
            this.m_saveAsButton.setEnabled(enable);
            this.m_saveButton.setEnabled(enable);
            this.m_postStackButton.setEnabled(enable);
            this.m_sortNameButton.setEnabled(enable);
            this.m_sortOffsetButton.setEnabled(enable);
            this.m_addEntryButton.setEnabled(enable);
            this.m_removeAllButton.setEnabled(enable);
            this.m_removeSelectedButton.setEnabled(enable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

