/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Tomography.VNS;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewTomoVNSDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
ChangeListener {
    protected InitialVelocitySource m_initialVelocitySource;
    public boolean OK = false;
    protected Java2D_SimpleComposite m_widget;
    protected JTextField m_txtAngle = new JTextField("0");
    protected JTextField m_txtSize = new JTextField("300");
    protected JTextField m_txtName = new JTextField("aaa");
    protected JTextField m_txtDepth = new JTextField("400");
    protected JTextField m_txtSizeVertTop = new JTextField("30");
    protected JTextField m_txtSizeVertBottom = new JTextField("100");
    protected JTextField m_txtBlockThick1 = new JTextField("200");
    protected JTextField m_txtBlockSpacing1 = new JTextField("40");
    protected JTextField m_txtBlockThick2 = new JTextField("400");
    protected JTextField m_txtBlockSpacing2 = new JTextField("80");
    protected JTextField m_txtBlockThick3 = new JTextField("600");
    protected JTextField m_txtBlockSpacing3 = new JTextField("100");
    protected JTabbedPane m_nodeTabs = new JTabbedPane();
    protected JTextField m_txtSizeHorz = new JTextField("100");
    protected ComboStringListWrapper m_comboVersion = new ComboStringListWrapper();
    protected JTextField m_txtVelTop_Depth = new JTextField("3000");
    protected JTextField m_txtVelBottom_Depth = new JTextField("6000");
    protected JTextField m_txtVelTop_Z = new JTextField("3000");
    protected JTextField m_txtVelBottom_Z = new JTextField("6000");
    protected JTextField m_txtMaxZ = new JTextField("1000");
    protected JTextField m_txtMinZ = new JTextField("-3000");
    protected JComboBox<String> m_cmbVelMethod = new JComboBox();
    protected JCheckBox m_chkMarine = new JCheckBox("Marine survey - keep water velocity fixed");
    protected JTextField m_txtWaterVelocity = new JTextField("1500");
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected JLabel m_lblStatusVersion = new JLabel("okay");
    protected JLabel m_lblStatus = new JLabel("");
    protected JLabel m_lblNumInline = new JLabel("", 4);
    protected JLabel m_lblNumCrossline = new JLabel("", 4);
    protected JLabel m_lblNumZ = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected JButton m_btnCreate;
    protected JButton m_btnCancel;
    protected Java2D_UserEventConsumer_Line m_lineUEC = new Java2D_UserEventConsumer_Line();
    protected Tomo_VNS m_tomo3D;
    protected boolean m_versionOkay = false;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_recPaintable = null;
    protected boolean m_first = true;

    public NewTomoVNSDialog(InitialVelocitySource initialVelocitySource) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_initialVelocitySource = initialVelocitySource;
            this.getContentPane().setLayout(new BorderLayout());
            JSplitPane splitter = new JSplitPane(1);
            LinearLayoutWidget right = LinearLayoutWidget.vert(0, null);
            this.m_widget = new Java2D_SimpleComposite(true);
            this.m_widget.setAxesVisible(true, true);
            this.m_widget.setScrollVisible(true, true);
            right.addComponent(new JLabel("Left click and drag to define grid angle"), 0);
            right.addComponent(this.m_widget, 10);
            splitter.setRightComponent(right);
            this.m_lineUEC.addListener(this);
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            int row = 0;
            GridLayoutWidget grid = main.createGridLayoutWidget(5, "Model parameters", 0);
            grid.addSimple(row++, new JLabel("Grid angle (degrees)"), this.m_txtAngle);
            grid.addSimple(row++, new JLabel("Horizontal node spacing (ft/m)"), this.m_txtSizeHorz);
            grid.addSimple(row++, new JLabel("Name"), this.m_txtName);
            if (project.units_feet()) {
                this.m_txtSizeHorz.setText("100");
            } else {
                this.m_txtSizeHorz.setText("30");
            }
            LinearLayoutWidget nodeSpacingMain = main.createVertical(0, "Vertical node spacing options", 0);
            nodeSpacingMain.addComponent(this.m_nodeTabs, 0);
            LinearLayoutWidget main2 = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            main2.addComponent(new JLabel("Linear increase with depth"), 0);
            grid = main2.createGridLayoutWidget(5, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Vertical node spacing at surface (ft/m)"), this.m_txtSizeVertTop);
            grid.addSimple(row++, new JLabel("Vertical node spacing at max depth(ft/m)"), this.m_txtSizeVertBottom);
            grid.addSimple(row++, new JLabel("Model depth (ft/m)"), this.m_txtDepth);
            main2.addStretch(10);
            this.m_nodeTabs.addTab("Linear", main2);
            if (project.units_feet()) {
                this.m_txtSizeVertTop.setText("50");
                this.m_txtSizeVertBottom.setText("150");
                this.m_txtDepth.setText("3000");
            } else {
                this.m_txtSizeVertTop.setText("15");
                this.m_txtSizeVertBottom.setText("50");
                this.m_txtDepth.setText("1000");
            }
            LinearLayoutWidget main3 = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            main3.addComponent(new JLabel("Node spacing constant within sections"), 0);
            grid = main3.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel("First section node spacing (ft/m)"), this.m_txtBlockSpacing1);
            grid.addSimple(row++, new JLabel("First section thickness (ft/m)"), this.m_txtBlockThick1);
            grid.addSimple(row++, new JLabel("Second section node spacing (ft/m)"), this.m_txtBlockSpacing2);
            grid.addSimple(row++, new JLabel("Second section thickness (ft/m)"), this.m_txtBlockThick2);
            grid.addSimple(row++, new JLabel("Third section node spacing (ft/m)"), this.m_txtBlockSpacing3);
            grid.addSimple(row++, new JLabel("Third section thickness (ft/m)"), this.m_txtBlockThick3);
            this.m_nodeTabs.addTab("Sections", main3);
            this.m_nodeTabs.addChangeListener(this);
            this.m_txtBlockSpacing1.addActionListener(this);
            this.m_txtBlockThick1.addActionListener(this);
            this.m_txtBlockSpacing2.addActionListener(this);
            this.m_txtBlockThick2.addActionListener(this);
            this.m_txtBlockSpacing3.addActionListener(this);
            this.m_txtBlockThick3.addActionListener(this);
            if (this.m_initialVelocitySource == InitialVelocitySource.Linear) {
                grid = main.createGridLayoutWidget(0, "Initial velocity field", 0);
                row = 0;
                this.m_cmbVelMethod.addItem("Velocity is a function of depth");
                this.m_cmbVelMethod.addItem("Velocity is a function of elevation");
                this.m_cmbVelMethod.addItemListener(this);
                grid.addSimple(row++, new JLabel(" "), this.m_cmbVelMethod);
                grid.addSimple(row++, new JLabel("Velocity at surface"), this.m_txtVelTop_Depth);
                grid.addSimple(row++, new JLabel("Velocity at max depth"), this.m_txtVelBottom_Depth);
                grid.addSimple(row++, new JLabel("Maximum elevation"), this.m_txtMaxZ);
                grid.addSimple(row++, new JLabel("Minimum elevation"), this.m_txtMinZ);
                grid.addSimple(row++, new JLabel("Velocity at maximum elevation"), this.m_txtVelTop_Z);
                grid.addSimple(row++, new JLabel("Velocity at minimum elevation"), this.m_txtVelBottom_Z);
                this.m_txtVelTop_Depth.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 0);
                this.m_txtVelBottom_Depth.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 0);
                if (project.units_feet()) {
                    this.m_txtVelTop_Depth.setText("3000");
                    this.m_txtVelBottom_Depth.setText("18000");
                } else {
                    this.m_txtVelTop_Depth.setText("1000");
                    this.m_txtVelBottom_Depth.setText("6000");
                }
                this.m_txtMaxZ.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
                this.m_txtMinZ.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
                this.m_txtVelTop_Z.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
                this.m_txtVelBottom_Z.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
            }
            JLabel lbl = new JLabel("<html><font color=\"red\">1) Both Shot and Receiver tables must have valid WaterDepth column<br>2) The surface elevation will be forced to zero<br> 3) The shot/receiver depths should be in PointDepth columns</font><br> </html>");
            LinearLayoutWidget sub = main.createVertical(0, "Marine survey options", 0);
            sub.addComponent(lbl, 0);
            sub.addComponent(this.m_chkMarine, 0);
            sub.addHorzPair(new JLabel("Water velocity"), 0, this.m_txtWaterVelocity, 4);
            main.createGapLabel(12);
            grid = main.createGridLayoutWidget(0, "Model size", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Inline node count"), this.m_lblNumInline);
            grid.addSimple(row++, new JLabel("Crossline node count"), this.m_lblNumCrossline);
            grid.addSimple(row++, new JLabel("Depth node count"), this.m_lblNumZ);
            grid.addSimple(row++, new JLabel("Total model memory (MB)"), this.m_lblMemory);
            main.addStretch(10);
            this.m_txtAngle.addActionListener(this);
            this.m_txtSize.addActionListener(this);
            this.m_txtSizeHorz.addActionListener(this);
            this.m_txtSizeVertTop.addActionListener(this);
            this.m_txtSizeVertBottom.addActionListener(this);
            this.m_txtDepth.addActionListener(this);
            splitter.setLeftComponent(main);
            this.getContentPane().add((Component)splitter, "Center");
            LinearLayoutWidget bottom = LinearLayoutWidget.horz(0, null);
            this.m_btnCreate = bottom.createButton("Create new model", this, 0);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            bottom.addComponent(this.m_lblStatus, 33);
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(950, 950);
            this.setTitle("Create new 3D TomoVNS model");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            this.reload();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.m_txtVelTop_Depth.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 0);
            this.m_txtVelBottom_Depth.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 0);
            this.m_txtMaxZ.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
            this.m_txtMinZ.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
            this.m_txtVelTop_Z.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
            this.m_txtVelBottom_Z.setEnabled(this.m_cmbVelMethod.getSelectedIndex() == 1);
            this.m_comboVersion.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.reload();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected Java2D_Paintable_Table createPT(String tableName, String colX, String colY) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            String colID = tableName + "ID";
            String query = String.format("SELECT  %s, %s, %s FROM %s WHERE KILLED = FALSE", colX, colY, colID, tableName);
            Table_Abstract table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
            painter.setTable(table);
            painter.UseColorScale = false;
            painter.FixedColor = Color.BLACK;
            painter.Symbol = Java2D_PointSymbol.Plus;
            painter.DrawMoveVectors = false;
            painter.Size_UsePixel = true;
            painter.Size_Pixel = 3;
            painter.setAxisX(colX);
            painter.setAxisY(colY);
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected boolean nameOkay() {
        try {
            String name = this.m_txtName.getText();
            if (name == null) {
                JOptionPane.showMessageDialog(null, "Please enter a name", "Cannot create model", 0);
                return false;
            }
            name = Tools_Strings.removeCrap(name, true);
            this.m_txtName.setText(name);
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return false;
            }
            String path = RefractionStaticsProject.singleton().tomoVNSProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return false;
            }
            if (name.equalsIgnoreCase("ShotRecStacks")) {
                JOptionPane.showMessageDialog(null, "Invalid name", "Cannot create model", 0);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void createNew() {
        try {
            int res;
            if (!this.nameOkay()) {
                return;
            }
            String name = this.m_txtName.getText();
            int mb = this.createTomo3D(false);
            if (mb > 500 && (res = JOptionPane.showConfirmDialog(null, "This model will require " + Integer.toString(mb) + " MB of memory. \nDo you still want to create the model?", "", 0)) != 0) {
                return;
            }
            mb = this.createTomo3D(true);
            if (this.m_initialVelocitySource == InitialVelocitySource.Linear) {
                if (this.m_cmbVelMethod.getSelectedIndex() == 0) {
                    v1 = Tools_Widget.extractDouble(this.m_txtVelTop_Depth, 3000.0, 700.0, 20000.0);
                    double v2 = Tools_Widget.extractDouble(this.m_txtVelBottom_Depth, 2.0 * v1, 1.1 * v1, 8.0 * v1);
                    this.m_tomo3D.setVelocityGradient(v1, v2);
                } else {
                    v1 = Tools_Widget.extractDouble(this.m_txtVelTop_Z, 3000.0, 700.0, 20000.0);
                    double v2 = Tools_Widget.extractDouble(this.m_txtVelBottom_Z, 2.0 * v1, 1.1 * v1, 8.0 * v1);
                    double maxz = Tools_Widget.extractDouble(this.m_txtMaxZ, 3000.0, -2000.0, 20000.0);
                    double minz = Tools_Widget.extractDouble(this.m_txtMinZ, 3000.0, v1 - 100000.0, v1);
                    this.m_tomo3D.setVelocityGradientZ(v1, v2, maxz, minz);
                }
                this.m_tomo3D.prepWaterVelocity();
            }
            if (this.m_initialVelocitySource == InitialVelocitySource.InteractivePicks) {
                this.m_tomo3D.computeVelocityUsingPicks();
                this.m_tomo3D.prepWaterVelocity();
            }
            this.m_tomo3D.prepWaterVelocity();
            Java2D_Polygon poly = RefractionStaticsProject.singleton().polygon();
            if (poly != null) {
                // empty if block
            }
            this.m_tomo3D.ray_cover_clear(true);
            this.m_tomo3D.save(name);
            RefractionStaticsProject.singleton().setTomo_VNS(this.m_tomo3D);
            this.OK = true;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean marineTableOkay(Table_Abstract tbl) {
        try {
            if (!tbl.column_exists("WaterDepth")) {
                return false;
            }
            return tbl.column_exists("PointDepth");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean checkMarineOkay() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Table_Abstract shotTable = project.shotTable();
            Table_Abstract recTable = project.receiverTable();
            return this.marineTableOkay(shotTable) && this.marineTableOkay(recTable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected int createTomo3D(boolean allocateMemory) {
        try {
            double angle = Math.PI * Tools_Widget.extractDouble(this.m_txtAngle, 0.0, -360.0, 360.0) / 180.0;
            double sizeX = Tools_Widget.extractDouble(this.m_txtSizeHorz, 50.0, 1.0, 1000.0);
            double sizeZ1 = Tools_Widget.extractDouble(this.m_txtSizeVertTop, 50.0, 1.0, 1000.0);
            double sizeZ2 = Tools_Widget.extractDouble(this.m_txtSizeVertBottom, sizeZ1, sizeZ1, sizeZ1 + 1000.0);
            double maxDepth = Tools_Widget.extractDouble(this.m_txtDepth, 5.0 * sizeZ2, 3.0 * sizeZ2, 500.0 * sizeZ2);
            boolean forceMarine = this.m_chkMarine.isSelected();
            double waterVelocity = Tools_Widget.extractDouble(this.m_txtWaterVelocity, 1500.0, 1400.0, 6000.0);
            if (forceMarine && !this.checkMarineOkay()) {
                forceMarine = false;
                JOptionPane.showMessageDialog(null, "Cannot treat as marine survey, required columns not valid", "", 0);
            }
            float[] nodeDepth = Tomo_VNS.computeNodeDepths(maxDepth, sizeZ1, sizeZ2);
            if (this.m_nodeTabs.getSelectedIndex() == 1) {
                double s1 = Tools_Widget.extractDouble(this.m_txtBlockSpacing1, 20.0, 1.0, 1000.0);
                double t1 = Tools_Widget.extractDouble(this.m_txtBlockThick1, 20.0, 1.0, 5000.0);
                double s2 = Tools_Widget.extractDouble(this.m_txtBlockSpacing2, 20.0, 1.0, 1000.0);
                double t2 = Tools_Widget.extractDouble(this.m_txtBlockThick2, 20.0, 1.0, 5000.0);
                double s3 = Tools_Widget.extractDouble(this.m_txtBlockSpacing3, 20.0, 1.0, 1000.0);
                double t3 = Tools_Widget.extractDouble(this.m_txtBlockThick3, 20.0, 1.0, 5000.0);
                nodeDepth = Tomo_VNS.computeNodeDepths(s1, t1, s2, t2, s3, t3);
            }
            this.m_tomo3D = new Tomo_VNS(angle, sizeX, nodeDepth, allocateMemory, forceMarine, waterVelocity);
            if (this.m_first) {
                this.m_first = false;
                this.m_tomo3D.initializeSurface();
                double maxZ = this.m_tomo3D.surfaceMax();
                double minZ = this.m_tomo3D.surfaceMin();
                this.m_txtMaxZ.setText(Double.toString(maxZ));
                this.m_txtMinZ.setText(Double.toString(minZ - 400.0));
            }
            this.m_lblNumInline.setText(Integer.toString(this.m_tomo3D.numX()));
            this.m_lblNumCrossline.setText(Integer.toString(this.m_tomo3D.numY()));
            this.m_lblNumZ.setText(Integer.toString(this.m_tomo3D.numZ()));
            double numNodes = (double)this.m_tomo3D.numX() * (double)this.m_tomo3D.numY() * (double)this.m_tomo3D.numZ();
            double mem = 13.2 * numNodes;
            int mb = 1 + (int)(mem *= 1.0E-6);
            this.m_lblMemory.setText(Integer.toString(mb));
            if (mb > 500) {
                this.m_lblMemory.setForeground(Color.red);
            } else {
                this.m_lblMemory.setForeground(Color.black);
            }
            return mb;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected void reload() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearPaintableList();
            if (this.m_shotPaintable == null) {
                this.m_shotPaintable = this.createPT("Shot", "Easting", "Northing");
                this.m_recPaintable = this.createPT("Receiver", "Easting", "Northing");
            }
            this.createTomo3D(false);
            w.addPaintable(this.m_tomo3D.createPointArray(), -9999);
            w.addPaintable(this.m_shotPaintable, -9999);
            w.addPaintable(this.m_recPaintable, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            this.m_lineUEC.BroadcastWhenDragging = false;
            w.addEventConsumer(this.m_lineUEC);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_versionCombo) {
                return;
            }
            if (sender == this.m_lineUEC) {
                double angle = 180.0 * this.m_lineUEC.Azimuth / Math.PI;
                this.m_txtAngle.setText(Double.toString(angle));
                this.reload();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCreate) {
                this.createNew();
                return;
            }
            this.reload();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String name() {
        try {
            return this.m_txtName.getText();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static enum InitialVelocitySource {
        Linear,
        InteractivePicks;

    }
}

