/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Tomography;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_DelayTime;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_DelayTimeModel;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Refraction.Tomography.TomoEikonal3DWidget;
import com.PecosLibrary.Windows.Refraction.Tomography.TomoLayerNewModelDialog;
import com.PecosLibrary.Windows.Refraction.Tomography.VNS.NewTomoVNSDialog;
import com.PecosLibrary.Windows.Refraction.Tomography.VNS.TomoVNSWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class TomoInteractiveModelWidget_DT
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
IParameterWidgetListener,
ISaveableFrame {
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_inputEnsemble_Copy = new Ensemble();
    protected Ensemble m_processedEnsemble = new Ensemble();
    protected JComboBox<String> m_radiusCombo = new JComboBox();
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected Java2D_AxisLocker m_axisLockerVelocity;
    protected Java2D_AxisLocker m_axisLockerDepth;
    protected JLabel m_lblStatus = new JLabel(" ", 0);
    protected Java2D_UserEventConsumer_DelayTimeModel m_delaytimeUEC = new Java2D_UserEventConsumer_DelayTimeModel();
    protected double m_worldX;
    protected double m_worldY;
    protected double m_worldZ;
    protected JCheckBox m_chkUseSparseGathers;
    protected Java2D_SimpleComposite m_basemapWidget = new Java2D_SimpleComposite(false);
    protected JButton m_clearButton;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected JTextField m_txtMaxOffset = new JTextField("5000");
    protected JButton m_btnCreateTomo;
    protected JButton m_btnCreateTomoVNS;
    protected LinearLayoutWidget m_modelContainer;
    protected ScrollTable m_modelTable;
    protected ScrollTable m_pickTable;
    protected Java2D_SimpleComposite m_modelWidget = new Java2D_SimpleComposite(false);
    protected SliderWidget m_lmoSlider;
    protected TomoInteractiveModel_DelayTime m_delayTimeModel = new TomoInteractiveModel_DelayTime();
    protected TomoLayerNewModelDialog m_dlgNew;
    protected NewTomoVNSDialog m_dlgNewVNS;
    protected TomoInteractiveModel_DelayTime m_hack = null;
    protected float[] m_tempOffset = new float[100];
    protected float[] m_tempTime = new float[100];

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Tomography.TomoInteractiveModelWidget_DT";
    }

    @Override
    public String TAB_LABEL() {
        return "Tomo IMB";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Tomo IMB";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public TomoInteractiveModelWidget_DT() {
        super(1);
        try {
            this.m_delayTimeModel.Permanent = false;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.reloadShotRecData();
            this.reloadMapPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void copyCurrentToProject() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.moveoutTrendData().read(project.moveoutTrendFileName());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createMapWidget() {
        try {
            LinearLayoutWidget mapWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_chkUseSparseGathers = new JCheckBox("Use precomputed sparse CMP gathers");
            if (RefractionStaticsProject.singleton().dim3D()) {
                LinearLayoutWidget w = mapWidget.createVertical(3, "Sparse CMP gathers", 0);
                w.addComponent(this.m_chkUseSparseGathers, 0);
                w.createLabel("Sparse CMP gathers computed under the Sort menu", 0, 0);
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                this.m_chkUseSparseGathers.setSelected(sparse.valid());
                this.m_chkUseSparseGathers.setEnabled(sparse.valid());
                this.m_chkUseSparseGathers.addActionListener(this);
            } else {
                this.m_chkUseSparseGathers.setSelected(false);
                this.m_chkUseSparseGathers.setEnabled(false);
            }
            this.m_btnCreateTomo = new JButton("Create standard tomo model");
            this.m_btnCreateTomo.addActionListener(this);
            this.m_btnCreateTomoVNS = new JButton("Create TomoVNS model");
            this.m_btnCreateTomoVNS.addActionListener(this);
            this.m_txtMaxOffset.addActionListener(this);
            GridLayoutWidget grid = mapWidget.createGridLayoutWidget(0, "Model, offset", 0);
            grid.addSimple(0, new JLabel("Maximum offset"), this.m_txtMaxOffset);
            grid.addSimple(1, new JLabel(" "), this.m_btnCreateTomo);
            grid.addSimple(2, new JLabel(" "), this.m_btnCreateTomoVNS);
            LinearLayoutWidget temp = mapWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Number of bins", 0);
            this.m_radiusCombo.addItem("1 bin");
            if (RefractionStaticsProject.singleton().dim3D()) {
                for (n = 1; n < 11; ++n) {
                    int num = 2 * n + 1;
                    String s = String.format("%d x %d bins", num, num);
                    this.m_radiusCombo.addItem(s);
                }
            } else {
                for (n = 1; n < 11; ++n) {
                    int num = 2 * n + 1;
                    String s = String.format("%d bins", num);
                    this.m_radiusCombo.addItem(s);
                }
            }
            this.m_radiusCombo.setSelectedIndex(1);
            temp.addComponent(this.m_radiusCombo, 10);
            mapWidget.createLabel("Left-click to add/select location", 2, 0);
            mapWidget.createLabel("Press \"r\" to remove nearest location", 2, 0);
            this.m_basemapWidget.setAxesVisible(false, false);
            this.m_basemapWidget.setColorScaleVisible(true);
            mapWidget.addComponent(this.m_basemapWidget, 10);
            LinearLayoutWidget bottom = mapWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearButton = bottom.createButton("Remove all", this, 0);
            bottom.addStretch(10);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            return mapWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("LinearTrend", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            LinearLayoutWidget mainDisplay = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget(null);
            this.m_wiggleOptionsWidget.setFill(false, true);
            this.m_wiggleOptionsWidget.setClippingState(true);
            this.m_wiggleOptionsWidget.setNoOverlap();
            mainDisplay.addComponent(this.m_wiggleOptionsWidget, 0);
            mainDisplay.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(mainDisplay, -2, null, true);
            BitmapCardWidget bmc = new BitmapCardWidget();
            bmc.addComponent(BitmapEnum.Basemap, this.createMapWidget(), "Basemap");
            bmc.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            bmc.addComponent(BitmapEnum.Wiggle, mainDisplay, "Wiggle display options");
            return bmc;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createWiggleComponent() {
        try {
            LinearLayoutWidget topLevel = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget topbar = topLevel.createHorizontal(0, null, 0);
            this.m_axisLockerTime = new Java2D_AxisLocker("Lock time", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerTime, 2);
            this.m_lmoSlider = new SliderWidget(this, "Apply linear moveout", "Linear moveout correction", 0, 3000.0, 1000.0, 22000.0);
            topbar.addComponent(this.m_lmoSlider, 3);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.setHeaderPlotVisibleCount(0, 0);
            this.m_widget.HeaderTextRowCount = 0;
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_widget.setAxisTableColumn("Trace", "Offset");
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            topLevel.addComponent(this.m_lblStatus, 0);
            topLevel.addComponent(this.m_widget, 10);
            this.m_widget.addZoomer();
            this.m_widget.addEventConsumer(0, this.m_delaytimeUEC);
            this.m_delaytimeUEC.addListener(this);
            return topLevel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelComponent() {
        try {
            LinearLayoutWidget topLevel = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget topbar = topLevel.createHorizontal(0, null, 0);
            this.m_axisLockerDepth = new Java2D_AxisLocker("Lock depth", "Lock axis ");
            this.m_axisLockerDepth.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerDepth, 2);
            this.m_axisLockerVelocity = new Java2D_AxisLocker("Lock velocity", "Lock axis ");
            this.m_axisLockerVelocity.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerVelocity, 2);
            this.m_modelWidget.setColorScaleVisible(false);
            topLevel.addComponent(this.m_modelWidget, 10);
            return topLevel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createWiggleComponent());
            splitter.setRightComponent(this.createModelComponent());
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            if (sender == this.m_lmoSlider) {
                this.m_delaytimeUEC.ApplyLMO = this.m_lmoSlider.isCheckSelected();
                this.m_delaytimeUEC.VelocityLMO = this.m_lmoSlider.getDoubleValue();
                TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
                if (pc.current() != null) {
                    pc.current().ApplyLMO = this.m_lmoSlider.isCheckSelected();
                    pc.current().VelocityLMO = this.m_lmoSlider.getDoubleValue();
                }
                this.processEnsemble(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadShotRecData() {
        try {
            this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot", "Elevation");
            this.m_receiverPaintable = Tools_RefractionStaticsProject.loadGeomPO("Receiver", "Elevation");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMapPlot() {
        try {
            SparseCmpGatherManager sparse;
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_shotPaintable != null) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_receiverPaintable != null) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            if (this.m_chkUseSparseGathers != null && this.m_chkUseSparseGathers.isSelected() && (sparse = RefractionStaticsProject.singleton().sparseCmpGathers()).size() > 0) {
                Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray(sparse);
                w.addPaintable(pa, -9999);
            }
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            w.addPaintable(pc, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_leftClickUEC);
            w.addEventConsumer(this.m_mapKeyUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createTomoModel() {
        try {
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            int num = pc.numValid();
            if (num < 1) {
                JOptionPane.showMessageDialog(null, "No locations picked yet", "", 0);
                return;
            }
            pc.recomputeAllVelocityProfiles();
            if (this.m_dlgNew == null) {
                this.m_dlgNew = new TomoLayerNewModelDialog(TomoLayerNewModelDialog.ModelType.Eikonal3D, TomoLayerNewModelDialog.InitialVelocitySource.InteractivePicks);
            }
            this.m_dlgNew.showDialog();
            if (!this.m_dlgNew.OK) {
                return;
            }
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            cm.showComponent(TomoEikonal3DWidget.class.getName(), "Tomo3D", "Tomo3D", true);
            Messenger.broadcast(Messenger.Message.EikonalModelChanged, this, this.m_dlgNew.name());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createTomoVNSModel() {
        try {
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            int num = pc.numValid();
            if (num < 1) {
                JOptionPane.showMessageDialog(null, "No locations picked yet", "", 0);
                return;
            }
            pc.recomputeAllVelocityProfiles();
            if (this.m_dlgNewVNS == null) {
                this.m_dlgNewVNS = new NewTomoVNSDialog(NewTomoVNSDialog.InitialVelocitySource.InteractivePicks);
            }
            this.m_dlgNewVNS.showDialog();
            if (!this.m_dlgNewVNS.OK) {
                return;
            }
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            cm.showComponent(TomoVNSWidget.class.getName(), "TomoVNS", "TomoVNS", true);
            Messenger.broadcast(Messenger.Message.TomoVNSModelChanged, this, this.m_dlgNewVNS.name());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_txtMaxOffset) {
                this.processEnsemble(true);
                return;
            }
            if (e.getSource() == this.m_btnCreateTomoVNS) {
                this.createTomoVNSModel();
            }
            if (e.getSource() == this.m_btnCreateTomo) {
                this.createTomoModel();
            }
            if (e.getSource() == this.m_clearButton) {
                TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
                pc.clear();
                this.m_inputEnsemble.clearTraces(true);
                this.processEnsemble(true);
                this.reloadMapPlot();
            }
            if (e.getSource() == this.m_chkUseSparseGathers) {
                this.reloadMapPlot();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadWiggle() {
        try {
            double maxOff = Tools_Widget.extractDouble(this.m_txtMaxOffset, 2000.0, 100.0, 22000.0);
            this.m_widget.setAxisLocked_X(true, 0.0, maxOff);
            this.m_widget.setEnsemble(0, this.m_processedEnsemble);
            this.m_widget.setRangeExpander(0, true, 0.0, 0.0, true, 0.0, 0.0);
            this.m_widget.clearAndLoadWigglePaintables();
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            if (pc.current() != null) {
                pc.current().computeDelayTimeModel();
                pc.current().computeTravelTimes_UseLinearSegments();
                this.m_widget.addPaintable(0, pc.current(), 1000);
            }
            this.m_widget.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void processEnsemble(boolean unzoom) {
        try {
            if (this.m_inputEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_inputEnsemble_Copy);
                this.m_processedEnsemble = this.m_sequence.work(this.m_inputEnsemble_Copy);
            }
            this.shiftTraces();
            if (unzoom) {
                this.reloadWiggle();
            } else {
                this.m_widget.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shiftTraces() {
        try {
            if (this.m_processedEnsemble == null) {
                return;
            }
            if (!this.m_processedEnsemble.dictionary().containsEntry("Trace", "Offset")) {
                return;
            }
            int indexOffset = this.m_processedEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexShotX = this.m_processedEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = this.m_processedEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexShotZ = this.m_processedEnsemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexRecX = this.m_processedEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = this.m_processedEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexRecZ = this.m_processedEnsemble.dictionary().getEntryIndex("Receiver", "Elevation");
            if (this.m_lmoSlider.isCheckSelected()) {
                double lmoVel = this.m_lmoSlider.getDoubleValue();
                for (int t = 0; t < this.m_processedEnsemble.traceCount(); ++t) {
                    FloatArrayWrapper wrapper = this.m_processedEnsemble.trace(t).data();
                    double offset = this.m_processedEnsemble.trace(t).header().getDouble(indexOffset);
                    float shift = (float)(1000.0 * offset / lmoVel);
                    wrapper.addShiftToFirstSampleCoord(0.0f - shift);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadModelPlot(boolean loadTemp, boolean reloadCurrent) {
        try {
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            Java2D_Widget w = this.m_modelWidget.mainWidget();
            this.m_modelWidget.setHorizontalTitle("Velocity");
            this.m_modelWidget.setVerticalTitle("Depth");
            Java2D_Paintable_AxisLines lines = new Java2D_Paintable_AxisLines();
            lines.DrawHorizontalLines = true;
            lines.DrawVerticalLines = true;
            w.clearPaintableList();
            w.addPaintable(lines, 2000);
            if (reloadCurrent || this.m_hack != pc.current()) {
                this.m_hack = pc.current();
                if (this.m_hack != null) {
                    this.m_hack.computeDelayTimeModel();
                    if (this.m_hack.modelValid()) {
                        this.m_hack.LineColor = Color.RED;
                        this.m_hack.computeTravelTimes_UseLinearSegments();
                    }
                }
            }
            if (this.m_hack != null) {
                w.addPaintable(this.m_hack, 2001);
            }
            if (loadTemp) {
                this.m_delaytimeUEC.prepDelayTimeModel(this.m_delayTimeModel, true);
                this.m_delayTimeModel.computeDelayTimeModel();
                if (this.m_delayTimeModel.modelValid()) {
                    w.addPaintable(this.m_delayTimeModel, 2000);
                }
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            if (sender == this.m_delaytimeUEC) {
                this.m_lblStatus.setText(" ");
                if (this.m_delaytimeUEC.IsMouseMoveEvent) {
                    if (!this.m_delaytimeUEC.currentValid()) {
                        this.m_lblStatus.setForeground(Color.red);
                        this.m_lblStatus.setText(this.m_delaytimeUEC.reasonNotValid());
                    } else {
                        this.m_lblStatus.setForeground(Color.blue);
                        String s = String.format("Current velocity = %d", (int)this.m_delaytimeUEC.currentVelocity());
                        this.m_lblStatus.setText(s);
                    }
                    this.reloadModelPlot(true, false);
                }
                if (this.m_delaytimeUEC.IsDoubleClickEvent) {
                    if (pc.current() != null) {
                        this.m_delaytimeUEC.prepDelayTimeModel(pc.current(), false);
                        this.m_delaytimeUEC.handleImageJustPainted();
                        pc.save();
                    }
                    this.reloadModelPlot(false, true);
                    this.reloadWiggle();
                }
            }
            if (sender == this.m_axisLockerDepth) {
                this.m_modelWidget.mainWidget().transform().setAxisLockedY(this.m_axisLockerDepth.locked(), this.m_axisLockerDepth.min(), this.m_axisLockerDepth.max());
                this.m_modelWidget.mainWidget().mooz();
                return;
            }
            if (sender == this.m_axisLockerVelocity) {
                this.m_modelWidget.mainWidget().transform().setAxisLockedX(this.m_axisLockerVelocity.locked(), this.m_axisLockerVelocity.min(), this.m_axisLockerVelocity.max());
                this.m_modelWidget.mainWidget().mooz();
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    this.processEnsemble(false);
                }
                return;
            }
            if (sender == this.m_mapKeyUEC) {
                if (this.m_mapKeyUEC.KeyCode == 82) {
                    pc.removeClosest(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    this.m_inputEnsemble.clearTraces(true);
                    this.processEnsemble(true);
                    this.reloadMapPlot();
                    this.m_basemapWidget.mainWidget().repaint();
                }
                return;
            }
            if (sender == this.m_leftClickUEC) {
                this.handleMapClick();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick() {
        try {
            this.m_worldX = this.m_leftClickUEC.WorldX;
            this.m_worldY = this.m_leftClickUEC.WorldY;
            if (!this.m_chkUseSparseGathers.isSelected()) {
                if (RefractionStaticsProject.singleton().dim3D()) {
                    Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                    grid3D.setWorldLocation(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    this.m_inputEnsemble.clearTraces(false);
                    RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, grid3D.Inline, grid3D.Crossline, radius, true);
                } else {
                    IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                    int bin = grid2D.getBin(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    this.m_worldX = grid2D.getX(bin);
                    this.m_worldY = grid2D.getY(bin);
                    this.m_inputEnsemble.clearTraces(false);
                    RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, bin, radius, true);
                }
            } else {
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                sparse.selectNearestCMP(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, this.m_inputEnsemble);
                this.m_worldX = sparse.SelectedX;
                this.m_worldY = sparse.SelectedY;
                RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_inputEnsemble, true, true);
                RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
            }
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            double minDistance = 50.0;
            if (RefractionStaticsProject.singleton().units_feet()) {
                minDistance = 50.0;
            }
            this.m_worldZ = this.getElevation(this.m_worldX, this.m_worldY);
            pc.setCurrent(this.m_worldX, this.m_worldY, this.m_worldZ, minDistance);
            if (pc.current() != null) {
                pc.current().ApplyLMO = this.m_lmoSlider.isCheckSelected();
                pc.current().VelocityLMO = this.m_lmoSlider.getDoubleValue();
            }
            this.processEnsemble(true);
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.forceImageRepaint();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected double getElevation(double x, double y) {
        try {
            double sum1 = 0.0;
            double sum2 = 1.0E-50;
            for (int iter = 1; iter <= 2; ++iter) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (iter == 2) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double dx = x - table.getDouble(n, indexX);
                    double dy = y - table.getDouble(n, indexY);
                    double dsq = dx * dx + dy * dy;
                    double z = table.getDouble(n, indexZ);
                    double w = 1.0 / (1.0 + dsq * dsq);
                    sum1 += w * z;
                    sum2 += w;
                }
            }
            double elev = sum1 / sum2;
            return elev;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }
}

