/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class TraceColumnExportDialog
extends JDialog
implements ActionListener {
    protected JButton m_btnOK = new JButton("Export column");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    public boolean OK = false;

    public TraceColumnExportDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Select column:"), this.m_combo);
            this.m_combo.setPreferredSelected("FBP_User");
            middle.addStretch(10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Export trace table column");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> cols = table.columns();
            this.m_combo.setStringArray(cols);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
                String c1 = this.m_combo.getSelectedString();
                this.setCursor(Cursor.getPredefinedCursor(3));
                boolean forceInt = false;
                RefractionStaticsProject.singleton().traceTableWrapper().exportColumn(c1, forceInt);
                this.setCursor(Cursor.getDefaultCursor());
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            this.setCursor(Cursor.getDefaultCursor());
            ExceptionMonitor.add(error);
        }
    }
}

