/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.PickerGizmo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class PickerGizmoWidget
extends LinearLayoutWidget
implements GenericObjectListener.Listener,
ItemListener,
ActionListener {
    protected JComboBox<String> m_leftCombo = new JComboBox();
    protected JCheckBox m_chkSnap = new JCheckBox("Snap to event");
    protected JCheckBox m_chkPickHidden = new JCheckBox("Pick hidden traces");
    protected JCheckBox m_chkPickLocal = new JCheckBox("Pick negative peaks");
    protected boolean m_ignoreCombo = true;
    protected JTable m_table = new JTable();
    protected JComboBox<String> m_editCombo = new JComboBox();
    protected JComboBox<String> m_eventCombo = new JComboBox();
    protected JRadioButton m_radWheelZoom = new JRadioButton("Zoom, X-axis");
    protected JRadioButton m_radWheelScroll = new JRadioButton("Scroll, X-axis");
    protected ButtonGroup m_bg = new ButtonGroup();

    public PickerGizmoWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            PickerGizmo.KeyActionEnum[] actions;
            PickerGizmo.LeftClickActionEnum[] lefts;
            PickEvent[] events;
            this.m_eventCombo.setEditable(false);
            for (PickEvent event : events = PickEvent.values()) {
                this.m_eventCombo.addItem(event.name());
            }
            this.m_eventCombo.setSelectedItem(PickerGizmo.singleton().pickEvent().name());
            this.m_eventCombo.addItemListener(this);
            LinearLayoutWidget sub = this.createHorizontal(0, null, 0);
            sub.addComponent(new JLabel("Pick event:"), 0);
            sub.addComponent(this.m_eventCombo, 10);
            sub = this.createHorizontal(0, "Mouse wheel action:", 0);
            sub.addComponent(this.m_radWheelZoom, 0);
            sub.addComponent(this.m_radWheelScroll, 0);
            this.m_bg.add(this.m_radWheelZoom);
            this.m_bg.add(this.m_radWheelScroll);
            sub.addStretch(10);
            this.m_radWheelZoom.setSelected(true);
            this.m_leftCombo.setEditable(false);
            for (PickerGizmo.LeftClickActionEnum left : lefts = PickerGizmo.LeftClickActionEnum.values()) {
                this.m_leftCombo.addItem(left.name());
            }
            this.m_leftCombo.setSelectedItem(PickerGizmo.singleton().LeftClickAction.name());
            this.m_leftCombo.addItemListener(this);
            this.m_ignoreCombo = false;
            sub = this.createVertical(0, "Left mouse action:", 0);
            sub.addComponent(this.m_leftCombo, 0);
            sub.addComponent(this.m_chkSnap, 0);
            this.m_chkSnap.addActionListener(this);
            this.m_chkSnap.setSelected(PickerGizmo.singleton().ControlPointSnap);
            this.m_chkSnap.setEnabled(PickerGizmo.singleton().LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd);
            this.addComponent(this.m_chkPickHidden, 0);
            this.m_chkPickHidden.addActionListener(this);
            this.m_chkPickHidden.setSelected(PickerGizmo.singleton().PickHiddenTraces);
            this.addComponent(this.m_chkPickLocal, 0);
            this.m_chkPickLocal.setSelected(PickerGizmo.singleton().PickLocalEvents);
            this.m_chkPickLocal.addActionListener(this);
            this.m_table.setModel(PickerGizmo.singleton());
            this.m_table.setGridColor(Color.lightGray);
            this.m_table.setShowGrid(true);
            this.m_table.getColumnModel().getColumn(0).setMaxWidth(50);
            this.addComponent(new JScrollPane(this.m_table), 10);
            for (PickerGizmo.KeyActionEnum action : actions = PickerGizmo.KeyActionEnum.values()) {
                this.m_editCombo.addItem(action.name());
            }
            this.m_editCombo.setEditable(false);
            Tools_FontChanger.changeSizeOfFont(this.m_editCombo, -2);
            TableColumn col = this.m_table.getColumnModel().getColumn(1);
            col.setCellEditor(new DefaultCellEditor(this.m_editCombo));
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            PickerGizmo.singleton().listener().addListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean wheel_scroll() {
        try {
            return this.m_radWheelScroll.isSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean wheel_zoom() {
        try {
            return this.m_radWheelZoom.isSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == PickerGizmo.singleton()) {
                this.m_ignoreCombo = true;
                this.m_leftCombo.setSelectedItem(PickerGizmo.singleton().LeftClickAction.name());
                this.m_eventCombo.setSelectedItem(PickerGizmo.singleton().pickEvent().name());
                this.m_chkPickLocal.setSelected(PickerGizmo.singleton().PickLocalEvents);
                this.m_chkSnap.setSelected(PickerGizmo.singleton().ControlPointSnap);
                this.m_chkSnap.setEnabled(PickerGizmo.singleton().LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd);
                this.m_chkPickHidden.setSelected(PickerGizmo.singleton().PickHiddenTraces);
                this.m_ignoreCombo = false;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkPickLocal) {
                PickerGizmo.singleton().PickLocalEvents = this.m_chkPickLocal.isSelected();
                PickerGizmo.singleton().stuffChanged();
                return;
            }
            if (e.getSource() == this.m_chkPickHidden) {
                PickerGizmo.singleton().PickHiddenTraces = this.m_chkPickHidden.isSelected();
                PickerGizmo.singleton().stuffChanged();
                return;
            }
            if (e.getSource() == this.m_chkSnap) {
                PickerGizmo.singleton().ControlPointSnap = this.m_chkSnap.isSelected();
                PickerGizmo.singleton().stuffChanged();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            if (e.getSource() == this.m_eventCombo) {
                PickerGizmo giz = PickerGizmo.singleton();
                PickEvent event = PickEvent.values()[this.m_eventCombo.getSelectedIndex()];
                giz.setPickEvent(event);
                return;
            }
            if (e.getSource() == this.m_leftCombo) {
                PickerGizmo giz = PickerGizmo.singleton();
                String left = (String)this.m_leftCombo.getSelectedItem();
                giz.LeftClickAction = PickerGizmo.LeftClickActionEnum.valueOf(left);
                this.m_chkSnap.setEnabled(giz.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd);
                giz.stuffChanged();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

