/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.PickerGizmo;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;

public class PickEventCombo
extends JComboBox<String>
implements ItemListener,
GenericObjectListener.Listener {
    public boolean m_ignoreCombo = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public PickEventCombo() {
        try {
            PickEvent[] events;
            this.setEditable(false);
            for (PickEvent event : events = PickEvent.values()) {
                this.addItem(event.name());
            }
            this.setSelectedItem(PickerGizmo.singleton().pickEvent().name());
            this.addItemListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            this.m_ignoreCombo = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (!PickerGizmo.singleton().PickEventJustChanged) {
                return;
            }
            this.m_ignoreCombo = true;
            this.setSelectedItem(PickerGizmo.singleton().pickEvent().name());
            this.m_listener.broadcast(this, null);
            this.m_ignoreCombo = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            PickEvent[] events = PickEvent.values();
            int index = this.getSelectedIndex();
            PickerGizmo.singleton().setPickEvent(events[index]);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

