/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class OffsetBinNavigationWidget
extends LinearLayoutWidget
implements ActionListener,
ListSelectionListener,
ITraceTableScannerMonitor {
    protected OffsetBinTableModel m_offsetBinList = new OffsetBinTableModel();
    protected JTextField m_txtBinSize = new JTextField("100");
    protected JCheckBox m_chkSignedOffset = new JCheckBox("Use signed offset");
    protected JButton m_btnBin = new JButton("Perform binning");
    protected JProgressBar m_progress = new JProgressBar();
    protected JButton m_btnNext = new JButton("Next");
    protected JButton m_btnPrev = new JButton("Previous");
    protected boolean m_ignoreTable = true;
    protected boolean m_noAutoLoad = false;
    protected ScrollTable m_scrollTable = new ScrollTable();
    protected Ensemble m_ensemble = new Ensemble();
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public Ensemble getEnsemble() {
        return this.m_ensemble;
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public OffsetBinNavigationWidget(boolean includeNavButtons, boolean noAutoLoad) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_noAutoLoad = noAutoLoad;
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Create offset bins", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Offset bin size (ft/m)"), this.m_txtBinSize);
            grid.addSimple(row++, this.m_chkSignedOffset, new JLabel("   "));
            grid.addSimple(row++, this.m_btnBin, this.m_progress);
            this.m_progress.setMaximum(100);
            if (includeNavButtons) {
                grid = this.createGridLayoutWidget(0, "Navigation", 0);
                row = 0;
                grid.addSimple(row++, this.m_btnPrev, this.m_btnNext);
                this.m_btnNext.addActionListener(this);
                this.m_btnPrev.addActionListener(this);
            }
            this.m_btnBin.addActionListener(this);
            this.m_scrollTable.table().setSelectionMode(0);
            this.m_scrollTable.table().getSelectionModel().addListSelectionListener(this);
            this.m_scrollTable.table().setModel(this.m_offsetBinList);
            this.addComponent(this.m_scrollTable, 10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.m_ignoreTable) {
                return;
            }
            if (e.getSource() == this.m_scrollTable.table().getSelectionModel()) {
                if (this.m_ignoreTable) {
                    return;
                }
                if (this.m_noAutoLoad) {
                    this.m_listener.broadcast(this, null);
                } else {
                    this.loadSelected();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadSelected() {
        try {
            if (this.m_noAutoLoad) {
                return;
            }
            this.populateEnsemble(this.m_ensemble, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateEnsemble(Ensemble ensemble, boolean emitSignal) {
        try {
            int row = this.m_scrollTable.table().getSelectedRow();
            int num = this.m_offsetBinList.Binnner.BinList.size();
            ensemble.clearTraces(false);
            if (row < 0 || row >= num) {
                return;
            }
            OffsetBin bin = this.m_offsetBinList.Binnner.BinList.get(row);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.ensemble_Indices(ensemble, bin.TraceTableIndex, bin.Count, true);
            ensemble.sortInt(0, "Trace", "Bin2D", "Trace", "TraceCode");
            if (emitSignal) {
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            this.m_progress.setValue((int)percent);
            this.m_progress.paintImmediately(0, 0, 600, 30);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    public void bin() {
        try {
            this.m_ignoreTable = true;
            int binSize = Tools_Widget.extractInteger(this.m_txtBinSize, 50, 1, 5000);
            this.m_offsetBinList.Binnner.SignedOffset = this.m_chkSignedOffset.isSelected();
            this.m_offsetBinList.Binnner.bin(this, binSize);
            this.m_progress.setValue(0);
            this.m_offsetBinList.fireTableStructureChanged();
            this.m_progress.setValue(0);
            this.m_offsetBinList.fireTableStructureChanged();
            this.m_scrollTable.table().setRowSelectionInterval(0, 0);
            this.m_ignoreTable = false;
            this.loadSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void goToNext(boolean load) {
        try {
            int num = this.m_offsetBinList.Binnner.BinList.size();
            if (num < 1) {
                return;
            }
            int row = this.m_scrollTable.table().getSelectedRow();
            if (row >= num - 1) {
                return;
            }
            this.m_ignoreTable = true;
            this.m_scrollTable.table().setRowSelectionInterval(row + 1, row + 1);
            this.m_ignoreTable = false;
            if (load) {
                this.loadSelected();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void goToPrev(boolean load) {
        try {
            int num = this.m_offsetBinList.Binnner.BinList.size();
            if (num < 1) {
                return;
            }
            int row = this.m_scrollTable.table().getSelectedRow();
            if (row < 1) {
                return;
            }
            this.m_ignoreTable = true;
            this.m_scrollTable.table().setRowSelectionInterval(row - 1, row - 1);
            this.m_ignoreTable = false;
            if (load) {
                this.loadSelected();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnBin) {
                this.bin();
                return;
            }
            if (e.getSource() == this.m_btnPrev) {
                this.goToPrev(true);
                return;
            }
            if (e.getSource() == this.m_btnNext) {
                this.goToNext(true);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class OffsetBinTableModel
    extends AbstractTableModel {
        public OffsetBinner Binnner;

        protected OffsetBinTableModel() {
            this.Binnner = new OffsetBinner();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Min Off";
                }
                if (column == 1) {
                    return "Max Off";
                }
                if (column == 2) {
                    return "Count";
                }
                if (column == 3) {
                    return "Sign";
                }
                return "Error";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            return this.Binnner.BinList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row < 0 || row >= this.Binnner.BinList.size()) {
                    return "ERROR:";
                }
                if (column == 0) {
                    return Integer.toString((int)(0.5 + this.Binnner.BinList.get((int)row).MinOffset));
                }
                if (column == 1) {
                    return Integer.toString((int)(0.5 + this.Binnner.BinList.get((int)row).MaxOffset));
                }
                if (column == 2) {
                    return Integer.toString(this.Binnner.BinList.get((int)row).Count);
                }
                if (column == 3) {
                    if (!this.Binnner.SignedOffset) {
                        return "Off";
                    }
                    if (this.Binnner.BinList.get((int)row).Sign < 0) {
                        return "Negative";
                    }
                    return "Positive";
                }
                return "error";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }
    }

    protected class OffsetBinner
    extends TraceTable_ScannerBase {
        protected double m_binSize = 100.0;
        public boolean SignedOffset = false;
        public ArrayList<OffsetBin> BinList = new ArrayList();
        protected int m_iter = 0;
        protected double[] m_shotCoord;
        protected double[] m_recCoord;
        protected double m_maxOffset;

        protected OffsetBinner() {
        }

        protected double[] rotatedCoords(double angle, Table_Abstract table) {
            try {
                int num = table.row_count();
                double[] coord = new double[num];
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                for (int n = 0; n < num; ++n) {
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    coord[n] = x * Math.cos(angle) + y * Math.sin(angle);
                }
                return coord;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return null;
            }
        }

        public void bin(ITraceTableScannerMonitor monitor, double binSize) {
            try {
                this.BinList.clear();
                this.m_binSize = Math.max(10.0, binSize);
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                ITraceTable traceTable = project.traceTableWrapper().traceTable();
                double angle = Tools_RefractionStaticsProject.findMaximumSurveyRangeAngle();
                this.m_shotCoord = this.rotatedCoords(angle, project.shotTable());
                this.m_recCoord = this.rotatedCoords(angle, project.receiverTable());
                this.m_iter = 0;
                this.m_maxOffset = 0.0;
                this.scan(traceTable, monitor);
                ++this.m_iter;
                this.m_maxOffset += this.m_binSize;
                int maxBinIndex = (int)(this.m_maxOffset / this.m_binSize);
                for (int b = 0; b < maxBinIndex; ++b) {
                    OffsetBin bin = new OffsetBin();
                    bin.MinOffset = (double)b * this.m_binSize;
                    bin.MaxOffset = bin.MinOffset + this.m_binSize;
                    this.BinList.add(bin);
                    if (!this.SignedOffset) continue;
                    bin = new OffsetBin();
                    bin.Sign = -1;
                    bin.MinOffset = (double)b * this.m_binSize;
                    bin.MaxOffset = bin.MinOffset + this.m_binSize;
                    this.BinList.add(bin);
                }
                this.m_iter = 1;
                this.scan(traceTable, monitor);
                for (OffsetBin bin : this.BinList) {
                    if (bin.Count > 0) {
                        bin.TraceTableIndex = new long[bin.Count];
                    }
                    bin.Count = 0;
                }
                this.m_iter = 2;
                this.scan(traceTable, monitor);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void work() throws Exception {
            try {
                if (this.m_iter == 0) {
                    this.m_maxOffset = Math.max(this.m_maxOffset, this.m_offset);
                    return;
                }
                int binIndex = (int)(this.m_offset / this.m_binSize);
                OffsetBin bin = this.BinList.get(binIndex);
                if (this.SignedOffset) {
                    binIndex *= 2;
                    double rot = this.m_recCoord[this.m_recRow] - this.m_shotCoord[this.m_shotRow];
                    if (rot < 0.0) {
                        ++binIndex;
                    }
                    bin = this.BinList.get(binIndex);
                }
                if (this.m_iter == 1) {
                    ++bin.Count;
                    return;
                }
                if (bin.Count < bin.TraceTableIndex.length) {
                    bin.TraceTableIndex[bin.Count] = this.m_traceRow;
                    ++bin.Count;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void finishScan() throws Exception {
        }
    }

    protected class OffsetBin {
        public int Sign = 1;
        public int Count = 0;
        public long[] TraceTableIndex;
        public double MinOffset;
        public double MaxOffset;

        protected OffsetBin() {
        }
    }
}

