/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_Ensemble_RefractionProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.Picking.OffsetBinNavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickDisplayWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Refraction.Picking.TraceBackgroundWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class Offset2DPickWidget
extends JSplitPane
implements INumberedWidget,
ActionListener,
GenericObjectListener.Listener,
ItemListener,
Java2D_VertStackedEnsembleDisplayWidget.Listener,
Messenger.Listener {
    protected JCheckBox m_reloadIfDtModCheck;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected OffsetBinNavigationWidget m_offsetBinWidget = new OffsetBinNavigationWidget(true, false);
    protected Sequence_MainWidget m_workerWidget;
    protected PickDisplayWidget m_pickDisplayWidget;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected TraceBackgroundWidget m_traceBackgroundWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected BitmapCardWidget m_rightBitmapCardWidget = new BitmapCardWidget();
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_inputEnsemble_Copy = new Ensemble();
    protected Ensemble m_processedEnsemble;
    protected Java2D_UserEventConsumer_MultiLineSegments m_lineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
    protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_ButtonPressed m_middleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);
    protected ParameterTree m_parameters = new ParameterTree();
    protected String m_paramFileName;
    protected int m_widgetNumber = 1;

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String root = p.guiOptionsPath() + "/Offset2D_" + Integer.toString(this.m_widgetNumber);
            this.m_paramFileName = root + "Options.xml";
            this.m_parameters.read(this.m_paramFileName);
            this.m_wiggleOptionsWidget.setParentParameterTree(this.m_parameters);
            String sfn = root + ".SequenceXML";
            this.m_workerWidget.setFileName(sfn);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_wiggleOptionsWidget.saveParameters();
            this.m_parameters.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Offset2DPickWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.setOneTouchExpandable(true);
            this.m_lineSegmentUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.m_middleClickUEC.addListener(this);
            this.m_keyUEC.addListener(this);
            this.loadUEC();
            Messenger.singleton().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createHorizontal(0, null, 0);
            Tools_FontChanger.changeSizeOfFont(sub, -2, null, true);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            this.m_widget.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(-400.0, 500.0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -1, null, true);
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Picker controls");
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.TaskList, main, "Axis locks, group info");
            this.m_rightBitmapCardWidget.setPreferredSize(new Dimension(200, 500));
            return this.m_rightBitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("Picker", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            LinearLayoutWidget disp = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_pickDisplayWidget = new PickDisplayWidget();
            this.m_pickDisplayWidget.getListenerController().addListener(this);
            this.m_traceBackgroundWidget = new TraceBackgroundWidget("Trace color");
            this.m_traceBackgroundWidget.listener().addListener(this);
            disp.addComponent(this.m_wiggleOptionsWidget, 0);
            disp.createGapLabel(15);
            disp.addComponent(this.m_traceBackgroundWidget, 0);
            disp.createGapLabel(15);
            disp.addComponent(this.m_pickDisplayWidget, 10);
            this.m_offsetBinWidget.listener().addListener(this);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.m_offsetBinWidget, "Offset bin selection");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, disp, "Wiggle display options");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean polarityFlipped;
            boolean bl = polarityFlipped = message == Messenger.Message.ReceiverPolarityFlipped || message == Messenger.Message.ShotPolarityFlipped || message == Messenger.Message.TracePolarityFlipped;
            if (message == Messenger.Message.PicksChanged) {
                if (sender == this) {
                    return;
                }
                Ensemble ensemble = (Ensemble)data;
                if (Tools_Ensemble.copyHeaderValue(ensemble, this.m_inputEnsemble, "Trace", "FBP_User") < 1) {
                    return;
                }
                this.handlePicksModified(false);
                return;
            }
            boolean reloadData = false;
            int reloadID = -9999;
            if (polarityFlipped) {
                Tools_Ensemble_RefractionProject.setTracePolarity(this.m_inputEnsemble, true);
                reloadData = true;
            }
            if (message == Messenger.Message.ReceiverGeometryChanged) {
                reloadID = (Integer)data;
                boolean bl2 = reloadData = reloadData || Tools_Ensemble.hasReceiverID(this.m_inputEnsemble, reloadID);
            }
            if (message == Messenger.Message.ShotGeometryChanged) {
                reloadID = (Integer)data;
                boolean bl3 = reloadData = reloadData || Tools_Ensemble.hasShotID(this.m_inputEnsemble, reloadID);
            }
            if (message == Messenger.Message.ProjectVersionChanged) {
                reloadData = true;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            if (imagePainted && widgetIndex != 0) return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadUEC() {
        try {
            boolean needControlPoint;
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            boolean bl = needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill;
            if (needControlPoint) {
                this.m_widget.addEventConsumer(0, this.m_lineSegmentUEC);
            } else {
                this.m_widget.addEventConsumer(0, this.m_leftClickUEC);
            }
            this.m_widget.addEventConsumer(0, this.m_middleClickUEC);
            this.m_widget.addEventConsumer(0, this.m_keyUEC);
            this.m_widget.addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void prepareWidget(boolean unzoom) {
        try {
            if (this.m_processedEnsemble != null) {
                this.m_pickDisplayWidget.prepEnsemble(this.m_processedEnsemble);
            }
            this.m_widget.setEnsemble(0, this.m_processedEnsemble);
            this.m_traceBackgroundWidget.setBackground(this.m_processedEnsemble);
            if (unzoom) {
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
            } else {
                this.m_widget.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void processInputEnsemble(boolean unzoom) {
        try {
            if (this.m_inputEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_inputEnsemble.resetAllKillFlags();
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_inputEnsemble_Copy);
                this.m_inputEnsemble_Copy.pickPlotData().clearRequiredList();
                this.m_processedEnsemble = this.m_sequence.work(this.m_inputEnsemble_Copy);
            }
            this.prepareWidget(unzoom);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected void nextEnsemble() {
    }

    protected void priorEnsemble() {
    }

    protected void handleKeyUEC() {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            if (this.m_keyUEC.KeyCode >= 48 && this.m_keyUEC.KeyCode <= 57) {
                int index = this.m_keyUEC.KeyCode - 48;
                return;
            }
            if (this.m_keyUEC.EscapePressed) {
                PickerGizmo.broadcastControlClick(this, this.m_processedEnsemble, this.m_keyUEC.PixelX);
                return;
            }
            if (pg.keyOff(this.m_keyUEC)) {
                return;
            }
            if (pg.keyPriorEnsemble(this.m_keyUEC) || pg.keyPriorGroup(this.m_keyUEC)) {
                this.m_offsetBinWidget.goToPrev(true);
                return;
            }
            if (pg.keyNextEnsemble(this.m_keyUEC) || pg.keyNextGroup(this.m_keyUEC)) {
                this.m_offsetBinWidget.goToNext(true);
                return;
            }
            if (pg.handleKey(this.m_keyUEC, this.m_processedEnsemble, this.m_inputEnsemble, this.m_widget.transform(0), false)) {
                this.handlePicksModified(true);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handlePicksModified(boolean emitMessage) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            if (sender == this.m_offsetBinWidget) {
                this.m_inputEnsemble = this.m_offsetBinWidget.getEnsemble();
                this.processInputEnsemble(true);
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            if (sender == this.m_traceBackgroundWidget) {
                this.prepareWidget(true);
                return;
            }
            if (sender == this.m_keyUEC) {
                this.handleKeyUEC();
                return;
            }
            if (sender == this.m_lineSegmentUEC) {
                if (this.m_lineSegmentUEC.Dragging) {
                    return;
                }
                if (!this.m_lineSegmentUEC.Finished) {
                    return;
                }
                if (pg.handleControlPoint(this.m_lineSegmentUEC, this.m_processedEnsemble, this.m_inputEnsemble)) {
                    this.handlePicksModified(true);
                }
                return;
            }
            if (sender == this.m_middleClickUEC) {
                return;
            }
            if (sender == this.m_leftClickUEC) {
                if (this.m_leftClickUEC.ControlDown) {
                    PickerGizmo.broadcastControlClick(this, this.m_processedEnsemble, this.m_leftClickUEC.PixelX);
                    return;
                }
                if (pg.handleButtonPressed(this.m_leftClickUEC, this.m_processedEnsemble, this.m_inputEnsemble, false)) {
                    this.handlePicksModified(true);
                }
                return;
            }
            if (sender == this.m_wiggleOptionsWidget) {
                this.saveParameters();
                return;
            }
            if (sender == this.m_pickDisplayWidget) {
                this.prepareWidget(false);
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    this.processInputEnsemble(false);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

