/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NavigationWidget
extends LinearLayoutWidget
implements ActionListener,
ItemListener,
ListSelectionListener,
Messenger.Listener {
    protected String m_tableName;
    protected JButton m_reloadButton;
    protected JButton m_applyButton;
    protected ComboStringListWrapper m_priSortCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_secSortCombo = new ComboStringListWrapper();
    protected JCheckBox m_chkDesc = new JCheckBox("DESCEND");
    protected ArrayList<FilterWrapper> FilterList = new ArrayList();
    protected JTextField m_skipText = new JTextField("1");
    protected JRadioButton m_polyOffRad = new JRadioButton("Not used");
    protected JRadioButton m_polyInRad = new JRadioButton("Inside");
    protected JRadioButton m_polyOutRad = new JRadioButton("Outside");
    protected JTable m_table = new JTable();
    protected boolean m_ignoreTableSelection = true;
    protected Table_Abstract m_selectedTable = new Table_Memory();
    protected int m_selectedRow = 0;
    protected int m_selectedID = 0;
    protected int m_columnIndexID;
    protected boolean m_selectedInTable = false;
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public NavigationWidget(String tableName) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_tableName = tableName.equalsIgnoreCase("Receiver") ? "Receiver" : "Shot";
            LinearLayoutWidget sub = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_reloadButton = sub.createButton("Reload columns", this, 10);
            this.m_applyButton = sub.createButton("Apply options", this, 10);
            sub = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Navigation order", 0);
            sub.addComponent(this.m_priSortCombo, 10);
            sub.addComponent(this.m_secSortCombo, 10);
            sub.addComponent(this.m_chkDesc, 0);
            sub = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Skip interval", 0);
            sub.addComponent(new JLabel("Skip interval:"), 0);
            sub.addComponent(this.m_skipText, 10);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Column filtering options", 0);
            grid.addComponent(new JLabel(" "), 0, 0, 0.0, 0.0);
            grid.addComponent(new JLabel("Column name:"), 0, 1, 0.0, 10.0);
            grid.addComponent(new JLabel("Min value:"), 0, 2, 0.0, 3.0);
            grid.addComponent(new JLabel("Max value:"), 0, 3, 0.0, 3.0);
            for (int n = 0; n < 3; ++n) {
                FilterWrapper w = new FilterWrapper();
                grid.addComponent(w.FilterCheck, n + 1, 0, 0.0, 0.0);
                grid.addComponent(w.FilterCombo, n + 1, 1, 0.0, 10.0);
                grid.addComponent(w.MinFilterText, n + 1, 2, 0.0, 3.0);
                grid.addComponent(w.MaxFilterText, n + 1, 3, 0.0, 3.0);
                this.FilterList.add(w);
            }
            ButtonGroup group = new ButtonGroup();
            grid = this.createGridLayoutWidget(0, "Project polygon", 0);
            grid.addComponent(this.m_polyOffRad, 0, 0, 1.0, 1.0);
            grid.addComponent(this.m_polyInRad, 0, 1, 1.0, 1.0);
            grid.addComponent(this.m_polyOutRad, 0, 2, 1.0, 1.0);
            group.add(this.m_polyOffRad);
            group.add(this.m_polyInRad);
            group.add(this.m_polyOutRad);
            this.m_polyOffRad.setSelected(true);
            this.m_table.setGridColor(Color.lightGray);
            this.m_table.setShowGrid(true);
            this.addComponent(new JScrollPane(this.m_table), 1);
            this.m_table.getSelectionModel().setSelectionMode(0);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_priSortCombo.setPreferredSelected("LineNumber");
            this.m_secSortCombo.setPreferredSelected("PointNumber");
            this.loadColumns();
            this.apply(false);
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean usesPoly;
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.loadColumns();
                return;
            }
            if (this.m_tableName.equalsIgnoreCase("Receiver") && message == Messenger.Message.ReceiverKilled) {
                this.apply(true);
                return;
            }
            if (this.m_tableName.equalsIgnoreCase("Shot") && message == Messenger.Message.ShotKilled) {
                this.apply(true);
                return;
            }
            boolean bl = usesPoly = this.m_polyInRad.isSelected() || this.m_polyOutRad.isSelected();
            if (usesPoly && message == Messenger.Message.ProjectPolygonModified) {
                this.apply(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting() || this.m_ignoreTableSelection) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (row < 0) {
                return;
            }
            if (row >= this.m_selectedTable.row_count()) {
                return;
            }
            this.m_selectedInTable = true;
            this.m_selectedRow = row;
            this.m_selectedID = this.m_selectedTable.getInt(this.m_selectedRow, this.m_columnIndexID);
            System.out.println("m_selectedID = " + this.m_selectedID);
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void apply(boolean goToNext) {
        try {
            try {
                if (this.m_selectedTable.row_count() >= 1) {
                    ++this.m_selectedRow;
                    if (this.m_selectedRow >= this.m_selectedTable.row_count()) {
                        this.m_selectedRow = 0;
                    }
                    if (this.m_selectedRow < 0) {
                        this.m_selectedRow = 0;
                    }
                    this.m_selectedID = this.m_selectedTable.getInt(this.m_selectedRow, this.m_columnIndexID);
                }
            }
            catch (Exception err) {
                this.m_selectedID = -9999;
            }
            IDatabaseConnection db = RefractionStaticsProject.singleton().geometryDatabase();
            String priName = this.m_priSortCombo.getSelectedString();
            String secName = this.m_secSortCombo.getSelectedString();
            Table_Abstract tbl = this.m_tableName.equalsIgnoreCase("Receiver") ? RefractionStaticsProject.singleton().receiverTable() : RefractionStaticsProject.singleton().shotTable();
            DataType priType = tbl.column_type(tbl.column_indexOfColumn(priName));
            DataType secType = tbl.column_type(tbl.column_indexOfColumn(secName));
            Object sql = String.format("SELECT * FROM %s ", this.m_tableName);
            Object where = " WHERE KILLED = FALSE ";
            for (FilterWrapper w : this.FilterList) {
                if (!w.FilterCheck.isSelected()) continue;
                String col = w.FilterCombo.getSelectedString();
                DataType ft = tbl.column_type(tbl.column_indexOfColumn(col));
                if (ft == DataType.Int || ft == DataType.Short) {
                    int min = Tools_Widget.extractInteger(w.MinFilterText, 0, -100000000, 100000000);
                    int max = Tools_Widget.extractInteger(w.MaxFilterText, 0, -100000000, 100000000);
                    where = (String)where + String.format("AND %s >= %d AND %s <= %d ", col, min, col, max);
                    continue;
                }
                double min = Tools_Widget.extractDouble(w.MinFilterText, 0.0, -1.0E20, 1.0E20);
                double max = Tools_Widget.extractDouble(w.MaxFilterText, 0.0, -1.0E20, 1.0E20);
                where = (String)where + String.format("AND %s > %f AND %s < %f ", col, min, col, max);
            }
            sql = (String)sql + (String)where;
            sql = this.m_chkDesc.isSelected() ? (String)sql + String.format("ORDER BY %s DESC, %s DESC ", this.m_priSortCombo.getSelectedString(), this.m_secSortCombo.getSelectedString()) : (String)sql + String.format("ORDER BY %s, %s ", this.m_priSortCombo.getSelectedString(), this.m_secSortCombo.getSelectedString());
            Table_Abstract fullTable = db.extractTableDataUsingQuery(this.m_tableName, (String)sql, Pecos.MaxQueryRowCount);
            this.m_selectedTable = new Table_Memory();
            this.m_selectedTable.setName(this.m_tableName);
            int fullIndexID = fullTable.column_indexOfColumn(this.m_tableName + "ID");
            int fullIndexPri = fullTable.column_indexOfColumn(this.m_priSortCombo.getSelectedString());
            int fullIndexSec = fullTable.column_indexOfColumn(this.m_secSortCombo.getSelectedString());
            int fullIndexX = fullTable.column_indexOfColumn("Easting");
            int fullIndexY = fullTable.column_indexOfColumn("Northing");
            this.m_columnIndexID = this.m_selectedTable.column_append(this.m_tableName + "ID", DataType.Int);
            int selIndexPri = this.m_selectedTable.column_append(priName, priType);
            int selIndexSec = this.m_selectedTable.column_append(secName, secType);
            Java2D_Polygon poly = RefractionStaticsProject.singleton().polygon();
            boolean forceInside = this.m_polyInRad.isSelected() && poly.valid();
            boolean forceOutside = this.m_polyOutRad.isSelected() && poly.valid();
            for (int r = 0; r < fullTable.row_count(); ++r) {
                int v;
                double x = fullTable.getDouble(r, fullIndexX);
                double y = fullTable.getDouble(r, fullIndexY);
                boolean accept = true;
                if (forceInside) {
                    accept = poly.contains(x, y);
                }
                if (forceOutside) {
                    boolean bl = accept = !poly.contains(x, y);
                }
                if (!accept) continue;
                int row = this.m_selectedTable.row_increment();
                int id = fullTable.getInt(r, fullIndexID);
                this.m_selectedTable.putInt(row, this.m_columnIndexID, id);
                if (priType == DataType.Int || priType == DataType.Short) {
                    v = fullTable.getInt(r, fullIndexPri);
                    this.m_selectedTable.putInt(row, selIndexPri, v);
                } else {
                    double v2 = fullTable.getDouble(r, fullIndexPri);
                    this.m_selectedTable.putDouble(row, selIndexPri, v2);
                }
                if (secType == DataType.Int || secType == DataType.Short) {
                    v = fullTable.getInt(r, fullIndexSec);
                    this.m_selectedTable.putInt(row, selIndexSec, v);
                    continue;
                }
                double v3 = fullTable.getDouble(r, fullIndexSec);
                this.m_selectedTable.putDouble(row, selIndexSec, v3);
            }
            this.m_ignoreTableSelection = true;
            this.m_table.setModel(new Table_SimpleModel(this.m_selectedTable));
            if (goToNext && this.m_selectedID >= 1) {
                this.setSelected(this.m_selectedID);
            } else {
                this.m_selectedRow = 0;
                this.m_selectedID = -9999;
                if (this.m_selectedTable.row_count() > 0) {
                    this.m_selectedInTable = true;
                    this.m_table.setRowSelectionInterval(this.m_selectedRow, this.m_selectedRow);
                    this.m_ignoreTableSelection = false;
                    this.m_selectedID = this.m_selectedTable.getInt(this.m_selectedRow, this.m_columnIndexID);
                    try {
                        this.m_table.scrollRectToVisible(new Rectangle(this.m_table.getCellRect(this.m_selectedRow, 0, true)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSelected(int selectedID) {
        try {
            this.m_selectedID = selectedID;
            this.m_selectedInTable = false;
            for (int row = 0; row < this.m_selectedTable.row_count(); ++row) {
                int id = this.m_selectedTable.getInt(row, this.m_columnIndexID);
                if (id != selectedID) continue;
                this.m_selectedRow = row;
                this.m_selectedInTable = true;
                this.m_ignoreTableSelection = true;
                this.m_table.setRowSelectionInterval(this.m_selectedRow, this.m_selectedRow);
                this.scrollToSelected();
                this.m_ignoreTableSelection = false;
                row = 10000000;
            }
            if (!this.m_selectedInTable) {
                this.m_ignoreTableSelection = true;
                this.m_table.clearSelection();
                this.m_ignoreTableSelection = false;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int selected() {
        return this.m_selectedID;
    }

    public int selected(int offset) {
        try {
            int row = this.m_selectedRow + offset;
            if (row < 0) {
                row += this.m_selectedTable.row_count();
            }
            if (row >= this.m_selectedTable.row_count()) {
                row -= this.m_selectedTable.row_count();
            }
            return this.m_selectedTable.getInt(row, this.m_columnIndexID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return this.m_selectedID;
        }
    }

    protected void scrollToSelected() {
        try {
            this.m_table.scrollRectToVisible(new Rectangle(this.m_table.getCellRect(this.m_selectedRow, 0, true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int goToPrevious() {
        try {
            int skip = Tools_Widget.extractInteger(this.m_skipText, 1, 1, 100);
            return this.goToPrevious(skip);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public int goToPrevious(int skip) {
        try {
            if (this.m_selectedTable.row_count() < 1) {
                return -9999;
            }
            this.m_selectedRow -= skip;
            if (this.m_selectedRow < 0) {
                this.m_selectedRow = this.m_selectedTable.row_count() - 1;
            }
            this.m_selectedID = this.m_selectedTable.getInt(this.m_selectedRow, this.m_columnIndexID);
            System.out.println(String.format("goToPrevious(): %d  %d", this.m_selectedRow, this.m_selectedID));
            this.m_ignoreTableSelection = true;
            this.m_table.setRowSelectionInterval(this.m_selectedRow, this.m_selectedRow);
            this.scrollToSelected();
            this.m_ignoreTableSelection = false;
            return this.m_selectedID;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public int goToNext() {
        try {
            int skip = Tools_Widget.extractInteger(this.m_skipText, 1, 1, 100);
            return this.goToNext(skip);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public int goToNext(int skip) {
        try {
            if (this.m_selectedTable.row_count() < 1) {
                return -9999;
            }
            this.m_selectedRow += skip;
            if (this.m_selectedRow >= this.m_selectedTable.row_count()) {
                this.m_selectedRow = 0;
            }
            this.m_selectedID = this.m_selectedTable.getInt(this.m_selectedRow, this.m_columnIndexID);
            this.m_ignoreTableSelection = true;
            this.m_table.setRowSelectionInterval(this.m_selectedRow, this.m_selectedRow);
            this.scrollToSelected();
            this.m_ignoreTableSelection = false;
            return this.m_selectedID;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    protected void loadColumns() {
        try {
            IDatabaseConnection db = RefractionStaticsProject.singleton().geometryDatabase();
            ArrayList<String> list = db.listOfColumnNames(this.m_tableName);
            this.m_priSortCombo.setStringArray(list);
            this.m_secSortCombo.setStringArray(list);
            for (FilterWrapper w : this.FilterList) {
                w.FilterCombo.setStringArray(list);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadButton) {
                this.loadColumns();
                return;
            }
            if (e.getSource() == this.m_applyButton) {
                this.apply(false);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class FilterWrapper {
        public JCheckBox FilterCheck = new JCheckBox("On");
        public ComboStringListWrapper FilterCombo = new ComboStringListWrapper();
        public JTextField MinFilterText = new JTextField("0");
        public JTextField MaxFilterText = new JTextField("100");

        protected FilterWrapper() {
        }
    }
}

