/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddPickVersionDialog
extends JDialog
implements ActionListener,
DocumentListener {
    protected JButton m_btnOK = new JButton("Create pick column");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JTextField m_text = new JTextField("");
    protected JLabel m_lbl = new JLabel("");
    public boolean OK = false;

    public AddPickVersionDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Pick name"), this.m_text);
            grid.addSimple(1, new JLabel(" "), this.m_lbl);
            this.m_text.getDocument().addDocumentListener(this);
            middle.addStretch(10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Add a first break pick column");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkName() {
        try {
            this.m_btnOK.setEnabled(false);
            String name = this.m_text.getText();
            this.m_lbl.setText("");
            if (name.length() < 3) {
                this.m_lbl.setForeground(Color.red);
                this.m_lbl.setText("Name must have at least 3 characters");
                return;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_lbl.setForeground(Color.red);
                this.m_lbl.setText("Spaces and special characters not allowed");
                return;
            }
            if (Tools_Strings.startsWithNumber(name)) {
                this.m_lbl.setForeground(Color.red);
                this.m_lbl.setText("Name cannot start with a number");
                return;
            }
            String colName = "FBP_" + name;
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            if (table.column_exists(colName)) {
                this.m_lbl.setForeground(Color.red);
                this.m_lbl.setText("Column already exists");
                return;
            }
            this.m_btnOK.setEnabled(true);
            this.m_lbl.setForeground(Color.blue);
            this.m_lbl.setText("New column name: " + colName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.checkName();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                String name = this.m_text.getText();
                String colName = "FBP_" + name;
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                if (p.traceTableWrapper().traceTable().needToExpandTableMemory(DataType.Float)) {
                    int res = JOptionPane.showConfirmDialog(null, "This will require resizing the trace table, which may be slow. \nDo you still want to add the new column?", "", 0);
                    if (res != 0) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        p.traceTable_SaveandRead_MainThread();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                ITraceTable table = p.traceTableWrapper().traceTable();
                int index = table.column_append(colName, DataType.Float);
                table.setColumnValue(index, -9999.0f);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

