/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class LinearMoveoutTrend_DisplayWidget
extends LinearLayoutWidget
implements ActionListener {
    protected MoveoutTrendData m_moveoutTrendData = new MoveoutTrendData();
    protected Display m_display = Display.Velocity;
    protected Java2D_SimpleComposite m_widget = new Java2D_SimpleComposite(false);
    protected JTextField m_timeText = new JTextField("100");
    protected JButton m_applyButton;

    public LinearMoveoutTrend_DisplayWidget(MoveoutTrendData mtd, Display display) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_moveoutTrendData = mtd;
            this.m_display = display;
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            top.addComponent(new JLabel("Enter offset"), 0);
            this.m_timeText.setMinimumSize(new Dimension(200, 20));
            this.m_timeText.setPreferredSize(new Dimension(200, 20));
            top.addComponent(this.m_timeText, 0);
            this.m_applyButton = top.createButton("Load plot", this, 0);
            top.addStretch(10);
            this.addComponent(this.m_widget, 10);
            this.m_widget.mainWidget().addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            double offset = Tools_Widget.extractDouble(this.m_timeText, 1000.0, 1.0, 30000.0);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D grid = project.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < grid.numInline(); ++ix) {
                for (int iy = 0; iy < grid.numCrossline(); ++iy) {
                    double x = grid.getWorldX_Indices(ix, iy);
                    double y = grid.getWorldY_Indices(ix, iy);
                    data[ix][iy] = this.m_display == Display.Velocity ? this.m_moveoutTrendData.getVelocity(x, y, (float)offset) : this.m_moveoutTrendData.getTime(x, y, (float)offset, true);
                }
            }
            this.m_widget.mainWidget().clearPaintableList();
            this.m_widget.mainWidget().addPaintable(grid, -9999);
            this.m_widget.mainWidget().addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot"), -9999);
            this.m_widget.mainWidget().addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), -9999);
            this.m_widget.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            this.m_widget.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum Display {
        Velocity,
        Time;

    }
}

