/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_BranchPickLocations;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_KillPicksUsingTrends;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_DelayTime;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_BranchPickCollections;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleHeaderCrossplot;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_RangeExpander;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MoveoutTrend;
import com.PecosLibrary.Windows.Refraction.LinearMoveoutTrend_DisplayWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LinearMoveoutTrendWidget_Picks
extends JSplitPane
implements GenericObjectListener.Listener,
IParameterWidgetListener,
ActionListener,
ITraceTableScannerMonitor {
    protected Java2D_SimpleComposite m_basemapWidget = new Java2D_SimpleComposite(false);
    protected Java2D_SimpleComposite m_branchWidget = new Java2D_SimpleComposite(false);
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected JButton m_clearButton;
    protected JTabbedPane m_rightTabs = new JTabbedPane();
    protected TomoInteractiveModel_DelayTime m_model = new TomoInteractiveModel_DelayTime();
    protected LinearLayoutWidget m_leftLayPre;
    protected GridLayoutWidget m_leftLayNormal;
    protected JTextField m_textPrecomputeSpacing = new JTextField("5000");
    protected JTextField m_textPrecomputeRadius = new JTextField("300");
    protected JButton m_btnPrecompute;
    protected JButton m_btnPrecomputeClear;
    protected JProgressBar m_progressPrecompute = new JProgressBar();
    protected JRadioButton m_rad_sparse = new JRadioButton("Use precomputed pick gathers");
    protected JRadioButton m_rad_cmp = new JRadioButton("Use standard CMP gathers");
    protected JRadioButton m_rad_shot = new JRadioButton("Use shot gathers");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JCheckBox m_chkDrawAcceptZone = new JCheckBox("Draw pick acceptance zone");
    protected JTextField m_txtAcceptZone = new JTextField("80");
    protected JButton m_btnKillPicks;
    protected ComboStringListWrapper m_killVersionCombo;
    protected JProgressBar m_progressKill = new JProgressBar();
    protected JProgressBar m_progressTemp;
    protected JComboBox<String> m_radiusCombo = new JComboBox();
    protected ComboStringListWrapper m_pickVersionCombo;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected String m_pickName = "";
    protected Ensemble m_ensemble = new Ensemble();
    protected Java2D_Paintable_EnsembleHeaderCrossplot m_paintable = new Java2D_Paintable_EnsembleHeaderCrossplot();
    protected Java2D_Paintable_RangeExpander m_pickExpander = new Java2D_Paintable_RangeExpander();
    protected Java2D_UserEventConsumer_MoveoutTrend m_moveoutUEC = new Java2D_UserEventConsumer_MoveoutTrend();
    protected MoveoutTrendData m_moveoutTrendData = new MoveoutTrendData();
    protected double m_worldX;
    protected double m_worldY;
    protected Java2D_AxisLocker m_axisLockerVelocity;
    protected Java2D_AxisLocker m_axisLockerDepth;
    protected Java2D_SimpleComposite m_modelWidget = new Java2D_SimpleComposite(false);

    public LinearMoveoutTrendWidget_Picks() {
        super(1);
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_moveoutTrendData.read(project.moveoutTrendFileName());
            this.m_pickName = "FBP_User";
            this.setRightComponent(this.createSplitRightWidget());
            this.setLeftComponent(this.createLeftWidget());
            this.reloadShotRecData();
            this.reloadMapPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createSplitRightWidget() {
        try {
            JSplitPane split = new JSplitPane(1);
            split.setLeftComponent(this.createRightWidget());
            split.setRightComponent(this.createModelComponent());
            split.setOneTouchExpandable(true);
            return split;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelComponent() {
        try {
            LinearLayoutWidget topLevel = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget topbar = topLevel.createHorizontal(0, null, 0);
            this.m_axisLockerDepth = new Java2D_AxisLocker("Lock depth", "Lock axis ");
            this.m_axisLockerDepth.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerDepth, 2);
            this.m_axisLockerVelocity = new Java2D_AxisLocker("Lock velocity", "Lock axis ");
            this.m_axisLockerVelocity.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerVelocity, 2);
            this.m_modelWidget.setColorScaleVisible(false);
            topLevel.addComponent(this.m_modelWidget, 10);
            return topLevel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Lock offset axis", "Lock offset axis");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Lock time axis", "Lock time axis");
            this.m_axisLockerTime.listener().addListener(this);
            top.addComponent(this.m_axisLockerOffset, 0);
            top.addComponent(this.m_axisLockerTime, 0);
            LinearLayoutWidget temp = top.createVertical(0, "Pick acceptance zone", 0);
            temp.addComponent(this.m_chkDrawAcceptZone, 0);
            temp.addHorzPair(new JLabel("Acceptance zone(ms)"), 0, this.m_txtAcceptZone, 10);
            temp.addStretch(10);
            this.m_chkDrawAcceptZone.addActionListener(this);
            this.m_txtAcceptZone.addActionListener(this);
            temp = top.createVertical(0, "Kill picks", 0);
            this.m_btnKillPicks = temp.createButton("Kill picks outside acceptance zone", this, 0);
            this.m_killVersionCombo = this.createPickCombo();
            temp.addHorzPair(new JLabel("Pick version"), 0, this.m_killVersionCombo, 10);
            temp.addComponent(this.m_progressKill, 0);
            this.m_progressKill.setMaximum(1000);
            this.m_progressKill.setMinimum(0);
            temp.addStretch(10);
            top.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            this.m_branchWidget.setAxesVisible(true, true);
            this.m_branchWidget.setColorScaleVisible(false);
            this.m_moveoutUEC.addListener(this);
            this.m_moveoutUEC.BroadCastWhenMouseMoves = true;
            main.addComponent(this.m_branchWidget, 10);
            this.m_rightTabs.addTab("Picks", main);
            this.m_rightTabs.addTab("Velocity at offset", new LinearMoveoutTrend_DisplayWidget(this.m_moveoutTrendData, LinearMoveoutTrend_DisplayWidget.Display.Velocity));
            this.m_rightTabs.addTab("Time at offset", new LinearMoveoutTrend_DisplayWidget(this.m_moveoutTrendData, LinearMoveoutTrend_DisplayWidget.Display.Time));
            return this.m_rightTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeftWidget() {
        try {
            JSplitPane leftSplitter = new JSplitPane(0);
            leftSplitter.setMinimumSize(new Dimension(300, 300));
            leftSplitter.setPreferredSize(new Dimension(300, 300));
            leftSplitter.setTopComponent(this.createPickWidget());
            leftSplitter.setBottomComponent(this.createMapWidget());
            return leftSplitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMapWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            main.createLabel("Left-click to add/select location", 2, 0);
            main.createLabel("Press \"r\" to remove nearest location", 2, 0);
            this.m_basemapWidget.setAxesVisible(false, false);
            this.m_basemapWidget.setColorScaleVisible(false);
            main.addComponent(this.m_basemapWidget, 10);
            LinearLayoutWidget bottom = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearButton = bottom.createButton("Remove all", this, 0);
            bottom.addStretch(10);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createInterpWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createPickWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget w = main.createVertical(3, "Select type of gather", 0);
            w.addComponent(this.m_rad_sparse, 0);
            w.addComponent(this.m_rad_cmp, 0);
            w.addComponent(this.m_rad_shot, 0);
            this.pickCollection().read();
            boolean sparse_ok = RefractionStaticsProject.singleton().dim3D() && this.pickCollection().valid();
            this.m_rad_sparse.setEnabled(sparse_ok);
            this.m_rad_sparse.setSelected(sparse_ok);
            this.m_rad_shot.setSelected(!sparse_ok);
            if (RefractionStaticsProject.singleton().dim3D()) {
                this.m_leftLayPre = main.createVertical(0, "Precomputed pick gather options", 0);
                GridLayoutWidget grid = this.m_leftLayPre.createGridLayoutWidget(3, 0);
                grid.addSimple(0, new JLabel("Spacing (ft/m)"), this.m_textPrecomputeSpacing);
                grid.addSimple(1, new JLabel("Radius (ft/m"), this.m_textPrecomputeRadius);
                this.m_btnPrecompute = this.m_leftLayPre.createButton("Create precomputed pick gathers", this, 0);
                this.m_btnPrecomputeClear = this.m_leftLayPre.createButton("Remove all precomputed pick gathers", this, 0);
                this.m_leftLayPre.addComponent(this.m_progressPrecompute, 0);
                this.m_progressPrecompute.setMaximum(1000);
                this.m_progressPrecompute.setMinimum(0);
            }
            this.m_rad_sparse.addActionListener(this);
            this.m_rad_cmp.addActionListener(this);
            this.m_rad_shot.addActionListener(this);
            this.m_group.add(this.m_rad_sparse);
            this.m_group.add(this.m_rad_cmp);
            this.m_group.add(this.m_rad_shot);
            this.m_leftLayNormal = RefractionStaticsProject.singleton().dim3D() ? main.createGridLayoutWidget(0, "If not using precomputed pick gathers", 0) : main.createGridLayoutWidget(0, 0);
            this.m_radiusCombo.addItem("1 bin");
            if (RefractionStaticsProject.singleton().dim3D()) {
                for (int n = 1; n < 11; ++n) {
                    int num = 2 * n + 1;
                    String s = String.format("%d x %d bins", num, num);
                    this.m_radiusCombo.addItem(s);
                }
            } else {
                for (int n = 1; n < 11; ++n) {
                    int num = 2 * n + 1;
                    String s = String.format("%d bins", num);
                    this.m_radiusCombo.addItem(s);
                }
            }
            this.m_radiusCombo.setSelectedIndex(2);
            this.m_pickVersionCombo = this.createPickCombo();
            this.m_leftLayNormal.addSimple(0, new JLabel("Bin radius (if using standard CMP"), this.m_radiusCombo);
            this.m_leftLayNormal.addSimple(1, new JLabel("Pick version (CMP or shot)"), this.m_pickVersionCombo);
            Tools_Widget.setEnabled(this.m_leftLayNormal, !this.m_rad_sparse.isSelected(), true);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected ComboStringListWrapper createPickCombo() {
        try {
            ComboStringListWrapper combo = new ComboStringListWrapper("FBP_User");
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> pickCols = traceTable.columns("FBP_");
            combo.setStringArray(pickCols);
            combo.listener().addListener(this);
            return combo;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Java2D_Paintable_BranchPickCollections pickCollection() {
        try {
            return RefractionStaticsProject.singleton().preselectedPickLocations();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void save_slb(String filename) {
        try {
            this.m_moveoutTrendData.save_slb(filename);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save_csv(String filename) {
        try {
            this.m_moveoutTrendData.save_csv(filename);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void copyCurrentToProject() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_moveoutTrendData.save(project.moveoutTrendFileName());
            project.moveoutTrendData().read(project.moveoutTrendFileName());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void precomputeClear() {
        try {
            this.pickCollection().deleteCurrentLocations();
            this.m_rad_sparse.setEnabled(false);
            this.m_rad_sparse.setSelected(false);
            Tools_Widget.setEnabled(this.m_leftLayNormal, !this.m_rad_sparse.isSelected(), true);
            this.m_rad_shot.setSelected(true);
            this.reloadMapPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            if (this.m_progressTemp != null) {
                System.out.println("setPercentDone = " + percent);
                this.m_progressTemp.setValue((int)(10.0 * percent));
                this.m_progressTemp.paintImmediately(0, 0, 777, 33);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected void kill() {
        try {
            if (this.m_moveoutTrendData.numValidLocations(true) < 1) {
                JOptionPane.showMessageDialog(null, "Must define at least one trend curve", "", 0);
                return;
            }
            String pickVersion = this.m_killVersionCombo.getSelectedString();
            String msg = "Okay to kill ( " + pickVersion + " ) outside acceptance zone?";
            int res = JOptionPane.showConfirmDialog(null, msg, "", 0);
            if (res != 0) {
                return;
            }
            this.m_progressTemp = this.m_progressKill;
            float radius = (float)Tools_Widget.extractDouble(this.m_txtAcceptZone, 40.0, 5.0, 2000.0);
            TraceTable_Scanner_KillPicksUsingTrends scanner = new TraceTable_Scanner_KillPicksUsingTrends(pickVersion, radius, this.m_moveoutTrendData);
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, this);
            this.m_progressTemp = null;
            this.m_progressKill.setValue(0);
            JOptionPane.showMessageDialog(null, "Changes will not be visible until pick gather\n selection has been redone", "", 1);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void precompute() {
        try {
            this.precomputeClear();
            this.pickCollection().deleteCurrentLocations();
            this.m_rad_sparse.setEnabled(false);
            this.m_rad_sparse.setSelected(false);
            Java2D_Paintable_BranchPickCollections coll = this.pickCollection();
            double spacing = Tools_Widget.extractDouble(this.m_textPrecomputeSpacing, 5000.0, 1.0, 20000.0);
            double radius = Tools_Widget.extractDouble(this.m_textPrecomputeRadius, 300.0, 1.0, 10000.0);
            coll.prep(spacing, radius);
            this.m_progressTemp = this.m_progressPrecompute;
            TraceTable_Scanner_BranchPickLocations scanner = new TraceTable_Scanner_BranchPickLocations(coll);
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, this);
            coll.finishedScanning();
            coll.save();
            this.m_progressTemp = null;
            this.m_rad_sparse.setEnabled(coll.valid());
            this.m_rad_sparse.setSelected(coll.valid());
            Tools_Widget.setEnabled(this.m_leftLayNormal, !this.m_rad_sparse.isSelected(), true);
            this.reloadMapPlot();
            this.m_progressPrecompute.setValue(0);
            this.m_ensemble.clearTraces(false);
            this.reloadBranchPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkDrawAcceptZone || e.getSource() == this.m_txtAcceptZone) {
                this.m_moveoutTrendData.AcceptZoneRadius = Tools_Widget.extractDouble(this.m_txtAcceptZone, 40.0, 5.0, 2000.0);
                this.m_moveoutTrendData.DrawAcceptanceZone = this.m_chkDrawAcceptZone.isSelected();
                this.m_branchWidget.mainWidget().mooz();
                return;
            }
            if (e.getSource() == this.m_btnKillPicks) {
                this.kill();
                return;
            }
            if (e.getSource() == this.m_btnPrecompute) {
                this.precompute();
                return;
            }
            if (e.getSource() == this.m_rad_sparse) {
                Tools_Widget.setEnabled(this.m_leftLayNormal, !this.m_rad_sparse.isSelected(), true);
                this.reloadMapPlot();
                if (this.m_rad_sparse.isSelected()) {
                    this.m_moveoutTrendData.clear();
                    this.m_ensemble.clearTraces(false);
                    this.reloadBranchPlot();
                }
            }
            if (e.getSource() == this.m_rad_shot || e.getSource() == this.m_rad_cmp) {
                Tools_Widget.setEnabled(this.m_leftLayNormal, true, true);
                this.reloadMapPlot();
            }
            if (e.getSource() == this.m_clearButton) {
                this.m_moveoutTrendData.clear();
                this.reloadBranchPlot();
                this.reloadMapPlot();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    protected void reloadModelPlot() {
        try {
            this.m_model.clearPicks();
            this.m_model.Permanent = false;
            for (int n = 0; n < this.m_moveoutUEC.m_nextPointIndex; ++n) {
                this.m_model.addPick(this.m_moveoutUEC.m_offset[n], this.m_moveoutUEC.m_time[n]);
            }
            this.m_model.addPick(this.m_moveoutUEC.m_currentOffset, this.m_moveoutUEC.m_currentTime);
            this.m_model.computeDelayTimeModel();
            Java2D_Widget w = this.m_modelWidget.mainWidget();
            this.m_modelWidget.setHorizontalTitle("Velocity");
            this.m_modelWidget.setVerticalTitle("Depth");
            Java2D_Paintable_AxisLines lines = new Java2D_Paintable_AxisLines();
            lines.DrawHorizontalLines = true;
            lines.DrawVerticalLines = true;
            w.clearPaintableList();
            w.addPaintable(this.m_model, 2000);
            w.addPaintable(lines, 2000);
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_moveoutUEC && this.m_moveoutUEC.MouseIsMoving) {
                this.reloadModelPlot();
                return;
            }
            if (sender == this.m_moveoutUEC && !this.m_moveoutUEC.MouseIsMoving) {
                this.m_moveoutTrendData.setSelected(this.m_moveoutUEC.PointCount, this.m_moveoutUEC.Offset, this.m_moveoutUEC.Time);
                this.m_moveoutTrendData.interpolate();
                this.reloadBranchPlot();
            }
            if (sender == this.m_axisLockerDepth) {
                this.m_modelWidget.mainWidget().transform().setAxisLockedY(this.m_axisLockerDepth.locked(), this.m_axisLockerDepth.min(), this.m_axisLockerDepth.max());
                this.m_modelWidget.mainWidget().mooz();
                return;
            }
            if (sender == this.m_axisLockerVelocity) {
                this.m_modelWidget.mainWidget().transform().setAxisLockedX(this.m_axisLockerVelocity.locked(), this.m_axisLockerVelocity.min(), this.m_axisLockerVelocity.max());
                this.m_modelWidget.mainWidget().mooz();
                return;
            }
            if (sender == this.m_pickVersionCombo) {
                this.m_pickName = this.m_pickVersionCombo.getSelectedString();
                this.reloadBranchPlot();
            }
            if (sender == this.m_mapKeyUEC) {
                if (this.m_mapKeyUEC.KeyCode == 82) {
                    this.m_moveoutTrendData.removeLocation(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    this.reloadMapPlot();
                    this.m_basemapWidget.mainWidget().repaint();
                    if (this.m_moveoutTrendData.Selected == null) {
                        this.m_ensemble.clearTraces(false);
                        this.reloadBranchPlot();
                    }
                }
                return;
            }
            if (sender == this.m_leftClickUEC) {
                this.handleMapClick();
                return;
            }
            if (sender == this.m_axisLockerOffset || sender == this.m_axisLockerTime) {
                this.reloadBranchPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick() {
        try {
            this.m_ensemble.clearTraces(false);
            this.m_worldX = this.m_leftClickUEC.WorldX;
            this.m_worldY = this.m_leftClickUEC.WorldY;
            if (this.m_rad_shot.isSelected()) {
                this.m_moveoutTrendData.selectLocation(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY, this.m_worldX, this.m_worldY);
                this.m_moveoutTrendData.interpolate();
                this.m_worldX = this.m_moveoutTrendData.Selected.X;
                this.m_worldY = this.m_moveoutTrendData.Selected.Y;
                this.m_ensemble.clearTraces(true);
                RefractionStaticsProject.singleton().shotTable().selectNearestSpatialPoint(this.m_worldX, this.m_worldY);
                int sid = RefractionStaticsProject.singleton().shotTable().SelectedID;
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_ensemble, sid, false);
            } else if (RefractionStaticsProject.singleton().dim3D()) {
                if (this.m_rad_sparse.isSelected()) {
                    this.pickCollection().nearest(this.m_ensemble, this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY);
                    this.m_moveoutTrendData.selectLocation(this.pickCollection().SelectedPixelX, this.pickCollection().SelectedPixelY, this.pickCollection().SelectedX, this.pickCollection().SelectedY);
                    this.m_moveoutTrendData.interpolate();
                } else {
                    this.m_moveoutTrendData.selectLocation(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY, this.m_worldX, this.m_worldY);
                    this.m_moveoutTrendData.interpolate();
                    Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                    grid3D.setWorldLocation(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_ensemble, grid3D.Inline, grid3D.Crossline, radius, false);
                }
            } else {
                this.m_moveoutTrendData.selectLocation(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY, this.m_worldX, this.m_worldY);
                this.m_moveoutTrendData.interpolate();
                IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                int bin = grid2D.getBin(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                int radius = this.m_radiusCombo.getSelectedIndex();
                RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_ensemble, bin, radius, false);
            }
            this.reloadBranchPlot();
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.forceImageRepaint();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadShotRecData() {
        try {
            this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot");
            this.m_receiverPaintable = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadBranchPlot() {
        try {
            Java2D_Widget w = this.m_branchWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_ensemble.traceCount() < 1) {
                w.mooz();
                return;
            }
            this.m_paintable.setEnsemble(this.m_ensemble);
            this.m_paintable.setAxisX("Trace", "Offset");
            this.m_paintable.setAxisY("Trace", this.m_pickName);
            this.m_paintable.Size = 5;
            this.m_paintable.FixedColor = Color.BLACK;
            this.m_paintable.Symbol = Java2D_PointSymbol.Plus;
            this.m_paintable.UseColorScale = false;
            this.m_paintable.MinimumValidY = 0.0;
            w.addPaintable(this.m_paintable, -9999);
            this.m_pickExpander.ApplyX = true;
            this.m_pickExpander.MinX = -200.0;
            this.m_pickExpander.MaxX = 0.0;
            this.m_pickExpander.ApplyY = true;
            this.m_pickExpander.MinY = -100.0;
            this.m_pickExpander.MaxY = 0.0;
            w.addPaintable(this.m_pickExpander, -9999);
            this.m_moveoutTrendData.AcceptZoneRadius = Tools_Widget.extractDouble(this.m_txtAcceptZone, 40.0, 5.0, 2000.0);
            this.m_moveoutTrendData.DrawAcceptanceZone = this.m_chkDrawAcceptZone.isSelected();
            w.addPaintable(this.m_moveoutTrendData, MoveoutTrendData.PlotType.Branch.ordinal());
            w.transform().setAxisLockedX(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
            w.transform().setAxisLockedY(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_moveoutUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMapPlot() {
        try {
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_shotPaintable != null) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_receiverPaintable != null) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            if (this.m_rad_sparse != null && this.pickCollection() != null && this.m_rad_sparse.isSelected() && this.pickCollection().valid()) {
                w.addPaintable(this.pickCollection(), -9999);
            }
            w.addPaintable(this.m_moveoutTrendData, MoveoutTrendData.PlotType.Map.ordinal());
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_leftClickUEC);
            w.addEventConsumer(this.m_mapKeyUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void acceptInterp() {
        try {
            if (this.m_moveoutTrendData.InterpolatedValid && this.m_moveoutTrendData.Selected.Offset == null) {
                this.m_moveoutTrendData.setSelected(this.m_moveoutTrendData.m_interpOffset.length, this.m_moveoutTrendData.m_interpOffset, this.m_moveoutTrendData.m_interpTime);
                this.m_moveoutTrendData.interpolate();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

