/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class SegyWizardSharedData {
    public ArrayList<CompressedImportLimit> ImportLimitList = new ArrayList();
    public String ProjectName;
    public String Units = "Meters";
    public String Dimension = "3D";
    public ArrayList<String> Files = null;
    public Segy_Dictionary Dictionary = new Segy_Dictionary();
    public boolean DecimateInput_ReceiverFold = false;
    public boolean DecimateInput = false;
    public int Decimation = 2;
    public boolean CreateCompressed = false;
    public boolean Resample = false;
    public float MaxTime = 2000.0f;
    public float OutputSampleInterval = 4.0f;
    public boolean CreateSparse = false;
    public float SparseSpacing = 5000.0f;
    public float SparseRadius = 200.0f;
    public boolean KillNoisy = false;
    public float NoiseWindow = 100.0f;
    public float NoiseCutoff = 10.0f;
    public boolean KillSensor = false;
    public int MinSensor = 0;
    public int MaxSensor = 50000;
    public boolean KillOffsets = false;
    public float MinOffset = 0.0f;
    public float MaxOffset = 50000.0f;
    public boolean IsMarine = false;
    public float RecBinSize = 25.0f;
    public int MarineDecimation = 0;
    public int MarineShotLineIncrement = 0;

    public void readFromParameterTree(ParameterTree tree) {
        try {
            this.ProjectName = tree.string_get("ProjectName", "ERROR");
            this.Units = tree.string_get("Units", "ERROR");
            this.Dimension = tree.string_get("Dimension", "ERROR");
            this.Files = tree.stringList_get("Files");
            String dict = tree.string_get("Dictionary", "ERROR");
            this.Dictionary.setOpenFileName(dict);
            this.RecBinSize = (float)tree.double_get("RecBinSize", 25.0);
            this.MaxTime = (float)tree.double_get("MaxTime", 1000.0);
            this.OutputSampleInterval = (float)tree.double_get("OutputSampleInterval", 4.0);
            this.SparseSpacing = (float)tree.double_get("SparseSpacing", 5000.0);
            this.SparseRadius = (float)tree.double_get("SparseRadius", 300.0);
            this.NoiseWindow = (float)tree.double_get("NoiseWindow", 10.0);
            this.NoiseCutoff = (float)tree.double_get("NoiseCutoff", 10.0);
            this.MinOffset = (float)tree.double_get("MinOffset", 0.0);
            this.MaxOffset = (float)tree.double_get("MaxOffset", 10000.0);
            this.IsMarine = tree.bool_get("IsMarine", false);
            this.CreateCompressed = tree.bool_get("CreateCompressed", true);
            this.Resample = tree.bool_get("Resample", false);
            this.CreateSparse = tree.bool_get("CreateSparse", false);
            this.KillNoisy = tree.bool_get("KillNoisy", false);
            this.KillOffsets = tree.bool_get("KillOffsets", false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void writeToParameterTree(ParameterTree tree) {
        try {
            tree.string_put("ProjectName", this.ProjectName);
            tree.string_put("Units", this.Units);
            tree.string_put("Dimension", this.Dimension);
            if (this.Files != null) {
                tree.stringList_put("Files", this.Files);
            }
            tree.string_put("Dictionary", this.Dictionary.getFileName());
            tree.double_put("RecBinSize", this.RecBinSize);
            tree.double_put("MaxTime", this.MaxTime);
            tree.double_put("OutputSampleInterval", this.OutputSampleInterval);
            tree.double_put("SparseSpacing", this.SparseSpacing);
            tree.double_put("SparseRadius", this.SparseRadius);
            tree.double_put("NoiseWindow", this.NoiseWindow);
            tree.double_put("NoiseCutoff", this.NoiseCutoff);
            tree.double_put("MinOffset", this.MinOffset);
            tree.double_put("MaxOffset", this.MaxOffset);
            tree.bool_put("IsMarine", this.IsMarine);
            tree.bool_put("CreateCompressed", this.CreateCompressed);
            tree.bool_put("Resample", this.Resample);
            tree.bool_put("CreateSparse", this.CreateSparse);
            tree.bool_put("KillNoisy", this.KillNoisy);
            tree.bool_put("KillOffsets", this.KillOffsets);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class CompressedImportLimit {
        public int Header = 1;
        public int Min = 1;
        public int Max = 1;
        public int Type = 1;
        public String Table = "";
        public String Column = "";
        public String HeaderName = "";
    }
}

